<?php 
/*-----------------------------------------------------------------------------------*/
/* Service Box
/*-----------------------------------------------------------------------------------*/

if ( ! defined( 'ABSPATH' ) ) { exit; }
class WPBakeryShortCode_Apress_Service_Box extends WPBakeryShortCode {}

$doc_link = 'http://apresswp.com/help';

if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"			=> __("Service Box", 'apcore'),
			"base"			=> "apress_service_box",
			"class"			=> "",
			"weight"		=> 7,
			"category"		=> __( "Apress", "apcore"),
			"description"	=> __("Beutiful Service Box Designs", "apcore"),
			"icon"			=> APRESS_EXTENSIONS_PLUGIN_URL . "vc_custom/assets/images/vc_icons/vc-icon-service_box.jpg",
			"params"		=> array(
				
				array(
					'type'        => 'radio_image_select',
					'heading'     => esc_html__( 'Box Style', 'apcore' ),
					'param_name'  => 'style',
					'simple_mode' => false,
					'options'     => array(
						'style1' => array(
							'tooltip' => esc_attr__('Style1','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/service_box/style1.jpg'
						),
						'style2' => array(
							'tooltip' => esc_attr__('Style2','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/service_box/style2.jpg'
						),
						'style3' => array(
							'tooltip' => esc_attr__('Style3','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/service_box/style3.jpg'
						),
						
					),		
	
				),
				
				array(
					"type"				=> "attach_image",
					"class"				=> "",
					"heading"			=> __("Image", "apcore"),
					"param_name"		=> "image",
					"value"				=> "",
				),
				array(
					'type'				=> 'textfield',
					'heading'			=> esc_html__('Title', 'apcore'),
					'param_name'		=> 'box_title',
					'value'				=> esc_html__('Your Title','apcore'),
				),
				array(
					'type'				=> 'textarea',
					'heading'			=> esc_html__('Description', 'apcore'),
					'param_name'		=> 'box_description',
					'value'				=> esc_html__('Description area','apcore'),
				),
				array(
					"type"				=> "attach_image",
					"class"				=> "",
					"heading"			=> __("Icon Image(Upload Icon size of 70px)", "apcore"),
					"param_name"		=> "image2",
					"value"				=> "",
				),
				array(
					'type'				=> 'zolo_single_checkbox',
					'heading'			=> esc_html__('Box Swing', 'apcore'),
					'param_name'		=> 'box_swing',
					'value'				=> 'no',
					'options'			=> array(
						'yes'			=> array(
							'on'				=> 'Yes',
							'off'				=> 'No',
						),
					),
				),
				
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Extra features', 'apcore'),
					'param_name'		=> 'features_heading',
					'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
				),
				array(
					"type"				=> "textfield",
					"heading"			=> __("Extra class name", "apcore"),
					"param_name"		=> "class",
					"description"		=> __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "apcore")
				),
				array(
					"type"				=> "dropdown",
					"class"				=> "",
					"heading"			=> __("CSS Animation",'apcore'),
					"param_name"		=> "data_animation",
					"value"				=> apress_data_animations(),
					"description"		=> __("Select type of animation. Note: Works only in modern browsers.",'apcore'),
					"edit_field_class"	=> "apress-heading-param-wrapper vc_column vc_col-sm-8 no-top-margin",
				),  
				array(
					"type"				=> "textfield",
					"class"				=> "",
					"heading"			=> __("Delay","apcore"),
					"param_name"		=> "data_delay",
					"value"				=> "500",
					"description"		=> __("Delay","apcore"),
					"edit_field_class"	=> "apress-heading-param-wrapper vc_column vc_col-sm-4 no-top-margin",
				),
				array(
					'type'				=> 'zolo_video_link_param',
					'heading'			=> esc_html__('Video tutorial and theme documentation article','apcore'),
					'param_name'		=> 'tutorials',
					'doc_link'			=> $doc_link,
					'video_link'		=> 'https://youtu.be/Gk6g0uOC9V0',
				),	
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Box Background Color",'apcore'),
					"param_name"		=> "box_background_color",
					"value"				=> '#ffffff',
					'group'				=> esc_html__('Box Style', 'apcore'),
				),
				array(
					'type' 				=> 'zolo_number',
					'heading' 			=> __("Border Radius",'apcore'),
					'param_name'		=> 'border_radius',
					'value'				=> '0',
					'suffix'			=> 'px',
					'group'				=> esc_html__('Box Style', 'apcore'),
				),
				array(
				   'type'    	=> 'zolo_box_shadow_param',
				   'heading'	=> esc_html__('Box Shadow', 'apcore'),
				   'param_name' => 'box_shadow',
				   "value"		=> 'box_shadow_enable:disable|shadow_horizontal:0|shadow_vertical:2|shadow_blur:10|shadow_spread:0|box_shadow_color:rgba(0%2C0%2C0%2C0.2)',
				   'group'		=> esc_html__('Box Style', 'apcore'),
				),
				array(
				   'type'    => 'zolo_box_shadow_param',
				   'heading'	=> esc_html__('Box Hover Shadow', 'apcore'),
				   'param_name' => 'box_hover_shadow',
				   "value"		=> 'box_shadow_enable:enable|shadow_horizontal:0|shadow_vertical:7|shadow_blur:15|shadow_spread:0|box_shadow_color:rgba(0%2C0%2C0%2C0.2)',
				   'group'		=> esc_html__('Box Style', 'apcore'),
				   ),
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Image Options', 'apcore'),
					'param_name'		=> 'img_opt_heading',
					'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
					'group'				=> esc_html__('Box Style', 'apcore'),
				),
				array(
					"type"				=> "dropdown",
					"heading"			=> __("Image Height Type",'apcore'),
					"param_name"		=> "height_type",
					'value'				=> array(
						__("Auto Height",'apcore') => "auto_height",
						__("Custom Height",'apcore') => "custom_height",
					),
					'group'				=> esc_html__('Box Style', 'apcore'),
				),
				array(
					'type' 		=> 'zolo_number',
					'heading' 	=> __("Min Height",'apcore'),
					'param_name'=> 'min_height',
					'value'		=> '300',
					'suffix'	=> 'px',
					'dependency'=> array( 'element' => 'height_type', 'value' => 'custom_height'),
					'group'		=> esc_html__('Box Style', 'apcore'),
				),
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Content Area', 'apcore'),
					'param_name'		=> 'content_area_heading',
					'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
					'group'				=> esc_html__('Box Style', 'apcore'),
				),
				array(
					"type" 			=> "textfield",
					"heading" 		=> __("Box top Padding",'apcore'),
					'description' 	=> __( 'Enter value with px OR % (ex: 5px OR 5%)', 'apcore' ),
					"param_name" 	=> "box_top_padding",
					"value" 		=> '30px',
					'edit_field_class'	=> 'vc_column vc_col-sm-3',
				   'group'			=> esc_html__('Box Style', 'apcore'),
				 ),
				 array(
					"type" 			=> "textfield",
					"heading" 		=> __("Box Right Padding",'apcore'),
					'description' 	=> __( 'Enter value with px OR % (ex: 5px OR 5%)', 'apcore' ),
					"param_name" 	=> "box_right_padding",
					"value" 		=> '40px',
					'edit_field_class'=> 'vc_column vc_col-sm-3',
				   'group'			=> esc_html__('Box Style', 'apcore'),
				 ),						 
				 array(
					"type" 			=> "textfield",
					"heading" 		=> __("Box Bottom Padding",'apcore'),
					'description' 	=> __( 'Enter value with px OR % (ex: 5px OR 5%)', 'apcore' ),
					"param_name" 	=> "box_bottom_padding",
					"value" 		=> '40px',
					'edit_field_class'=> 'vc_column vc_col-sm-3',
				   'group'			=> esc_html__('Box Style', 'apcore'),
				 ),	
				 array(
					"type" 			=> "textfield",
					"heading" 		=> __("Box Left Padding",'apcore'),
					'description' 	=> __( 'Enter value with px OR % (ex: 5px OR 5%)', 'apcore' ),
					"param_name" 	=> "box_left_padding",
					"value" 		=> '40px',
					'edit_field_class'=> 'vc_column vc_col-sm-3',
				   'group'			=> esc_html__('Box Style', 'apcore'),
				 ),
				   
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Title Typography', 'apcore'),
					'param_name'		=> 'title_heading',
					'class'				=> 'zolo-param-heading',
					'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12',
					'group'				=> esc_html__('Typography', 'apcore'),
				),
				array(
					'type'				=> 'zolo_font_container',
					'heading'			=> '',
					'param_name'		=> 'title_font_options',
					'settings'				=> array(
						'fields'				=> array(
							'tag' => 'h2',
							'font_size',							
							'line_height',
							'letter_spacing',
							'font_style',
							'color',
						),
					),
					'group'				=> esc_html__('Typography', 'apcore'),
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Custom font family', 'apcore'),
					'param_name'		=> 'title_google_fonts',
					'value'				=> 'no',
					'options'			=> array(
						esc_html__('Yes', 'apcore')	=> 'yes',
						esc_html__('No', 'apcore') => 'no',
					),
					'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
					'group'				=> esc_html__('Typography', 'apcore'),
				),
				array(
					'type'				=> 'google_fonts',
					'param_name'		=> 'title_custom_fonts',
					'settings'			=> array(
						'fields'			=> array(
							'font_family_description'	=> esc_html__('Select font family.', 'apcore'),
							'font_style_description'	=> esc_html__('Select font style.', 'apcore'),
						),
					),
					'dependency' => array( 'element' => 'title_google_fonts', 'value' => 'yes'),
					'group'				=> esc_html__('Typography', 'apcore'),
				),
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Description Style', 'apcore'),
					'param_name'		=> 'description_heading',
					'group'				=> esc_html__('Description Style', 'apcore'),
				),
				array(
					'type'				=> 'zolo_font_container',
					'heading'			=> '',
					'param_name'		=> 'description_font_options',
					'settings'				=> array(
						'fields'				=> array(
							'font_size',							
							'line_height',
							'letter_spacing',
							'font_style',
							'color' => '',
						),
					),
					'group'			=> esc_html__('Description Style', 'apcore'),
				),		
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Custom font family', 'apcore'),
					'param_name'		=> 'description_google_fonts',
					'value'				=> 'no',
					'options'			=> array(
						esc_html__('Yes', 'apcore')	=> 'yes',
						esc_html__('No', 'apcore') => 'no',
					),
					'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
					'group'				=> esc_html__('Description Style', 'apcore'),
				),
				array(
					'type'				=> 'google_fonts',
					'param_name'		=> 'description_custom_fonts',
					'settings'			=> array(
						'fields'			=> array(
							'font_family_description'	=> esc_html__('Select font family.', 'apcore'),
							'font_style_description'	=> esc_html__('Select font style.', 'apcore'),
						),
					),
					'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
					'dependency' => array( 'element' => 'description_google_fonts', 'value' => 'yes'),
					'group'				=> esc_html__('Description Style', 'apcore'),
				),
				
				// 1ST Button Options Start
				array(
					'type'				=> 'zolo_single_checkbox',
					'heading'			=> esc_html__('Button Enable', 'apcore'),
					'param_name'		=> 'button1_enable',
					'value'				=> 'yes',
					'options'			=> array(
						'yes'			=> array(
							'on'				=> 'Yes',
							'off'				=> 'No',
						),
					),
					'group'				=> esc_html__('1ST Button', 'apcore'),
				),
				array(
					'type'        => 'radio_image_select',
					'heading'     => esc_html__( 'Style', 'apcore' ),
					'param_name'  => 'button1_shape',
					'simple_mode' => false,
					'options'     => array(
						'square' => array(
							'tooltip' => esc_attr__('Button Style1','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style1.jpg'
						),
						'rounded' => array(
							'tooltip' => esc_attr__('Button Style2','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style2.jpg'
						),
						'round' => array(
							'tooltip' => esc_attr__('Button Style3','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style3.jpg'
						),
						'style4' => array(
							'tooltip' => esc_attr__('Button Style4','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style4.jpg'
						),
						'style5' => array(
							'tooltip' => esc_attr__('Button Style5','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style5.jpg'
						),
						'style6' => array(
							'tooltip' => esc_attr__('Button Style6','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style6.jpg'
						),
						'style7' => array(
							'tooltip' => esc_attr__('Button Style7','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style7.jpg'
						),
						'style8' => array(
							'tooltip' => esc_attr__('Button Style8','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style8.jpg'
						),
						'style9' => array(
							'tooltip' => esc_attr__('Button Style9','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style9.jpg'
						),
						'style10' => array(
							'tooltip' => esc_attr__('Button Style10','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style10.jpg'
						),
					),		
					'dependency'	=> array('element' => 'button1_enable', 'value' => array('yes')),	
					'group'				=> esc_html__('1ST Button', 'apcore'),		
				),
				array(
					'type'				=> 'textfield',
					'heading'			=> esc_html__('Button Text', 'apcore'),
					'param_name'		=> 'button1_text',
					'value'				=> esc_html__('Button','apcore'),
					'admin_label'		=> true,
					'dependency'	=> array('element' => 'button1_enable', 'value' => array('yes')),	
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					"type"			=> "vc_link",
					"heading"		=> __("Button Link",'apcore'),
					"param_name"	=> "button1_link",
					"description"	=> __("http://example.com",'apcore'),
					'dependency'	=> array('element' => 'button1_enable', 'value' => array('yes')),	
					'group'				=> esc_html__('1ST Button', 'apcore'),
				 ),
				 array(
					"type"				=> "colorpicker",
					"heading"			=> __("Button Border Color",'apcore'),
					'param_name'		=> "button1_border_color_for_style5",
					"value"				=> '#e5e5e5',
					'dependency'		=> array('element' => 'button1_shape', 'value' => array('style5', 'style9')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Button Hover Border Color",'apcore'),
					'param_name'		=> "button1_hover_border_color_for_style5",
					"value"				=> '#549ffc',
					'dependency'		=> array('element' => 'button1_shape', 'value' => array('style5', 'style9')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					"type"			=> "dropdown",
					"heading"		=> __("Select Color Scheme",'apcore'),
					"description"	=> __("Options available in Theme Options > Colors for and Theme Options > Button",'apcore'),
					"param_name"	=> "button1_color_scheme",
					"value"			=> array(
						__("Default Button Color",'apcore') => "default_button_color_scheme",
						__("Primary Color",'apcore') 	=> "primary_color_scheme",
						__("Color Scheme 1",'apcore') 	=> "color_scheme1",
						__("Color Scheme 2",'apcore') 	=> "color_scheme2",
						__("Gradient Scheme 1",'apcore')=> "gradient_scheme1",
						__("Gradient Scheme 2",'apcore')=> "gradient_scheme2",
						__("Gradient Scheme 3",'apcore')=> "gradient_scheme3",
						__("Custom Color",'apcore') 	=> "design_your_own"
					),
					'dependency'	=> array('element' => 'button1_shape', 'value' => array('square', 'rounded', 'round', 'style7', 'style10')),
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					'type'				=> 'zolo_number',
					'heading'			=> esc_html__('Border Height','apcore'),
					'param_name'		=> 'button1_border_height_for_style4',
					'step'				=> '1',
					'value'				=> '2',
					'suffix'			=> 'px',
					'dependency'		=> array('element' => 'button1_shape', 'value' => array('style4')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Border Color",'apcore'),
					'param_name'		=> "button1_border_color_for_style4",
					"value"				=> '#e5e5e5',
					'dependency'		=> array('element' => 'button1_shape', 'value' => array('style4')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					"type"			=> "dropdown",
					"heading"		=> __("Select Color Scheme",'apcore'),
					"description"	=> __("Options available in Theme Options > Colors for and Theme Options > Button",'apcore'),
					"param_name"	=> "button1_color_scheme2",
					"value"			=> array(
						__("Default Button Color",'apcore') => "default_button_color_scheme",
						__("Primary Color",'apcore') 	=> "primary_color_scheme",
						__("Color Scheme 1",'apcore') 	=> "color_scheme1",
						__("Color Scheme 2",'apcore') 	=> "color_scheme2",
						__("Gradient Scheme 1",'apcore')=> "gradient_scheme1",
						__("Gradient Scheme 2",'apcore')=> "gradient_scheme2",
						__("Gradient Scheme 3",'apcore')=> "gradient_scheme3",
					),
					'dependency'		=> array('element' => 'button1_shape', 'value' => array('style4')),
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Background Color",'apcore'),
					"param_name"		=> "button1_bg_color",
					"value"				=> '#5295ea',
					'dependency'		=> array('element' => 'button1_color_scheme', 'value' => array('design_your_own')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Hover Background Color",'apcore'),
					"param_name"		=> "button1_bg_color_h",
					"value"				=> '#3b65d6',
					"dependency"		=> array("element" => "button1_color_scheme", "value" => array("design_your_own")),
					"edit_field_class"	=> "vc_column vc_col-sm-6 crum_vc apress-number-wrap",
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Border Color",'apcore'),
					'param_name'		=> "button1_border_color",
					"value"				=> '#5295ea',
					'dependency'		=> array('element' => 'button1_color_scheme', 'value' => array('design_your_own')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Hover Border Color",'apcore'),
					'param_name'		=> "button1_border_color_h",
					"value"				=> '#3b65d6',
					'dependency'		=> array('element' => 'button1_color_scheme', 'value' => array('design_your_own')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),				
				array(
					"type"				=> "dropdown",
					"heading"			=> __("Select Button Hover Style",'apcore'),
					'param_name'		=> "button1_hover_style",
					'value' 	=> array(
						__("Hover Style 1 - Fade",'apcore') 			=> "hoverstyle1",
						__("Hover Style 2 - Top To Bottom",'apcore') 	=> "hoverstyle2",
						__("Hover Style 3 - Bottom to Top",'apcore') 	=> "hoverstyle3",
						__("Hover Style 4 - Left To Right",'apcore') 	=> "hoverstyle4",
						__("Hover Style 5 - Right To Left",'apcore') 	=> "hoverstyle5",
					),
					'dependency'		=> array('element' => 'button1_color_scheme', 'value' => array('design_your_own')),
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),				
				array(
					"type"				=> "dropdown",
					"class"				=> "",
					"heading"			=> __("Button Size",'apcore'),
					'param_name'		=> "button1_size",
					"value"				=> array (
						__("Small",'apcore') => "small",
						__("Medium",'apcore') => "medium", 
						__("Large",'apcore') => "large",
						__("Full Width",'apcore') => "fullwidth",
						__("Design Your Own",'apcore') 	=> "design_your_own"
					 ), 
					 'dependency'	=> array('element' => 'button1_shape', 'value' => array('square', 'rounded', 'round', 'style5', 'style7', 'style9', 'style10')),
					 'group'				=> esc_html__('1ST Button', 'apcore'),	
					),
				
				array(
					'type'				=> 'zolo_number',
					'heading'			=> esc_html__('Padding Top & Bottom','apcore'),
					'param_name'		=> 'button1_padding_top_bottom',
					'step'				=> '1',
					'value'				=> '15',
					'suffix'			=> 'px',
					'dependency'		=> array('element' => 'button1_size', 'value' => 'design_your_own'),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					'type'				=> 'zolo_number',
					'heading'			=> esc_html__('Padding Right & Left','apcore'),
					'param_name'		=> 'button1_padding_right_left',
					'step'				=> '1',
					'value'				=> '25',
					'suffix'			=> 'px',
					'dependency'		=> array('element' => 'button1_size', 'value' => 'design_your_own'),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					'type'				=> 'zolo_number',
					'heading'			=> esc_html__('Padding Top & Bottom','apcore'),
					'param_name'		=> 'button1_padding_top_bottom_for_style4',
					'step'				=> '1',
					'value'				=> '12',
					'suffix'			=> 'px',
					'dependency'		=> array('element' => 'button1_shape', 'value' => array('style4', 'style6', 'style8')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
				   'type'    => 'zolo_box_shadow_param',
				   'heading'	=> esc_html__('Button Shadow', 'apcore'),
				   'param_name' => 'button1_shadow',
				   "value"		=> 'box_shadow_enable:enable|shadow_horizontal:1|shadow_vertical:2|shadow_blur:4|shadow_spread:0|box_shadow_color:rgba(0%2C0%2C0%2C0.2)',
				   'dependency'	=> array('element' => 'button1_shape', 'value' => array('square', 'rounded', 'round', 'style5', 'style7', 'style9', 'style10')),
				   'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
				   'type'    => 'zolo_box_shadow_param',
				   'heading'	=> esc_html__('Button Hover Shadow', 'apcore'),
				   'param_name' => 'button1_hover_shadow',
				   "value"		=> 'box_shadow_enable:enable|shadow_horizontal:2|shadow_vertical:2|shadow_blur:7|shadow_spread:0|box_shadow_color:rgba(0%2C0%2C0%2C0.2)',
				   'dependency'	=> array('element' => 'button1_shape', 'value' => array('square', 'rounded', 'round', 'style5', 'style7', 'style9', 'style10')),
				   'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				
				array(
					'type'				=> 'zolo_single_checkbox',
					'heading'			=> esc_html__('Button Icon Enable', 'apcore'),
					'param_name'		=> 'button1_icon_enable',
					'value'				=> 'yes',
					'options'			=> array(
						'yes'			=> array(
							'on'				=> 'Yes',
							'off'				=> 'No',
						),
					),
					'dependency'	=> array('element' => 'button1_enable', 'value' => array('yes')),	
					'group'				=> esc_html__('1ST Button', 'apcore'),
				),
				
				array(
					'type'				=> 'dropdown',
					'heading'			=> __( 'Icon library', 'apcore' ),
					'value'				=> array(
						__( 'Font Awesome', 'apcore' )	=> 'fontawesome',
						__( 'Open Iconic', 'apcore' )	=> 'openiconic',
						__( 'Typicons', 'apcore' )		=> 'typicons',
						__( 'Entypo', 'apcore' )		=> 'entypo',
						__( 'Linecons', 'apcore' )		=> 'linecons',
						__( 'Mono Social', 'apcore' )	=> 'monosocial',
						__( 'Linea', 'apcore' ) 	=> 'linea',
					),
					'save_always' 		=> true,
					'param_name' 		=> 'button1_icon_family',
					'description' 		=> __( 'Select icon library.', 'apcore' ),
					'dependency'		=> array('element' => 'button1_icon_enable', 'value' => array('yes')),
					'group'				=> esc_html__('1ST Button', 'apcore'),
				),
				array(
					'type'				=> 'iconpicker',
					'heading'			=> __('Icon', 'apcore'),
					'param_name'		=> 'button1_icon_fontawesome',
					'value'				=> 'fas fa-long-arrow-alt-right',
					'settings'			=> array( 'emptyIcon' => false, 'iconsPerPage' => 100),
					'dependency'		=> array('element' => 'button1_icon_family', 'value' => 'fontawesome'),
					'description'		=> __('Select icon from library.', 'apcore'),
					'group'				=> esc_html__('1ST Button', 'apcore'),
				),	
				array(
					'type'				=> 'iconpicker',
					'heading'			=> __( 'Icon', 'apcore' ),
					'param_name'		=> 'button1_icon_openiconic',
					'value'				=> 'vc-oi vc-oi-dial',
					'settings'			=> array('emptyIcon' => false, 'type' => 'openiconic', 'iconsPerPage' => 100),
					'dependency'		=> array('element' => 'button1_icon_family','value' => 'openiconic'),
					'description'		=> __( 'Select icon from library.', 'apcore' ),
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),	
				array(
					'type'				=> 'iconpicker',
					'heading'			=> __( 'Icon', 'apcore' ),
					'param_name'		=> 'button1_icon_typicons',
					'value'				=> 'typcn typcn-adjust-brightness',
					'settings'			=> array('emptyIcon' => false,'type' => 'typicons','iconsPerPage' => 100),
					'dependency'		=> array('element' => 'button1_icon_family','value' => 'typicons'),
					'description'		=> __( 'Select icon from library.', 'apcore'),
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					'type' 				=> 'iconpicker',
					'heading' 			=> __( 'Icon', 'apcore' ),
					'param_name' 		=> 'button1_icon_entypo',
					'value' 			=> 'entypo-icon entypo-icon-note',
					'settings' 			=> array('emptyIcon' => false,'type' => 'entypo','iconsPerPage' => 100),
					'dependency' 		=> array('element' => 'button1_icon_family','value' => 'entypo'),
					'description' 		=> __( 'Select icon from library.', 'apcore' ),
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					'type' 				=> 'iconpicker',
					'heading' 			=> __( 'Icon', 'apcore' ),
					'param_name' 		=> 'button1_icon_linecons',
					'value' 			=> 'vc_li vc_li-heart',
					'settings' 			=> array('emptyIcon' => false,'type' => 'linecons','iconsPerPage' => 100),
					'dependency' 		=> array('element' => 'button1_icon_family','value' => 'linecons'),
					'description' 		=> __( 'Select icon from library.', 'apcore' ),
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),	
				array(
					'type'				=> 'iconpicker',
					'heading'			=> __( 'Icon', 'apcore' ),
					'param_name'		=> 'button1_icon_monosocial',
					'value'				=> 'vc-mono vc-mono-fivehundredpx',
					'settings'			=> array('emptyIcon' => false,'type' => 'monosocial','iconsPerPage' => 100),
					'dependency'		=> array('element' => 'button1_icon_family','value' => 'monosocial'),
					'description'		=> __( 'Select icon from library.', 'apcore' ),
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),	
				array(
					'type'				=> 'iconpicker',
					'heading'			=> __('Icon', 'apcore'),
					'param_name'		=> 'button1_icon_linea',
					'value'				=> 'icon-basic-heart',
					'settings'			=> array( 'emptyIcon' => true, 'type' => 'linea', 'iconsPerPage' => 100),
					'dependency'		=> array('element' => 'button1_icon_family', 'value' => 'linea'),
					'description'		=> __('Select icon from library.', 'apcore'),
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					'type' 				=> 'zolo_number',
					'heading'			=> esc_html__('Icon size','apcore'),
					'param_name'		=> 'button1_icon_size',
					'value'				=> '16',
					'step'				=> '1',
					'suffix'			=> 'px',
					'dependency'		=> array('element' => 'button1_icon_enable', 'value' => array('yes')),
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Icon Color",'apcore'),
					'param_name'		=> "button1_icon_color",
					"value"				=> '#333333',
					'dependency'		=> array('element' => 'button1_icon_enable', 'value' => array('yes')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Icon Hover Color",'apcore'),
					'param_name'		=> "button1_icon_hover_color",
					"value"				=> '#ffffff',
					'dependency'		=> array('element' => 'button1_icon_enable', 'value' => array('yes')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					'type'				=> 'zolo_single_checkbox',
					'heading'			=> esc_html__('Icon Background Enable', 'apcore'),
					'param_name'		=> 'button1_icon_bg_color_show',
					'value'				=> 'no',
					'options'			=> array(
						'yes'			=> array(
							'on'				=> 'Yes',
							'off'				=> 'No',
						),
					),
					'dependency'		=> array('element' => 'button1_shape', 'value' => array('style6', 'style8')),
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Icon Background Color",'apcore'),
					'param_name'		=> "button1_icon_bg_color_for_style6",
					"value"				=> '#e5e5e5',
					'dependency' => array( 'element' => 'button1_icon_bg_color_show', 'value' => 'yes'),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Icon Hover Background Color",'apcore'),
					'param_name'		=> "button1_icon_hover_bg_color_for_style6",
					"value"				=> '#549ffc',
					'dependency' => array( 'element' => 'button1_icon_bg_color_show', 'value' => 'yes'),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Icon Alignment', 'apcore'),
					'param_name'		=> 'button1_icon_alignment',
					'value'				=> 'right',
					'options'			=> array(
						esc_html__('Left', 'apcore') 	=> 'left',
						esc_html__('Right', 'apcore')	=> 'right',
					),
					'dependency'		=> array('element' => 'button1_shape', 'value' => array('square','rounded','round','style4')),
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('1st Button Typography', 'apcore'),
					'param_name'		=> 'button1_heading',
					'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
					'dependency'	=> array('element' => 'button1_enable', 'value' => array('yes')),	
					'group'			=> esc_html__('1ST Button', 'apcore'),
				),
				array(
					'type'				=> 'zolo_font_container',
					'heading'			=> '',
					'param_name'		=> 'button1_font_options',
					'settings'				=> array(
						'fields'				=> array(
							'font_size',							
							'line_height',
							'letter_spacing',
							'font_style',
						),
					),
					'dependency'	=> array('element' => 'button1_enable', 'value' => array('yes')),	
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Custom font family', 'apcore'),
					'param_name'		=> 'button1_google_fonts',
					'value'				=> 'no',
					'options'			=> array(
						esc_html__('Yes', 'apcore')	=> 'yes',
						esc_html__('No', 'apcore') => 'no',
					),
					'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
					'dependency'	=> array('element' => 'button1_enable', 'value' => array('yes')),	
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					'type'				=> 'google_fonts',
					'param_name'		=> 'button1_custom_fonts',
					'settings'			=> array(
						'fields'			=> array(
							'font_family_description'	=> esc_html__('Select font family.', 'apcore'),
							'font_style_description'	=> esc_html__('Select font style.', 'apcore'),
						),
					),
					'dependency' => array( 'element' => 'button1_google_fonts', 'value' => 'yes'),
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),	
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Text Color",'apcore'),
					'param_name'		=> "button1_text_color",
					"value"				=> '',
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'dependency'	=> array('element' => 'button1_enable', 'value' => array('yes')),	
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Hover Text Color",'apcore'),
					'param_name'		=> "button1_text_color_h",
					"value"				=> '',
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'dependency'	=> array('element' => 'button1_enable', 'value' => array('yes')),	
					'group'				=> esc_html__('1ST Button', 'apcore'),	
				),	
				// 1ST Button Options End

				// 2ND Button Options Start
				array(
					'type'				=> 'zolo_single_checkbox',
					'heading'			=> esc_html__('Button Enable', 'apcore'),
					'param_name'		=> 'button2_enable',
					'value'				=> 'yes',
					'options'			=> array(
						'yes'			=> array(
							'on'				=> 'Yes',
							'off'				=> 'No',
						),
					),
					'group'				=> esc_html__('2ND Button', 'apcore'),
				),
				array(
					'type'        => 'radio_image_select',
					'heading'     => esc_html__( 'Style', 'apcore' ),
					'param_name'  => 'button2_shape',
					'simple_mode' => false,
					'options'     => array(
						'square' => array(
							'tooltip' => esc_attr__('Button Style1','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style1.jpg'
						),
						'rounded' => array(
							'tooltip' => esc_attr__('Button Style2','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style2.jpg'
						),
						'round' => array(
							'tooltip' => esc_attr__('Button Style3','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style3.jpg'
						),
						'style4' => array(
							'tooltip' => esc_attr__('Button Style4','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style4.jpg'
						),
						'style5' => array(
							'tooltip' => esc_attr__('Button Style5','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style5.jpg'
						),
						'style6' => array(
							'tooltip' => esc_attr__('Button Style6','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style6.jpg'
						),
						'style7' => array(
							'tooltip' => esc_attr__('Button Style7','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style7.jpg'
						),
						'style8' => array(
							'tooltip' => esc_attr__('Button Style8','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style8.jpg'
						),
						'style9' => array(
							'tooltip' => esc_attr__('Button Style9','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style9.jpg'
						),
						'style10' => array(
							'tooltip' => esc_attr__('Button Style10','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/button/button_style10.jpg'
						),
					),		
					'dependency'	=> array('element' => 'button2_enable', 'value' => array('yes')),	
					'group'				=> esc_html__('2ND Button', 'apcore'),		
				),
				array(
					'type'				=> 'textfield',
					'heading'			=> esc_html__('Button Text', 'apcore'),
					'param_name'		=> 'button2_text',
					'value'				=> esc_html__('Button','apcore'),
					'admin_label'		=> true,
					'dependency'	=> array('element' => 'button2_enable', 'value' => array('yes')),	
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					"type"			=> "vc_link",
					"heading"		=> __("Button Link",'apcore'),
					"param_name"	=> "button2_link",
					"description"	=> __("http://example.com",'apcore'),
					'dependency'	=> array('element' => 'button2_enable', 'value' => array('yes')),	
					'group'				=> esc_html__('2ND Button', 'apcore'),
				 ),
				 array(
					"type"				=> "colorpicker",
					"heading"			=> __("Button Border Color",'apcore'),
					'param_name'		=> "button2_border_color_for_style5",
					"value"				=> '#e5e5e5',
					'dependency'		=> array('element' => 'button2_shape', 'value' => array('style5', 'style9')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Button Hover Border Color",'apcore'),
					'param_name'		=> "button2_hover_border_color_for_style5",
					"value"				=> '#549ffc',
					'dependency'		=> array('element' => 'button2_shape', 'value' => array('style5', 'style9')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					"type"			=> "dropdown",
					"heading"		=> __("Select Color Scheme",'apcore'),
					"description"	=> __("Options available in Theme Options > Colors for and Theme Options > Button",'apcore'),
					"param_name"	=> "button2_color_scheme",
					"value"			=> array(
						__("Default Button Color",'apcore') => "default_button_color_scheme",
						__("Primary Color",'apcore') 	=> "primary_color_scheme",
						__("Color Scheme 1",'apcore') 	=> "color_scheme1",
						__("Color Scheme 2",'apcore') 	=> "color_scheme2",
						__("Gradient Scheme 1",'apcore')=> "gradient_scheme1",
						__("Gradient Scheme 2",'apcore')=> "gradient_scheme2",
						__("Gradient Scheme 3",'apcore')=> "gradient_scheme3",
						__("Custom Color",'apcore') 	=> "design_your_own"
					),
					'dependency'	=> array('element' => 'button2_shape', 'value' => array('square', 'rounded', 'round', 'style7', 'style10')),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					'type'				=> 'zolo_number',
					'heading'			=> esc_html__('Border Height','apcore'),
					'param_name'		=> 'button2_border_height_for_style4',
					'step'				=> '1',
					'value'				=> '2',
					'suffix'			=> 'px',
					'dependency'		=> array('element' => 'button2_shape', 'value' => array('style4')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Border Color",'apcore'),
					'param_name'		=> "button2_border_color_for_style4",
					"value"				=> '#e5e5e5',
					'dependency'		=> array('element' => 'button2_shape', 'value' => array('style4')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					"type"			=> "dropdown",
					"heading"		=> __("Select Color Scheme",'apcore'),
					"description"	=> __("Options available in Theme Options > Colors for and Theme Options > Button",'apcore'),
					"param_name"	=> "button2_color_scheme2",
					"value"			=> array(
						__("Default Button Color",'apcore') => "default_button_color_scheme",
						__("Primary Color",'apcore') 	=> "primary_color_scheme",
						__("Color Scheme 1",'apcore') 	=> "color_scheme1",
						__("Color Scheme 2",'apcore') 	=> "color_scheme2",
						__("Gradient Scheme 1",'apcore')=> "gradient_scheme1",
						__("Gradient Scheme 2",'apcore')=> "gradient_scheme2",
						__("Gradient Scheme 3",'apcore')=> "gradient_scheme3",
					),
					'dependency'		=> array('element' => 'button2_shape', 'value' => array('style4')),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Background Color",'apcore'),
					"param_name"		=> "button2_bg_color",
					"value"				=> '#5295ea',
					'dependency'		=> array('element' => 'button2_color_scheme', 'value' => array('design_your_own')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Hover Background Color",'apcore'),
					"param_name"		=> "button2_bg_color_h",
					"value"				=> '#3b65d6',
					"dependency"		=> array("element" => "button2_color_scheme", "value" => array("design_your_own")),
					"edit_field_class"	=> "vc_column vc_col-sm-6 crum_vc apress-number-wrap",
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Border Color",'apcore'),
					'param_name'		=> "button2_border_color",
					"value"				=> '#5295ea',
					'dependency'		=> array('element' => 'button2_color_scheme', 'value' => array('design_your_own')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Hover Border Color",'apcore'),
					'param_name'		=> "button2_border_color_h",
					"value"				=> '#3b65d6',
					'dependency'		=> array('element' => 'button2_color_scheme', 'value' => array('design_your_own')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),				
				array(
					"type"				=> "dropdown",
					"heading"			=> __("Select Button Hover Style",'apcore'),
					'param_name'		=> "button2_hover_style",
					'value' 	=> array(
						__("Hover Style 1 - Fade",'apcore') 			=> "hoverstyle1",
						__("Hover Style 2 - Top To Bottom",'apcore') 	=> "hoverstyle2",
						__("Hover Style 3 - Bottom to Top",'apcore') 	=> "hoverstyle3",
						__("Hover Style 4 - Left To Right",'apcore') 	=> "hoverstyle4",
						__("Hover Style 5 - Right To Left",'apcore') 	=> "hoverstyle5",
					),
					'dependency'		=> array('element' => 'button2_color_scheme', 'value' => array('design_your_own')),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),				
				array(
					"type"				=> "dropdown",
					"class"				=> "",
					"heading"			=> __("Button Size",'apcore'),
					'param_name'		=> "button2_size",
					"value"				=> array (
						__("Small",'apcore') => "small",
						__("Medium",'apcore') => "medium", 
						__("Large",'apcore') => "large",
						__("Full Width",'apcore') => "fullwidth",
						__("Design Your Own",'apcore') 	=> "design_your_own"
					 ), 
					 'dependency'	=> array('element' => 'button2_shape', 'value' => array('square', 'rounded', 'round', 'style5', 'style7', 'style9', 'style10')),
					 'group'				=> esc_html__('2ND Button', 'apcore'),	
					),
				
				array(
					'type'				=> 'zolo_number',
					'heading'			=> esc_html__('Padding Top & Bottom','apcore'),
					'param_name'		=> 'padding_top_bottom',
					'step'				=> '1',
					'value'				=> '15',
					'suffix'			=> 'px',
					'dependency'		=> array('element' => 'button2_size', 'value' => 'design_your_own'),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					'type'				=> 'zolo_number',
					'heading'			=> esc_html__('Padding Right & Left','apcore'),
					'param_name'		=> 'padding_right_left',
					'step'				=> '1',
					'value'				=> '25',
					'suffix'			=> 'px',
					'dependency'		=> array('element' => 'button2_size', 'value' => 'design_your_own'),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					'type'				=> 'zolo_number',
					'heading'			=> esc_html__('Padding Top & Bottom','apcore'),
					'param_name'		=> 'padding_top_bottom_for_style4',
					'step'				=> '1',
					'value'				=> '12',
					'suffix'			=> 'px',
					'dependency'		=> array('element' => 'button2_shape', 'value' => array('style4', 'style6', 'style8')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				
				array(
				   'type'    => 'zolo_box_shadow_param',
				   'heading'	=> esc_html__('Button Shadow', 'apcore'),
				   'param_name' => 'button2_shadow',
				   "value"		=> 'button2_shadow_enable:enable|shadow_horizontal:1|shadow_vertical:2|shadow_blur:4|shadow_spread:0|box_shadow_color:rgba(0%2C0%2C0%2C0.2)',
				   'dependency'	=> array('element' => 'button2_shape', 'value' => array('square', 'rounded', 'round', 'style5', 'style7', 'style9', 'style10')),
				   'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
				   'type'    => 'zolo_box_shadow_param',
				   'heading'	=> esc_html__('Button Hover Shadow', 'apcore'),
				   'param_name' => 'button2_hover_shadow',
				   "value"		=> 'box_shadow_enable:enable|shadow_horizontal:2|shadow_vertical:2|shadow_blur:7|shadow_spread:0|box_shadow_color:rgba(0%2C0%2C0%2C0.2)',
				   'dependency'	=> array('element' => 'button2_shape', 'value' => array('square', 'rounded', 'round', 'style5', 'style7', 'style9', 'style10')),
				   'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					'type'				=> 'zolo_single_checkbox',
					'heading'			=> esc_html__('Button Swing', 'apcore'),
					'param_name'		=> 'button2_swing',
					'value'				=> 'no',
					'options'			=> array(
						'yes'			=> array(
							'on'				=> 'Yes',
							'off'				=> 'No',
						),
					),
					'dependency'	=> array('element' => 'button2_shape', 'value' => array('square', 'rounded', 'round', 'style7', 'style10')),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				
				array(
					'type'				=> 'zolo_single_checkbox',
					'heading'			=> esc_html__('Button Icon Enable', 'apcore'),
					'param_name'		=> 'button2_icon_enable',
					'value'				=> 'yes',
					'options'			=> array(
						'yes'			=> array(
							'on'				=> 'Yes',
							'off'				=> 'No',
						),
					),
					'dependency'	=> array('element' => 'button2_enable', 'value' => array('yes')),
					'group'				=> esc_html__('2ND Button', 'apcore'),
				),
				
				array(
					'type'				=> 'dropdown',
					'heading'			=> __( 'Icon library', 'apcore' ),
					'value'				=> array(
						__( 'Font Awesome', 'apcore' )	=> 'fontawesome',
						__( 'Open Iconic', 'apcore' )	=> 'openiconic',
						__( 'Typicons', 'apcore' )		=> 'typicons',
						__( 'Entypo', 'apcore' )		=> 'entypo',
						__( 'Linecons', 'apcore' )		=> 'linecons',
						__( 'Mono Social', 'apcore' )	=> 'monosocial',
						__( 'Linea', 'apcore' ) 	=> 'linea',
					),
					'save_always' 		=> true,
					'param_name' 		=> 'button2_icon_family',
					'description' 		=> __( 'Select icon library.', 'apcore' ),
					'dependency'		=> array('element' => 'button2_icon_enable', 'value' => array('yes')),
					'group'				=> esc_html__('2ND Button', 'apcore'),
				),
				array(
					'type'				=> 'iconpicker',
					'heading'			=> __('Icon', 'apcore'),
					'param_name'		=> 'button2_icon_fontawesome',
					'value'				=> 'fas fa-long-arrow-alt-right',
					'settings'			=> array( 'emptyIcon' => false, 'iconsPerPage' => 100),
					'dependency'		=> array('element' => 'button2_icon_family', 'value' => 'fontawesome'),
					'description'		=> __('Select icon from library.', 'apcore'),
					'group'				=> esc_html__('2ND Button', 'apcore'),
				),	
				array(
					'type'				=> 'iconpicker',
					'heading'			=> __( 'Icon', 'apcore' ),
					'param_name'		=> 'button2_icon_openiconic',
					'value'				=> 'vc-oi vc-oi-dial',
					'settings'			=> array('emptyIcon' => false, 'type' => 'openiconic', 'iconsPerPage' => 100),
					'dependency'		=> array('element' => 'button2_icon_family','value' => 'openiconic'),
					'description'		=> __( 'Select icon from library.', 'apcore' ),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),	
				array(
					'type'				=> 'iconpicker',
					'heading'			=> __( 'Icon', 'apcore' ),
					'param_name'		=> 'button2_icon_typicons',
					'value'				=> 'typcn typcn-adjust-brightness',
					'settings'			=> array('emptyIcon' => false,'type' => 'typicons','iconsPerPage' => 100),
					'dependency'		=> array('element' => 'button2_icon_family','value' => 'typicons'),
					'description'		=> __( 'Select icon from library.', 'apcore'),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					'type' 				=> 'iconpicker',
					'heading' 			=> __( 'Icon', 'apcore' ),
					'param_name' 		=> 'button2_icon_entypo',
					'value' 			=> 'entypo-icon entypo-icon-note',
					'settings' 			=> array('emptyIcon' => false,'type' => 'entypo','iconsPerPage' => 100),
					'dependency' 		=> array('element' => 'button2_icon_family','value' => 'entypo'),
					'description' 		=> __( 'Select icon from library.', 'apcore' ),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					'type' 				=> 'iconpicker',
					'heading' 			=> __( 'Icon', 'apcore' ),
					'param_name' 		=> 'button2_icon_linecons',
					'value' 			=> 'vc_li vc_li-heart',
					'settings' 			=> array('emptyIcon' => false,'type' => 'linecons','iconsPerPage' => 100),
					'dependency' 		=> array('element' => 'button2_icon_family','value' => 'linecons'),
					'description' 		=> __( 'Select icon from library.', 'apcore' ),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),	
				array(
					'type'				=> 'iconpicker',
					'heading'			=> __( 'Icon', 'apcore' ),
					'param_name'		=> 'button2_icon_monosocial',
					'value'				=> 'vc-mono vc-mono-fivehundredpx',
					'settings'			=> array('emptyIcon' => false,'type' => 'monosocial','iconsPerPage' => 100),
					'dependency'		=> array('element' => 'button2_icon_family','value' => 'monosocial'),
					'description'		=> __( 'Select icon from library.', 'apcore' ),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),	
				array(
					'type'				=> 'iconpicker',
					'heading'			=> __('Icon', 'apcore'),
					'param_name'		=> 'button2_icon_linea',
					'value'				=> 'icon-basic-heart',
					'settings'			=> array( 'emptyIcon' => true, 'type' => 'linea', 'iconsPerPage' => 100),
					'dependency'		=> array('element' => 'button2_icon_family', 'value' => 'linea'),
					'description'		=> __('Select icon from library.', 'apcore'),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					'type' 				=> 'zolo_number',
					'heading'			=> esc_html__('Icon size','apcore'),
					'param_name'		=> 'button2_icon_size',
					'value'				=> '16',
					'step'				=> '1',
					'suffix'			=> 'px',
					'dependency'		=> array('element' => 'button2_icon_enable', 'value' => array('yes')),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Icon Color",'apcore'),
					'param_name'		=> "button2_icon_color",
					"value"				=> '#333333',
					'dependency'		=> array('element' => 'button2_icon_enable', 'value' => array('yes')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Icon Hover Color",'apcore'),
					'param_name'		=> "button2_icon_hover_color",
					"value"				=> '#ffffff',
					'dependency'		=> array('element' => 'button2_icon_enable', 'value' => array('yes')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					'type'				=> 'zolo_single_checkbox',
					'heading'			=> esc_html__('Icon Background Enable', 'apcore'),
					'param_name'		=> 'button2_icon_bg_color_show',
					'value'				=> 'no',
					'options'			=> array(
						'yes'			=> array(
							'on'				=> 'Yes',
							'off'				=> 'No',
						),
					),
					'dependency'		=> array('element' => 'button2_shape', 'value' => array('style6', 'style8')),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Icon Background Color",'apcore'),
					'param_name'		=> "button2_icon_bg_color_for_style6",
					"value"				=> '#e5e5e5',
					'dependency' => array( 'element' => 'button2_icon_bg_color_show', 'value' => 'yes'),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Icon Hover Background Color",'apcore'),
					'param_name'		=> "button2_icon_hover_bg_color_for_style6",
					"value"				=> '#549ffc',
					'dependency' => array( 'element' => 'button2_icon_bg_color_show', 'value' => 'yes'),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Icon Alignment', 'apcore'),
					'param_name'		=> 'button2_icon_alignment',
					'value'				=> 'right',
					'options'			=> array(
						esc_html__('Left', 'apcore') 	=> 'left',
						esc_html__('Right', 'apcore')	=> 'right',
					),
					'dependency'		=> array('element' => 'button2_shape', 'value' => array('square','rounded','round','style4')),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('1st Button Typography', 'apcore'),
					'param_name'		=> 'button2_heading',
					'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
					'dependency'	=> array('element' => 'button2_enable', 'value' => array('yes')),
					'group'			=> esc_html__('2ND Button', 'apcore'),
				),
				array(
					'type'				=> 'zolo_font_container',
					'heading'			=> '',
					'param_name'		=> 'button2_font_options',
					'settings'				=> array(
						'fields'				=> array(
							'font_size',							
							'line_height',
							'letter_spacing',
							'font_style',
						),
					),
					'dependency'	=> array('element' => 'button2_enable', 'value' => array('yes')),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Custom font family', 'apcore'),
					'param_name'		=> 'button2_google_fonts',
					'value'				=> 'no',
					'options'			=> array(
						esc_html__('Yes', 'apcore')	=> 'yes',
						esc_html__('No', 'apcore') => 'no',
					),
					'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
					'dependency'	=> array('element' => 'button2_enable', 'value' => array('yes')),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					'type'				=> 'google_fonts',
					'param_name'		=> 'button2_custom_fonts',
					'settings'			=> array(
						'fields'			=> array(
							'font_family_description'	=> esc_html__('Select font family.', 'apcore'),
							'font_style_description'	=> esc_html__('Select font style.', 'apcore'),
						),
					),
					'dependency' => array( 'element' => 'button2_google_fonts', 'value' => 'yes'),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),	
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Text Color",'apcore'),
					'param_name'		=> "button2_text_color",
					"value"				=> '',
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'dependency'	=> array('element' => 'button2_enable', 'value' => array('yes')),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Hover Text Color",'apcore'),
					'param_name'		=> "button2_text_color_h",
					"value"				=> '',
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'dependency'	=> array('element' => 'button2_enable', 'value' => array('yes')),
					'group'				=> esc_html__('2ND Button', 'apcore'),	
				),	

				// 2ND Button Options End
				

				),
			) 
		);		
		
	}		