<?php 
/*-----------------------------------------------------------------------------------*/
/* Header Gradient Icon Box
/*-----------------------------------------------------------------------------------*/

if ( ! defined( 'ABSPATH' ) ) { exit; }
class WPBakeryShortCode_Apress_Header_Gradient_Icon_Box extends WPBakeryShortCode {}

$doc_link = 'http://apresswp.com/help';

if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"			=> __("Header Gradient Icon Box", 'apcore'),
			"base"			=> "apress_header_gradient_icon_box",
			"category"		=> __( "Header Modules", "apcore"),
			"description"	=> __( "Amazing Gradient Icon Box for header Section", "apcore"),
			"icon"			=> APRESS_EXTENSIONS_PLUGIN_URL . "vc_custom/assets/images/vc_icons/vc-icon-gradient_icon_box.png",
			"params"		=> array(
				array(
					'type'        => 'radio_image_select',
					'heading'     => esc_html__( 'Style', 'apcore' ),
					'param_name'  => 'style',
					'simple_mode' => false,
					'options'     => array(
						'iconbox_style1' => array(
							'tooltip' => esc_attr__('Icon Box Style1','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/iconbox_style/iconbox_style1.jpg'
						),
						'iconbox_style2' => array(
							'tooltip' => esc_attr__('Icon Box Style2','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/iconbox_style/iconbox_style2.jpg'
						),
						'iconbox_style3' => array(
							'tooltip' => esc_attr__('Icon Box Style3','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/iconbox_style/iconbox_style3.jpg'
						),
						'iconbox_style4' => array(
							'tooltip' => esc_attr__('Icon Box Style4','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/iconbox_style/iconbox_style4.jpg'
						),
						'iconbox_style5' => array(
							'tooltip' => esc_attr__('Icon Box Style5','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/iconbox_style/iconbox_style5.jpg'
						),
						'iconbox_style6' => array(
							'tooltip' => esc_attr__('Icon Box Style6','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/iconbox_style/iconbox_style6.jpg'
						),
						'iconbox_style7' => array(
							'tooltip' => esc_attr__('Icon Box Style7','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/iconbox_style/iconbox_style7.gif'
						),
						'iconbox_style8' => array(
							'tooltip' => esc_attr__('Icon Box Style8','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/iconbox_style/iconbox_style8.jpg'
						),
						'iconbox_style9' => array(
							'tooltip' => esc_attr__('Icon Box Style9','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/iconbox_style/iconbox_style9.jpg'
						),
						'iconbox_style10' => array(
							'tooltip' => esc_attr__('Icon Box Style10','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/iconbox_style/iconbox_style10.jpg'
						),
					),					
				),
				array(
					"type"				=> "dropdown",
					"heading"			=> __("Icon Alignment",'apcore'),
					'param_name'		=> 'icon_alignment',
					'value'				=> array(
						__('Center', 'apcore')	=> 'center',
						__('Top Left', 'apcore') 	=> 'top_left',
						__('Top Right', 'apcore')	=> 'top_right',
						__('Left', 'apcore') 	=> 'left',
						__('Right', 'apcore')	=> 'right',
						
					),
					'std' 				=> 'left',
					"admin_label"		=> true,
				),
				array(
					'type'				=> 'textarea_html',
					'heading'			=> esc_html__('Title', 'apcore'),
					'param_name'		=> 'content',
					'value'				=> esc_html__('Title','apcore'),
					'admin_label'		=> true,
				),
				array(
					'type'				=> 'textarea',
					'heading'			=> esc_html__('Description', 'apcore'),
					'param_name'		=> 'description',
					'value'				=> esc_html__('Description area','apcore'),
				),
				
				array(
					"type"				=> "vc_link",
					"heading"			=> __("Link",'apcore'),
					"param_name"		=> "box_link",
					"description"		=> __("http://example.com",'apcore'),
				 ),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Box Background Color",'apcore'),
					"param_name"		=> "box_bg_color",
					"value"				=> '#ffffff',
					'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style7', 'iconbox_style8')),
				),
				array(
					"type"				=> "dropdown",
					"heading"			=> __("Select Color Scheme",'apcore'),
					"param_name"		=> "color_scheme",
					"value"				=> array(
						__("Primary Color",'apcore') 	=> "primary_color_scheme",
						__("Color Scheme 1",'apcore') 	=> "color_scheme1",
						__("Color Scheme 2",'apcore') 	=> "color_scheme2",
						__("Gradient Scheme 1",'apcore') 	=> "gradient_scheme1",
						__("Gradient Scheme 2",'apcore') 	=> "gradient_scheme2",
						__("Gradient Scheme 3",'apcore') 	=> "gradient_scheme3",
						__("Custom Color",'apcore') 		=> "design_your_own"
					),
					'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style1', 'iconbox_style2', 'iconbox_style3', 'iconbox_style4', 'iconbox_style5', 'iconbox_style6', 'iconbox_style7', 'iconbox_style8', 'iconbox_style10')),
				),	
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Icon Color",'apcore'),
					"param_name"		=> "custom_color",
					"value"				=> '#549ffc',
					'dependency'		=> array('element' => 'color_scheme', 'value' => array('design_your_own')),
				),	
				array(
					'type' 		=> 'zolo_number',
					'heading' 	=> __("Border Width",'apcore'),
					'param_name'=> 'highlight_border_width',
					"value" => 3,
					"step" => 1,
					'suffix'=> 'px',
					"edit_field_class"	=> "apress-heading-param-wrapper vc_column vc_col-sm-6 no-top-margin",
					'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style8')),
				),
				array(
					"type"			=> "colorpicker",
					"heading"		=> __("Border Color",'apcore'),
					"param_name"	=> "highlight_border_color",
					"value"			=> '#e5e5e5',
					"edit_field_class"	=> "apress-heading-param-wrapper vc_column vc_col-sm-6 no-top-margin",
					'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style8')),
				),
				array(
					"type"			=> "dropdown",
					"heading"		=> __("Border Hover Color Scheme",'apcore'),
					"param_name"	=> "border_hover_color_scheme",
					"value"			=> array(
						__("Primary Color",'apcore') 	=> "primary_color_scheme",
						__("Color Scheme 1",'apcore') 	=> "color_scheme1",
						__("Color Scheme 2",'apcore') 	=> "color_scheme2",
						__("Gradient Scheme 1",'apcore') => "gradient_scheme1",
						__("Gradient Scheme 2",'apcore') => "gradient_scheme2",
						__("Gradient Scheme 3",'apcore') => "gradient_scheme3",
						__("Custom Color",'apcore') 	=> "design_your_own"
					),
					"edit_field_class"	=> "apress-heading-param-wrapper vc_column vc_col-sm-6 no-top-margin",
					'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style8')),
				),
				array(
					"type"			=> "colorpicker",
					"heading"		=> __("Border Hover Color",'apcore'),
					"param_name"	=> "border_hover_color",
					"value"			=> '#003ba3',
					"edit_field_class"	=> "apress-heading-param-wrapper vc_column vc_col-sm-6 no-top-margin",
					'dependency'	=> array('element' => 'border_hover_color_scheme', 'value' => array('design_your_own')),
				),
				array(
				   'type'    => 'zolo_box_shadow_param',
				   'heading'	=> esc_html__('Box Shadow', 'apcore'),
				   'param_name' => 'box_shadow',
				   "value"		=> 'box_shadow_enable:disable|shadow_horizontal:0|shadow_vertical:2|shadow_blur:10|shadow_spread:0|box_shadow_color:rgba(0%2C0%2C0%2C0.08)',
				   'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style7', 'iconbox_style8')),
				),
				array(
				   'type'    => 'zolo_box_shadow_param',
				   'heading'	=> esc_html__('Box Hover Shadow', 'apcore'),
				   'param_name' => 'box_hover_shadow',
				   "value"		=> 'box_shadow_enable:enable|shadow_horizontal:0|shadow_vertical:7|shadow_blur:90|shadow_spread:-38|box_shadow_color:rgba(0%2C0%2C0%2C0.1)',
				   'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style7', 'iconbox_style8')),
				),
				
				array(
					"type" 			=> "zolo_number",
					"heading" 		=> __("Box top Padding",'apcore'),
					'description' 	=> __( 'Enter value without px', 'apcore' ),
					"param_name" 	=> "box_top_padding",
					"value" 		=> '40',
					'edit_field_class'	=> 'vc_column vc_col-sm-3',
					'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style7', 'iconbox_style8')),
				 ),
				 array(
					"type" 			=> "zolo_number",
					"heading" 		=> __("Box Right Padding",'apcore'),
					'description' 	=> __( 'Enter value without px', 'apcore' ),
					"param_name" 	=> "box_right_padding",
					"value" 		=> '40',
					'edit_field_class'=> 'vc_column vc_col-sm-3',
					'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style7', 'iconbox_style8')),
				 ),						 
				 array(
					"type" 			=> "zolo_number",
					"heading" 		=> __("Box Bottom Padding",'apcore'),
					'description' 	=> __( 'Enter value without px', 'apcore' ),
					"param_name" 	=> "box_bottom_padding",
					"value" 		=> '40',
					'edit_field_class'=> 'vc_column vc_col-sm-3',
					'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style7', 'iconbox_style8')),
				 ),	
				 array(
					"type" 			=> "zolo_number",
					"heading" 		=> __("Box Left Padding",'apcore'),
					'description' 	=> __( 'Enter value without px', 'apcore' ),
					"param_name" 	=> "box_left_padding",
					"value" 		=> '40',
					'edit_field_class'=> 'vc_column vc_col-sm-3',
					'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style7', 'iconbox_style8')),
				 ),
				array(
					'type'				=> 'zolo_single_checkbox',
					'heading'			=> esc_html__('Icon Shadow', 'apcore'),
					'param_name'		=> 'icon_shadow',
					'value'				=> 'yes',
					'options'			=> array(
						'yes'			=> array(
							'on'				=> 'Yes',
							'off'				=> 'No',
						),
					),
					'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style2', 'iconbox_style4')),
				),
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Extra features', 'apcore'),
					'param_name'		=> 'subtitle_margin_heading',
					'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
				),
				array(
					"type"				=> "dropdown",
					"class"				=> "",
					"heading"			=> __("CSS Animation",'apcore'),
					"param_name"		=> "data_animation",
					"value"				=> apress_data_animations(),
					"description"		=> __("Select type of animation. Note: Works only in modern browsers.",'apcore'),
					"edit_field_class"	=> "apress-heading-param-wrapper vc_column vc_col-sm-8 no-top-margin",
				),  
				array(
					"type"				=> "textfield",
					"class"				=> "",
					"heading"			=> __("Delay","apcore"),
					"param_name"		=> "data_delay",
					"value"				=> "500",
					"description"		=> __("Delay","apcore"),
					"edit_field_class"	=> "apress-heading-param-wrapper vc_column vc_col-sm-4 no-top-margin",
				),
				array(
					"type"				=> "textfield",
					"heading"			=> __("Extra class name", "apcore"),
					"param_name"		=> "class",
					"description"		=> __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "apcore")
				),
				array(
					'type'				=> 'zolo_video_link_param',
					'heading'			=> esc_html__('Video tutorial and theme documentation article','apcore'),
					'param_name'		=> 'tutorials',
					'doc_link'			=> $doc_link,
					'video_link'		=> 'https://youtu.be/Gk6g0uOC9V0',
				),
				
				array(
					'type'				=> 'zolo_single_checkbox',
					'heading'			=> esc_html__('Box Styling Enable', 'apcore'),
					'param_name'		=> 'wrapbox_styling_enable',
					'value'				=> 'no',
					'options'			=> array(
						'yes'			=> array(
							'on'				=> 'Yes',
							'off'				=> 'No',
						),
					),
					'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style1', 'iconbox_style9', 'iconbox_style10')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				
				array(
					'type'				=> 'zolo_single_checkbox',
					'heading'			=> esc_html__('Box Overflow Visible?', 'apcore'),
					'param_name'		=> 'wrapbox_overflow',
					'value'				=> 'no',
					'options'			=> array(
						'yes'			=> array(
							'on'				=> 'Yes',
							'off'				=> 'No',
						),
					),
					'dependency'		=> array('element' => 'wrapbox_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Box Styling', 'apcore'),
					'param_name'		=> 'wrapbox_styling_heading',
					'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
					'dependency'		=> array('element' => 'wrapbox_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),		
				array(
					"type"			=> "dropdown",
					"heading"		=> __("Background Color Scheme",'apcore'),
					"param_name"	=> "wrapbox_bg_color_scheme",
					"value"			=> array(
						__("Primary Color",'apcore') 	=> "primary_color_scheme",
						__("Color Scheme 1",'apcore') 	=> "color_scheme1",
						__("Color Scheme 2",'apcore') 	=> "color_scheme2",
						__("Gradient Scheme 1",'apcore') => "gradient_scheme1",
						__("Gradient Scheme 2",'apcore') => "gradient_scheme2",
						__("Gradient Scheme 3",'apcore') => "gradient_scheme3",
						__("Custom Color",'apcore') 	=> "design_your_own"
					),
					'std' 				=> 'design_your_own',
					'dependency'		=> array('element' => 'wrapbox_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				
				array(
					"type"				=> "colorpicker",
					"class"				=> "",
					"heading"			=> __("Background Color",'apcore'),
					"param_name"		=> "wrapbox_bg_color",
					"value"				=> '#f9f9f9',
					"description"		=> __("Select normal background color.",'apcore'),
					'dependency'		=> array('element' => 'wrapbox_bg_color_scheme', 'value' => array('design_your_own')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				array(
					'type' 				=> 'zolo_number',
					'heading' 			=> __("Opacity",'apcore'),
					'param_name'		=> 'wrapbox_bg_color_opacity',
					"value" 			=> 1,
					"min" 				=> 0.0,
					"max" 				=> 1.0,
					"step" 				=> 0.1,
					'suffix'			=> 'px',
					'dependency'		=> array('element' => 'wrapbox_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),	
				array(
					"type"				=> "attach_image",
					"class"				=> "",
					"heading"			=> __("Image", "apcore"),
					"param_name"		=> "wrapbox_bg_image",
					"value"				=> "",
					'dependency'		=> array('element' => 'wrapbox_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Box Hover Styling', 'apcore'),
					'param_name'		=> 'wrapbox_hover_styling_heading',
					'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
					'dependency'		=> array('element' => 'wrapbox_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				array(
					"type"				=> "dropdown",
					"heading"			=> __("Background Color Scheme",'apcore'),
					"param_name"		=> "wrapbox_hover_bg_color_scheme",
					"value"				=> array(
						__("Primary Color",'apcore') 	=> "primary_color_scheme",
						__("Color Scheme 1",'apcore') 	=> "color_scheme1",
						__("Color Scheme 2",'apcore') 	=> "color_scheme2",
						__("Gradient Scheme 1",'apcore') 	=> "gradient_scheme1",
						__("Gradient Scheme 2",'apcore') 	=> "gradient_scheme2",
						__("Gradient Scheme 3",'apcore') 	=> "gradient_scheme3",
						__("Custom Color",'apcore') 	=> "design_your_own"
					),
					'std' 				=> 'primary_color_scheme',
					'dependency'		=> array('element' => 'wrapbox_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Background Color",'apcore'),
					"param_name"		=> "wrapbox_hover_bg_color",
					"value"				=> '',
					"description"		=> __("Select normal background color.",'apcore'),
					'dependency'		=> array('element' => 'wrapbox_hover_bg_color_scheme', 'value' => array('design_your_own')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				array(
					'type' 				=> 'zolo_number',
					'heading' 			=> __("Opacity",'apcore'),
					'param_name'		=> 'wrapbox_hover_bg_color_opacity',
					"value" 			=> 1,
					"min" 				=> 0.0,
					"max" 				=> 1.0,
					"step" 				=> 0.1,
					'suffix'			=> 'px',
					'dependency'		=> array('element' => 'wrapbox_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),	
				array(
					"type"				=> "attach_image",
					"class"				=> "",
					"heading"			=> __("Image", "apcore"),
					"param_name"		=> "wrapbox_hover_bg_image",
					"value"				=> "",
					'dependency'		=> array('element' => 'wrapbox_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Hover Font Color",'apcore'),
					"param_name"		=> "wrapbox_hover_text_color",
					"value"				=> '#ffffff',
					"description"		=> __("Select text color.",'apcore'),
					'dependency'		=> array('element' => 'wrapbox_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				array(
					'type' 				=> 'zolo_number',
					'heading'			=> esc_html__('Border Radius','apcore'),
					'param_name'		=> 'wrapbox_border_radius',
					'value'				=> '0',
					'step'				=> '1',
					'suffix'			=> 'px',
					'dependency'		=> array('element' => 'wrapbox_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				
				array(
				   'type'    			=> 'zolo_box_shadow_param',
				   'heading'			=> esc_html__('Box Shadow', 'apcore'),
				   'param_name' 		=> 'box_shadow_style1',
				   "value"				=> 'box_shadow_enable:disable|shadow_horizontal:0|shadow_vertical:2|shadow_blur:10|shadow_spread:0|box_shadow_color:rgba(0%2C0%2C0%2C0.08)',
				   'dependency'		=> array('element' => 'wrapbox_styling_enable', 'value' => array('yes')),
				   'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				array(
				   'type'    			=> 'zolo_box_shadow_param',
				   'heading'			=> esc_html__('Box Hover Shadow', 'apcore'),
				   'param_name' 		=> 'box_hover_shadow_style1',
				   "value"				=> 'box_shadow_enable:enable|shadow_horizontal:0|shadow_vertical:7|shadow_blur:90|shadow_spread:-38|box_shadow_color:rgba(0%2C0%2C0%2C0.1)',
				   'dependency'		=> array('element' => 'wrapbox_styling_enable', 'value' => array('yes')),
				   'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				
				array(
					"type" 				=> "zolo_number",
					"heading" 			=> __("Box top Padding",'apcore'),
					'description' 		=> __( 'Enter value without px', 'apcore' ),
					"param_name" 		=> "box_top_padding_style1",
					"value" 			=> '40',
					'edit_field_class'	=> 'vc_column vc_col-sm-3',
					'dependency'		=> array('element' => 'wrapbox_styling_enable', 'value' => array('yes')),
				    'group'				=> esc_html__('Box Styling', 'apcore'),
				 ),
				 array(
					"type" 				=> "zolo_number",
					"heading" 			=> __("Box Right Padding",'apcore'),
					'description' 		=> __( 'Enter value without px', 'apcore' ),
					"param_name" 		=> "box_right_padding_style1",
					"value" 			=> '40',
					'edit_field_class'	=> 'vc_column vc_col-sm-3',
					'dependency'		=> array('element' => 'wrapbox_styling_enable', 'value' => array('yes')),
				    'group'				=> esc_html__('Box Styling', 'apcore'),
				 ),						 
				 array(
					"type" 				=> "zolo_number",
					"heading" 			=> __("Box Bottom Padding",'apcore'),
					'description' 		=> __( 'Enter value without px', 'apcore' ),
					"param_name" 		=> "box_bottom_padding_style1",
					"value" 			=> '40',
					'edit_field_class'	=> 'vc_column vc_col-sm-3',
					'dependency'		=> array('element' => 'wrapbox_styling_enable', 'value' => array('yes')),
				    'group'		  		=> esc_html__('Box Styling', 'apcore'),
				 ),	
				 array(
					"type" 				=> "zolo_number",
					"heading" 			=> __("Box Left Padding",'apcore'),
					'description' 		=> __( 'Enter value without px', 'apcore' ),
					"param_name" 		=> "box_left_padding_style1",
					"value" 			=> '40',
					'edit_field_class'	=> 'vc_column vc_col-sm-3',
					'dependency'		=> array('element' => 'wrapbox_styling_enable', 'value' => array('yes')),
				    'group'				=> esc_html__('Box Styling', 'apcore'),
				 ),
				
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Icon Type', 'apcore'),
					'param_name'		=> 'icon_type',
					'value'				=> 'icon',
					'options'			=> array(
						esc_html__('Icon', 'apcore')	=> 'icon',
						esc_html__('Image', 'apcore')	=> 'image',
						esc_html__('Animated SVG', 'apcore')	=> 'icon_svg',
					),
					'group'				=> esc_html__('Icon', 'apcore'),
				),	
				array(
					"type"				=> "attach_image",
					"class"				=> "",
					"heading"			=> __("Image", "apcore"),
					"param_name"		=> "icon_image",
					"value"				=> "",
					'dependency'		=> array('element' => 'icon_type', 'value' => array('image', 'icon_svg')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),			
				array(
					"type"				=> "textfield",
					"heading"			=> esc_html__('SVG Animation Duration', 'apcore'),
					"param_name"		=> "icon_svg_animation_duration",
					"value"				=> '100',
					"description"		=> esc_html__( "Add delay in milliseconds.", "apcore" ),
					"dependency"		=> array( 'element' => "icon_type", 'value' => array( 'icon_svg' ) ),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Start Color",'apcore'),
					'param_name'		=> "start_color",
					"value"				=> '#0467e6',
					"dependency"		=> array( 'element' => "icon_type", 'value' => array( 'icon_svg' ) ),
					'group'				=> esc_html__('Icon', 'apcore'),
					'edit_field_class' 	=> 'vc_column vc_col-sm-6',
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("End Color",'apcore'),
					'param_name'		=> "end_color",
					"value"				=> '#5295ea',
					"dependency"		=> array( 'element' => "icon_type", 'value' => array( 'icon_svg' ) ),
					'group'				=> esc_html__('Icon', 'apcore'),
					'edit_field_class' 	=> 'vc_column vc_col-sm-6',
				),
				array(
					'type'				=> 'dropdown',
					'heading'			=> __( 'Icon library', 'apcore' ),
					'value'				=> array(
						__( 'Font Awesome', 'apcore' )	=> 'fontawesome',
						__( 'Open Iconic', 'apcore' )	=> 'openiconic',
						__( 'Typicons', 'apcore' )		=> 'typicons',
						__( 'Entypo', 'apcore' )		=> 'entypo',
						__( 'Linecons', 'apcore' )		=> 'linecons',
						__( 'Mono Social', 'apcore' )	=> 'monosocial',
						__( 'Linea', 'apcore' ) 	=> 'linea',
					),
					'save_always' 		=> true,
					'param_name' 		=> 'icon_family',
					'description' 		=> __( 'Select icon library.', 'apcore' ),
					'dependency'		=> array('element' => 'icon_type', 'value' => 'icon'),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					'type'				=> 'iconpicker',
					'heading'			=> __('Icon', 'apcore'),
					'param_name'		=> 'icon_fontawesome',
					'value'				=> 'fa fa-rocket',
					'settings'			=> array( 'emptyIcon' => false, 'iconsPerPage' => 100),
					'dependency'		=> array('element' => 'icon_family', 'value' => 'fontawesome'),
					'description'		=> __('Select icon from library.', 'apcore'),
					'group'				=> esc_html__('Icon', 'apcore'),
				),	
				array(
					'type'				=> 'iconpicker',
					'heading'			=> __( 'Icon', 'apcore' ),
					'param_name'		=> 'icon_openiconic',
					'value'				=> 'vc-oi vc-oi-dial',
					'settings'			=> array('emptyIcon' => false, 'type' => 'openiconic', 'iconsPerPage' => 100),
					'dependency'		=> array('element' => 'icon_family','value' => 'openiconic'),
					'description'		=> __( 'Select icon from library.', 'apcore' ),
					'group'				=> esc_html__('Icon', 'apcore'),
				),	
				array(
					'type'				=> 'iconpicker',
					'heading'			=> __( 'Icon', 'apcore' ),
					'param_name'		=> 'icon_typicons',
					'value'				=> 'typcn typcn-adjust-brightness',
					'settings'			=> array('emptyIcon' => false,'type' => 'typicons','iconsPerPage' => 100),
					'dependency'		=> array('element' => 'icon_family','value' => 'typicons'),
					'description'		=> __( 'Select icon from library.', 'apcore'),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					'type' 				=> 'iconpicker',
					'heading' 			=> __( 'Icon', 'apcore' ),
					'param_name' 		=> 'icon_entypo',
					'value' 			=> 'entypo-icon entypo-icon-note',
					'settings' 			=> array('emptyIcon' => false,'type' => 'entypo','iconsPerPage' => 100),
					'dependency' 		=> array('element' => 'icon_family','value' => 'entypo'),
					'description' 		=> __( 'Select icon from library.', 'apcore' ),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					'type' 				=> 'iconpicker',
					'heading' 			=> __( 'Icon', 'apcore' ),
					'param_name' 		=> 'icon_linecons',
					'value' 			=> 'vc_li vc_li-heart',
					'settings' 			=> array('emptyIcon' => false,'type' => 'linecons','iconsPerPage' => 100),
					'dependency' 		=> array('element' => 'icon_family','value' => 'linecons'),
					'description' 		=> __( 'Select icon from library.', 'apcore' ),
					'group'				=> esc_html__('Icon', 'apcore'),
				),	
				array(
					'type'				=> 'iconpicker',
					'heading'			=> __( 'Icon', 'apcore' ),
					'param_name'		=> 'icon_monosocial',
					'value'				=> 'vc-mono vc-mono-fivehundredpx',
					'settings'			=> array('emptyIcon' => false,'type' => 'monosocial','iconsPerPage' => 100),
					'dependency'		=> array('element' => 'icon_family','value' => 'monosocial'),
					'description'		=> __( 'Select icon from library.', 'apcore' ),
					'group'				=> esc_html__('Icon', 'apcore'),
				),	
				array(
					'type'				=> 'iconpicker',
					'heading'			=> __('Icon', 'apcore'),
					'param_name'		=> 'icon_linea',
					'value'				=> 'icon-basic-heart',
					'settings'			=> array( 'emptyIcon' => true, 'type' => 'linea', 'iconsPerPage' => 100),
					'dependency'		=> array('element' => 'icon_family', 'value' => 'linea'),
					'description'		=> __('Select icon from library.', 'apcore'),
					'group'				=> esc_html__( 'Icon', 'apcore' ),
				),
				array(
					"type"			=> "dropdown",
					"heading"		=> __("Icon Color Scheme",'apcore'),
					"param_name"	=> "gradient_icon_color_scheme",
					"value"			=> array(
						__("Primary Color",'apcore') 	=> "primary_color_scheme",
						__("Color Scheme 1",'apcore') 	=> "color_scheme1",
						__("Color Scheme 2",'apcore') 	=> "color_scheme2",
						__("Gradient Scheme 1",'apcore') => "gradient_scheme1",
						__("Gradient Scheme 2",'apcore') => "gradient_scheme2",
						__("Gradient Scheme 3",'apcore') => "gradient_scheme3",
						__("Custom Color",'apcore') 	=> "design_your_own"
					),
					'std' 				=> 'design_your_own',
					'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style9')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Icon Color",'apcore'),
					"param_name"		=> "gradient_icon_color",
					"value"				=> '#3ed2a7',
					"description"		=> __("Select normal background color.",'apcore'),
					'dependency'		=> array('element' => 'gradient_icon_color_scheme', 'value' => array('design_your_own')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					"type"			=> "dropdown",
					"heading"		=> __("Icon Background Color Scheme",'apcore'),
					"param_name"	=> "icon_background_color_scheme",
					"value"			=> array(
						__("Primary Color",'apcore') 	=> "primary_color_scheme",
						__("Color Scheme 1",'apcore') 	=> "color_scheme1",
						__("Color Scheme 2",'apcore') 	=> "color_scheme2",
						__("Gradient Scheme 1",'apcore') => "gradient_scheme1",
						__("Gradient Scheme 2",'apcore') => "gradient_scheme2",
						__("Gradient Scheme 3",'apcore') => "gradient_scheme3",
						__("Custom Color",'apcore') 	=> "design_your_own"
					),
					'std' 				=> 'design_your_own',
					'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style9')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("icon Background Color",'apcore'),
					"param_name"		=> "icon_background_color",
					"value"				=> 'rgba(62, 210, 167, 0.26)',
					"description"		=> __("Select normal background color.",'apcore'),
					'dependency'		=> array('element' => 'icon_background_color_scheme', 'value' => array('design_your_own')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				
				array(
					"type"			=> "dropdown",
					"heading"		=> __("Icon Hover Background Color Scheme",'apcore'),
					"param_name"	=> "icon_hover_background_color_scheme",
					"value"			=> array(
						__("Primary Color",'apcore') 	=> "primary_color_scheme",
						__("Color Scheme 1",'apcore') 	=> "color_scheme1",
						__("Color Scheme 2",'apcore') 	=> "color_scheme2",
						__("Gradient Scheme 1",'apcore') => "gradient_scheme1",
						__("Gradient Scheme 2",'apcore') => "gradient_scheme2",
						__("Gradient Scheme 3",'apcore') => "gradient_scheme3",
						__("Custom Color",'apcore') 	=> "design_your_own"
					),
					'std' 				=> 'design_your_own',
					'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style9')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Icon Hover Background Color",'apcore'),
					"param_name"		=> "icon_hover_background_color",
					"value"				=> '#3ed2a7',
					"description"		=> __("Select normal background color.",'apcore'),
					'dependency'		=> array('element' => 'icon_hover_background_color_scheme', 'value' => array('design_your_own')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					'type' 				=> 'zolo_number',
					'heading'			=> esc_html__('Icon size','apcore'),
					'param_name'		=> 'gradient_icon_size',
					'value'				=> '30',
					'step'				=> '1',
					'suffix'			=> 'px',
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				
				array(
					"type" 				=> "zolo_number",
					"heading" 			=> __("Icon top Margin",'apcore'),
					'description' 		=> __( 'Enter value without px', 'apcore' ),
					"param_name" 		=> "icon_top_padding",
					"value" 			=> '0',
					'suffix'			=> 'px',
					'edit_field_class'	=> 'vc_column vc_col-sm-6',
				    'group'				=> esc_html__('Icon', 'apcore'),
				 ),						 
				 array(
					"type" 				=> "zolo_number",
					"heading" 			=> __("Icon Bottom Margin",'apcore'),
					'description' 		=> __( 'Enter value without px', 'apcore' ),
					"param_name" 		=> "icon_bottom_padding",
					"value" 			=> '0',
					'suffix'			=> 'px',
					'edit_field_class'	=> 'vc_column vc_col-sm-6',
				    'group'		  		=> esc_html__('Icon', 'apcore'),
				 ),	
				 array(
					"type" 				=> "zolo_number",
					"heading" 			=> __("Icon and Content space",'apcore'),
					'description' 		=> __( 'Enter value without px. Control the space between icon and content . Works for left and right alignment of icon', 'apcore' ),
					"param_name" 		=> "icon_left_right_gap",
					"value" 			=> '14',
					'suffix'			=> 'px',
					'edit_field_class'	=> 'vc_column vc_col-sm-6',
					'dependency'		=> array('element' => 'icon_alignment', 'value' => array('left','right')),
				    'group'				=> esc_html__('Icon', 'apcore'),
				 ),						 	
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Icon Background Styling', 'apcore'),
					'param_name'		=> 'icon_bg_heading',
					'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
					'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style1')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					'type'				=> 'zolo_single_checkbox',
					'heading'			=> esc_html__('Icon Background Enable', 'apcore'),
					'param_name'		=> 'icon_bg_enable',
					'value'				=> 'no',
					'options'			=> array(
						'yes'			=> array(
							'on'				=> 'Yes',
							'off'				=> 'No',
						),
					),
					'dependency'		=> array('element' => 'style', 'value' => array('iconbox_style1')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Icon Background Type', 'apcore'),
					'param_name'		=> 'icon_bg_type',
					'value'				=> 'image',
					'options'			=> array(
						esc_html__('Image', 'apcore')	=> 'image',
						esc_html__('SVG', 'apcore')	=> 'svgbg',
					),
					'dependency'		=> array('element' => 'icon_bg_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),	
				array(
					"type"				=> "attach_image",
					"class"				=> "",
					"heading"			=> __("Image", "apcore"),
					"param_name"		=> "image_bg",
					"value"				=> "",
					'dependency'		=> array('element' => 'icon_bg_type', 'value' => array('image', 'svgbg')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),			
				array(
					'type' 				=> 'zolo_number',
					'heading'			=> esc_html__('Icon Background Size','apcore'),
					'param_name'		=> 'gradient_icon_bg_size',
					'value'				=> '60',
					'step'				=> '1',
					'suffix'			=> 'px',
					'dependency'		=> array('element' => 'icon_bg_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Background Image/SVG Position', 'apcore'),
					'param_name'		=> 'icon_bg_position',
					'value'				=> 'position_icon_bg',
					'options'			=> array(
						esc_html__('Icon Background', 'apcore')	=> 'position_icon_bg',
						esc_html__('Box Background', 'apcore')	=> 'position_box_bg',
					),
					'dependency'		=> array('element' => 'icon_bg_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				
				array(
					"type"				=> "textfield",
					"heading"			=> __("Position Top","apcore"),
					"param_name"		=> "bg_position_top",
					"value"				=> "",
					'description' 		=> __( 'enter value in px or % ex: 10px.', 'apcore' ),
					'edit_field_class'	=> 'vc_column vc_col-sm-3',
					'dependency'		=> array('element' => 'icon_bg_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					"type"				=> "textfield",
					"heading"			=> __("Position Right","apcore"),
					"param_name"		=> "bg_position_right",
					"value"				=> "",
					'description' 		=> __( 'enter value in px or % ex: 10px.', 'apcore' ),
					'edit_field_class'	=> 'vc_column vc_col-sm-3',
					'dependency'		=> array('element' => 'icon_bg_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					"type"				=> "textfield",
					"heading"			=> __("Position Bottom","apcore"),
					"param_name"		=> "bg_position_bottom",
					"value"				=> "",
					'description' 		=> __( 'enter value in px or % ex: 10px.', 'apcore' ),
					'edit_field_class'	=> 'vc_column vc_col-sm-3',
					'dependency'		=> array('element' => 'icon_bg_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					"type"				=> "textfield",
					"heading"			=> __("Position Left","apcore"),
					"param_name"		=> "bg_position_left",
					"value"				=> "",
					'description' 		=> __( 'enter value in px or % ex: 10px.', 'apcore' ),
					'edit_field_class'	=> 'vc_column vc_col-sm-3',
					'dependency'		=> array('element' => 'icon_bg_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					"type"				=> "dropdown",
					"heading"			=> __("On Hover Background Animation",'apcore'),
					"param_name"		=> "on_hover_icon_bg_animation",
					"value"				=> array(
						__("No Animation",'apcore') 	=> "zolo_icon_bg_animation_no",
						__("Zoom In",'apcore') 	=> "zolo_icon_bg_animation1",
						__("Zoom Out",'apcore') 	=> "zolo_icon_bg_animation2",
						__("rotate",'apcore') 	=> "zolo_icon_bg_animation3",
						__("Buzz Out",'apcore') 	=> "zolo_icon_bg_animation4",
					),
					'std' 				=> 'zolo_icon_bg_animation_no',
					'dependency'		=> array('element' => 'icon_bg_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),

				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Title Typography', 'apcore'),
					'param_name'		=> 'title_heading',
					'class'				=> 'zolo-param-heading',
					'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12',
					'group'				=> esc_html__('Title Typography', 'apcore'),
				),
				array(
					'type'				=> 'zolo_font_container',
					'heading'			=> '',
					'param_name'		=> 'title_font_options',
					'settings'				=> array(
						'fields'				=> array(
							'tag' => 'h2',
							'font_size',							
							'line_height',
							'letter_spacing',
							'font_style',
							'color',
						),
					),
					'group'				=> esc_html__('Title Typography', 'apcore'),
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Custom font family', 'apcore'),
					'param_name'		=> 'title_google_fonts',
					'value'				=> 'no',
					'options'			=> array(
						esc_html__('Yes', 'apcore')	=> 'yes',
						esc_html__('No', 'apcore') => 'no',
					),
					'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
					'group'				=> esc_html__('Title Typography', 'apcore'),
				),
				array(
					'type'				=> 'google_fonts',
					'param_name'		=> 'title_custom_fonts',
					'settings'			=> array(
						'fields'			=> array(
							'font_family_description'	=> esc_html__('Select font family.', 'apcore'),
							'font_style_description'	=> esc_html__('Select font style.', 'apcore'),
						),
					),
					'dependency' => array( 'element' => 'title_google_fonts', 'value' => 'yes'),
					'group'				=> esc_html__('Title Typography', 'apcore'),
				),
				
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Description Typography', 'apcore'),
					'param_name'		=> 'description_heading',
					'class'				=> 'zolo-param-heading',
					'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12',
					'group'				=> esc_html__('Description Typography', 'apcore'),
				),
				array(
					'type'				=> 'zolo_font_container',
					'heading'			=> '',
					'param_name'		=> 'description_font_options',
					'settings'				=> array(
						'fields'			=> array(
							'font_size',							
							'line_height',
							'letter_spacing',
							'font_style',
							'color',
						),
					),
					'group'				=> esc_html__('Description Typography', 'apcore'),
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Custom font family', 'apcore'),
					'param_name'		=> 'description_google_fonts',
					'value'				=> 'no',
					'options'			=> array(
						esc_html__('Yes', 'apcore')	=> 'yes',
						esc_html__('No', 'apcore') => 'no',
					),
					'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
					'group'				=> esc_html__('Description Typography', 'apcore'),
				),
				array(
					'type'				=> 'google_fonts',
					'param_name'		=> 'description_custom_fonts',
					'settings'			=> array(
						'fields'			=> array(
							'font_family_description'	=> esc_html__('Select font family.', 'apcore'),
							'font_style_description'	=> esc_html__('Select font style.', 'apcore'),
						),
					),
					'dependency' => array( 'element' => 'description_google_fonts', 'value' => 'yes'),
					'group'				=> esc_html__('Description Typography', 'apcore'),
				),		
			
				),
			) 
		);		
		
	}		