<?php

add_filter( 'vc_load_default_templates', 'apress_reset_default_templates' ); // Hook in
function apress_reset_default_templates( $data ) {
	// This will remove all default templates. Basically you should use native PHP functions to modify existing array and then return it.
    return array(); 
}

function apress_add_default_templates() {

	$templates = apress_vc_templates();
	return array_map( 'vc_add_default_templates', $templates );
}
apress_add_default_templates();

function apress_vc_templates(){
	
	$templates = array();
	
	//Category Banners
	//About Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 1', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about1.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][apress_heading sub_title="" enable_delimiter="" style="heading_style1" heading_margin="margin-bottom:50" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div"]We are a <u><em>Digital First </em></u> web development company based in New York City.[/apress_heading][ultimate_spacer height="50"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " data_animation="fadeInUp" data_delay="300" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="50"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " data_animation="fadeInUp" data_delay="1200" icon_family="linecons" icon_linecons="vc_li vc_li-paperplane" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][/vc_column][vc_column width="1/3"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " data_animation="fadeInUp" data_delay="600" icon_family="linecons" icon_linecons="vc_li vc_li-diamond" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="50"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " data_animation="fadeInUp" data_delay="1500" icon_family="linecons" icon_linecons="vc_li vc_li-shop" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][/vc_column][vc_column width="1/3"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " data_animation="fadeInUp" data_delay="900" icon_family="linecons" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="50"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " data_animation="fadeInUp" data_delay="1800" icon_family="linecons" icon_linecons="vc_li vc_li-star" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//About Banner 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 2', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about2.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][vc_row_inner][vc_column_inner width="1/2"][apress_heading sub_title="" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" style="heading_style1" heading_margin="margin-bottom:50" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div"]We are a <u><em>Digital First </em></u> web development company based in NYC.[/apress_heading][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text css_animation="fadeInUp"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. Vivamus a eros vel tellus consequat dictum. Integer eget blandit nunc. Suspendisse porttitor ex magna, et sodales quam venenatis quis. Pellentesque iaculis tincidunt augue nec mollis. Sed vitae sapien non diam feugiat bibendum. Phasellus convallis lacus in nisi auctor, in convallis felis feugiat. Fusce ac feugiat leo, nec aliquam erat. Vivamus porttitor eget arcu a porttitor. Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/vc_column_text][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. " icon_alignment="left" data_animation="fadeInUp" data_delay="300" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" style="iconbox_style4" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="50"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. " icon_alignment="left" data_animation="fadeInUp" data_delay="1200" icon_family="linecons" icon_linecons="vc_li vc_li-paperplane" style="iconbox_style4" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][/vc_column][vc_column width="1/3"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " icon_alignment="left" data_animation="fadeInUp" data_delay="600" icon_family="linecons" icon_linecons="vc_li vc_li-diamond" style="iconbox_style4" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="50"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. " icon_alignment="left" data_animation="fadeInUp" data_delay="1500" icon_family="linecons" icon_linecons="vc_li vc_li-shop" style="iconbox_style4" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][/vc_column][vc_column width="1/3"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. " icon_alignment="left" data_animation="fadeInUp" data_delay="900" icon_family="linecons" style="iconbox_style4" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="50"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. " icon_alignment="left" data_animation="fadeInUp" data_delay="1800" icon_family="linecons" icon_linecons="vc_li vc_li-star" style="iconbox_style4" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Big Button Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 5', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about5.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^30|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/bg5.jpg|caption^null|alt^null|title^bg5|description^null" enable_overlay="enable_overlay_value" overlay_color="rgba(0,0,0,0.5)" css=".vc_custom_1504691266490{background-color: #f7f7f7 !important;}"][vc_column css=".vc_custom_1504683686869{padding-top: 150px !important;padding-right: 5% !important;padding-bottom: 150px !important;padding-left: 5% !important;}"][apress_heading sub_title="ABOUT US" data_animation="fadeInUp" data_delay="300" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style2" title_font_options="tag:h2|letter_spacing:1" subtitle_font_options="tag:div|color:%23ffffff"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/apress_heading][ultimate_spacer height="100" height_on_mob_landscape="50" height_on_mob="50"][vc_row_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat." color_scheme="gradient_scheme2" data_animation="fadeInUp" data_delay="300" icon_family="fontawesome" icon_fontawesome="fa fa-desktop" gradient_icon_size="35" style="iconbox_style2" title_font_options="tag:h3|color:%23ffffff" description_font_options="color:%23ffffff"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="30"][apress_button button_text="Read more" color_scheme="gradient_scheme2" button_shape="round" button_alignment="center" data_animation="fadeInUp" data_delay="400"][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat" color_scheme="gradient_scheme2" data_animation="fadeInUp" data_delay="600" icon_family="fontawesome" icon_fontawesome="fa fa-tablet" gradient_icon_size="35" style="iconbox_style2" title_font_options="tag:h3|color:%23ffffff" description_font_options="color:%23ffffff"]Ipad Apps[/apress_gradient_icon_box][ultimate_spacer height="30"][apress_button button_text="Read more" color_scheme="gradient_scheme2" button_shape="round" button_alignment="center" data_animation="fadeInUp" data_delay="700"][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat" color_scheme="gradient_scheme2" data_animation="fadeInUp" data_delay="900" icon_family="fontawesome" icon_fontawesome="fa fa-mobile" gradient_icon_size="35" style="iconbox_style2" title_font_options="tag:h3|color:%23ffffff" description_font_options="color:%23ffffff"]Mobile Apps[/apress_gradient_icon_box][ultimate_spacer height="30"][apress_button button_text="Read more" color_scheme="gradient_scheme2" button_shape="round" button_alignment="center" data_animation="fadeInUp" data_delay="1000"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Colorful Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 3', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about3.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column width="1/3" css=".vc_custom_1504682727491{padding-top: 150px !important;padding-right: 5% !important;padding-bottom: 150px !important;padding-left: 5% !important;background-color: #333333 !important;}"][apress_heading sub_title="" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" heading_margin="margin-bottom:50" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div"]We are a <u><em>Digital First </em></u> web development company based in NYC.[/apress_heading][/vc_column][vc_column width="2/3" css=".vc_custom_1504682787757{padding-top: 150px !important;padding-right: 5% !important;padding-bottom: 150px !important;padding-left: 5% !important;background-color: #f7f7f7 !important;}"][vc_row_inner][vc_column_inner width="1/2"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " color_scheme="gradient_scheme2" icon_alignment="top_left" data_animation="fadeInUp" data_delay="300" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" style="iconbox_style4" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="50"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " color_scheme="gradient_scheme2" icon_alignment="top_left" data_animation="fadeInUp" data_delay="900" icon_family="linecons" icon_linecons="vc_li vc_li-paperplane" style="iconbox_style4" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][/vc_column_inner][vc_column_inner width="1/2"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " color_scheme="gradient_scheme2" icon_alignment="top_left" data_animation="fadeInUp" data_delay="600" icon_family="linecons" icon_linecons="vc_li vc_li-diamond" style="iconbox_style4" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="50"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " color_scheme="gradient_scheme2" icon_alignment="top_left" data_animation="fadeInUp" data_delay="1200" icon_family="linecons" icon_linecons="vc_li vc_li-shop" style="iconbox_style4" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Lightbox Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 4', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about4.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1504684111017{background-color: #f7f7f7 !important;}"][vc_column css=".vc_custom_1504683686869{padding-top: 150px !important;padding-right: 5% !important;padding-bottom: 150px !important;padding-left: 5% !important;}"][apress_heading sub_title="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat." data_animation="fadeInUp" data_delay="300" delimiter_line_height="2" delimiter_line_width="80" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" heading_margin="margin-bottom:20" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" delimiter_line_color="#6e48aa" subheading_margin="margin-top:30"]What We Do[/apress_heading][ultimate_spacer height="100" height_on_mob_landscape="50" height_on_mob="50"][vc_row_inner][vc_column_inner width="1/3"][apress_icon_box box_style="box_style_square" box_variation="variation_modern" box_bg="#ffffff" box_border="#eeeeee" iconcolor="#ffffff" icon_hover_color="#f9f9f9" variation_icon_bg_shape="full_width" shape_size="100" variation_icon_bg_color="#6e48aa" variation_icon_border_color="#6e48aa" iconposition2="center" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="" icon_family="linecons" contentboxtitle="Web Design" contentboxanimation="fadeInUp" contentboxdelay="300"][ultimate_spacer height="100" height_on_mob_landscape="50" height_on_mob="50"][apress_icon_box box_style="box_style_square" box_variation="variation_modern" box_bg="#ffffff" box_border="#eeeeee" iconcolor="#ffffff" icon_hover_color="#f9f9f9" variation_icon_bg_shape="full_width" shape_size="100" variation_icon_bg_color="#6e48aa" variation_icon_border_color="#6e48aa" iconposition2="center" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="" icon_family="linecons" icon_linecons="vc_li vc_li-like" contentboxtitle="Web Design" contentboxanimation="fadeInUp" contentboxdelay="300"][/vc_column_inner][vc_column_inner width="1/3"][apress_icon_box box_style="box_style_square" box_variation="variation_modern" box_bg="#ffffff" box_border="#eeeeee" iconcolor="#ffffff" icon_hover_color="#f9f9f9" variation_icon_bg_shape="full_width" shape_size="100" variation_icon_bg_color="#6e48aa" variation_icon_border_color="#6e48aa" iconposition2="center" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="" icon_family="linecons" icon_linecons="vc_li vc_li-star" contentboxtitle="Web Design" contentboxanimation="fadeInUp" contentboxdelay="600"][ultimate_spacer height="100" height_on_mob_landscape="50" height_on_mob="50"][apress_icon_box box_style="box_style_square" box_variation="variation_modern" box_bg="#ffffff" box_border="#eeeeee" iconcolor="#ffffff" icon_hover_color="#f9f9f9" variation_icon_bg_shape="full_width" shape_size="100" variation_icon_bg_color="#6e48aa" variation_icon_border_color="#6e48aa" iconposition2="center" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="" icon_family="linecons" icon_linecons="vc_li vc_li-paperplane" contentboxtitle="Web Design" contentboxanimation="fadeInUp" contentboxdelay="600"][/vc_column_inner][vc_column_inner width="1/3"][apress_icon_box box_style="box_style_square" box_variation="variation_modern" box_bg="#ffffff" box_border="#eeeeee" iconcolor="#ffffff" icon_hover_color="#f9f9f9" variation_icon_bg_shape="full_width" shape_size="100" variation_icon_bg_color="#6e48aa" variation_icon_border_color="#6e48aa" iconposition2="center" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="" icon_family="linecons" icon_linecons="vc_li vc_li-video" contentboxtitle="Web Design" contentboxanimation="fadeInUp" contentboxdelay="900"][ultimate_spacer height="100" height_on_mob_landscape="50" height_on_mob="50"][apress_icon_box box_style="box_style_square" box_variation="variation_modern" box_bg="#ffffff" box_border="#eeeeee" iconcolor="#ffffff" icon_hover_color="#f9f9f9" variation_icon_bg_shape="full_width" shape_size="100" variation_icon_bg_color="#6e48aa" variation_icon_border_color="#6e48aa" iconposition2="center" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="" icon_family="linecons" icon_linecons="vc_li vc_li-settings" contentboxtitle="Web Design" contentboxanimation="fadeInUp" contentboxdelay="900"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Mobile Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 17', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about17.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][vc_row_inner content_placement="middle"][vc_column_inner width="1/2"][vc_single_image image="290" img_size="full" alignment="center" css_animation="fadeInUp" css=".vc_custom_1504793566356{margin-bottom: -100px !important;}"][ultimate_spacer height="10" height_on_mob_landscape="300" height_on_mob="200"][/vc_column_inner][vc_column_inner width="1/2"][apress_heading sub_title="" data_animation="fadeInUp" data_delay="300" enable_delimiter="" color_scheme="gradient_scheme2" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div" heading_margin="margin-bottom:50"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/apress_heading][apress_button button_text="Learn More" color_scheme="gradient_scheme2" button_size="large" button_alignment="center" data_animation="fadeInUp" data_delay="300"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1504794061813{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #333333 !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " color_scheme="gradient_scheme2" icon_family="linecons" icon_linecons="vc_li vc_li-photo" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3|color:%23ffffff" description_font_options="color:%23ffffff"]Image Apps[/apress_gradient_icon_box][ultimate_spacer height="50"][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " color_scheme="gradient_scheme2" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3|color:%23ffffff" description_font_options="color:%23ffffff"]Inbuilt Filters[/apress_gradient_icon_box][ultimate_spacer height="50"][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " color_scheme="gradient_scheme2" icon_family="linecons" icon_linecons="vc_li vc_li-cloud" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3|color:%23ffffff" description_font_options="color:%23ffffff"]Unlimited Downloads[/apress_gradient_icon_box][ultimate_spacer height="50"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Music Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 6', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about6.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row gap="30" equal_height="yes" content_placement="middle"][vc_column width="1/3"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " data_animation="fadeInUp" data_delay="300" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" style="iconbox_style5" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="50"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " data_animation="fadeInUp" data_delay="1200" icon_family="linecons" icon_linecons="vc_li vc_li-paperplane" style="iconbox_style5" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][/vc_column][vc_column width="1/3"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " data_animation="fadeInUp" data_delay="600" icon_family="linecons" icon_linecons="vc_li vc_li-diamond" style="iconbox_style5" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="50"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " data_animation="fadeInUp" data_delay="1500" icon_family="linecons" icon_linecons="vc_li vc_li-shop" style="iconbox_style5" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][/vc_column][vc_column parallax="content-moving" parallax_image="78" css_animation="fadeIn" width="1/3"][ultimate_spacer height="50"][apress_heading sub_title="" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. [/apress_heading][ultimate_spacer height="50"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Video Background Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 7', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about7.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row gap="30" equal_height="yes" content_placement="middle"][vc_column parallax="content-moving" parallax_image="78" css_animation="fadeIn" width="1/3"][ultimate_spacer height="50"][apress_heading sub_title="" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor.[/apress_heading][ultimate_spacer height="50"][/vc_column][vc_column width="1/3"][ultimate_spacer height="50"][apress_icon_box iconcolor="#8224e3" icon_hover_color="#ffffff" icon_background_shape="diamond" icon_background_shape_type="thin_bordered" shape_background_color="#8224e3" iconhoverstyle2="fill-up" icon_hover_bg_color="#8224e3" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-star" contentboxtitle="Web Design" contentboxanimation="fadeIn" contentboxdelay="300"][ultimate_spacer height="50"][apress_icon_box iconcolor="#8224e3" icon_hover_color="#ffffff" icon_background_shape="diamond" icon_background_shape_type="thin_bordered" shape_background_color="#8224e3" iconhoverstyle2="fill-up" icon_hover_bg_color="#8224e3" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-star" contentboxtitle="Web Design" contentboxanimation="fadeIn" contentboxdelay="300"][ultimate_spacer height="50"][/vc_column][vc_column width="1/3"][ultimate_spacer height="50"][apress_icon_box iconcolor="#8224e3" icon_hover_color="#ffffff" icon_background_shape="diamond" icon_background_shape_type="thin_bordered" shape_background_color="#8224e3" iconhoverstyle2="fill-up" icon_hover_bg_color="#8224e3" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-star" contentboxtitle="Web Design" contentboxanimation="fadeIn" contentboxdelay="300"][ultimate_spacer height="50"][apress_icon_box iconcolor="#8224e3" icon_hover_color="#ffffff" icon_background_shape="diamond" icon_background_shape_type="thin_bordered" shape_background_color="#8224e3" iconhoverstyle2="fill-up" icon_hover_bg_color="#8224e3" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-star" contentboxtitle="Web Design" contentboxanimation="fadeIn" contentboxdelay="300"][ultimate_spacer height="50"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Travel Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 18', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about18.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^341|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/prj06.jpg|caption^null|alt^null|title^prj06|description^null" bg_override="full" enable_overlay="enable_overlay_value" overlay_color="rgba(0,0,0,0.6)" css=".vc_custom_1504846179205{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column width="1/2"][info_list style="hexagon" font_size_icon="24" connector_color="#ffffff" connector_animation="fadeInUp"][info_list_item list_title="Top Notch Designs Made By Professionals" list_icon="Defaults-image photo picture-o" animation="fadeInLeft" title_font_size="desktop:20px;" title_font_line_height="desktop:30px;" title_font_color="#ffffff" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;" desc_font_color="#ffffff"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/info_list_item][info_list_item list_title="Tons Of Options With Powerful Admin Panel" list_icon="Defaults-cog gear" animation="fadeInLeft" title_font_size="desktop:20px;" title_font_line_height="desktop:30px;" title_font_color="#ffffff" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;" desc_font_color="#ffffff"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/info_list_item][info_list_item list_title="24 x 7 Dedicated One To One Email Support" list_icon="Defaults-paper-plane send" animation="fadeInLeft" title_font_size="desktop:20px;" title_font_line_height="desktop:30px;" title_font_color="#ffffff" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;" desc_font_color="#ffffff"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/info_list_item][/info_list][/vc_column][vc_column css_animation="fadeIn" width="1/2"][vc_row_inner][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1504847119061{border-top-width: 20px !important;border-right-width: 20px !important;border-bottom-width: 20px !important;border-left-width: 20px !important;padding-top: -20px !important;padding-right: 30px !important;padding-bottom: 50px !important;padding-left: 30px !important;border-left-color: #ffffff !important;border-left-style: solid !important;border-right-color: #ffffff !important;border-right-style: solid !important;border-top-color: #ffffff !important;border-top-style: solid !important;border-bottom-color: #ffffff !important;border-bottom-style: solid !important;}"][apress_heading sub_title="Years Of Excellence" delimiter_line_height="2" delimiter_line_width="80" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" delimiter_line_color="#ffffff" title_font_options="tag:h2|font_size:200|line_height:200|letter_spacing:5" subtitle_font_options="tag:h2|color:%23ffffff" subheading_margin="margin-top:20"]25[/apress_heading][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Gradient Circles Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 8', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about8.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][apress_heading sub_title="We are number construction and business brand with a presence in 15 cities." data_animation="fadeInUp" delimiter_line_height_9_10="50" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style9" title_font_options="tag:h2|letter_spacing:1" subtitle_font_options="tag:h3"]About Us[/apress_heading][ultimate_spacer height="100"][vc_row_inner][vc_column_inner width="1/3"][interactive_banner_2 banner_title="Petrol Industry" banner_desc="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat." banner_image="id^126|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/service1.jpg|caption^null|alt^null|title^service1|description^null" banner_style="style1" banner_color_title="#ffffff" banner_color_desc="#ffffff" banner_color_bg="#dd9933" image_opacity="0.2" image_opacity_on_hover="0.5"][/vc_column_inner][vc_column_inner width="1/3"][interactive_banner_2 banner_title="Construction Industry" banner_desc="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat." banner_image="id^125|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/service6.jpg|caption^null|alt^null|title^service6|description^null" banner_style="style1" banner_color_title="#ffffff" banner_color_desc="#ffffff" banner_color_bg="#dd9933" image_opacity="0.2" image_opacity_on_hover="0.5"][/vc_column_inner][vc_column_inner width="1/3"][interactive_banner_2 banner_title="Refinery Industry" banner_desc="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat." banner_image="id^124|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/service5.jpg|caption^View gas processing factory. gas and oil industry|alt^null|title^View gas processing factory.|description^null" banner_style="style1" banner_color_title="#ffffff" banner_color_desc="#ffffff" banner_color_bg="#dd9933" image_opacity="0.2" image_opacity_on_hover="0.5"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][interactive_banner_2 banner_title="Processing Industry" banner_desc="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat." banner_image="id^124|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/service5.jpg|caption^View gas processing factory. gas and oil industry|alt^null|title^View gas processing factory.|description^null" banner_style="style1" banner_color_title="#ffffff" banner_color_desc="#ffffff" banner_color_bg="#dd9933" image_opacity="0.2" image_opacity_on_hover="0.5"][/vc_column_inner][vc_column_inner width="1/3"][interactive_banner_2 banner_title="Architecture Industry" banner_desc="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat." banner_image="id^128|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/service3.jpg|caption^null|alt^null|title^service3|description^null" banner_style="style1" banner_color_title="#ffffff" banner_color_desc="#ffffff" banner_color_bg="#dd9933" image_opacity="0.2" image_opacity_on_hover="0.5"][/vc_column_inner][vc_column_inner width="1/3"][interactive_banner_2 banner_title="Highway Contracts" banner_desc="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat." banner_image="id^129|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/service4.jpg|caption^null|alt^null|title^service4|description^null" banner_style="style1" banner_color_title="#ffffff" banner_color_desc="#ffffff" banner_color_bg="#dd9933" image_opacity="0.2" image_opacity_on_hover="0.5"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Gradient Text Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 9', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about9.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][vc_row_inner][vc_column_inner width="2/3"][apress_heading sub_title="Cras gravida consequat lorem vitae vestibulum. Vivamus a eros vel tellus consequat dictum. Integer eget blandit nunc. Suspendisse porttitor ex magna, et sodales quam venenatis quis. Pellentesque iaculis tincidunt augue nec mollis. Sed vitae sapien non diam feugiat bibendum. Phasellus convallis lacus in nisi auctor, in convallis felis feugiat. Phasellus convallis lacus in nisi auctor, in convallis felis feugiat. " content_alignment="left" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:30"]Passion<em> &amp; </em>Dedication[/apress_heading][/vc_column_inner][vc_column_inner width="1/3"][stat_counter icon="Defaults-cloud-download" icon_size="100" icon_color="#6e48aa" counter_value="11111" speed="3" counter_color_txt="#333333" title_font_size="desktop:35px;" title_font_line_height="desktop:50px;" desc_font_color="#6e48aa"][/vc_column_inner][/vc_row_inner][ultimate_spacer height="100"][vc_row_inner][vc_column_inner width="1/3"][apress_text_separator title="OUR MISSION" title_align="separator_align_left" el_width="80" title_font_options="tag:h2" color="#6e48aa"][vc_column_text]
<blockquote> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</blockquote>
[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3"][apress_text_separator title="OUR SERVICES" title_align="separator_align_left" el_width="80" title_font_options="tag:h2" color="#6e48aa"][ultimate_icon_list icon_size="20" icon_margin="10"][ultimate_icon_list_item icon="Defaults-check" icon_color="#ffffff" icon_style="circle" icon_color_bg="#6e48aa"]Web Designing[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-check" icon_color="#ffffff" icon_style="circle" icon_color_bg="#6e48aa"]Mobile Apps[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-check" icon_color="#ffffff" icon_style="circle" icon_color_bg="#6e48aa"]Web Designing[/ultimate_icon_list_item][/ultimate_icon_list][/vc_column_inner][vc_column_inner width="1/3"][apress_text_separator title="RECENT AWARDS" title_align="separator_align_left" el_width="80" title_font_options="tag:h2" color="#6e48aa"][vc_column_text]Mars Award 2016

Neptune Award 2017

Pluto Award 2017[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Bussines Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 24', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about24.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^443|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/bg2-1.jpg|caption^null|alt^null|title^bg2|description^null" bg_image_repeat="no-repeat" bg_override="browser_size"][vc_column width="1/2"][apress_heading sub_title="" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" heading_margin="margin-bottom:50" title_font_options="tag:h2" subtitle_font_options="tag:div"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/apress_heading][apress_button button_text="Learn More" color_scheme="design_your_own" button_bg_color="#ff5858" button_bg_color_h="rgba(59,101,214,0.01)" button_border_color="#ff5858" button_border_color_h="#ffffff" button_shape="round" button_size="large" data_animation="fadeInUp" data_delay="300"][apress_button button_text="Download" color_scheme="design_your_own" button_bg_color="rgba(82,149,234,0.01)" button_bg_color_h="#ff5858" button_border_color="#ffffff" button_border_color_h="#ff5858" button_shape="round" button_size="large" data_animation="fadeInUp" data_delay="300"][/vc_column][vc_column width="1/2" css=".vc_custom_1504865853093{padding: 10% !important;}"][apress_image_slider images="451,452" img_size="353x300" slick_fade_effect="yes" slick_item_shadow="yes" slick_lazyload="" slick_autoplay="yes" slick_autoplay_duration="5000" slick_hide_arrow_navigation="" bullet_bg="#ffffff" data_animation="fadeInUp" style="slider_style1" bullet_navigation_style="dots_style1"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Bussines Banner 02 vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 10', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about10.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][vc_row_inner gap="30"][vc_column_inner width="2/3"][apress_text_separator title="ABOUT US " title_align="separator_align_left" color="#ededed" title_font_options="tag:h2"][vc_column_text]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.

Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3"][apress_text_separator title="OUR SKILLS" title_align="separator_align_left" el_width="80" title_font_options="tag:h2" color="#ededed"][apress_progress_bar style="rounded" cnt_margin="10" title="DESIGNING" pb_color="#f45c43" pb_alt_color="#f857a6" pb_ctn_color="#eaeaea" enable_border=""][apress_progress_bar style="rounded" cnt_margin="10" title="PRESENTATION" pb_color="#ff5858" pb_alt_color="#f857a6" pb_ctn_color="#eaeaea" enable_border=""][apress_progress_bar style="rounded" cnt_margin="10" title="MARKETING" percentage="90" pb_color="#ff5858" pb_alt_color="#f857a6" pb_ctn_color="#eaeaea" enable_border=""][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][vc_row_inner][vc_column_inner width="1/3" css=".vc_custom_1504708930924{padding-bottom: 50px !important;}"][apress_icon_box box_style="box_style_rounded" box_hover_style="box-fade" box_bg="#ffffff" box_border="#f45c43" box_hover_bg="#f45c43" box_hover_border="#f45c43" iconcolor="#f45c43" icon_hover_color="#ffffff" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-pen" contentboxtitle="WEB DESIGN"][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1504708944360{padding-bottom: 50px !important;}"][apress_icon_box box_style="box_style_rounded" box_hover_style="box-fade" box_bg="#ffffff" box_border="#f45c43" box_hover_bg="#f45c43" box_hover_border="#f45c43" iconcolor="#f45c43" icon_hover_color="#ffffff" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-camera" contentboxtitle="IMAGE APPS"][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1504708951260{padding-bottom: 50px !important;}"][apress_icon_box box_style="box_style_rounded" box_hover_style="box-fade" box_bg="#ffffff" box_border="#f45c43" box_hover_bg="#f45c43" box_hover_border="#f45c43" iconcolor="#f45c43" icon_hover_color="#ffffff" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-tv" contentboxtitle="TV ADS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Dealer Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 11', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about11.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][vc_row_inner][vc_column_inner css=".vc_custom_1504712012826{padding-right: 5% !important;padding-left: 5% !important;}"][apress_heading sub_title="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. " delimiter_line_height="3" delimiter_line_width="80" color_scheme="design_your_own" main_heading_color="#ff5858" title_google_fonts="yes" style="heading_style5" heading_margin="margin-bottom:20" delimiter_line_color="#ff5858" title_font_options="tag:h2|font_size:20|line_height:30|letter_spacing:5" subtitle_font_options="tag:div" subheading_margin="margin-bottom:30" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:500%20bold%20regular%3A500%3Anormal"]ABOUT US[/apress_heading][/vc_column_inner][/vc_row_inner][ultimate_spacer height="100"][vc_row_inner][vc_column_inner width="1/3"][stat_counter icon="Defaults-film" icon_size="50" icon_color="#f66767" icon_animation="fadeInUp" icon_position="left" counter_title="CAPMAIGNS" speed="3" desc_font_color="#f66767"][/vc_column_inner][vc_column_inner width="1/3"][stat_counter icon="Defaults-heart-o" icon_size="50" icon_color="#f66767" icon_animation="fadeInUp" icon_position="left" counter_title="LIKES" counter_value="22000" speed="3" desc_font_color="#f66767"][/vc_column_inner][vc_column_inner width="1/3"][stat_counter icon="Defaults-lightbulb-o" icon_size="50" icon_color="#f66767" icon_animation="fadeInUp" icon_position="left" counter_title="VIEWS" counter_value="1300000" speed="3" desc_font_color="#f66767"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Car Dealer Banner 02 vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 25', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about25.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column width="1/3" css=".vc_custom_1504868251989{padding-right: 5% !important;padding-left: 5% !important;background-color: #f2f2f2 !important;}"][ultimate_spacer height="50"][apress_gradient_icon_box description="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " color_scheme="gradient_scheme2" icon_family="linecons" icon_linecons="vc_li vc_li-star" style="iconbox_style2" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="100"][/vc_column][vc_column width="1/3" css=".vc_custom_1504868454196{padding-right: 5% !important;padding-left: 5% !important;background-color: #eeeeee !important;}"][ultimate_spacer height="50"][apress_gradient_icon_box description="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " color_scheme="gradient_scheme2" icon_family="linecons" icon_linecons="vc_li vc_li-paperplane" style="iconbox_style2" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="100"][/vc_column][vc_column width="1/3" css=".vc_custom_1504868443255{padding-right: 5% !important;padding-left: 5% !important;background-color: #dddddd !important;}"][ultimate_spacer height="50"][apress_gradient_icon_box description="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " color_scheme="gradient_scheme2" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" style="iconbox_style2" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="100"][/vc_column][/vc_row][vc_row full_width="stretch_row" bg_type="grad" css=".vc_custom_1504868733891{background-color: #ff5858 !important;}" bg_grad="background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, #F857A5), color-stop(99%, #FF5858));background: -moz-linear-gradient(left,#F857A5 0%,#FF5858 99%);background: -webkit-linear-gradient(left,#F857A5 0%,#FF5858 99%);background: -o-linear-gradient(left,#F857A5 0%,#FF5858 99%);background: -ms-linear-gradient(left,#F857A5 0%,#FF5858 99%);background: linear-gradient(left,#F857A5 0%,#FF5858 99%);"][vc_column css=".vc_custom_1504868747923{margin-top: 0px !important;}"][ultimate_spacer height="100"][apress_testimonial_slider num="2" testimonialfontsize="22" testimoniallineheight="32" testimonialnamefontsize="20" testimonialfontcolor="#ffffff" testimonialnamefontcolor="#ffffff" testimonialimgborradi="0" testimonialsliderpagi="pagi_none" testimonialslidernav="nav_style3" testimonialimgborcolor="#ffffff" data_animation="fadeInUp"][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Dealer Banner 03 vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 12', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about12.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][apress_text_separator title="ABOUT US" style="style1" data_animation="fadeInUp" color="#8224e3" title_font_options="tag:h2|color:%23ffffff"][ultimate_spacer height="50"][vc_row_inner][vc_column_inner width="1/2"][vc_column_text css_animation="fadeInUp"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text css_animation="fadeInUp"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/vc_column_text][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][vc_row_inner][vc_column_inner width="1/3"][apress_process title="DESIGN" content_alignment="left" data_animation="fadeInUp" data_delay="300" style="process_style3" title_font_options="tag:h1" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/apress_process][ultimate_spacer height="30"][/vc_column_inner][vc_column_inner width="1/3"][apress_process title="DEVELOP" process_step="02" content_alignment="left" data_animation="fadeInUp" data_delay="600" style="process_style3" title_font_options="tag:h1" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/apress_process][ultimate_spacer height="30"][/vc_column_inner][vc_column_inner width="1/3"][apress_process title="IMPRESS" process_step="03" content_alignment="left" data_animation="fadeInUp" data_delay="900" style="process_style3" title_font_options="tag:h1" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/apress_process][ultimate_spacer height="30"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Rental Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 13', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about13.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row gap="30" equal_height="yes" content_placement="middle"][vc_column width="2/3" css=".vc_custom_1504768908678{padding-right: 5% !important;}"][vc_row_inner][vc_column_inner][ultimate_spacer height="100"][apress_heading sub_title="Designer de Excellence" content_alignment="left" enable_delimiter="" color_scheme="color_scheme1" style="heading_style2" heading_margin="margin-bottom:50" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div"]La perfection n'est qu'un voyage vers l'excellence avec le plus grand dévouement et l'amour[/apress_heading][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][vc_row_inner][vc_column_inner width="1/2"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " color_scheme="color_scheme1" icon_alignment="top_left" data_animation="fadeInUp" data_delay="300" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="50"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " color_scheme="color_scheme1" icon_alignment="top_left" data_animation="fadeInUp" data_delay="900" icon_family="linecons" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][/vc_column_inner][vc_column_inner width="1/2"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " color_scheme="color_scheme1" icon_alignment="top_left" data_animation="fadeInUp" data_delay="600" icon_family="linecons" icon_linecons="vc_li vc_li-diamond" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="50"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. " color_scheme="color_scheme1" icon_alignment="top_left" data_animation="fadeInUp" data_delay="1200" icon_family="linecons" icon_linecons="vc_li vc_li-shop" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][/vc_column_inner][/vc_row_inner][ultimate_spacer height="100"][/vc_column][vc_column parallax="content-moving" parallax_image="190" parallax_speed_bg="1.2" css_animation="fadeIn" width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Rental Banner 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 27', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about27.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1504887679117{padding-right: 5% !important;padding-left: 5% !important;}"][ultimate_spacer height="100"][apress_heading sub_title="DESIGNED FOR PERFECTION" content_alignment="left" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style2" title_font_options="tag:h2" subtitle_font_options="tag:div|color:%23006473|letter_spacing:1" heading_margin="margin-bottom:20"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/apress_heading][vc_column_text]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/vc_column_text][ultimate_spacer height="100"][/vc_column][vc_column css_animation="fadeInUp" width="1/4" css=".vc_custom_1504887642833{background-image: url(http://apresswp.com/demo35/wp-content/uploads/2017/09/a3.jpg?id=500) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_spacer height="100"][ultimate_spacer height="100"][/vc_column][vc_column css_animation="fadeInRight" width="1/4" css=".vc_custom_1504887814301{background-image: url(http://apresswp.com/demo35/wp-content/uploads/2017/09/a2.jpg?id=499) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_spacer height="100"][ultimate_spacer height="100"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column css_animation="fadeInLeft" width="1/4" css=".vc_custom_1504890772654{background-image: url(http://apresswp.com/demo35/wp-content/uploads/2017/09/a1.jpg?id=505) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_spacer height="75"][apress_testimonial_slider num="2" testimonialfontsize="18" testimoniallineheight="26" testimonialnamefontsize="20" testimonialfontcolor="#ffffff" testimonialnamefontcolor="#ffffff" testimonialsliderpagi="pagi_square" testimonialimgborcolor="#ffffff"][ultimate_spacer height="75"][/vc_column][vc_column css_animation="fadeInUp" width="1/4" css=".vc_custom_1504888495340{background-color: #006473 !important;}"][ultimate_spacer height="100"][stat_counter icon="Defaults-cloud-download" icon_size="100" icon_color="#ffffff" icon_animation="fadeInUp" counter_value="220000" speed="3" counter_color_txt="#ffffff" desc_font_color="#ffffff"][ultimate_spacer height="100"][/vc_column][vc_column css_animation="fadeInUp" width="1/2" css=".vc_custom_1504890781594{padding-right: 5% !important;padding-left: 5% !important;background-color: #333333 !important;}"][ultimate_spacer height="100"][apress_heading sub_title="OUR CUSTOM SERVICES" content_alignment="left" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style2" title_font_options="tag:h2" subtitle_font_options="tag:div|color:%23ffffff|letter_spacing:1" heading_margin="margin-bottom:20"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/apress_heading][apress_progress_bar cnt_height="5" cnt_margin="10" title="WEB DESIGN" title_color="#ffffff" pb_color="#24c6dc" pb_alt_color="#4776e6"][apress_progress_bar cnt_height="5" cnt_margin="10" title="PROMOTION" title_color="#ffffff" pb_color="#24c6dc" pb_alt_color="#4776e6"][apress_progress_bar cnt_height="5" cnt_margin="10" title="MARKETING" title_color="#ffffff" pb_color="#24c6dc" pb_alt_color="#4776e6"][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 14', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about14.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][vc_row_inner][vc_column_inner][apress_heading sub_title="" data_animation="fadeIn" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" title_google_fonts="yes" style="heading_style1" heading_margin="margin-bottom:50" title_font_options="tag:h2|font_size:50|line_height:60" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div"]ABOUT US[/apress_heading][/vc_column_inner][/vc_row_inner][ultimate_spacer height="100"][vc_row_inner][vc_column_inner width="1/3"][apress_counter_circle data_percent_value="80" bar_color="#d38312" line_width="5"][apress_heading sub_title="Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." data_animation="fadeInUp" data_delay="300" delimiter_line_height="2" delimiter_line_width="80" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:h3" subtitle_font_options="tag:div" heading_margin="margin-top:50|margin-bottom:30" subheading_margin="margin-top:30|margin-bottom:50" delimiter_line_color="#d38312"]PLANNING[/apress_heading][/vc_column_inner][vc_column_inner width="1/3"][apress_counter_circle data_percent_value="85" bar_color="#ff5607" line_width="5"][apress_heading sub_title="Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." data_animation="fadeInUp" data_delay="600" delimiter_line_height="2" delimiter_line_width="80" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:h3" subtitle_font_options="tag:div" heading_margin="margin-top:50|margin-bottom:30" subheading_margin="margin-top:30|margin-bottom:50" delimiter_line_color="#ff5607"]PRESENTATION[/apress_heading][/vc_column_inner][vc_column_inner width="1/3"][apress_counter_circle data_percent_value="90" bar_color="#f6412d" line_width="5"][apress_heading sub_title="Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." data_animation="fadeInUp" data_delay="900" delimiter_line_height="2" delimiter_line_width="80" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:h3" subtitle_font_options="tag:div" heading_margin="margin-top:50|margin-bottom:30" subheading_margin="margin-top:30|margin-bottom:50" delimiter_line_color="#f6412d"]PERFECTION[/apress_heading][/vc_column_inner][/vc_row_inner][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Corporate Banner 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 15', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about15.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][apress_heading sub_title="" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" heading_margin="margin-bottom:50" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div"]ABOUT US[/apress_heading][ultimate_spacer height="50"][vc_row_inner][vc_column_inner width="1/3"][vc_column_text css_animation="fadeInUp"]
<h2>Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque.</h2>
[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3"][vc_column_text css_animation="fadeInUp"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Suspendisse placerat sapien in ullamcorper porttitor.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3"][vc_column_text css_animation="fadeInUp"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. Vivamus a eros vel tellus consequat dictum. Integer eget blandit nunc.[/vc_column_text][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][vc_row_inner][vc_column_inner width="1/3"][apress_process title="DESIGN" data_animation="fadeInUp" data_delay="300" style="process_style2" process_image="237" title_font_options="tag:h3" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/apress_process][ultimate_spacer height="50"][/vc_column_inner][vc_column_inner width="1/3"][apress_process title="CREATE" process_step="02" data_animation="fadeInUp" data_delay="600" style="process_style2" process_image="235" title_font_options="tag:h3" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/apress_process][ultimate_spacer height="50"][/vc_column_inner][vc_column_inner width="1/3"][apress_process title="IMPRESS" process_step="03" data_animation="fadeInUp" data_delay="900" style="process_style2" process_image="236" title_font_options="tag:h3" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/apress_process][ultimate_spacer height="50"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Banner 3 vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 34', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about34.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1504958598486{padding-right: 5% !important;padding-left: 5% !important;}"][ultimate_spacer height="300" height_on_mob_landscape="100" height_on_mob="100"][apress_heading sub_title="ABOUT ME" content_alignment="left" delimiter_line_height="3" delimiter_line_width="80" delimiter_margin="margin-top:10|margin-bottom:30" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style6" title_font_options="tag:h2|font_size:40|line_height:50|letter_spacing:1" subtitle_font_options="tag:div|color:%23ff5858" heading_margin="margin-bottom:20" delimiter_line_color="#ff5858"]I'm ace photographer specializing in abstract photography. When I'm not shooting you can find my in kitchen[/apress_heading][vc_column_text]Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum. Vivamus a eros vel tellus consequat dictum. Integer eget blandit nunc. Suspendisse porttitor ex magna, et sodales quam venenatis quis. Pellentesque iaculis tincidunt augue nec mollis. Sed vitae sapien non diam feugiat bibendum. Phasellus convallis lacus in nisi auctor, in convallis felis feugiat. Fusce ac feugiat leo, nec aliquam erat. Vivamus porttitor eget arcu a porttitor.[/vc_column_text][apress_sociallinks socialicon_design="rounded" socialicon_facebook="#" socialicon_twitter="#" socialicon_instagram="#" socialicon_dribbble="#" socialicon_googleplus="#" socialicon_linkedin="#"][ultimate_spacer height="300" height_on_mob_landscape="100" height_on_mob="100"][/vc_column][vc_column width="1/2" css=".vc_custom_1504959110597{padding-top: 400px !important;padding-bottom: 400px !important;background-image: url(http://apresswp.com/demo35/wp-content/uploads/2017/09/abts.jpg?id=655) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Banner 4 vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 16', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about16.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle"][vc_column][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner width="1/2"][apress_heading sub_title=" Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " content_alignment="left" data_animation="fadeInLeft" enable_delimiter="" style="heading_style1" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:30"]We are a friendly team to work with.[/apress_heading][/vc_column_inner][vc_column_inner width="1/2"][vc_single_image image="250" img_size="full" css_animation="fadeInRight"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Elegant Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 19', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about19.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1504849189477{padding-right: 5% !important;padding-left: 5% !important;}"][ultimate_spacer height="200"][apress_heading sub_title="ABOUT US" content_alignment="left" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style2" title_font_options="tag:h2|font_size:35|line_height:50|letter_spacing:1" subtitle_font_options="tag:div"]WE ARE YOUNG &amp; ENERGETIC TEAM OF MULTI TALENTED INDIVIDUALS[/apress_heading][vc_column_text css_animation="fadeIn"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/vc_column_text][apress_button button_text="Learn More" color_scheme="primary_color_scheme" button_shape="round" button_size="medium" data_animation="fadeIn"][ultimate_spacer height="200"][/vc_column][vc_column width="1/2" css=".vc_custom_1504848679489{background-image: url(http://apresswp.com/demo35/wp-content/uploads/2017/09/sl03.jpg?id=366) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_spacer height="200"][ultimate_spacer height="200"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1504848686511{background-image: url(http://apresswp.com/demo35/wp-content/uploads/2017/09/sl01.jpg?id=365) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_spacer height="200"][ultimate_spacer height="200"][/vc_column][vc_column width="1/2" css=".vc_custom_1504849249493{padding-right: 5% !important;padding-left: 5% !important;}"][ultimate_spacer height="200"][apress_heading sub_title="What We Do" content_alignment="left" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style2" title_font_options="tag:h2|font_size:35|line_height:50|letter_spacing:1" subtitle_font_options="tag:div"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/apress_heading][ultimate_spacer height="20"][apress_progress_bar cnt_height="5" cnt_margin="10" title="WEB DESIGN" pb_color="#4776e6" pb_alt_color="#8e54e9"][apress_progress_bar cnt_height="5" cnt_margin="10" title="PROMOTION" percentage="90" pb_color="#4776e6" pb_alt_color="#8e54e9"][apress_progress_bar cnt_height="5" cnt_margin="10" title="MARKETING" pb_color="#4776e6" pb_alt_color="#8e54e9"][ultimate_spacer height="200"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Lawyer Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 35', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about35.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1504963712550{background-color: #f7f7f7 !important;}"][vc_single_image image="672" img_size="full" alignment="center"][/vc_column][vc_column width="1/2" css=".vc_custom_1504963918620{padding-right: 10% !important;padding-left: 10% !important;background-color: #3e4eb7 !important;}"][ultimate_spacer height="150" height_on_mob_landscape="100" height_on_mob="100"][info_list icon_color="#3e4eb7" font_size_icon="24" connector_color="#ffffff" connector_animation="fadeInUp"][info_list_item list_title="Fusce ac feugiat leo, nec aliquam erat." list_icon="Defaults-tint" animation="fadeInLeft" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;" title_font_color="#ffffff" desc_font_color="#ffffff"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/info_list_item][info_list_item list_title="Fusce ac feugiat leo, nec aliquam erat." list_icon="Defaults-lightbulb-o" animation="fadeInLeft" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;" title_font_color="#ffffff" desc_font_color="#ffffff"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/info_list_item][info_list_item list_title="Fusce ac feugiat leo, nec aliquam erat." list_icon="Defaults-paper-plane send" animation="fadeInLeft" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;" title_font_color="#ffffff" desc_font_color="#ffffff"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/info_list_item][/info_list][ultimate_spacer height="150" height_on_mob_landscape="100" height_on_mob="100"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 20', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about20.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][vc_row_inner][vc_column_inner][vc_single_image image="388" img_size="full" alignment="center" css_animation="slideInDown"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][apress_heading sub_title="" data_animation="fadeInUp" data_delay="300" enable_delimiter="" style="heading_style1" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:50"]We are a multifaceted design company with special interest in creating amazing designs.[/apress_heading][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][vc_row_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " data_animation="fadeInUp" data_delay="300" icon_family="linecons" icon_linecons="vc_li vc_li-display" style="iconbox_style5" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="50"][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " data_animation="fadeInUp" data_delay="300" icon_family="linecons" icon_linecons="vc_li vc_li-settings" style="iconbox_style5" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="50"][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " data_animation="fadeInUp" data_delay="300" icon_family="linecons" icon_linecons="vc_li vc_li-paperplane" style="iconbox_style5" title_font_options="tag:h3"]Web Design[/apress_gradient_icon_box][ultimate_spacer height="50"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Mobile Banner 3 vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 21', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about21.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][apress_heading sub_title="" enable_delimiter="" color_scheme="gradient_scheme2" style="heading_style1" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div"]DESIGN MEETS EXCELLENCE[/apress_heading][ultimate_spacer height="50"][vc_row_inner][vc_column_inner][vc_single_image image="388" img_size="full" alignment="center" css_animation="flipInX"][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][vc_row_inner][vc_column_inner width="1/3"][stat_counter icon="Defaults-paper-plane-o send-o" icon_size="50" icon_color="#ff5858" icon_animation="fadeInUp" icon_position="left" counter_title="OPTIONS" speed="3"][/vc_column_inner][vc_column_inner width="1/3"][stat_counter icon="Defaults-comment-o" icon_size="50" icon_color="#ff5858" icon_animation="fadeInUp" icon_position="left" counter_title="HOURS" counter_value="22700" speed="3"][/vc_column_inner][vc_column_inner width="1/3"][stat_counter icon="Defaults-star-o" icon_size="50" icon_color="#ff5858" icon_animation="fadeInUp" icon_position="left" counter_title="USERS" counter_value="300000" speed="3"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Mobile Banner 4 vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 40', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about40.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column width="2/3" css=".vc_custom_1504971235356{padding-right: 5% !important;padding-left: 5% !important;background-image: url(http://apresswp.com/demo35/wp-content/uploads/2017/09/ab-bg.jpeg?id=747) !important;}"][ultimate_spacer height="100"][vc_row_inner gap="30" css=".vc_custom_1504971177661{padding-right: 5% !important;padding-left: 5% !important;}"][vc_column_inner width="1/2" css=".vc_custom_1504971168433{padding-right: 5% !important;padding-left: 5% !important;}"][ultimate_spacer height="50"][apress_gradient_icon_box description="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " color_scheme="color_scheme1" icon_family="linecons" style="iconbox_style2" title_font_options="tag:h3|color:%23ffffff" description_font_options="color:%23ffffff"]WEB DESIGN[/apress_gradient_icon_box][ultimate_spacer height="50"][apress_gradient_icon_box description="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " color_scheme="color_scheme1" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" style="iconbox_style2" title_font_options="tag:h3|color:%23ffffff" description_font_options="color:%23ffffff"]WEB DESIGN[/apress_gradient_icon_box][ultimate_spacer height="50"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1504971230060{padding-right: 5% !important;padding-left: 5% !important;}"][ultimate_spacer height="50"][apress_gradient_icon_box description="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " color_scheme="color_scheme1" icon_family="linecons" icon_linecons="vc_li vc_li-diamond" style="iconbox_style2" title_font_options="tag:h3|color:%23ffffff" description_font_options="color:%23ffffff"]WEB DESIGN[/apress_gradient_icon_box][ultimate_spacer height="50"][apress_gradient_icon_box description="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " color_scheme="color_scheme1" icon_family="linecons" icon_linecons="vc_li vc_li-like" style="iconbox_style2" title_font_options="tag:h3|color:%23ffffff" description_font_options="color:%23ffffff"]WEB DESIGN[/apress_gradient_icon_box][ultimate_spacer height="50"][/vc_column_inner][/vc_row_inner][ultimate_spacer height="100"][/vc_column][vc_column width="1/3" css=".vc_custom_1504971475429{padding-right: 5% !important;padding-left: 5% !important;background-color: #3361f7 !important;}"][apress_heading sub_title="" delimiter_line_height="2" delimiter_line_width="80" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" heading_margin="margin-bottom:30" title_font_options="tag:h2" subtitle_font_options="tag:div" delimiter_line_color="#ffffff"]GET FREE QUOTE[/apress_heading][apress_contactform contactform_id="4" contactform_textcolor="#a0b4f7" contactform_button_size="medium_buttton"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Restaurant Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 22', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about22.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][vc_row_inner gap="25"][vc_column_inner width="1/2"][apress_heading sub_title="" content_alignment="left" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" heading_margin="margin-bottom:50" title_font_options="tag:h2|font_size:35|line_height:50|letter_spacing:1" subtitle_font_options="tag:div"]Easy to manage features with full customization support. Without touching a single line of code.[/apress_heading][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/vc_column_text][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][vc_row_inner][vc_column_inner width="1/3"][vc_hoverbox image="408" primary_title="WEB DESIGN" primary_title_font_container="color:%23ffffff" primary_title_use_theme_fonts="yes" primary_title_css_animation="fadeInUp" hover_title="WEB DESIGN" hover_title_font_container="color:%23ffffff" hover_title_use_theme_fonts="yes" hover_background_color="custom" hover_btn_title="Learn More" hover_btn_style="gradient-custom" hover_btn_gradient_custom_color_1="#4776e6" hover_btn_gradient_custom_color_2="#8e54e9" use_custom_fonts_primary_title="true" use_custom_fonts_hover_title="true" hover_add_button="true" hover_custom_background="#333333"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/vc_hoverbox][ultimate_spacer height="50"][/vc_column_inner][vc_column_inner width="1/3"][vc_hoverbox image="409" primary_title="PHOTOSHOP" primary_title_font_container="color:%23ffffff" primary_title_use_theme_fonts="yes" primary_title_css_animation="fadeInUp" hover_title="WEB DESIGN" hover_title_font_container="color:%23ffffff" hover_title_use_theme_fonts="yes" hover_background_color="custom" hover_btn_title="Learn More" hover_btn_style="gradient-custom" hover_btn_gradient_custom_color_1="#4776e6" hover_btn_gradient_custom_color_2="#8e54e9" use_custom_fonts_primary_title="true" use_custom_fonts_hover_title="true" hover_add_button="true" hover_custom_background="#333333"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/vc_hoverbox][ultimate_spacer height="50"][/vc_column_inner][vc_column_inner width="1/3"][vc_hoverbox image="410" primary_title="PROMOTION" primary_title_font_container="color:%23ffffff" primary_title_use_theme_fonts="yes" primary_title_css_animation="fadeInUp" hover_title="WEB DESIGN" hover_title_font_container="color:%23ffffff" hover_title_use_theme_fonts="yes" hover_background_color="custom" hover_btn_title="Learn More" hover_btn_style="gradient-custom" hover_btn_gradient_custom_color_1="#4776e6" hover_btn_gradient_custom_color_2="#8e54e9" use_custom_fonts_primary_title="true" use_custom_fonts_hover_title="true" hover_add_button="true" hover_custom_background="#333333"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/vc_hoverbox][ultimate_spacer height="50"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Minimal Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 23', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about23.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/4"][/vc_column][vc_column width="1/2"][ultimate_spacer height="100"][apress_heading sub_title="" enable_delimiter="" title_google_fonts="yes" style="heading_style1" title_font_options="tag:h2|font_size:60|line_height:70" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:100%20light%20regular%3A100%3Anormal" subtitle_font_options="tag:div"]The most trusted &amp; easiest dashboard app.[/apress_heading][ultimate_spacer height="100"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][apress_image_slider images="423,424,425" img_size="900x634" slick_center_desktop_padding="20%" slick_center_small_desktop_padding="20%" slick_center_tablet_padding="20%" arrows_color="#333333" bullet_bg="#333333" data_animation="fadeIn" style="slider_style5" arrows_style="arrows_style4" bullet_navigation_style="dots_style3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//With play button banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 42', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about42.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" bg_type="grad" bg_override="full" bg_grad="background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, #1FA2FF), color-stop(100%, #12D7FA));background: -moz-linear-gradient(left,#1FA2FF 0%,#12D7FA 100%);background: -webkit-linear-gradient(left,#1FA2FF 0%,#12D7FA 100%);background: -o-linear-gradient(left,#1FA2FF 0%,#12D7FA 100%);background: -ms-linear-gradient(left,#1FA2FF 0%,#12D7FA 100%);background: linear-gradient(left,#1FA2FF 0%,#12D7FA 100%);"][vc_column][vc_row_inner][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][ultimate_spacer height="100"][apress_heading sub_title="" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style2" title_font_options="tag:h2|font_size:40|line_height:60|letter_spacing:1" subtitle_font_options="tag:div|letter_spacing:5"]Our app to provide the best of our services in helping our clients to maximize returns and minimize expenditure.[/apress_heading][ultimate_spacer height="100"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][apress_image_slider images="770,771,772,773,774,775,776,777" img_size="484x861" desktop_no_of_items2="7" small_desktop_no_of_items="3" tablet_no_of_items="1" slider_gutter="10" slick_focusonselect="yes" slick_item_shadow="yes" slick_lazyload="yes" slick_autoplay="yes" slick_autoplay_duration="5000" slick_hide_arrow_navigation="" bullet_bg="#ffffff" data_animation="fadeInUp" style="slider_style3" bullet_navigation_style="dots_style3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//With play button banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 26', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about26.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][apress_heading sub_title="ABOUT US" delimiter_line_height="3" delimiter_line_width="80" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style6" heading_margin="margin-bottom:30" delimiter_line_color="#f5e148" title_font_options="tag:h2" subtitle_font_options="tag:div"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/apress_heading][ultimate_spacer height="50"][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner width="1/3"][info_list position="right" style="circle with_bg" icon_bg_color="#f5e148" icon_color="#ffffff" font_size_icon="24"][info_list_item list_title="HEADER BUILDER" list_icon="Defaults-check" animation="fadeInLeft" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/info_list_item][info_list_item list_title="PAGE BUILDER" list_icon="Defaults-check" animation="fadeInLeft" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/info_list_item][info_list_item list_title="POWERFUL OPTIONS" list_icon="Defaults-check" animation="fadeInLeft" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/info_list_item][/info_list][/vc_column_inner][vc_column_inner width="1/3"][vc_single_image image="486" img_size="full" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner width="1/3"][info_list style="circle with_bg" icon_bg_color="#f5e148" icon_color="#ffffff" font_size_icon="24" connector_animation="fadeInUp"][info_list_item list_title="DESIGN GALLERY" list_icon="Defaults-check" animation="fadeInRight" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/info_list_item][info_list_item list_title="PAGE OPTIONS" list_icon="Defaults-check" animation="fadeInLeft" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/info_list_item][info_list_item list_title="DEDICATED SUPPORT" list_icon="Defaults-check" animation="fadeInRight" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/info_list_item][/info_list][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//With play button 3 banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 28', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about28.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][vc_row_inner][vc_column_inner width="1/2"][apress_heading sub_title="ABOUT US" content_alignment="left" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style2" title_font_options="tag:h2|font_size:35|line_height:45|letter_spacing:1" subtitle_font_options="tag:div|color:%2312d8fa|letter_spacing:2" heading_margin="margin-top:10|margin-bottom:50"]We take extreme attention  to create modern and minimal web design based on principles.[/apress_heading][apress_button button_text="HIRE US" color_scheme="design_your_own" button_bg_color="#12d8fa" button_bg_color_h="#3bddf9" button_border_color="#12d8fa" button_border_color_h="#12d8fa" button_shape="round" button_size="large"][/vc_column_inner][vc_column_inner width="1/4"][apress_text_separator title="Acounts" title_align="separator_align_left" el_width="70" color="#eeeeee" title_font_options="tag:h3"][ultimate_icon_list icon_size="16" icon_margin="10"][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][/ultimate_icon_list][apress_text_separator title="HR" title_align="separator_align_left" el_width="70" color="#eeeeee" title_font_options="tag:h3"][ultimate_icon_list icon_size="16" icon_margin="10"][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][/ultimate_icon_list][/vc_column_inner][vc_column_inner width="1/4"][apress_text_separator title="Marketing" title_align="separator_align_left" el_width="70" color="#eeeeee" title_font_options="tag:h3"][ultimate_icon_list icon_size="16" icon_margin="10"][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][/ultimate_icon_list][apress_text_separator title="Operations" title_align="separator_align_left" el_width="70" color="#eeeeee" title_font_options="tag:h3"][ultimate_icon_list icon_size="16" icon_margin="10"][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][/ultimate_icon_list][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//With rounded button banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 43', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about43.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^792|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/bg3-1.jpg|caption^null|alt^null|title^bg3|description^null" bg_override="full"][vc_column][vc_row_inner css=".vc_custom_1505054396624{padding-right: 5% !important;padding-left: 5% !important;}"][vc_column_inner][ultimate_spacer height="150"][apress_heading sub_title="ABOUT US" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style2" title_font_options="tag:h2|font_size:40|line_height:60|letter_spacing:1" subtitle_font_options="tag:div|color:%23ffffff|letter_spacing:5"]Our app to provide the best of our services in helping our clients to maximize returns and minimize expenditure.[/apress_heading][ultimate_spacer height="100"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor." icon_family="linecons" icon_linecons="vc_li vc_li-display" style="iconbox_style2" title_font_options="tag:h3|color:%23ffffff" description_font_options="color:%23ffffff"]WEB DESIGN[/apress_gradient_icon_box][ultimate_spacer height="50"][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor." icon_family="linecons" icon_linecons="vc_li vc_li-tv" style="iconbox_style2" title_font_options="tag:h3|color:%23ffffff" description_font_options="color:%23ffffff"]WEB DESIGN[/apress_gradient_icon_box][ultimate_spacer height="50"][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor." icon_family="linecons" icon_linecons="vc_li vc_li-diamond" style="iconbox_style2" title_font_options="tag:h3|color:%23ffffff" description_font_options="color:%23ffffff"]WEB DESIGN[/apress_gradient_icon_box][ultimate_spacer height="50"][/vc_column_inner][/vc_row_inner][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Zig zag banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 29', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about29.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1504937855885{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #f7f7f7 !important;}"][vc_column][vc_row_inner][vc_column_inner][apress_heading sub_title="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo." enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:h2|font_size:50|line_height:1|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:50"]Passion <em>&amp;</em> Dedication[/apress_heading][/vc_column_inner][/vc_row_inner][ultimate_spacer height="100"][vc_row_inner][vc_column_inner width="1/3"][ult_content_box bg_color="#ffffff" box_shadow="horizontal:0px|vertical:5px|blur:25px|spread:0px|color:rgba(2,2,2,0.09)|style:outset|" padding="padding:50px;" hover_bg_color="#ffffff" hover_border_color="#f7f7f7" hover_box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:none|" border="border-style:solid;|border-radius:10px;|border-color:#ffffff;"][apress_gradient_icon_box description="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo." data_animation="fadeInUp" data_delay="300" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]WEB DESIGN[/apress_gradient_icon_box][/ult_content_box][/vc_column_inner][vc_column_inner width="1/3"][ult_content_box box_shadow="horizontal:0px|vertical:5px|blur:15px|spread:0px|color:rgba(2,2,2,0.09)|style:outset|" hover_box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:none|" bg_color="#ffffff" border="border-style:solid;|border-radius:10px;|border-color:#f7f7f7;" padding="padding:50px;" hover_bg_color="#ffffff" hover_border_color="#f7f7f7"][apress_gradient_icon_box description="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo." data_animation="fadeInUp" data_delay="300" icon_family="linecons" icon_linecons="vc_li vc_li-diamond" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]WEB DESIGN[/apress_gradient_icon_box][/ult_content_box][/vc_column_inner][vc_column_inner width="1/3"][ult_content_box box_shadow="horizontal:0px|vertical:5px|blur:15px|spread:0px|color:rgba(2,2,2,0.09)|style:outset|" padding="padding:50px;" hover_box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:none|" bg_color="#ffffff" border="border-style:solid;|border-radius:10px;|border-color:#f7f7f7;" hover_bg_color="#ffffff" hover_border_color="#f7f7f7"][apress_gradient_icon_box description="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo." data_animation="fadeInUp" data_delay="300" icon_family="linecons" icon_linecons="vc_li vc_li-paperplane" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]WEB DESIGN[/apress_gradient_icon_box][/ult_content_box][/vc_column_inner][/vc_row_inner][ultimate_spacer height="40"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Blog Category
	//Agency Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 30', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about30.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2"][apress_heading sub_title="" content_alignment="left" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#9d9d9d" style="heading_style1" title_font_options="tag:h2|font_size:35|line_height:50|letter_spacing:1" subtitle_font_options="tag:div|color:%239d9d9d"]Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.[/apress_heading][/vc_column][vc_column width="1/2"][apress_progress_bar cnt_height="5" cnt_margin="10" title="WEB DESIGN" percentage_style="z_percentage_3" tooltip_text_color="#ffffff" tooltip_bg_color="#ff5607" pb_color="#1193f5" pb_alt_color="#ff5607"][apress_progress_bar cnt_height="5" cnt_margin="10" title="PROMOTION" percentage="85" percentage_style="z_percentage_3" tooltip_text_color="#ffffff" tooltip_bg_color="#ff5607" pb_color="#1193f5" pb_alt_color="#ff5607"][apress_progress_bar cnt_height="5" cnt_margin="10" title="ANALYTICS" percentage="90" percentage_style="z_percentage_3" tooltip_text_color="#ffffff" tooltip_bg_color="#ff5607" pb_color="#1193f5" pb_alt_color="#ff5607"][/vc_column][/vc_row][vc_row][vc_column][ultimate_spacer height="100"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/3" css=".vc_custom_1504944796153{background-color: #1193f5 !important;}"][ultimate_spacer height="50"][apress_process title="DESIGN" style="process_style3" title_font_options="tag:h1|color:%23ffffff" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div|color:%23ffffff"]Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.[/apress_process][ultimate_spacer height="100"][/vc_column][vc_column width="1/3" css=".vc_custom_1504943704165{background-color: #88c441 !important;}"][ultimate_spacer height="50"][apress_process title="CODE" process_step="02" style="process_style3" title_font_options="tag:h1|color:%23ffffff" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div|color:%23ffffff"]Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.[/apress_process][ultimate_spacer height="100"][/vc_column][vc_column width="1/3" css=".vc_custom_1504943719556{background-color: #ff5607 !important;}"][ultimate_spacer height="50"][apress_process title="IMPRESS" process_step="03" style="process_style3" title_font_options="tag:h1|color:%23ffffff" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div|color:%23ffffff"]Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.[/apress_process][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Business Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 45', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about45.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content" gap="15" equal_height="yes" content_placement="middle"][vc_column css_animation="fadeInUp" width="1/2"][vc_row_inner][vc_column_inner css=".vc_custom_1505118733202{padding-right: 5% !important;padding-left: 5% !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][apress_heading sub_title="ABOUT US" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style6" title_font_options="tag:h2|font_size:40|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:50"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor[/apress_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column css_animation="fadeInUp" width="1/2"][vc_row_inner][vc_column_inner css=".vc_custom_1505117609198{padding-top: 250px !important;padding-bottom: 250px !important;background-image: url(http://apresswp.com/demo35/wp-content/uploads/2017/09/abt2.jpg?id=825) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content" gap="15" equal_height="yes" content_placement="middle" css=".vc_custom_1505118693524{padding-top: 0px !important;}"][vc_column css_animation="fadeInUp" width="1/2"][vc_row_inner][vc_column_inner css=".vc_custom_1505117937680{padding-top: 250px !important;padding-bottom: 250px !important;background-image: url(http://apresswp.com/demo35/wp-content/uploads/2017/09/abt3.jpg?id=831) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column css_animation="fadeInUp" width="1/2"][vc_row_inner][vc_column_inner css=".vc_custom_1505117626879{padding-top: 250px !important;padding-bottom: 250px !important;background-image: url(http://apresswp.com/demo35/wp-content/uploads/2017/09/abt1.jpg?id=824) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Dealer Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 31', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about31.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle"][vc_column css_animation="fadeIn" width="1/2"][apress_heading sub_title="Aliquam sagittis interdum velit at laoreet. Praesent lacus eros, tempor vitae finibus ac, commodo id dui. Aenean semper nisl in elit pharetra, a accumsan mauris laoreet. Quisque porttitor purus turpis, id sollicitudin diam pretium at. Fusce nec ante et ex euismod dignissim. Praesent vitae arcu metus. Fusce eu tristique lectus. Quisque id hendrerit diam. Curabitur sollicitudin nunc ut posuere convallis. Quisque suscipit massa at libero sollicitudin molestie. Aenean vitae placerat sem. Duis quis iaculis tortor. Vestibulum eget tincidunt nisi. Nunc efficitur tellus egestas augue posuere." content_alignment="left" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:h2|font_size:35|line_height:50|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:30" subheading_margin="margin-bottom:50"]Welcome To Howard &amp; Tower[/apress_heading][vc_row_inner][vc_column_inner width="1/3"][stat_counter icon_size="32" counter_title="EMPLOYEES" counter_value="25" speed="3" desc_font_color="#333333" desc_font_size="desktop:40px;" desc_font_line_height="desktop:60px;" title_font_size="desktop:14px;" title_font_line_height="desktop:20px;"][/vc_column_inner][vc_column_inner width="1/3"][stat_counter icon_size="32" counter_title="CASES SOLVED" counter_value="220" speed="3" desc_font_color="#333333" desc_font_size="desktop:40px;" desc_font_line_height="desktop:60px;" title_font_size="desktop:14px;" title_font_line_height="desktop:20px;"][/vc_column_inner][vc_column_inner width="1/3"][stat_counter icon_size="32" counter_title="CASE STUDIES" counter_value="2900" speed="3" desc_font_color="#333333" desc_font_size="desktop:40px;" desc_font_line_height="desktop:60px;" title_font_size="desktop:14px;" title_font_line_height="desktop:20px;"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][vc_single_image image="597" img_size="full" alignment="center" style="vc_box_shadow" css_animation="fadeInUp"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Rental Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 32', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about32.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/4"][apress_imagebox imagebox_style="style2" imagebox_bor_color="#e2e2e2" imagebox_image="609" imagebox_title="OIL DRILLING" imagebox_title_fonsize="22" imagebox_title_color="#333333" imagebox_description_color="" imagebox_button_size="medium" imagebox_button_border_radius="50" imagebox_buttonfontcolor="#dd9933" imagebox_buttonfontcolorhover="#ffffff" imagebox_buttonbackgroundcolor="rgba(84,159,252,0.01)" imagebox_buttonbackgroundcolorhover="#dd9933" imagebox_buttonbordercolor="#dd9933" imagebox_buttonbordercolorhover="#dd9933" data_animation="fadeInUp" data_delay="300"]Your Description Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column][vc_column width="1/4"][apress_imagebox imagebox_style="style2" imagebox_bor_color="#e2e2e2" imagebox_image="608" imagebox_title="REFINERY" imagebox_title_fonsize="22" imagebox_title_color="#333333" imagebox_description_color="" imagebox_button_size="medium" imagebox_button_border_radius="50" imagebox_buttonfontcolor="#dd9933" imagebox_buttonfontcolorhover="#ffffff" imagebox_buttonbackgroundcolor="rgba(84,159,252,0.01)" imagebox_buttonbackgroundcolorhover="#dd9933" imagebox_buttonbordercolor="#dd9933" imagebox_buttonbordercolorhover="#dd9933" data_animation="fadeInUp" data_delay="600"]Your Description Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column][vc_column width="1/4"][apress_imagebox imagebox_style="style2" imagebox_bor_color="#e2e2e2" imagebox_image="607" imagebox_title="CONSTRUCTION" imagebox_title_fonsize="22" imagebox_title_color="#333333" imagebox_description_color="" imagebox_button_size="medium" imagebox_button_border_radius="50" imagebox_buttonfontcolor="#dd9933" imagebox_buttonfontcolorhover="#ffffff" imagebox_buttonbackgroundcolor="rgba(84,159,252,0.01)" imagebox_buttonbackgroundcolorhover="#dd9933" imagebox_buttonbordercolor="#dd9933" imagebox_buttonbordercolorhover="#dd9933" data_animation="fadeInUp" data_delay="900"]Your Description Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column][vc_column width="1/4"][apress_imagebox imagebox_style="style2" imagebox_bor_color="#e2e2e2" imagebox_image="606" imagebox_title="HUMAN RESOURCE" imagebox_title_fonsize="22" imagebox_title_color="#333333" imagebox_description_color="" imagebox_button_size="medium" imagebox_button_border_radius="50" imagebox_buttonfontcolor="#dd9933" imagebox_buttonfontcolorhover="#ffffff" imagebox_buttonbackgroundcolor="rgba(84,159,252,0.01)" imagebox_buttonbackgroundcolorhover="#dd9933" imagebox_buttonbordercolor="#dd9933" imagebox_buttonbordercolorhover="#dd9933" data_animation="fadeInUp" data_delay="1200"]Your Description Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Cloud Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 46', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about46.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^792|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/bg3-1.jpg|caption^null|alt^null|title^bg3|description^null" bg_image_repeat="no-repeat" bg_override="browser_size"][vc_column width="1/2"][apress_heading sub_title="OUR PASSION" content_alignment="left" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style6" title_font_options="tag:h2" subtitle_font_options="tag:div|color:%23ffffff" heading_margin="margin-top:10|margin-bottom:50"]We are the <span style="color: #4776e6;"><em>creative folks</em></span> behind the Apress theme. Our focus is to provide our customers the best of our ability to help in making their website live as quickly as possible.[/apress_heading][apress_button button_text="Hire Us" button_shape="round" button_size="large" data_animation="fadeInUp" button_font_options="font_style_italic:1"][/vc_column][vc_column width="1/2"][ultimate_spacer height="25"][apress_progress_bar title="WEB DESIGN" percentage_style="z_percentage_2" title_color="#ffffff" pb_color="#4776e6" pb_alt_color="#8e54e9" pb_ctn_color="#eaeaea"][apress_progress_bar title="ADVERTISING" percentage="85" percentage_style="z_percentage_2" title_color="#ffffff" pb_color="#4776e6" pb_alt_color="#8e54e9" pb_ctn_color="#eaeaea"][apress_progress_bar title="ANALYTICS" percentage="90" percentage_style="z_percentage_2" title_color="#ffffff" pb_color="#4776e6" pb_alt_color="#8e54e9" pb_ctn_color="#eaeaea"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 33', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about33.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][vc_single_image image="388" img_size="full" alignment="center" css_animation="fadeInUp"][/vc_column][vc_column width="1/2"][ultimate_fancytext fancytext_prefix="WE DESIGN " fancytext_align="left" strings_textspeed="35" strings_backspeed="0" sufpref_color="#333333" fancytext_strings="FUTURE
WEBSITES" strings_font_size="desktop:50px;" strings_line_height="desktop:60px;" prefix_suffix_font_size="desktop:50px;" prefix_suffix_line_height="desktop:60px;" fancytext_color="#8e54e9"][vc_tta_accordion c_icon="cross" active_section="1" accordian_titleborder="titleborder_none" title_color="#8e54e9" border_color="rgba(236,235,235,0.01)" content_text_color="" content_border_color="rgba(236,235,235,0.01)"][vc_tta_section active_title_color="" active_bg_color="rgba(0,0,0,0.01)" active_border_color="rgba(236,235,235,0.01)" title="CREATIVE AND MINIMAL" tab_id="1504948896450-0423c8b3-160a"][vc_column_text css=".vc_custom_1504949675353{margin-top: -20px !important;margin-bottom: -20px !important;padding-top: 0px !important;padding-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section active_title_color="" active_bg_color="rgba(0,0,0,0.01)" active_border_color="rgba(236,235,235,0.01)" title="HEADER BUILDER" tab_id="1504948896571-2245263e-ff6b"][vc_column_text css=".vc_custom_1504949688430{margin-top: -20px !important;margin-bottom: -20px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section active_title_color="" active_bg_color="rgba(0,0,0,0.01)" active_border_color="rgba(236,235,235,0.01)" title="TEMPLATE GALLERY" tab_id="1504949609019-78470f8f-905d"][vc_column_text css=".vc_custom_1504949646171{margin-top: -20px !important;margin-bottom: -20px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Blog 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 36', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about36.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][info_circle edge_radius="80" start_degree="90" eg_padding="60" icon_size="100" img_icon_size="36" icon_show="not-show" content_color="#333333" eg_br_style="dashed" eg_br_width="1" eg_border_color="#aaaaaa" highlight_style="info-circle-pop" icon_launch="easeOutBounce" icon_launch_duration="1" icon_launch_delay="0.2" responsive_breakpoint="800" desc_font_size="desktop:16px;" desc_line_height="desktop:26px;" title_font_size="desktop:20px;" title_line_height="desktop:30px;"][info_circle_item info_title="Search Optimization" icon_type="custom" info_img="id^682|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/search-optiomization.png|caption^null|alt^null|title^search-optiomization|description^null"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/info_circle_item][info_circle_item info_title="Page Rank Optimization" icon_type="custom" info_img="id^683|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/page-rank.png|caption^null|alt^null|title^page-rank|description^null"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/info_circle_item][info_circle_item info_title="Location Targeting Optimization" icon_type="custom" info_img="id^684|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/location-targeting.png|caption^null|alt^null|title^location-targeting|description^null"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/info_circle_item][info_circle_item info_title="Link Optimization" icon_type="custom" info_img="id^685|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/link.png|caption^null|alt^null|title^link|description^null"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/info_circle_item][info_circle_item info_title="Conversion Management Optimization" icon_type="custom" info_img="id^686|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/conversion-management.png|caption^null|alt^null|title^conversion-management|description^null"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/info_circle_item][info_circle_item info_title="Content Optimization" icon_type="custom" info_img="id^687|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/content.png|caption^null|alt^null|title^content|description^null"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/info_circle_item][/info_circle][/vc_column][vc_column width="1/2"][apress_heading sub_title="ABOUT OUR TEAM" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style2" title_font_options="tag:h2|font_size:35|line_height:50|letter_spacing:1" subtitle_font_options="tag:div|letter_spacing:3" heading_margin="margin-bottom:20"]We are a team of industry veterans in field of SEO.[/apress_heading][vc_column_text]
<p style="text-align: center;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>
[/vc_column_text][apress_button button_text="Hire Us" color_scheme="design_your_own" button_bg_color="#ff5607" button_bg_color_h="rgba(255,86,7,0.01)" button_text_color_h="#ff5607" button_border_color="#ff5607" button_border_color_h="#ff5607" button_shape="rounded" button_size="large" button_alignment="center"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Elegant Blog 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 47', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about47.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^792|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/bg3-1.jpg|caption^null|alt^null|title^bg3|description^null" bg_image_repeat="no-repeat" bg_override="browser_size"][vc_column width="1/2"][apress_heading sub_title="OUR PASSION" content_alignment="left" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style6" title_font_options="tag:h2" subtitle_font_options="tag:div|color:%23ffffff" heading_margin="margin-top:10|margin-bottom:50"]We are the <span style="color: #4776e6;"><em>creative folks</em></span> behind the Apress theme. Our focus is to provide our customers the best of our ability to help in making their website live as quickly as possible.[/apress_heading][apress_button button_text="Hire Us" button_shape="round" button_size="large" data_animation="fadeInUp" button_font_options="font_style_italic:1"][/vc_column][vc_column width="1/2"][ultimate_spacer height="40"][vc_row_inner][vc_column_inner width="1/3"][vc_single_image image="876" img_size="full" css_animation="fadeInDown"][/vc_column_inner][vc_column_inner width="1/3"][vc_single_image image="875" img_size="full" css_animation="fadeInDown"][/vc_column_inner][vc_column_inner width="1/3"][vc_single_image image="874" img_size="full" css_animation="fadeInDown"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][vc_single_image image="873" img_size="full" css_animation="fadeInDown"][/vc_column_inner][vc_column_inner width="1/3"][vc_single_image image="872" img_size="full" css_animation="fadeInDown"][/vc_column_inner][vc_column_inner width="1/3"][vc_single_image image="871" img_size="full" css_animation="fadeInDown"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Hosting Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 38', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about38.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][ultimate_spacer height="100"][ultimate_carousel slide_to_scroll="single" slides_on_desk="3" slides_on_mob="1" arrows="off"][apress_icon_box box_style="box_style_square" box_variation="variation_modern" box_bg="#ffffff" box_border="#f7f7f7" iconcolor="#ffffff" icon_hover_color="#ffffff" icon_size="50" variation_icon_bg_shape="full_width" shape_size="100" variation_icon_bg_color="#48af4b" variation_icon_border_color="#48af4b" iconposition2="center" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" contentboxtitle="WEB DESIGN"][apress_icon_box box_style="box_style_square" box_variation="variation_modern" box_bg="#ffffff" box_border="#f7f7f7" iconcolor="#ffffff" icon_hover_color="#ffffff" icon_size="50" variation_icon_bg_shape="full_width" shape_size="100" variation_icon_bg_color="#48af4b" variation_icon_border_color="#48af4b" iconposition2="center" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-paperplane" contentboxtitle="WEB DESIGN"][apress_icon_box box_style="box_style_square" box_variation="variation_modern" box_bg="#ffffff" box_border="#f7f7f7" iconcolor="#ffffff" icon_hover_color="#ffffff" icon_size="50" variation_icon_bg_shape="full_width" shape_size="100" variation_icon_bg_color="#48af4b" variation_icon_border_color="#48af4b" iconposition2="center" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-display" contentboxtitle="WEB DESIGN"][apress_icon_box box_style="box_style_square" box_variation="variation_modern" box_bg="#ffffff" box_border="#f7f7f7" iconcolor="#ffffff" icon_hover_color="#ffffff" icon_size="50" variation_icon_bg_shape="full_width" shape_size="100" variation_icon_bg_color="#48af4b" variation_icon_border_color="#48af4b" iconposition2="center" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" contentboxtitle="WEB DESIGN"][apress_icon_box box_style="box_style_square" box_variation="variation_modern" box_bg="#ffffff" box_border="#f7f7f7" iconcolor="#ffffff" icon_hover_color="#ffffff" icon_size="50" variation_icon_bg_shape="full_width" shape_size="100" variation_icon_bg_color="#48af4b" variation_icon_border_color="#48af4b" iconposition2="center" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-paperplane" contentboxtitle="WEB DESIGN"][apress_icon_box box_style="box_style_square" box_variation="variation_modern" box_bg="#ffffff" box_border="#f7f7f7" iconcolor="#ffffff" icon_hover_color="#ffffff" icon_size="50" variation_icon_bg_shape="full_width" shape_size="100" variation_icon_bg_color="#48af4b" variation_icon_border_color="#48af4b" iconposition2="center" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-display" contentboxtitle="WEB DESIGN"][/ultimate_carousel][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Lawyer Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 50', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about50.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^443|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/bg2-1.jpg|caption^null|alt^null|title^bg2|description^null" bg_image_repeat="no-repeat" bg_override="browser_size"][vc_column][vc_row_inner][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1505195401689{padding-top: 50px !important;padding-right: 50px !important;padding-bottom: 50px !important;padding-left: 50px !important;background-color: #ffffff !important;}"][apress_heading sub_title="ABOUT US" data_animation="fadeInUp" enable_delimiter="" title_google_fonts="yes" subtitle_google_fonts="yes" style="heading_style2" title_font_options="tag:h2|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div|letter_spacing:3" subtitle_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" heading_margin="margin-bottom:20"]BRIDGING THE GAP[/apress_heading][apress_heading sub_title="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " data_animation="fadeInUp" enable_delimiter="" subtitle_google_fonts="yes" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div" subtitle_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][/apress_heading][ultimate_spacer height="30"][apress_button button_text="Hire Us" button_shape="round" button_size="large" button_alignment="center" data_animation="fadeInUp" button_google_fonts="yes" button_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 39', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about39.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row gap="30"][vc_column width="2/3"][apress_text_separator title="ABOUT US" title_align="separator_align_left" el_width="90" color="#dddddd" title_font_options="tag:h2"][vc_column_text]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/vc_column_text][/vc_column][vc_column width="1/3"][apress_text_separator title="SERVICES" title_align="separator_align_left" el_width="80" color="#dddddd" title_font_options="tag:h2"][vc_row_inner][vc_column_inner width="1/2"][ultimate_icon_list icon_size="16" icon_margin="10"][ultimate_icon_list_item icon="Defaults-check" icon_color="#ffffff" icon_style="circle" icon_color_bg="#3e4eb7"]Web Design[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-check" icon_color="#ffffff" icon_style="circle" icon_color_bg="#3e4eb7"]Web Design[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-check" icon_color="#ffffff" icon_style="circle" icon_color_bg="#3e4eb7"]Web Design[/ultimate_icon_list_item][/ultimate_icon_list][/vc_column_inner][vc_column_inner width="1/2"][ultimate_icon_list icon_size="16" icon_margin="10"][ultimate_icon_list_item icon="Defaults-check" icon_color="#ffffff" icon_style="circle" icon_color_bg="#3e4eb7"]Web Design[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-check" icon_color="#ffffff" icon_style="circle" icon_color_bg="#3e4eb7"]Web Design[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-check" icon_color="#ffffff" icon_style="circle" icon_color_bg="#3e4eb7"]Web Design[/ultimate_icon_list_item][/ultimate_icon_list][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ultimate_spacer height="50"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][apress_counter_circle data_percent_value="70" bar_color="#3e4eb7" track_color="#ffffff" scale_color="#3e4eb7" line_cap="square" size="250"][apress_heading sub_title="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " delimiter_line_height="2" delimiter_line_width="30" color_scheme="design_your_own" main_heading_color=". Nunc auctor pulvinar velit, et vehicula lectus congue volutpat." style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div" heading_margin="margin-top:50|margin-bottom:20" subheading_margin="margin-top:20"]DESIGN[/apress_heading][/vc_column][vc_column width="1/3"][apress_counter_circle data_percent_value="80" bar_color="#3e4eb7" track_color="#ffffff" scale_color="#3e4eb7" line_cap="square" size="250"][apress_heading sub_title="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " delimiter_line_height="2" delimiter_line_width="30" color_scheme="design_your_own" main_heading_color=". Nunc auctor pulvinar velit, et vehicula lectus congue volutpat." style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div" heading_margin="margin-top:50|margin-bottom:20" subheading_margin="margin-top:20"]CODE[/apress_heading][/vc_column][vc_column width="1/3"][apress_counter_circle data_percent_value="90" bar_color="#3e4eb7" track_color="#ffffff" scale_color="#3e4eb7" line_cap="square" size="250"][apress_heading sub_title="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " delimiter_line_height="2" delimiter_line_width="30" color_scheme="design_your_own" main_heading_color=". Nunc auctor pulvinar velit, et vehicula lectus congue volutpat." style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div" heading_margin="margin-top:50|margin-bottom:20" subheading_margin="margin-top:20"]IMPRESS[/apress_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Mobile Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 41', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about41.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][ultimate_spacer height="100"][apress_heading sub_title="" enable_delimiter="" color_scheme="design_your_own" style="heading_style2" title_font_options="tag:h2|font_size:40|line_height:60|letter_spacing:1" subtitle_font_options="tag:div|letter_spacing:5"]We are a<span style="color: #0700e4;"><em> technology company</em></span> with diverse range of services in management, development, operations and licensing of WordPress based products.[/apress_heading][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Restaurant Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 51', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about51.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^443|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/bg2-1.jpg|caption^null|alt^null|title^bg2|description^null" bg_image_repeat="no-repeat" bg_override="browser_size"][vc_column][vc_row_inner][vc_column_inner width="1/2" css=".vc_custom_1505195401689{padding-top: 50px !important;padding-right: 50px !important;padding-bottom: 50px !important;padding-left: 50px !important;background-color: #ffffff !important;}"][apress_heading sub_title="ABOUT US" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" title_google_fonts="yes" subtitle_google_fonts="yes" style="heading_style2" title_font_options="tag:h2|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div|letter_spacing:3" subtitle_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" heading_margin="margin-bottom:20"]BRIDGING THE GAP[/apress_heading][apress_heading sub_title="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " content_alignment="left" data_animation="fadeInUp" enable_delimiter="" subtitle_google_fonts="yes" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div" subtitle_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][/apress_heading][ultimate_spacer height="30"][apress_button button_text="Hire Us" button_shape="round" button_size="large" button_alignment="left" data_animation="fadeInUp" button_google_fonts="yes" button_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Shop Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 44', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about44.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][ultimate_spacer height="50"][vc_row_inner gap="5"][vc_column_inner width="1/3"][apress_heading sub_title="" content_alignment="left" data_animation="fadeInUp" data_delay="300" delimiter_line_height="2" delimiter_line_width="60" color_scheme="design_your_own" main_heading_color="#eaeaea" style="heading_style8" title_font_options="tag:h1|font_size:70|line_height:80|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:20"]ABOUT US[/apress_heading][/vc_column_inner][vc_column_inner width="2/3"][vc_column_text css_animation="fadeInUp"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.[/vc_column_text][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][vc_row_inner][vc_column_inner width="1/3"][apress_process title="DESIGN" data_animation="fadeInUp" data_delay="300" style="process_style2" process_image="237" title_font_options="tag:h3" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor[/apress_process][/vc_column_inner][vc_column_inner width="1/3"][apress_process title="CODE" process_step="02" data_animation="fadeInUp" data_delay="600" style="process_style2" process_image="235" title_font_options="tag:h3" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor[/apress_process][/vc_column_inner][vc_column_inner width="1/3"][apress_process title="IMPRESS" process_step="03" data_animation="fadeInUp" data_delay="900" style="process_style2" process_image="236" title_font_options="tag:h3" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor[/apress_process][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//University Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 48', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about48.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2" css=".vc_custom_1505125243693{padding-right: 5% !important;padding-left: 5% !important;}"][vc_single_image image="884" img_size="full" alignment="center" style="vc_box_shadow" onclick="link_image" css_animation="fadeInUp"][apress_heading sub_title="OUR MISSION" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style2" heading_margin="margin-bottom:20" title_font_options="tag:h2" subtitle_font_options="tag:div"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque.[/apress_heading][vc_column_text css_animation="fadeInUp"]Suspendisse placerat sapien in ullamcorper porttitor consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/2" css=".vc_custom_1505125253613{padding-right: 5% !important;padding-left: 5% !important;}"][apress_heading sub_title="ABOUT US" content_alignment="left" data_animation="fadeInDown" data_delay="300" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style2" heading_margin="margin-bottom:20" title_font_options="tag:h2" subtitle_font_options="tag:div"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque.[/apress_heading][vc_column_text css_animation="fadeInDown"]Suspendisse placerat sapien in ullamcorper porttitor consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_single_image image="885" img_size="full" alignment="center" style="vc_box_shadow" onclick="link_image" css_animation="fadeInDown"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients Category
	//Corporate clients vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 52', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about52.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^918|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/abt9.jpg|caption^null|alt^null|title^abt9|description^null" bg_image_repeat="no-repeat" bg_override="browser_size" enable_overlay="enable_overlay_value" overlay_color="rgba(0,0,0,0.05)"][vc_column][vc_row_inner][vc_column_inner width="1/3" css=".vc_custom_1505195401689{padding-top: 50px !important;padding-right: 50px !important;padding-bottom: 50px !important;padding-left: 50px !important;background-color: #ffffff !important;}"][apress_heading sub_title="ABOUT US" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" title_google_fonts="yes" subtitle_google_fonts="yes" style="heading_style2" title_font_options="tag:h2|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div|letter_spacing:3" subtitle_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" heading_margin="margin-bottom:20"]BRIDGING THE GAP[/apress_heading][apress_heading sub_title="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " content_alignment="left" data_animation="fadeInUp" enable_delimiter="" subtitle_google_fonts="yes" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div" subtitle_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][/apress_heading][ultimate_spacer height="30"][apress_button button_text="Hire Us" button_shape="round" button_size="large" button_alignment="left" data_animation="fadeInUp" button_google_fonts="yes" button_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][/vc_column_inner][vc_column_inner width="1/3"][/vc_column_inner][vc_column_inner width="1/3"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate clients 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 49', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about49.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][apress_heading sub_title="" data_animation="fadeInUp" data_delay="300" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" title_google_fonts="yes" style="heading_style1" title_font_options="tag:h2|font_size:70|line_height:80|letter_spacing:3|font_style_underline:1" subtitle_font_options="tag:div" title_custom_fonts="font_family:Lekton%3Aregular%2Citalic%2C700|font_style:400%20regular%3A400%3Anormal"]Jane & Smith[/apress_heading][ultimate_spacer height="50"][/vc_column][/vc_row][vc_row gap="30"][vc_column width="1/2"][vc_single_image image="895" img_size="full" alignment="center" onclick="link_image" css_animation="fadeInUp"][apress_heading sub_title="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor" data_animation="fadeInUp" data_delay="300" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" title_google_fonts="yes" subtitle_google_fonts="yes" style="heading_style1" title_font_options="tag:h2|font_style_underline:1" subtitle_font_options="tag:div" title_custom_fonts="font_family:Lekton%3Aregular%2Citalic%2C700|font_style:400%20regular%3A400%3Anormal" subtitle_custom_fonts="font_family:Lekton%3Aregular%2Citalic%2C700|font_style:400%20regular%3A400%3Anormal"][/apress_heading][/vc_column][vc_column width="1/2"][vc_single_image image="896" img_size="full" alignment="center" onclick="link_image" css_animation="fadeInUp"][apress_heading sub_title="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor" data_animation="fadeInUp" data_delay="600" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" title_google_fonts="yes" subtitle_google_fonts="yes" style="heading_style1" title_font_options="tag:h2|font_style_underline:1" subtitle_font_options="tag:div" title_custom_fonts="font_family:Lekton%3Aregular%2Citalic%2C700|font_style:400%20regular%3A400%3Anormal" subtitle_custom_fonts="font_family:Lekton%3Aregular%2Citalic%2C700|font_style:400%20regular%3A400%3Anormal"][/apress_heading][/vc_column][/vc_row][vc_row][vc_column][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Hosting red clients vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 53', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about53.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row gap="30" bg_type="grad" bg_override="browser_size" enable_overlay="enable_overlay_value" overlay_color="rgba(0,0,0,0.05)" bg_grad="background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, #F857A5), color-stop(100%, #FF5858));background: -moz-linear-gradient(left,#F857A5 0%,#FF5858 100%);background: -webkit-linear-gradient(left,#F857A5 0%,#FF5858 100%);background: -o-linear-gradient(left,#F857A5 0%,#FF5858 100%);background: -ms-linear-gradient(left,#F857A5 0%,#FF5858 100%);background: linear-gradient(left,#F857A5 0%,#FF5858 100%);"][vc_column][vc_row_inner][vc_column_inner width="1/4" css=".vc_custom_1505201265724{padding-top: 50px !important;padding-right: 50px !important;padding-bottom: 50px !important;padding-left: 50px !important;}"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1505201188360{padding: 50px !important;background-color: #ffffff !important;}"][apress_heading sub_title="ABOUT US" data_animation="fadeInUp" enable_delimiter="" color_scheme="gradient_scheme2" title_google_fonts="yes" subtitle_google_fonts="yes" style="heading_style2" title_font_options="tag:h2|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div|letter_spacing:3" subtitle_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" heading_margin="margin-bottom:20"]BRIDGING THE GAP[/apress_heading][apress_heading sub_title="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " data_animation="fadeInUp" enable_delimiter="" subtitle_google_fonts="yes" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div" subtitle_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][/apress_heading][ultimate_spacer height="30"][apress_button button_text="Hire Us" color_scheme="gradient_scheme2" button_shape="round" button_size="large" button_alignment="center" data_animation="fadeInUp" button_google_fonts="yes" button_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1505201272795{padding-top: 50px !important;padding-right: 50px !important;padding-bottom: 50px !important;padding-left: 50px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Mobile clients vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 54', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about54.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row gap="30" bg_type="bg_color" bg_override="browser_size" bg_color_value="#f7f7f7"][vc_column css_animation="fadeInUp" width="1/3" css=".vc_custom_1505204011713{border-top-width: 2px !important;padding-top: 50px !important;padding-right: 50px !important;padding-bottom: 50px !important;padding-left: 50px !important;background-color: #ffffff !important;border-top-color: #ff5858 !important;border-top-style: solid !important;}"][apress_heading sub_title="ABOUT US" content_alignment="left" data_animation="fadeInUp" data_delay="1000" enable_delimiter="" color_scheme="gradient_scheme2" title_google_fonts="yes" subtitle_google_fonts="yes" style="heading_style2" title_font_options="tag:h2|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div|letter_spacing:3" subtitle_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" heading_margin="margin-bottom:20"]BRIDGING THE GAP[/apress_heading][apress_heading sub_title="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " content_alignment="left" data_animation="fadeInUp" enable_delimiter="" subtitle_google_fonts="yes" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div" subtitle_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][/apress_heading][ultimate_spacer height="30"][apress_button button_text="Hire Us" color_scheme="gradient_scheme2" button_shape="round" button_size="large" button_alignment="left" data_animation="fadeInDown" data_delay="1200" button_google_fonts="yes" button_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][/vc_column][vc_column css_animation="fadeInUp" width="1/3" css=".vc_custom_1505204018795{border-top-width: 2px !important;padding-top: 50px !important;padding-right: 50px !important;padding-bottom: 50px !important;padding-left: 50px !important;background-color: #ffffff !important;border-top-color: #ff5858 !important;border-top-style: solid !important;}"][apress_heading sub_title="HOW WE WORK" content_alignment="left" data_animation="fadeInUp" data_delay="1000" enable_delimiter="" color_scheme="gradient_scheme2" title_google_fonts="yes" subtitle_google_fonts="yes" style="heading_style2" title_font_options="tag:h2|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div|letter_spacing:3" subtitle_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" heading_margin="margin-bottom:20"]PASSION REDEFINED[/apress_heading][apress_heading sub_title="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " content_alignment="left" data_animation="fadeInUp" enable_delimiter="" subtitle_google_fonts="yes" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div" subtitle_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][/apress_heading][ultimate_spacer height="30"][apress_button button_text="Learn More" color_scheme="gradient_scheme2" button_shape="round" button_size="large" button_alignment="left" data_animation="fadeInDown" data_delay="1200" button_google_fonts="yes" button_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][/vc_column][vc_column css_animation="fadeInUp" width="1/3" css=".vc_custom_1505204025096{border-top-width: 2px !important;padding-top: 50px !important;padding-right: 50px !important;padding-bottom: 50px !important;padding-left: 50px !important;background-color: #ffffff !important;border-top-color: #ff5858 !important;border-top-style: solid !important;}"][apress_heading sub_title="WORK WITH US" content_alignment="left" data_animation="fadeInUp" data_delay="1000" enable_delimiter="" color_scheme="gradient_scheme2" title_google_fonts="yes" subtitle_google_fonts="yes" style="heading_style2" title_font_options="tag:h2|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div|letter_spacing:3" subtitle_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" heading_margin="margin-bottom:20"]TALENT UNIFIED[/apress_heading][apress_heading sub_title="Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. " content_alignment="left" data_animation="fadeInUp" enable_delimiter="" subtitle_google_fonts="yes" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div" subtitle_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][/apress_heading][ultimate_spacer height="30"][apress_button button_text="Contact Us" color_scheme="gradient_scheme2" button_shape="round" button_size="large" button_alignment="left" data_animation="fadeInDown" data_delay="1200" button_google_fonts="yes" button_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][/vc_column][/vc_row]

CONTENT;
	$templates[] = $data;

	//Shop clients vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 55', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about55.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][apress_heading sub_title="ABOUT US" delimiter_line_height="1" delimiter_line_width="100" color_scheme="design_your_own" main_heading_color="#333333" title_google_fonts="yes" subtitle_google_fonts="yes" style="heading_style6" delimiter_line_color="#333333" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div|color:%23333333|letter_spacing:3" subtitle_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:900%20bold%20italic%3A900%3Aitalic" heading_margin="margin-top:30|margin-bottom:50"]We are a Digital Agency based in London and ready to serve your requirements within your budget and requirement.[/apress_heading][ultimate_spacer height="100"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][apress_icon_box box_style="box_style_square" box_hover_style="box-flip-vertical" box_bg="#ffffff" box_border="#e8e8e8" iconcolor="#0088cc" icon_size="60" iconposition2="center" boxtitlepad="padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-cloud" contentboxtitle="CLOUD APPS" contentboxanimation="fadeInUp" contentboxdelay="300"][ultimate_spacer height="30"][/vc_column][vc_column width="1/3"][apress_icon_box box_style="box_style_square" box_hover_style="box-flip-vertical" box_bg="#ffffff" box_border="#e8e8e8" iconcolor="#0088cc" icon_size="60" iconposition2="center" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-paperplane" contentboxtitle="EMAIL APPS" contentboxanimation="fadeInUp" contentboxdelay="600"][ultimate_spacer height="30"][/vc_column][vc_column width="1/3"][apress_icon_box box_style="box_style_square" box_hover_style="box-flip-vertical" box_bg="#ffffff" box_border="#e8e8e8" iconcolor="#0088cc" icon_size="60" iconposition2="center" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" contentboxtitle="EVENT APPS" contentboxanimation="fadeInUp" contentboxdelay="900"][ultimate_spacer height="30"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][apress_icon_box box_style="box_style_square" box_hover_style="box-flip-vertical" box_bg="#ffffff" box_border="#e8e8e8" iconcolor="#0088cc" icon_size="60" iconposition2="center" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-bubble" contentboxtitle="CHAT APPS" contentboxanimation="fadeInUp"][ultimate_spacer height="30"][/vc_column][vc_column width="1/3"][apress_icon_box box_style="box_style_square" box_hover_style="box-flip-vertical" box_bg="#ffffff" box_border="#e8e8e8" iconcolor="#0088cc" icon_size="60" iconposition2="center" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-tag" contentboxtitle="ECOMMERCE APPS" contentboxanimation="fadeInUp"][ultimate_spacer height="30"][/vc_column][vc_column width="1/3"][apress_icon_box box_style="box_style_square" box_hover_style="box-flip-vertical" box_bg="#ffffff" box_border="#e8e8e8" iconcolor="#0088cc" icon_size="60" iconposition2="center" boxtitlepad="padding-top:10|padding-bottom:5" icon_family="linecons" icon_linecons="vc_li vc_li-diamond" contentboxtitle="COLOR APPS" contentboxanimation="fadeInUp"][ultimate_spacer height="30"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counters Category
	//Agency Counter vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 56', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about56.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/4"][/vc_column][vc_column width="1/2"][apress_heading sub_title="ABOUT US" data_animation="fadeInUp" data_delay="300" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style6" title_font_options="tag:h2" subtitle_font_options="tag:div" heading_margin="margin-bottom:50"]Starting the Creative Revolution of freedom to design your own website your own way[/apress_heading][ultimate_spacer height="100"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row][vc_row][vc_column][apress_photo_gallery images="993,994,995,996,997,998,999,1000,1013,1014,452" photo_gallery_type="image_masonry" image_gutter="10" use_lightbox="yes" hover_effects="colortobw_effect" data_animation="fadeInUp" data_delay="100"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Bussines Cpunter vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 58', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about58.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^443|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/bg2-1.jpg|caption^null|alt^null|title^bg2|description^null" bg_image_repeat="no-repeat" bg_override="browser_size"][vc_column][apress_heading sub_title="ABOUT US" data_animation="fadeIn" delimiter_line_height="3" delimiter_line_width="80" color_scheme="design_your_own" main_heading_color="#ffffff" title_google_fonts="yes" style="heading_style6" heading_margin="margin-bottom:50" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div|color:%23ffffff|letter_spacing:3" delimiter_line_color="#ffffff"]Multi talented team with a experience of working with top notch product designers and fortune 500 companies.[/apress_heading][ultimate_spacer height="100"][vc_row_inner][vc_column_inner width="1/3"][stat_counter icon_size="32" counter_title="COUNTRIES" counter_value="51" speed="3" counter_color_txt="#ffffff" title_font_size="desktop:14px;" title_font_line_height="desktop:26px;" desc_font_size="desktop:50px;" desc_font_line_height="desktop:60px;" desc_font_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/3"][stat_counter icon_size="32" counter_title="HOURS" counter_value="22250" speed="3" counter_color_txt="#ffffff" title_font_size="desktop:14px;" title_font_line_height="desktop:26px;" desc_font_size="desktop:50px;" desc_font_line_height="desktop:60px;" desc_font_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/3"][stat_counter icon_size="32" counter_title="PROJECTS" counter_value="150" speed="3" counter_color_txt="#ffffff" title_font_size="desktop:14px;" title_font_line_height="desktop:26px;" desc_font_size="desktop:50px;" desc_font_line_height="desktop:60px;" desc_font_color="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Bussines Cpunter 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 57', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about57.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][apress_heading sub_title="ABOUT US" delimiter_line_height="3" delimiter_line_width="80" color_scheme="design_your_own" main_heading_color="#333333" title_google_fonts="yes" style="heading_style6" heading_margin="margin-bottom:50" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div|letter_spacing:3"]Multi talented team with a experience of working with top notch product designers and fortune 500 companies.[/apress_heading][ultimate_spacer height="100"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/3" css=".vc_custom_1505221093150{border-right-width: 1px !important;border-left-width: 1px !important;border-left-color: #ffffff !important;border-left-style: solid !important;border-right-color: #ffffff !important;border-right-style: solid !important;}"][stat_counter icon_size="32" counter_title="COUNTRIES" counter_value="51" speed="3" title_font_size="desktop:14px;" title_font_line_height="desktop:26px;" desc_font_size="desktop:50px;" desc_font_line_height="desktop:60px;" desc_font_color="#333333"][/vc_column][vc_column width="1/3" css=".vc_custom_1505221002335{border-right-width: 1px !important;border-left-width: 1px !important;border-left-color: #cccccc !important;border-left-style: solid !important;border-right-color: #cccccc !important;border-right-style: solid !important;}"][stat_counter icon_size="32" counter_title="HOURS" counter_value="22250" speed="3" title_font_size="desktop:14px;" title_font_line_height="desktop:26px;" desc_font_size="desktop:50px;" desc_font_line_height="desktop:60px;" desc_font_color="#333333"][/vc_column][vc_column width="1/3" css=".vc_custom_1505221104634{border-right-width: 1px !important;border-left-width: 1px !important;border-left-color: #ffffff !important;border-left-style: solid !important;border-right-color: #ffffff !important;border-right-style: solid !important;}"][stat_counter icon_size="32" counter_title="PROJECTS" counter_value="150" speed="3" title_font_size="desktop:14px;" title_font_line_height="desktop:26px;" desc_font_size="desktop:50px;" desc_font_line_height="desktop:60px;" desc_font_color="#333333"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Rental counter vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 59', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about59.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" css=".vc_custom_1505222836505{background-image: url(http://apresswp.com/demo35/wp-content/uploads/2017/09/abt11.jpg?id=1042) !important;}"][vc_column width="1/2" css=".vc_custom_1505222096477{padding-right: 5% !important;padding-left: 5% !important;}"][ultimate_spacer height="150"][apress_heading sub_title="ABOUT US" content_alignment="left" delimiter_line_height="2" delimiter_line_width="80" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style6" title_font_options="tag:h2" subtitle_font_options="tag:div|color:%23ffffff" heading_margin="margin-bottom:30" delimiter_line_color="#ffffff"]Suspendisse placerat sapien in ullamcorper porttitor.[/apress_heading][apress_heading sub_title="Cras gravida consequat lorem vitae vestibulum. Vivamus a eros vel tellus consequat dictum. Integer eget blandit nunc. Suspendisse porttitor ex magna, et sodales quam venenatis quis. Pellentesque iaculis tincidunt augue nec mollis. Sed vitae sapien non diam feugiat bibendum. Phasellus convallis lacus in nisi auctor, in convallis felis feugiat." content_alignment="left" enable_delimiter="" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div|color:%23ffffff" subheading_margin="margin-top:30|margin-bottom:30"][/apress_heading][apress_button button_text="Learn More" color_scheme="gradient_scheme2" button_shape="round" button_size="large"][ultimate_spacer height="150"][/vc_column][vc_column width="1/2" css=".vc_custom_1505223177004{margin-top: 0px !important;margin-bottom: 0px !important;padding-right: 5% !important;padding-left: 5% !important;background-color: #8e54e9 !important;}"][ultimate_spacer height="150"][apress_heading sub_title="ABOUT US" content_alignment="left" delimiter_line_height="2" delimiter_line_width="80" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style6" title_font_options="tag:h2" subtitle_font_options="tag:div|color:%23ffffff" heading_margin="margin-bottom:30" delimiter_line_color="#ffffff"]Suspendisse placerat sapien in ullamcorper porttitor.[/apress_heading][apress_heading sub_title="Cras gravida consequat lorem vitae vestibulum. Vivamus a eros vel tellus consequat dictum. Integer eget blandit nunc. Suspendisse porttitor ex magna, et sodales quam venenatis quis. Pellentesque iaculis tincidunt augue nec mollis. Sed vitae sapien non diam feugiat bibendum. Phasellus convallis lacus in nisi auctor, in convallis felis feugiat." content_alignment="left" enable_delimiter="" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div|color:%23ffffff" subheading_margin="margin-top:30|margin-bottom:30"][/apress_heading][apress_button button_text="Learn More" color_scheme="design_your_own" button_bg_color="rgba(82,149,234,0.01)" button_bg_color_h="#ffffff" button_text_color_h="#8e54e9" button_border_color="#ffffff" button_border_color_h="#ffffff" button_shape="round" button_size="large"][ultimate_spacer height="150"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Counter vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 60', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about60.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1505224325592{padding-top: 50px !important;padding-bottom: 100px !important;}"][vc_column width="1/2"][apress_process title="DESIGN" content_alignment="left" data_animation="fadeInUp" data_delay="300" style="process_style3" title_font_options="tag:h1" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Cras gravida consequat lorem vitae vestibulum. Vivamus a eros vel tellus consequat dictum. Integer eget blandit nunc. Suspendisse porttitor ex magna, et sodales quam venenatis quis. Pellentesque iaculis tincidunt augue nec mollis.[/apress_process][vc_empty_space height="30px"][apress_process title="CODE" process_step="02" content_alignment="left" data_animation="fadeInUp" data_delay="600" style="process_style3" title_font_options="tag:h1" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Cras gravida consequat lorem vitae vestibulum. Vivamus a eros vel tellus consequat dictum. Integer eget blandit nunc. Suspendisse porttitor ex magna, et sodales quam venenatis quis. Pellentesque iaculis tincidunt augue nec mollis.[/apress_process][vc_empty_space height="30px"][apress_process title="IMPRESS" process_step="03" content_alignment="left" data_animation="fadeInUp" data_delay="900" style="process_style3" title_font_options="tag:h1" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Cras gravida consequat lorem vitae vestibulum. Vivamus a eros vel tellus consequat dictum. Integer eget blandit nunc. Suspendisse porttitor ex magna, et sodales quam venenatis quis. Pellentesque iaculis tincidunt augue nec mollis.[/apress_process][vc_empty_space height="30px"][/vc_column][vc_column width="1/2"][apress_image_slider images="1059,1060" img_size="full" bullet_bg="#333333" style="slider_style1" bullet_navigation_style="dots_style3" arrows_style="arrows_style1"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Counter 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 61', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about61.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1505224325592{padding-top: 50px !important;padding-bottom: 100px !important;}"][vc_column width="1/2" css=".vc_custom_1505226672395{padding-right: 5% !important;padding-left: 5% !important;}"][vc_tta_accordion c_icon="cross" active_section="1" css_animation="fadeInUp" title_color="#333333" content_border_color="rgba(236,235,235,0.01)"][vc_tta_section active_title_color="#ffffff" active_bg_color="#8e54e9" active_border_color="#8e54e9" title="Section 1" tab_id="1505225066133-350de239-255e"][vc_column_text css=".vc_custom_1505226388133{margin-top: -10px !important;margin-bottom: -10px !important;}"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section active_title_color="#333333" active_bg_color="#ffffff" active_border_color="#8e54e9" title="Section 1" tab_id="1505227863428-528cbe02-247b"][vc_column_text css=".vc_custom_1505226388133{margin-top: -10px !important;margin-bottom: -10px !important;}"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section active_title_color="#333333" active_bg_color="#ffffff" active_border_color="#8e54e9" title="Section 2" tab_id="1505225341223-9dbe3910-a96d"][vc_column_text css=".vc_custom_1505226437384{margin-top: -10px !important;margin-bottom: -10px !important;}"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section active_title_color="#333333" active_bg_color="#ffffff" active_border_color="#8e54e9" title="Section 3" tab_id="1505225340483-b44da7d2-0a28"][vc_column_text css=".vc_custom_1505226462600{margin-top: -10px !important;margin-bottom: -10px !important;padding-top: -10px !important;padding-bottom: -10px !important;}"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_accordion][/vc_column][vc_column width="1/2"][apress_image_slider images="1059,1060" img_size="full" bullet_bg="#333333" data_animation="fadeInUp" style="slider_style1" bullet_navigation_style="dots_style3" arrows_style="arrows_style1"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Hosting Red Counter vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 62', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about62.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][apress_heading sub_title="" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:30"]Our team's<span style="color: #0700e4;"><em> talent &amp; dedication</em></span> to help you solve your troubles.[/apress_heading][apress_lightbox lightbox_type="video" link_style="link_icon" button_icon_color="#0700e4" link="https://www.youtube.com/watch?v=yUCFRL43Zm4" select_button_style="video_icon_style4"][/vc_column][/vc_row]

CONTENT;
	$templates[] = $data;
	
	//Lawyer Counter vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 65', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about65.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" bg_type="grad" css=".vc_custom_1504945140413{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #f7f7f7 !important;}" bg_grad="background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, #4777E6), color-stop(99%, #8D54E9));background: -moz-linear-gradient(left,#4777E6 0%,#8D54E9 99%);background: -webkit-linear-gradient(left,#4777E6 0%,#8D54E9 99%);background: -o-linear-gradient(left,#4777E6 0%,#8D54E9 99%);background: -ms-linear-gradient(left,#4777E6 0%,#8D54E9 99%);background: linear-gradient(left,#4777E6 0%,#8D54E9 99%);"][vc_column][vc_row_inner][vc_column_inner][apress_heading sub_title="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo." enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" title_font_options="tag:h2|font_size:50|line_height:1|letter_spacing:1" subtitle_font_options="tag:div|color:%23ffffff" heading_margin="margin-bottom:50"]Passion <em>&amp;</em> Dedication[/apress_heading][/vc_column_inner][/vc_row_inner][ultimate_spacer height="100"][vc_row_inner][vc_column_inner width="1/3"][ult_content_box bg_color="#ffffff" box_shadow="horizontal:0px|vertical:5px|blur:25px|spread:0px|color:#0044e5|style:outset|" padding="padding:50px;" hover_bg_color="#ffffff" hover_border_color="#f7f7f7" hover_box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:none|" border="border-style:solid;|border-radius:10px;|border-color:#ffffff;"][apress_gradient_icon_box description="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo." data_animation="fadeInUp" data_delay="300" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]WEB DESIGN[/apress_gradient_icon_box][/ult_content_box][/vc_column_inner][vc_column_inner width="1/3"][ult_content_box box_shadow="horizontal:0px|vertical:5px|blur:15px|spread:0px|color:#5800e8|style:outset|" hover_box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:none|" bg_color="#ffffff" border="border-style:solid;|border-radius:10px;|border-color:#f7f7f7;" padding="padding:50px;" hover_bg_color="#ffffff" hover_border_color="#f7f7f7"][apress_gradient_icon_box description="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo." data_animation="fadeInUp" data_delay="300" icon_family="linecons" icon_linecons="vc_li vc_li-diamond" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]WEB DESIGN[/apress_gradient_icon_box][/ult_content_box][/vc_column_inner][vc_column_inner width="1/3"][ult_content_box box_shadow="horizontal:0px|vertical:5px|blur:15px|spread:0px|color:#600be8|style:outset|" padding="padding:50px;" hover_box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:none|" bg_color="#ffffff" border="border-style:solid;|border-radius:10px;|border-color:#f7f7f7;" hover_bg_color="#ffffff" hover_border_color="#f7f7f7"][apress_gradient_icon_box description="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo." data_animation="fadeInUp" data_delay="300" icon_family="linecons" icon_linecons="vc_li vc_li-paperplane" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]WEB DESIGN[/apress_gradient_icon_box][/ult_content_box][/vc_column_inner][/vc_row_inner][ultimate_spacer height="40"][/vc_column][/vc_row]

CONTENT;
	$templates[] = $data;

	//Main Counter vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 63', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about63.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle"][vc_column css_animation="fadeInLeft" width="1/3" css=".vc_custom_1504694625002{margin-top: 10px !important;margin-right: 10px !important;margin-bottom: 10px !important;margin-left: 10px !important;padding-top: 0px !important;background-image: url(http://apresswp.com/demo35/wp-content/uploads/2017/09/bg4.jpg) !important;}"][ultimate_spacer height="100"][apress_heading sub_title="" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div"]<span class="zolo_gradient_icon_description">Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. </span>[/apress_heading][ultimate_spacer height="100"][/vc_column][vc_column css_animation="fadeInUp" width="1/3" css=".vc_custom_1504694699432{margin-top: 10px !important;margin-right: 10px !important;margin-bottom: 10px !important;margin-left: 10px !important;padding-top: 0px !important;background-image: url(http://apresswp.com/demo35/wp-content/uploads/2017/09/bg1.jpg) !important;}"][ultimate_spacer height="100"][apress_heading sub_title="" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div"]<span class="zolo_gradient_icon_description">Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. </span>[/apress_heading][ultimate_spacer height="100"][/vc_column][vc_column css_animation="fadeInRight" width="1/3" css=".vc_custom_1504694707194{margin-top: 10px !important;margin-right: 10px !important;margin-bottom: 10px !important;margin-left: 10px !important;padding-top: 0px !important;background-image: url(http://apresswp.com/demo35/wp-content/uploads/2017/09/bg5-1.jpg) !important;}"][ultimate_spacer height="100"][apress_heading sub_title="" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div"]<span class="zolo_gradient_icon_description">Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. </span>[/apress_heading][ultimate_spacer height="100"][/vc_column][/vc_row]

CONTENT;
	$templates[] = $data;

	//Mobile Counter vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 64', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about64.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner width="2/3"][apress_heading sub_title="ABOUT US" content_alignment="left" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style2" title_font_options="tag:h2|font_size:35|line_height:45|letter_spacing:1" subtitle_font_options="tag:div|color:%2312d8fa|letter_spacing:2" heading_margin="margin-top:10|margin-bottom:50"]We take extreme attention  to create modern and minimal web design based on principles.[/apress_heading][/vc_column_inner][vc_column_inner width="1/3"][apress_button button_text="HIRE US" color_scheme="design_your_own" button_bg_color="#12d8fa" button_bg_color_h="#3bddf9" button_border_color="#12d8fa" button_border_color_h="#12d8fa" button_shape="rounded" button_size="large" button_alignment="center"][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][vc_row_inner][vc_column_inner width="1/4"][apress_text_separator title="HR" title_align="separator_align_left" el_width="70" color="#eeeeee" title_font_options="tag:h3"][ultimate_icon_list icon_size="16" icon_margin="10"][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][/ultimate_icon_list][/vc_column_inner][vc_column_inner width="1/4"][apress_text_separator title="Acounts" title_align="separator_align_left" el_width="70" color="#eeeeee" title_font_options="tag:h3"][ultimate_icon_list icon_size="16" icon_margin="10"][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][/ultimate_icon_list][/vc_column_inner][vc_column_inner width="1/4"][apress_text_separator title="Marketing" title_align="separator_align_left" el_width="70" color="#eeeeee" title_font_options="tag:h3"][ultimate_icon_list icon_size="16" icon_margin="10"][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][/ultimate_icon_list][/vc_column_inner][vc_column_inner width="1/4"][apress_text_separator title="Operations" title_align="separator_align_left" el_width="70" color="#eeeeee" title_font_options="tag:h3"][ultimate_icon_list icon_size="16" icon_margin="10"][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][ultimate_icon_list_item icon="Defaults-arrow-circle-o-right" icon_color="#12d8fa"]Suspendisse placerat sapien[/ultimate_icon_list_item][/ultimate_icon_list][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Mobile Counter 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 66', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about66.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^1117|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/abt12.jpg|caption^null|alt^null|title^abt12|description^null" bg_image_repeat="no-repeat" bg_override="browser_size"][vc_column width="1/2"][apress_heading sub_title="" content_alignment="left" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" title_font_options="tag:h2|font_size:35|line_height:45|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:30"]<em> Talent &amp; Dedication</em> to make your concept into reality.[/apress_heading][apress_lightbox lightbox_type="video" link_style="link_icon" button_icon_color="#ffffff" button_icon_hover_color="#ffffff" link="https://www.youtube.com/watch?v=yUCFRL43Zm4" select_button_style="video_icon_style5"][/vc_column][vc_column width="1/2"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//FAQ category
	//Car Rental FAQ vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 67', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about67.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1505237787731{padding-top: 150px !important;padding-bottom: 150px !important;background-color: #eb3349 !important;}"][vc_column][apress_heading sub_title="" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" title_font_options="tag:h2|font_size:70|line_height:80|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:30" title_responsive="font_size_tablet:50|line_height_tablet:60|letter_spacing_tablet:1|font_size_mobile:40|line_height_mobile:50|letter_spacing_mobile:1"]<em> Talent &amp; Dedication</em> to make your concept into reality.[/apress_heading][apress_lightbox lightbox_type="video" link_style="link_icon" button_icon_color="#ffffff" lightbox_hover_effect="yes" link="https://www.youtube.com/watch?v=yUCFRL43Zm4" select_button_style="video_icon_style2"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Cloud FAQ vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 69', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about69.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1505238930331{padding-top: 150px !important;padding-bottom: 150px !important;}"][vc_column width="1/2"][apress_heading sub_title="" content_alignment="left" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:h2|font_size:40|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:30" title_responsive="font_size_tablet:50|line_height_tablet:60|letter_spacing_tablet:1|font_size_mobile:40|line_height_mobile:50|letter_spacing_mobile:1"]<em> Talent &amp; Dedication</em> to make your concept into reality.[/apress_heading][apress_lightbox lightbox_type="video" link_style="link_icon_with_text" button_icon_color="#f45c43" link="https://www.youtube.com/watch?v=yUCFRL43Zm4" select_button_style="video_icon_style4" link_text="Watch Intro" videolink_font_options="color:%23333333|letter_spacing:1"][/vc_column][vc_column width="1/2"][vc_single_image image="1143" img_size="full" alignment="center"][/vc_column][/vc_row]

CONTENT;
	$templates[] = $data;

	//Hosting Blue FAQ vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 70', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about70.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1505122997432{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column width="1/2"][apress_heading sub_title="OUR PASSION" content_alignment="left" enable_delimiter="" color_scheme="design_your_own" style="heading_style6" title_font_options="tag:h2" subtitle_font_options="tag:div" heading_margin="margin-top:10|margin-bottom:50"]We are the <span style="color: #8e54e9;"><em>creative folks</em></span> behind the Apress theme. Our focus is to provide our customers the best of our ability to help in making their website live as quickly as possible.[/apress_heading][apress_button button_text="Hire Us" button_shape="round" button_size="large" data_animation="fadeInUp" button_font_options="font_style_italic:1"][/vc_column][vc_column width="1/2"][ultimate_spacer height="40"][vc_row_inner][vc_column_inner width="1/3"][vc_single_image image="876" img_size="full" css_animation="fadeInDown"][/vc_column_inner][vc_column_inner width="1/3"][vc_single_image image="875" img_size="full" css_animation="fadeInDown"][/vc_column_inner][vc_column_inner width="1/3"][vc_single_image image="874" img_size="full" css_animation="fadeInDown"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][vc_single_image image="873" img_size="full" css_animation="fadeInDown"][/vc_column_inner][vc_column_inner width="1/3"][vc_single_image image="872" img_size="full" css_animation="fadeInDown"][/vc_column_inner][vc_column_inner width="1/3"][vc_single_image image="871" img_size="full" css_animation="fadeInDown"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Hosting RED FAQ vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 68', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about68.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row bg_type="grad" bg_override="ex-full" css=".vc_custom_1505238263319{padding-top: 150px !important;padding-bottom: 150px !important;}" bg_grad="background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, #1FA2FF), color-stop(99%, #A6FFCB));background: -moz-linear-gradient(left,#1FA2FF 0%,#A6FFCB 99%);background: -webkit-linear-gradient(left,#1FA2FF 0%,#A6FFCB 99%);background: -o-linear-gradient(left,#1FA2FF 0%,#A6FFCB 99%);background: -ms-linear-gradient(left,#1FA2FF 0%,#A6FFCB 99%);background: linear-gradient(left,#1FA2FF 0%,#A6FFCB 99%);"][vc_column][apress_heading sub_title="" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" title_font_options="tag:h2|font_size:70|line_height:80|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:30" title_responsive="font_size_tablet:50|line_height_tablet:60|letter_spacing_tablet:1|font_size_mobile:40|line_height_mobile:50|letter_spacing_mobile:1"]<em> Talent &amp; Dedication</em> to make your concept into reality.[/apress_heading][apress_lightbox lightbox_type="video" link_style="link_icon" button_icon_color="#ffffff" lightbox_hover_effect="yes" link="https://www.youtube.com/watch?v=yUCFRL43Zm4" select_button_style="video_icon_style2"][/vc_column][/vc_row]

CONTENT;
	$templates[] = $data;

	//Lawyer FAQ vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 71', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about71.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1505122997432{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/2"][apress_heading sub_title="OUR PASSION" content_alignment="left" enable_delimiter="" color_scheme="design_your_own" style="heading_style6" title_font_options="tag:h2" subtitle_font_options="tag:div" heading_margin="margin-top:10|margin-bottom:50"]We are the <span style="color: #8e54e9;"><em>creative folks</em></span> behind the Apress theme. Our focus is to provide our customers the best of our ability to help in making their website live as quickly as possible.[/apress_heading][apress_button button_text="Hire Us" button_shape="round" button_size="large" data_animation="fadeInUp" button_font_options="font_style_italic:1"][/vc_column_inner][vc_column_inner width="1/2"][ultimate_spacer height="25"][apress_progress_bar title="WEB DESIGN" percentage_style="z_percentage_2" pb_color="#4776e6" pb_alt_color="#8e54e9" pb_ctn_color="#eaeaea"][apress_progress_bar title="ADVERTISING" percentage="85" percentage_style="z_percentage_2" pb_color="#4776e6" pb_alt_color="#8e54e9" pb_ctn_color="#eaeaea"][apress_progress_bar title="ANALYTICS" percentage="90" percentage_style="z_percentage_2" pb_color="#4776e6" pb_alt_color="#8e54e9" pb_ctn_color="#eaeaea"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//University FAQ vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 73', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about73.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^443|url^http://apresswp.com/demo35/wp-content/uploads/2017/09/bg2-1.jpg|caption^null|alt^null|title^bg2|description^null" bg_image_repeat="no-repeat" bg_override="browser_size"][vc_column][ultimate_spacer height="50"][vc_row_inner gap="5"][vc_column_inner width="1/3"][apress_heading sub_title="" content_alignment="left" data_animation="fadeInUp" data_delay="300" delimiter_line_height="2" delimiter_line_width="60" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style8" title_font_options="tag:h1|font_size:70|line_height:80|letter_spacing:1" subtitle_font_options="tag:div|color:%23ffffff" heading_margin="margin-bottom:20" delimiter_line_color="#ffffff"]ABOUT US[/apress_heading][/vc_column_inner][vc_column_inner width="2/3"][apress_heading sub_title="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." content_alignment="left" data_animation="fadeInUp" data_delay="600" enable_delimiter="" style="heading_style2" title_font_options="tag:h2" subtitle_font_options="tag:div|color:%23ffffff"][/apress_heading][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][vc_row_inner][vc_column_inner width="1/3"][apress_process title="DESIGN" data_animation="fadeInUp" data_delay="300" style="process_style2" process_image="237" title_font_options="tag:h3|color:%23ffffff" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div|color:%23ffffff"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor[/apress_process][/vc_column_inner][vc_column_inner width="1/3"][apress_process title="CODE" process_step="02" data_animation="fadeInUp" data_delay="600" style="process_style2" process_image="235" title_font_options="tag:h3|color:%23ffffff" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div|color:%23ffffff"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor[/apress_process][/vc_column_inner][vc_column_inner width="1/3"][apress_process title="IMPRESS" process_step="03" data_animation="fadeInUp" data_delay="900" style="process_style2" process_image="236" title_font_options="tag:h3|color:%23ffffff" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div|color:%23ffffff"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor[/apress_process][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][/vc_column][/vc_row]

CONTENT;
	$templates[] = $data;

	//Footers
	//Agency Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 72', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about72.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row bg_type="grad" bg_override="browser_size" bg_grad="background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, #F857A5), color-stop(100%, #FF5858));background: -moz-linear-gradient(left,#F857A5 0%,#FF5858 100%);background: -webkit-linear-gradient(left,#F857A5 0%,#FF5858 100%);background: -o-linear-gradient(left,#F857A5 0%,#FF5858 100%);background: -ms-linear-gradient(left,#F857A5 0%,#FF5858 100%);background: linear-gradient(left,#F857A5 0%,#FF5858 100%);"][vc_column][ultimate_spacer height="50"][vc_row_inner gap="5"][vc_column_inner width="1/3"][apress_heading sub_title="" content_alignment="left" data_animation="fadeInUp" data_delay="300" delimiter_line_height="2" delimiter_line_width="60" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style8" title_font_options="tag:h1|font_size:70|line_height:80|letter_spacing:1" subtitle_font_options="tag:div|color:%23ffffff" heading_margin="margin-bottom:20" delimiter_line_color="#ffffff"]ABOUT US[/apress_heading][/vc_column_inner][vc_column_inner width="2/3"][apress_heading sub_title="Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." content_alignment="left" data_animation="fadeInUp" data_delay="600" enable_delimiter="" style="heading_style2" title_font_options="tag:h2" subtitle_font_options="tag:div|color:%23ffffff"][/apress_heading][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][vc_row_inner][vc_column_inner width="1/3"][apress_process title="DESIGN" data_animation="fadeInUp" data_delay="300" style="process_style2" process_image="237" title_font_options="tag:h3|color:%23ffffff" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div|color:%23ffffff"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor[/apress_process][/vc_column_inner][vc_column_inner width="1/3"][apress_process title="CODE" process_step="02" data_animation="fadeInUp" data_delay="600" style="process_style2" process_image="235" title_font_options="tag:h3|color:%23ffffff" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div|color:%23ffffff"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor[/apress_process][/vc_column_inner][vc_column_inner width="1/3"][apress_process title="IMPRESS" process_step="03" data_animation="fadeInUp" data_delay="900" style="process_style2" process_image="236" title_font_options="tag:h3|color:%23ffffff" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div|color:%23ffffff"]Sed et ornare nisl. Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor[/apress_process][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][/vc_column][/vc_row]

CONTENT;

	$templates[] = $data;
		
	//Black Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 74', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about74.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1503902148464{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column css_animation="fadeInLeft" width="1/2"][apress_heading sub_title="" content_alignment="left" delimiter_line_height="3" delimiter_line_width="80" color_scheme="design_your_own" style="heading_style1" delimiter_line_color="#00a300" title_font_options="tag:h2|font_size:25|line_height:30" subtitle_font_options="tag:div" heading_margin="margin-bottom:15" subheading_margin="margin-top:30|margin-bottom:15"]ABOUT US[/apress_heading][vc_empty_space height="15px"][vc_column_text]Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.

Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/vc_column_text][vc_empty_space height="15px"][vc_row_inner][vc_column_inner width="1/2"][stat_counter icon="Defaults-suitcase" icon_size="32" icon_color="#00a300" counter_title="CLAIMS SETTLED" counter_value="250000" speed="3" desc_font_color="#00a300" title_font_size="desktop:18px;" title_font_line_height="desktop:30px;" desc_font_size="desktop:30px;" desc_font_line_height="desktop:40px;"][/vc_column_inner][vc_column_inner width="1/2"][stat_counter icon="Defaults-dollar usd" icon_size="32" icon_color="#00a300" counter_title="INSURANCE PAID" counter_value="12500000" speed="3" desc_font_color="#00a300" title_font_size="desktop:18px;" title_font_line_height="desktop:30px;" desc_font_size="desktop:30px;" desc_font_line_height="desktop:40px;"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column css_animation="fadeInRight" width="1/2"][apress_heading sub_title="" content_alignment="left" delimiter_line_height="3" delimiter_line_width="80" color_scheme="design_your_own" style="heading_style1" delimiter_line_color="#00a300" title_font_options="tag:h2|font_size:25|line_height:30" subtitle_font_options="tag:div" heading_margin="margin-bottom:15" subheading_margin="margin-bottom:15"]HOW IT WORKS[/apress_heading][vc_empty_space height="15px"][info_list style="hexagon" icon_bg_color="#00a300" icon_color="#ffffff" font_size_icon="20" connector_color="#00a300"][info_list_item list_title=" FIND AN AGENT" list_icon="Defaults-user" animation="fadeInLeft" title_font_size="desktop:18px;" title_font_line_height="desktop:30px;" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;"]Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/info_list_item][info_list_item list_title="SELECT A PACKAGE" list_icon="Defaults-gift" animation="fadeInLeft" title_font_size="desktop:18px;" title_font_line_height="desktop:30px;" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;"]Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/info_list_item][info_list_item list_title="GET INSURANCE" list_icon="Defaults-briefcase" animation="fadeInLeft" title_font_size="desktop:18px;" title_font_line_height="desktop:30px;" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;"]Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/info_list_item][/info_list][/vc_column][/vc_row]

CONTENT;

$templates[] = $data;
		
	//Black Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 75', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about75.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1504107174551{padding-top: 100px !important;}"][vc_column][apress_heading sub_title="ABOUT US" content_alignment="left" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style2" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:50"]Boston Architect Company[/apress_heading][vc_row_inner][vc_column_inner width="1/3"][apress_vertical_separator vertical_separator_width="1" vertical_separator_height="200" vertical_separator_align="center" vertical_separator_color="#333333" data_animation="fadeInUp" data_delay="300"][/vc_column_inner][vc_column_inner width="2/3"][vc_column_text css_animation="fadeInUp"]Morbi at suscipit diam, id sodales leo. Quisque mollis facilisis dui, in mattis felis molestie id. Suspendisse nec arcu venenatis, lacinia metus eget, malesuada nisi. Etiam a elementum augue, eget sodales erat.

Pellentesque sit amet lorem ac lorem congue aliquet. Pellentesque urna elit, hendrerit nec iaculis non, auctor sit amet mauris. Integer et ligula dignissim orci malesuada malesuada et ut arcu. Etiam viverra, libero ut vulputate ultrices, quam elit convallis magna, quis congue mauris eros eget mi.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1504107188047{padding-top: 30px !important;padding-bottom: 100px !important;}"][vc_column css_animation="fadeInUp" width="1/3"][stat_counter icon_size="32" counter_title="OFFICES" counter_value="5" speed="3"][/vc_column][vc_column css_animation="fadeInUp" width="1/3"][stat_counter icon_size="32" counter_title="TEAM" counter_value="50" counter_suffix="+" speed="3"][/vc_column][vc_column css_animation="fadeInUp" width="1/3"][stat_counter icon_size="32" counter_title="PROJECTS" counter_value="500" speed="3"][/vc_column][/vc_row]

CONTENT;

$templates[] = $data;
		
	//Black Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 76', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about76.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1504202038723{background-color: #f2f2f2 !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/6"][apress_heading sub_title="" data_animation="fadeInDown" data_delay="300" enable_delimiter="" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div"]AS SEEN ON[/apress_heading][/vc_column_inner][vc_column_inner width="1/6"][vc_single_image image="13" img_size="full" alignment="center" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner width="1/6"][vc_single_image image="14" img_size="full" alignment="center" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner width="1/6"][vc_single_image image="15" img_size="full" alignment="center" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner width="1/6"][vc_single_image image="16" img_size="full" alignment="center" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner width="1/6"][vc_single_image image="32" img_size="full" alignment="center" css_animation="fadeInUp"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1504198445055{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column width="1/2"][vc_single_image image="20" img_size="full" alignment="center" style="vc_box_shadow" css_animation="fadeInLeft"][/vc_column][vc_column width="1/2"][apress_heading sub_title="ABOUT ME" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" title_google_fonts="yes" style="heading_style2" title_font_options="tag:h2" subtitle_font_options="tag:div" title_custom_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"]Small Introduction[/apress_heading][vc_column_text css_animation="fadeIn"]Suspendisse quis lobortis diam. Aenean sagittis arcu ut neque ornare, ac porta augue commodo. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Proin malesuada enim ut turpis pulvinar consequat. Quisque dignissim metus ligula. Nam molestie eleifend feugiat.[/vc_column_text][ult_animation_block animation="fadeInLeft" animation_duration="3" animation_delay="0" animation_iteration_count="1"][info_list style="circle with_bg" icon_bg_color="#4cd964" icon_color="#ffffff" font_size_icon="24" connector_color="#4cd964"][info_list_item list_title="Holistic Coach" list_icon="Defaults-check" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;"]Aenean sagittis arcu ut neque ornare, ac porta augue commodo.[/info_list_item][info_list_item list_title="Stay at home " list_icon="Defaults-check" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;"]Aenean sagittis arcu ut neque ornare, ac porta augue commodo.[/info_list_item][info_list_item list_title="Female Entrepreneur" list_icon="Defaults-check" desc_font_size="desktop:16px;" desc_font_line_height="desktop:26px;"]Aenean sagittis arcu ut neque ornare, ac porta augue commodo.[/info_list_item][/info_list][/ult_animation_block][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;
		
	//Black Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 77', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about77.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1504535541500{padding-bottom: 100px !important;}"][vc_column width="1/2"][apress_heading sub_title="SMALL INTRO" enable_delimiter="" style="heading_style2" title_font_options="tag:h1|font_size:60|line_height:70|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:50"]ABOUT US[/apress_heading][vc_column_text]Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.

Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/vc_column_text][/vc_column][vc_column width="1/2"][info_circle edge_radius="80" start_degree="90" eg_padding="60" icon_size="100" img_icon_size="35" icon_show="not-show" eg_br_style="dashed" eg_br_width="1" eg_border_color="#a1b400" icon_launch="linear" icon_launch_duration="1" icon_launch_delay="0.2" responsive_breakpoint="800"][info_circle_item info_title="Search Optiomization" icon_type="custom" info_img="id^72|url^http://apresswp.com/demo14/wp-content/uploads/2017/09/search-optiomization.png|caption^null|alt^null|title^search-optiomization|description^null"]Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/info_circle_item][info_circle_item info_title="Link Management" icon_type="custom" info_img="id^75|url^http://apresswp.com/demo14/wp-content/uploads/2017/09/link.png|caption^null|alt^null|title^link|description^null"]Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/info_circle_item][info_circle_item info_title="Content Optimization" icon_type="custom" info_img="id^77|url^http://apresswp.com/demo14/wp-content/uploads/2017/09/content.png|caption^null|alt^null|title^content|description^null"]Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/info_circle_item][info_circle_item info_title="Page Rank Optimization" icon_type="custom" info_img="id^73|url^http://apresswp.com/demo14/wp-content/uploads/2017/09/page-rank.png|caption^null|alt^null|title^page-rank|description^null"]Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/info_circle_item][info_circle_item info_title="Location Targeting" icon_type="custom" info_img="id^74|url^http://apresswp.com/demo14/wp-content/uploads/2017/09/location-targeting.png|caption^null|alt^null|title^location-targeting|description^null"]Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/info_circle_item][info_circle_item info_title="Conversion Management" icon_type="custom" info_img="id^76|url^http://apresswp.com/demo14/wp-content/uploads/2017/09/conversion-management.png|caption^null|alt^null|title^conversion-management|description^null"]Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/info_circle_item][/info_circle][/vc_column][/vc_row]

CONTENT;

$templates[] = $data;
		
	//Black Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 78', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about78.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" gap="30" full_height="yes" equal_height="yes" content_placement="middle" css=".vc_custom_1504552290234{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column width="1/2" css=".vc_custom_1504552213857{padding-left: 10% !important;}"][apress_heading sub_title="" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" style="heading_style1" title_font_options="tag:h2|font_size:65|line_height:80" subtitle_font_options="tag:div" heading_margin="margin-bottom:50"]Why Choose APRESS Theme[/apress_heading][vc_column_text css_animation="fadeInUp"]Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum.

In nec arcu ac sem tristique iaculis. Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis.[/vc_column_text][apress_button button_text="Read More" button_shape="round" button_size="design_your_own" padding_right_left="50" data_animation="fadeInDown" button_font_options="font_size:18|line_height:30|letter_spacing:1"][apress_button button_text="Buy Now" color_scheme="design_your_own" button_bg_color="rgba(82,149,234,0.01)" button_bg_color_h="#8e54e9" button_text_color="#8e54e9" button_border_color="#8e54e9" button_border_color_h="#8e54e9" button_shape="round" button_size="design_your_own" padding_right_left="50" data_animation="fadeInDown" button_font_options="font_size:18|line_height:30|letter_spacing:1"][/vc_column][vc_column width="1/2"][vc_single_image image="12" img_size="900x634" alignment="center" style="vc_box_shadow" onclick="link_image" css_animation="fadeInRight"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;
		
	//Black Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'About 79', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/about79.jpg' );
	$data['sort_name'] = 'About';
	$data['custom_class'] = 'general about';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" css=".vc_custom_1504610832260{margin-top: 20px !important;margin-bottom: 20px !important;}"][vc_column width="1/2" css=".vc_custom_1504610346089{padding-right: 5% !important;padding-left: 5% !important;}"][ultimate_spacer height="" height_on_mob_landscape="50" height_on_mob="50"][apress_heading sub_title="" enable_delimiter="" style="heading_style1" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:50"]Passion &amp; Dedication To Redefine Industry[/apress_heading][vc_column_text css_animation="fadeInUp" css=".vc_custom_1504607138919{padding-right: 5% !important;padding-left: 5% !important;}"]Nullam eu arcu eget nisl tempus pellentesque. Donec pellentesque nulla vel est posuere semper. Praesent non ipsum eleifend, consectetur nisi commodo, blandit magna. Aenean nec accumsan est. Sed porttitor porttitor felis ut interdum. Nam eget nisl ligula. Integer eget congue diam.

Nullam eu arcu eget nisl tempus pellentesque. Donec pellentesque nulla vel est posuere semper. Praesent non ipsum eleifend, consectetur nisi commodo, blandit magna. Aenean nec accumsan est. Sed porttitor porttitor felis ut interdum. Nam eget nisl ligula. Integer eget congue diam.[/vc_column_text][/vc_column][vc_column video_bg="yes" video_bg_url="https://www.youtube.com/watch?v=qpY-iL5KD6s" video_bg_parallax="content-moving" width="1/2" css=".vc_custom_1504609386545{padding-right: 5% !important;padding-left: 5% !important;background-color: rgba(51,51,51,0.45) !important;*background-color: rgb(51,51,51) !important;}"][vc_row_inner css=".vc_custom_1504607647843{padding-top: 200px !important;padding-bottom: 200px !important;}"][vc_column_inner width="1/2"][apress_gradient_icon_box description="Liam eu arcu eget nisl tempus pellentesque. Donec pellentesque nulla vel est posuere semper. Praesent non ipsum eleifend, consectetur nisi commodo, blandit magna. " color_scheme="color_scheme1" icon_family="linecons" style="iconbox_style1" title_font_options="tag:h2|color:%23ffffff" description_font_options="color:%23ffffff"]Title[/apress_gradient_icon_box][vc_empty_space][apress_gradient_icon_box description="Liam eu arcu eget nisl tempus pellentesque. Donec pellentesque nulla vel est posuere semper. Praesent non ipsum eleifend, consectetur nisi commodo, blandit magna. " color_scheme="color_scheme1" icon_family="linecons" style="iconbox_style1" title_font_options="tag:h2|color:%23ffffff" description_font_options="color:%23ffffff"]Title[/apress_gradient_icon_box][/vc_column_inner][vc_column_inner width="1/2"][apress_gradient_icon_box description="Liam eu arcu eget nisl tempus pellentesque. Donec pellentesque nulla vel est posuere semper. Praesent non ipsum eleifend, consectetur nisi commodo, blandit magna. " color_scheme="color_scheme1" icon_family="linecons" style="iconbox_style1" title_font_options="tag:h2|color:%23ffffff" description_font_options="color:%23ffffff"]Title[/apress_gradient_icon_box][vc_empty_space][apress_gradient_icon_box description="Liam eu arcu eget nisl tempus pellentesque. Donec pellentesque nulla vel est posuere semper. Praesent non ipsum eleifend, consectetur nisi commodo, blandit magna. " color_scheme="color_scheme1" icon_family="linecons" style="iconbox_style1" title_font_options="tag:h2|color:%23ffffff" description_font_options="color:%23ffffff"]Title[/apress_gradient_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

	$templates[] = $data;

	//Business Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 1', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog1.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1501867536980{padding-top: 50px !important;padding-bottom: 100px !important;}"][vc_column][vc_row_inner][vc_column_inner css=".vc_custom_1501869410892{padding-right: 5% !important;padding-left: 5% !important;}"][apress_heading sub_title="Suspendisse potenti. Donec vestibulum commodo gravida. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam congue nibh porta augue scelerisque bibendum facilisis sed libero." enable_delimiter="" title_google_fonts="yes" style="heading_style1" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div" heading_margin="margin-bottom:30" subheading_margin="margin-bottom:30"]Our Recent News[/apress_heading][/vc_column_inner][/vc_row_inner][ultimate_spacer height="70" height_on_tabs="50" height_on_tabs_portrait="50" height_on_mob_landscape="50" height_on_mob="50"][vc_row_inner][vc_column_inner][apress_blog_styles style="style10" category="all" num="3" blgcrslcolprw="Three" posttitlealignment="left" blgcrslcolpad="15,15,15,15" excerptlength="25" categoryfontcolor="#ffffff" categoryfontcolorhover="#8659d6" categorybackgroundcolor="#8659d6" categorybordercolor="#8659d6" categorybordercolorhover="#8659d6" postmetacolorhover="#8659d6" postdesign2="box" boxbackgroundcolor2="#ffffff" boxbordercolor2="#dddddd"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 2', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog2.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1504088943013{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column][apress_text_separator title="RECENT NEWS" title_align="separator_align_left" align="align_left" el_width="40" contentboxanimation="fadeIn" contentboxdelay="300" color="#dd9933" title_font_options="tag:h2|color:%23dd9933"][apress_blog_styles style="style9" category="all" blgcrslcolprw="Four" posttitleposition="below" excerptlength="20" categoryfontcolor="#ffffff" categoryfontcolorhover="#dd9933" categorybackgroundcolor="#dd9933" categorybordercolor="#dd9933" categorybordercolorhover="#dd9933" buttonfontcolor="#dd9933" buttonfontcolorhover="#ffffff" buttonbackgroundcolorhover="#dd9933" buttonbordercolor="#dd9933" buttonbordercolorhover="#dd9933" socialsharingshowhide="hide" postmetashowhide="hide" postdesign="box_withoutpadding" boxbackgroundcolor="#ffffff" boxbordercolor="#dddddd"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 3', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog3.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1481530322016{padding-right: 0px !important;padding-left: 0px !important;}"][vc_column][apress_post_slider blogpostsliderstyle="postsliderstyle3" category="all" num="6" postsliderheight="600" postslidercaptionbg="74" slidercaptiontextalgin="center" blgcrsltitlecolor="#333333" slidercategorydesign="box" categorybackgroundcolor="#21b384" categorybackgroundcolorhover="#21b384" categorybordercolor="#21b384" categorybordercolorhover="#21b384" postmetacolorhover="#21b384"][ultimate_spacer height="50"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 4', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog4.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row gap="35" css=".vc_custom_1480577665774{padding-top: 40px !important;}"][vc_column width="2/3" el_class="sidebar custom_sidebar"][apress_blog_styles style="style_large" category="all" posttitleposition="below" posttitlealignment="center" blgcrsltitlecolor="rgba(0,0,0,0.62)" categoryposition="below" categoryfontcolor="#ffffff" categoryfontcolorhover="#21b384" categorybackgroundcolor="#21b384" categorybordercolor="#21b384" categorybordercolorhover="#21b384" buttonfontcolor="#ffffff" buttonfontcolorhover="#21b384" buttonbackgroundcolor="#21b384" buttonbordercolor="#21b384" buttonbordercolorhover="#21b384" socialiconcolor="#21b384" socialiconcolorhover="#ffffff" socialiconbackgroundcolorhover="#21b384" socialiconbordercolor="#21b384" socialiconbordercolorhover="#21b384" postmetacolorhover="#21b384" blog_navigation="default" data_animation="fadeIn" data_delay="300"][/vc_column][vc_column width="1/3" css=".vc_custom_1481869428891{padding-top: 0px !important;}" el_class="sidebar custom_sidebar"][vc_widget_sidebar sidebar_id="sidebar" el_class="sidebar"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 5', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog5.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][apress_post_slider category="all" postsliderheight="600" blgcrsltitlesize="24" slidercaptiontextalgin="center" blgcrsltitlecolor="#ffffff" slidercategorydesign="box" categorybackgroundcolor="rgba(84,159,252,0)" categorybackgroundcolorhover="rgba(84,159,252,0)" categorybordercolor="#ffffff" categorybordercolorhover="#ffffff" postmetashowhide="hide"][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 6', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog6.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][apress_blog_styles style="style9" category="all" layoutstyle="masonry" num="9" blgcrslcolprw="Three" posttitleposition="below" categoryposition="below" continuereadingshowhide="hide" socialsharingshowhide="hide" postmetashowhide="hide" postdesign="box_withoutpadding" boxbackgroundcolor="#ffffff" boxbordercolor="#eeeeee" blog_navigation="classic_nav" nav_color="#333333" nav_hover_bg="#333333" data_animation="fadeIn" data_delay="300"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 7', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog7.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gap="35"][vc_column width="2/3" el_class="sidebar custom_sidebar"][apress_blog_styles style="style12" category="all" num="8" boxbackgroundcolor3="#ffffff" boxbordercolor3="#eeeeee" blgcrsltitlesize="20" categoryfontcolor="#ffffff" categoryfontcolorhover="#ffffff" categorybackgroundcolor="#f82eb3" categorybackgroundcolorhover="#f82eb3" categorybordercolor="#f82eb3" categorybordercolorhover="#f82eb3" buttonfontcolorhover="#ffffff" buttonbackgroundcolorhover="#f82eb3" buttonbordercolor="#dddddd" buttonbordercolorhover="#f82eb3" postmetacolorhover2="#f82eb3" blog_navigation="classic_nav" nav_color="#4c4c4c" nav_bg="#ffffff" nav_border="#f82eb3" nav_hover_bg="#f82eb3" blgcrslcolprw2="Two"][/vc_column][vc_column width="1/3" el_class="sidebar custom_sidebar" css=".vc_custom_1482589259419{padding-top: 30px !important;}"][vc_widget_sidebar sidebar_id="sidebar" el_class="sidebar custom_sidebar"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 8', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog8.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content"][vc_column][apress_post_slider blogpostsliderstyle="postsliderstyle2" category="all" postsliderheight="500" postslidercaptionheight="200" postslidercaptionwidth="450" postslidercaptionbg="21" slidercaptiontextalgin="center" blgcrsltitlecolor="#333333" slidercategorydesign="box" categorybackgroundcolor="#333333" categorybackgroundcolorhover="#333333" categorybordercolor="#333333" categorybordercolorhover="#333333" data_delay="300"][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 9', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog9.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][apress_post_slider category="all" postsliderheight="600" postslidercaptionheight="250" postslidercaptionwidth="400" postslidercaptionbg="26" blgcrsltitlesize="24" slidercaptiontextalgin="center" blgcrsltitlecolor="#333333" slidercategorydesign="box" categorybackgroundcolor="#333333" categorybackgroundcolorhover="#333333" categorybordercolor="#333333" categorybordercolorhover="#333333" blgmodernmetacolor="#333333"][ultimate_spacer height="100"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ult_content_box border="border-style:solid;|border-width:1px;|border-color:#efefef;" box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:inherit|" padding="padding:20px;" hover_box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:inherit|" bg_color="#ffffff"][ultimate_heading main_heading="ABOUT ME" main_heading_margin="margin-bottom:10px;" sub_heading_margin="margin-bottom:20px;"]A SHORT BIO[/ultimate_heading][ultimate_spacer height="10"][vc_single_image image="57" img_size="200x 200" alignment="center"][/ult_content_box][ultimate_spacer height="10"][/vc_column][vc_column width="1/3"][ult_content_box border="border-style:solid;|border-width:1px;|border-color:#efefef;" box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:inherit|" padding="padding:20px;" hover_box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:inherit|" bg_color="#ffffff"][ultimate_heading main_heading="CONTACT ME" main_heading_margin="margin-bottom:10px;" sub_heading_margin="margin-bottom:20px;"]SEND QUICK CONTACT[/ultimate_heading][ultimate_spacer height="10"][vc_single_image image="58" img_size="200x 200" alignment="center"][/ult_content_box][ultimate_spacer height="10"][/vc_column][vc_column width="1/3"][ult_content_box border="border-style:solid;|border-width:1px;|border-color:#efefef;" box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:inherit|" padding="padding:20px;" hover_box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:inherit|" bg_color="#ffffff"][ultimate_heading main_heading="INSTAGRAM" main_heading_margin="margin-bottom:10px;" sub_heading_margin="margin-bottom:20px;"]FOLLOW ME ON INSTAGRAM[/ultimate_heading][ultimate_spacer height="10"][vc_single_image image="56" img_size="200x 200" alignment="center"][/ult_content_box][ultimate_spacer height="10"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 10', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog10.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row"][vc_column][apress_blog_styles style="style10" category="all" num="12" blgcrslcolpad="0,0,0,0" excerptlength="25" categoryfontcolor="#ffffff" categoryfontcolorhover="#ffffff" categorybackgroundcolor="#21b384" categorybackgroundcolorhover="#21b384" categorybordercolor="#21b384" categorybordercolorhover="#21b384" postmetacolor="" postmetacolorhover="#21b384" postcontentcolor="" postdesign2="box_withseparator" boxbackgroundcolor2="#ffffff" boxbordercolor2="#dddddd" postmetabordercolor="#dddddd" data_animation="fadeIn" data_delay="100" blgcrsltitlesize6="30"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 11', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog11.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content"][vc_column][apress_post_slider blogpostsliderstyle="postsliderstyle4" category="all" num="3" postsliderheight="500" postslidercaptionheight="100" postslidercaptionwidth="450" postslidercaptionpad="25,25,25,25" postslidercaptionbg="147" slidercaptiontextalgin="center" blgcrsltitlecolor="#4c4c4c" slidercategorydesign="box" categorybackgroundcolor="#ff6464" categorybackgroundcolorhover="#ff6464" categorybordercolor="#ff6464" categorybordercolorhover="#ff6464" continuereadingshowhide="show" buttonfontcolor="#ffffff" buttonfontcolorhover="#ffffff" buttonbackgroundcolor="#e55b01" buttonbackgroundcolorhover="#e55b01" buttonbordercolor="#e55b01" buttonbordercolorhover="#e55b01" postmetashowhide="hide" postcontentcolor=""][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 12', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog12.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][apress_blog_styles style="style13" category="all" layoutstyle="masonry" num="8" blgcrslcolprw="Two" boxbackgroundcolor3="#ffffff" boxbordercolor3="#dddddd" blgcrslcolpad="30,30,30,30" blgcrsltitlesize="20" category_topmargin="-64" categoryfontcolor="#ffffff" categoryfontcolorhover="#ffffff" categorybackgroundcolor="#ff6464" categorybackgroundcolorhover="#ff6464" categorybordercolor="#ff6464" categorybordercolorhover="#ff6464" buttonfontcolor="#333333" buttonfontcolorhover="#ffffff" buttonbackgroundcolorhover="#ff6464" buttonbordercolor="#dddddd" buttonbordercolorhover="#ff6464" postmetacolorhover="#ff6464" postmetabordercolor2="#f7f7f7" postcontentcolor="" blog_navigation="classic_nav" nav_color="#4c4c4c" nav_bg="#ffffff" nav_border="#ff6464" nav_hover_bg="#ff6464" blgcrslcolprw2="Two"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 13', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog13.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1481578951470{padding-left: 20px !important;}"][vc_column width="2/3"][ultimate_spacer height="100"][ultimate_heading main_heading="Life's A Story" alignment="left" main_heading_font_size="desktop:35px;" main_heading_line_height="desktop:70px;" main_heading_margin="margin-bottom:12px;" sub_heading_font_size="desktop:16px;" sub_heading_line_height="desktop:30px;" sub_heading_margin="margin-bottom:20px;" main_heading_style="font-weight:bold;"]Phasellus in nibh eu nisl hendrerit malesuada. Aenean pretium volutpat nisi et facilisis. Vivamus tristique nunc lorem, sit amet venenatis orci fermentum quis. In nisl sem, varius elementum nisl nec.[/ultimate_heading][/vc_column][vc_column width="1/3"][/vc_column][/vc_row][vc_row full_width="stretch_row"][vc_column][apress_blog_styles layoutstyle="masonry" num="8" blgcrslcolprw="Two" blgcrslcolbg="#ffffff" blgcrslcolpad="15,15,0,15" blgcrsltitlesize="20" blgcrslbuttonbg="#333333" blgcrslbuttonhovbg="#333333" blog_navigation="loadmore_nav" button_bg="#ffffff" button_title="#333333" button_border="#333333" button_hover_title="#ffffff" button_hover_bg="#333333" data_animation="fadeIn" data_delay="300" blgcrslcolprw2="Two"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 14', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog14.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content"][vc_column][apress_blog_styles style="style15" category="all" num="8" boxbackgroundcolor3="#ffffff" boxbordercolor3="#dddddd" blgcrslcolpad="0,0,0,0" blgcrsltitlesize="20" excerptlength="15" categoryfontcolor="#ffffff" categoryfontcolorhover="#ffffff" categorybackgroundcolor="#e55b01" categorybackgroundcolorhover="#e55b01" categorybordercolor="#e55b01" categorybordercolorhover="#e55b01" continuereadingmodify="READ MORE" buttonfontcolorhover="#ffffff" buttonbackgroundcolorhover="#e55b01" buttonbordercolor="#dddddd" buttonbordercolorhover="#e55b01" postmetashowhide="hide" blog_navigation="classic_nav" nav_color="#4c4c4c" nav_bg="#ffffff" nav_border="#e55b01" nav_hover_bg="#e55b01" blgcrslcolprw2="Two"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 15', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog15.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row"][vc_column][apress_post_slider blogpostsliderstyle="postsliderstyle5" category="all" num="3" postslidercaptionwidth="450" postslidercaptionbg="207" blgcrsltitlesize="30" blgcrsltitlecolor="#333333" excerptlength="20" slidercategorydesign="box" categorybackgroundcolor="#333333" categorybackgroundcolorhover="#333333" categorybordercolor="#333333" categorybordercolorhover="#333333" continuereadingshowhide="show" buttonfontcolor="#333333" buttonfontcolorhover="#ffffff" buttonbackgroundcolor="rgba(229,91,1,0.01)" buttonbackgroundcolorhover="#333333" buttonbordercolor="#333333" buttonbordercolorhover="#333333" postmetashowhide="hide"][ultimate_spacer height="20"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 16', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog16.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row"][vc_column][apress_blog_styles style="style13" category="all" layoutstyle="masonry" num="8" blgcrslcolprw="Two" boxbackgroundcolor3="#ffffff" boxbordercolor3="#dddddd" blgcrslcolpad="30,30,30,30" blgcrsltitlesize="30" category_topmargin="-15" categoryfontcolor="#ffffff" categoryfontcolorhover="#ffffff" categorybackgroundcolor="#333333" categorybackgroundcolorhover="#333333" categorybordercolor="#333333" categorybordercolorhover="#333333" buttonfontcolor="#333333" buttonfontcolorhover="#ffffff" buttonbackgroundcolorhover="#333333" buttonbordercolor="#333333" buttonbordercolorhover="#333333" postmetacolor="#747474" postmetacolorhover="#333333" postmetabordercolor2="#eeeeee" blog_navigation="classic_nav" nav_color="#4c4c4c" nav_bg="#ffffff" nav_border="#333333" nav_hover_bg="#333333" data_animation="fadeIn" data_delay="100" blgcrslcolprw2="Two"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 17', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog17.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1481197680114{background-color: #282a2b !important;}"][vc_column css=".vc_custom_1481190576949{padding-top: 0px !important;}"][apress_blog_styles style="style4" category="all" layoutstyle="masonry" num="8" blgcrslcolprw="Two" blog_navigation="loadmore_nav" button_bg="rgba(255,255,255,0)" button_title="#ffffff" button_border="rgba(255,255,255,0.51)" button_hover_title="rgba(255,255,255,0.52)" button_hover_bg="rgba(0,0,0,0.43)" data_delay="300" blgcrslhoveropac="0.5" blgcrslcolprw2="Two"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 18', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog18.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row][vc_column css=".vc_custom_1482304921660{background-color: #ffffff !important;}"][apress_blog_styles style="style11" num="16" blgcrslcolpad="10,10,10,10" blgcrsltitlesize="50" categoryfontcolor="#ffffff" categoryfontcolorhover="#ffffff" categorybackgroundcolor="#e55b01" categorybackgroundcolorhover="#e55b01" categorybordercolor="#e55b01" categorybordercolorhover="#e55b01" postmetacolorhover="#e55b01" postdesign2="box_withseparator" boxbackgroundcolor2="#ffffff" boxbordercolor2="rgba(255,255,255,0.01)" postmetabordercolor="#f2f2f2" data_animation="fadeIn" data_delay="300" blgcrsltitlesize6="50"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 19', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog19.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][apress_blog_styles style="style14" num="6" postcaptionwidth="1200" posttitlealignment="center" blgcrsltitlesize="40" blgcrsltitlecolor="#ffffff" excerptlength="0" categoryfontcolor="#ffffff" categoryfontcolorhover="#ffffff" categorybackgroundcolor="#e55b01" categorybackgroundcolorhover="#e55b01" categorybordercolor="#e55b01" categorybordercolorhover="#e55b01" continuereadingshowhide="hide" postmetacolor="#ffffff" postmetacolorhover="#ffffff" blgcrslhoveropac="0.3" posttoppadding="200" postbottompadding="200" blog_navigation="classic_nav" nav_color="#4c4c4c" nav_bg="#ffffff" nav_border="#e55b01" nav_hover_bg="#e55b01" blgcrslcolprw2="Two"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog 20', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/blog20.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][apress_blog_styles style="style14" category="all" num="5" posttitlealignment="center" blgcrsltitlesize="40" blgcrsltitlecolor="#ffffff" excerptlength="0" categoryfontcolor="#333333" categoryfontcolorhover="#333333" categorybordercolor="#ffffff" categorybordercolorhover="#ffffff" continuereadingshowhide="hide" postmetashowhide="hide" color_scheme="design_your_own" blgcrslimgoverlay="rgba(0,0,0,0.1)" blgcrslhovercolor="rgba(0,0,0,0.55)" fullheightpost="1" blog_navigation="default" data_animation="fadeIn" data_delay="300" blgstyleoverlayopac="0.3" blgcrslhoveropac="0.4"][/vc_column][/vc_row]
CONTENT;
	
	$templates[] = $data;
	//Hero Section vc-template
	$data = array();
	$data['name'] = esc_html__( 'Hero Section 1', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/hero-sections1.jpg' );
	$data['sort_name'] = 'Hero Sections';
	$data['custom_class'] = 'general hero-sections';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" content_placement="middle" css=".vc_custom_1505541257774{border-bottom-width: 1px !important;padding-top: 50px !important;border-bottom-color: #f4f4f4 !important;border-bottom-style: solid !important;}"][vc_column width="1/2"][apress_heading sub_title="Suspendisse potenti. Donec vestibulum commodo gravida. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam congue nibh porta augue scelerisque bibendum facilisis sed libero." content_alignment="left" enable_delimiter="" title_google_fonts="yes" style="heading_style1" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div" heading_margin="margin-bottom:30" subheading_margin="margin-bottom:30"]Building Simple Solutions For The Complex World.[/apress_heading][apress_button button_text="Download Now" color_scheme="primary_color_scheme" button_size="design_your_own" padding_top_bottom="20" padding_right_left="35" button_font_options="font_size:20|line_height:30|letter_spacing:1"][apress_button button_text="Learn More" color_scheme="design_your_own" button_bg_color="rgba(82,149,234,0.01)" button_bg_color_h="#8659d6" button_text_color="#8659d6" button_border_color="#8659d6" button_border_color_h="#8659d6" button_size="design_your_own" padding_top_bottom="19" padding_right_left="35" button_font_options="font_size:20|line_height:30|letter_spacing:1"][ultimate_spacer height="50"][/vc_column][vc_column width="1/2"][vc_single_image image="41" img_size="full" alignment="center" css=".vc_custom_1501858576075{margin-bottom: 0px !important;padding-bottom: 0px !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Hero Section vc-template
	$data = array();
	$data['name'] = esc_html__( 'Hero Section 2', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/hero-sections2.jpg' );
	$data['sort_name'] = 'Hero Sections';
	$data['custom_class'] = 'general hero-sections';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1501897932386{border-bottom-width: 1px !important;padding-top: 45px !important;padding-bottom: 65px !important;border-bottom-color: #efefef !important;border-bottom-style: solid !important;}"][vc_column centered_text="true" css=".vc_custom_1505542977097{padding-right: 10% !important;padding-left: 10% !important;}"][apress_heading sub_title="" data_animation="fadeInUp" data_delay="300" enable_delimiter="" title_google_fonts="yes" style="heading_style1" heading_margin="margin-bottom:30" subheading_margin="margin-bottom:30" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div" title_responsive="font_size_tablet:35|line_height_tablet:40|letter_spacing_tablet:1|font_size_mobile:25|line_height_mobile:30|letter_spacing_mobile:1"]Welcome To APRESS Theme Demo[/apress_heading][vc_row_inner][vc_column_inner width="1/3"][/vc_column_inner][vc_column_inner width="1/3"][apress_button button_text="Download Now" button_shape="round" button_size="design_your_own" data_animation="fadeInLeft" data_delay="600" button_font_options="font_size:16|line_height:26|letter_spacing:1"][apress_button button_text="Learn More" color_scheme="design_your_own" button_bg_color="rgba(82,149,234,0.01)" button_bg_color_h="#8e54e9" button_text_color="#8e54e9" button_border_color="#8e54e9" button_border_color_h="#8e54e9" button_shape="round" button_size="design_your_own" padding_top_bottom="14" data_animation="fadeInRight" data_delay="700" button_font_options="font_size:16|line_height:26|letter_spacing:1"][/vc_column_inner][vc_column_inner width="1/3"][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][vc_single_image image="484" img_size="full" alignment="center" css_animation="slideInUp"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Hero Section vc-template
	$data = array();
	$data['name'] = esc_html__( 'Hero Section 3', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/hero-sections3.jpg' );
	$data['sort_name'] = 'Hero Sections';
	$data['custom_class'] = 'general hero-sections';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" equal_height="yes" content_placement="middle" bg_type="image" parallax_style="vcpb-default" bg_image_new="id^1088|url^http://apresswp.com/demo1/wp-content/uploads/2016/09/business_1.jpg|caption^null|alt^null|title^business_1|description^null" bg_image_repeat="no-repeat" bg_override="full" css=".vc_custom_1501949660299{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/4"][/vc_column][vc_column centered_text="true" width="1/2" el_class="aligncenter"][apress_heading sub_title="Integer et gravida ante. Duis efficitur, nibh non porttitor mattis, elit nulla facilisis lorem, sed luctus ligula purus in elit. Integer et gravida ante. Duis efficitur, nibh non porttitor mattis, elit nulla facilisis lorem, sed luctus ligula purus in elit." data_animation="fadeInUp" data_delay="300" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" title_google_fonts="yes" style="heading_style1" heading_margin="margin-bottom:30" subheading_margin="margin-bottom:30" title_font_options="tag:h2|font_size:65|line_height:70|letter_spacing:1" subtitle_font_options="tag:p|color:%23ffffff" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" title_responsive="font_size_tablet:45|line_height_tablet:50|letter_spacing_tablet:1|font_size_mobile:35|line_height_mobile:40|letter_spacing_mobile:1"]Streamlining Your Work Flow[/apress_heading][apress_button button_text="Download Now" color_scheme="design_your_own" button_bg_color="#8b79db" button_bg_color_h="#8b79db" button_border_color="#8b79db" button_border_color_h="#8b79db" button_size="large" data_animation="fadeIn"][apress_button button_text="Learn More" color_scheme="design_your_own" button_bg_color="rgba(139,121,219,0.01)" button_bg_color_h="#8b79db" button_border_color="#ffffff" button_border_color_h="#8b79db" button_size="large" data_animation="fadeIn" data_delay="600"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Hero Section vc-template
	$data = array();
	$data['name'] = esc_html__( 'Hero Section 4', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/hero-sections4.jpg' );
	$data['sort_name'] = 'Hero Sections';
	$data['custom_class'] = 'general hero-sections';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" bg_type="image" parallax_style="vcpb-default" bg_image_new="id^500|url^http://apresswp.com/demo1/wp-content/uploads/2016/09/slider-agency.jpg|caption^null|alt^null|title^slider-agency|description^null" bg_override="ex-full" css=".vc_custom_1507360855757{padding-top: 250px !important;padding-bottom: 200px !important;}"][vc_column][ultimate_fancytext fancytext_prefix="WE ARE " strings_textspeed="35" strings_backspeed="0" sufpref_color="#ffffff" fancytext_strings="MINIMAL
CREATIVE
AGENCY" strings_font_size="desktop:80px;tablet:60px;tablet_portrait:30px;mobile_landscape:25px;mobile:25px;" strings_line_height="desktop:150px;tablet:100px;tablet_portrait:60px;mobile_landscape:50px;mobile:50px;" fancytext_color="#6348db" prefix_suffix_font_size="desktop:80px;tablet:60px;tablet_portrait:30px;mobile_landscape:25px;mobile:25px;" prefix_suffix_line_height="desktop:150px;tablet:100px;tablet_portrait:60px;mobile_landscape:50px;mobile:50px;" typewriter_cursor_color="#6348db"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Hero Section vc-template
	$data = array();
	$data['name'] = esc_html__( 'Hero Section 5', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/hero-sections5.jpg' );
	$data['sort_name'] = 'Hero Sections';
	$data['custom_class'] = 'general hero-sections';
	$data['content'] = <<<CONTENT
[vc_row content_placement="top" bg_type="image" parallax_style="vcpb-default" bg_image_new="id^507|url^http://apresswp.com/demo1/wp-content/uploads/2016/09/slider3.jpg|caption^null|alt^null|title^slider3|description^null" bg_override="ex-full" css=".vc_custom_1474442108546{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column][ultimate_spacer height="100" height_on_tabs="100" height_on_tabs_portrait="100" height_on_mob_landscape="50" height_on_mob="50"][ultimate_heading main_heading="DESIGN &amp; IMPRESS" main_heading_color="#ffffff" sub_heading_color="#ffffff" main_heading_font_size="desktop:60px;tablet:30px;tablet_portrait:30px;mobile_landscape:25px;mobile:25px;" main_heading_line_height="desktop:90px;tablet:45px;tablet_portrait:45px;mobile_landscape:40px;mobile:40px;" main_heading_style="font-weight:bold;" sub_heading_font_size="desktop:18px;" sub_heading_line_height="desktop:30px;"]APRESS Theme has everything to make a amazing website and Woo clients.[/ultimate_heading][ultimate_spacer height="100" height_on_tabs="100" height_on_tabs_portrait="100" height_on_mob_landscape="50" height_on_mob="50"][vc_row_inner][vc_column_inner width="1/4"][apress_icon_box box_style="box_style_square" box_hover_style="box-fade" box_bg="" box_border="rgba(0,0,0,0.01)" box_hover_bg="#8e54e9" box_hover_border="#8e54e9" iconcolor="#ffffff" icon_hover_color="#ffffff" icon_size="50" iconposition2="center" contentboxtitle_size="20" boxtitlepad="padding-top:0|padding-bottom:5" title_desc_color="#ffffff" icon_family="openiconic" icon_openiconic="vc-oi vc-oi-layers" contentboxtitle="Drag n Drop" contentboxarea="Suspendisse placerat sapien in ullamcorper porttitor. Integer eget blandit nunc." contentboxanimation="fadeIn" contentboxdelay="200" icon="wb-layers"][/vc_column_inner][vc_column_inner width="1/4"][apress_icon_box box_style="box_style_square" box_hover_style="box-fade" box_bg="" box_border="rgba(0,0,0,0.01)" box_hover_bg="#8e54e9" box_hover_border="#8e54e9" iconcolor="#ffffff" icon_hover_color="rgba(255,255,255,0.5)" icon_size="50" iconposition2="center" contentboxtitle_size="20" boxtitlepad="padding-bottom:5" title_desc_color="#ffffff" icon_family="fontawesome" icon_fontawesome="fa fa-shopping-cart" contentboxtitle="WooCommerce Ready" contentboxarea="Suspendisse placerat sapien in ullamcorper porttitor. Integer eget blandit nunc." contentboxanimation="fadeIn" contentboxdelay="400" icon="fa-shopping-cart"][/vc_column_inner][vc_column_inner width="1/4"][apress_icon_box box_style="box_style_square" box_hover_style="box-fade" box_bg="" box_border="rgba(144,200,71,0.01)" box_hover_bg="#8e54e9" box_hover_border="#8e54e9" iconcolor="#ffffff" icon_hover_color="rgba(255,255,255,0.5)" icon_size="50" iconposition2="center" contentboxtitle_size="20" boxtitlepad="padding-bottom:5" title_desc_color="#ffffff" icon_family="fontawesome" icon_fontawesome="fa fa-cloud-download" contentboxtitle="LIfetime Updates" contentboxarea="Suspendisse placerat sapien in ullamcorper porttitor. Integer eget blandit nunc." contentboxanimation="fadeIn" contentboxdelay="600" icon="mfg-download-cloud"][/vc_column_inner][vc_column_inner width="1/4"][apress_icon_box box_style="box_style_square" box_hover_style="box-fade" box_bg="" box_border="rgba(144,200,71,0.01)" box_hover_bg="#8e54e9" box_hover_border="#8e54e9" iconcolor="#ffffff" icon_hover_color="rgba(255,255,255,0.5)" icon_size="50" iconposition2="center" contentboxtitle_size="20" boxtitlepad="padding-bottom:5" title_desc_color="#ffffff" icon_family="fontawesome" icon_fontawesome="fa fa-life-ring" contentboxtitle="Instant Support" contentboxarea="Suspendisse placerat sapien in ullamcorper porttitor. Integer eget blandit nunc." contentboxanimation="fadeIn" contentboxdelay="800" icon="imf-support"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Hero Section vc-template
	$data = array();
	$data['name'] = esc_html__( 'Hero Section 6', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/hero-sections6.jpg' );
	$data['sort_name'] = 'Hero Sections';
	$data['custom_class'] = 'general hero-sections';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1473946888311{padding-top: 80px !important;padding-bottom: 30px !important;}"][vc_column][ultimate_heading main_heading="DESIGN ANYTHING &amp; CUSTOMIZE LIKE A PRO" main_heading_color="#757575" sub_heading_color="#757575" main_heading_font_size="desktop:50px;tablet:30px;tablet_portrait:25px;mobile_landscape:25px;mobile:24px;" main_heading_line_height="desktop:80px;tablet:50px;tablet_portrait:40px;mobile_landscape:40px;mobile:40px;" sub_heading_font_size="desktop:18px;" sub_heading_line_height="desktop:30px;" sub_heading_margin="margin-bottom:30px;"]APRESS is powered by powerful theme admin that lets you customize everything.[/ultimate_heading][ultimate_spacer height="70" height_on_tabs="50" height_on_tabs_portrait="50" height_on_mob_landscape="40" height_on_mob="40"][vc_single_image image="484" img_size="full" alignment="center" css_animation="appear"][/vc_column][/vc_row][vc_row css=".vc_custom_1474441923866{padding-top: 20px !important;padding-bottom: 150px !important;}"][vc_column width="1/3"][apress_icon_box iconcolor="#8e54e9" contentboxtitle_size="20" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="#757575" icon_family="fontawesome" icon_fontawesome="fa fa-codepen" contentboxtitle="POWERFUL ADMIN" contentboxanimation="fadeInUp" contentboxdelay="300"][/vc_column][vc_column width="1/3"][apress_icon_box iconcolor="#8e54e9" contentboxtitle_size="20" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="#757575" icon_family="fontawesome" icon_fontawesome="fa fa-thumbs-o-up" contentboxtitle="DRAG N DROP" contentboxanimation="fadeInUp" contentboxdelay="600" icon="wb-layers"][/vc_column][vc_column width="1/3"][apress_icon_box iconcolor="#8e54e9" contentboxtitle_size="20" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="#757575" icon_family="openiconic" icon_openiconic="vc-oi vc-oi-play" contentboxtitle="ONE CLICK SET UP" contentboxanimation="fadeInUp" contentboxdelay="900" icon="zm-settings"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1505548290397{margin-top: 0px !important;background-color: #8e54e9 !important;}"][vc_column width="1/4"][stat_counter icon="new-ribbon" icon_size="50" icon_color="#ffffff" icon_animation="pulse" icon_position="right" counter_title="CLIENTS" counter_value="5754" speed="5" counter_color_txt="#ffffff" desc_font_size="desktop:30px;" desc_font_line_height="desktop:40px;" desc_font_color="#ffffff" title_font_size="desktop:19px;" title_font_line_height="desktop:23px;"][/vc_column][vc_column width="1/4"][stat_counter icon="zplus-download" icon_size="50" icon_color="#ffffff" icon_animation="pulse" icon_position="right" counter_title="DOWNLOADS" counter_value="10856" speed="5" counter_color_txt="#ffffff" desc_font_size="desktop:30px;" desc_font_line_height="desktop:40px;" desc_font_color="#ffffff" title_font_size="desktop:19px;" title_font_line_height="desktop:23px;"][/vc_column][vc_column width="1/4"][stat_counter icon="new-target" icon_size="50" icon_color="#ffffff" icon_animation="pulse" icon_position="right" counter_title="TICKETS" counter_value="15659" speed="5" counter_color_txt="#ffffff" desc_font_size="desktop:30px;" desc_font_line_height="desktop:40px;" desc_font_color="#ffffff" title_font_size="desktop:19px;" title_font_line_height="desktop:23px;"][/vc_column][vc_column width="1/4"][stat_counter icon="new-adjustments" icon_size="50" icon_color="#ffffff" icon_animation="pulse" icon_position="right" counter_title="OPTIONS" counter_value="1585" speed="5" counter_color_txt="#fcfcfc" desc_font_size="desktop:30px;" desc_font_line_height="desktop:40px;" desc_font_color="#ffffff" title_font_size="desktop:19px;" title_font_line_height="desktop:23px;"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Hero Section vc-template
	$data = array();
	$data['name'] = esc_html__( 'Hero Section 7', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/hero-sections1.jpg' );
	$data['sort_name'] = 'Hero Sections';
	$data['custom_class'] = 'general hero-sections';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-default" bg_image_new="id^559|url^http://apresswp.com/demo1/wp-content/uploads/2016/09/3.jpg|caption^null|alt^null|title^3|description^null" bg_override="ex-full" enable_overlay="enable_overlay_value" overlay_color="rgba(0,0,0,0.56)" css=".vc_custom_1507361201399{padding-top: 150px !important;padding-bottom: 150px !important;}"][vc_column css=".vc_custom_1473430252985{padding-top: 100px !important;padding-bottom: 100px !important;}"][ultimate_heading main_heading="DESIGN AGENCY " main_heading_color="#ffffff" sub_heading_color="#ffffff" main_heading_font_size="desktop:90px;tablet:70px;tablet_portrait:40px;mobile_landscape:40px;mobile:25px;" main_heading_line_height="desktop:100px;tablet:80px;tablet_portrait:40px;mobile_landscape:40px;mobile:30px;" main_heading_margin="margin-bottom:20px;" sub_heading_font_size="desktop:35px;tablet:20px;tablet_portrait:20px;mobile_landscape:20px;mobile:20px;" sub_heading_line_height="desktop:50px;tablet:20px;tablet_portrait:20px;mobile_landscape:20px;mobile:20px;"]BUILDING WEB AND APPS SINCE 2009[/ultimate_heading][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Hero Section vc-template
	$data = array();
	$data['name'] = esc_html__( 'Hero Section 8', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/hero-sections8.jpg' );
	$data['sort_name'] = 'Hero Sections';
	$data['custom_class'] = 'general hero-sections';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^568|url^http://apresswp.com/demo1/wp-content/uploads/2016/09/Freelancer.jpg|caption^null|alt^null|title^Freelancer|description^null" bg_image_repeat="no-repeat" parallax_sense="30" bg_override="ex-full" parallax_content="parallax_content_value" css=".vc_custom_1500730264268{padding-top: 250px !important;padding-bottom: 250px !important;}"][vc_column][ultimate_heading main_heading="JOHN WICK Jr" main_heading_color="#8659d6" sub_heading_color="#ffffff" alignment="left" main_heading_font_size="desktop:70px;tablet:35px;tablet_portrait:30px;mobile_landscape:25px;mobile:20px;" main_heading_line_height="desktop:100px;tablet:50px;tablet_portrait:50px;mobile_landscape:50px;mobile:50px;" sub_heading_font_size="desktop:30px;tablet:30px;tablet_portrait:25px;mobile_landscape:20px;mobile:20px;" sub_heading_line_height="desktop:50px;tablet:50px;tablet_portrait:50px;mobile_landscape:40px;mobile:40px;" main_heading_style="font-weight:bold;" sub_heading_margin="margin-bottom:30px;"]WORDPRESS DEVELOPER[/ultimate_heading][apress_sociallinks socialicon_style="color" socialicon_design="square" socialicon_facebook="#" socialicon_twitter="#" socialicon_instagram="#" socialicon_dribbble="#" socialicon_linkedin="$#" socialicon_email="#"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Hero Section vc-template
	$data = array();
	$data['name'] = esc_html__( 'Hero Section 9', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/hero-sections9.jpg' );
	$data['sort_name'] = 'Hero Sections';
	$data['custom_class'] = 'general hero-sections';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^1923|url^http://apresswp.com/demo1/wp-content/uploads/2017/09/bg2.jpg|caption^null|alt^null|title^bg2|description^null" bg_override="browser_size"][vc_column centered_text="true"][apress_heading sub_title="This is the video lightbox to show your story in an impressive way." data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" heading_margin="margin-bottom:20" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div|color:%23ffffff" subheading_margin="margin-bottom:20"]Impressive Way To Share Your Story[/apress_heading][apress_lightbox lightbox_type="video" link_style="link_icon" button_icon_color="#1f3aef" lightbox_hover_effect="yes" select_button_style="video_icon_style3" link="https://www.youtube.com/watch?v=yUCFRL43Zm4"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Hero Section vc-template
	$data = array();
	$data['name'] = esc_html__( 'Hero Section 10', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/hero-sections10.jpg' );
	$data['sort_name'] = 'Hero Sections';
	$data['custom_class'] = 'general hero-sections';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css_animation="none"][vc_column css_animation="fadeInDown" width="1/2"][vc_single_image image="25" img_size="full" css_animation="none"][/vc_column][vc_column css_animation="fadeInUp" width="1/2"][ultimate_heading main_heading="Clarity Breeds Mastery." alignment="left" main_heading_font_size="desktop:45px;" main_heading_line_height="desktop:55px;" main_heading_margin="margin-bottom:30px;" sub_heading_font_size="desktop:16px;" sub_heading_line_height="desktop:30px;"]Aliquam sagittis interdum velit at laoreet. Praesent lacus eros, tempor vitae finibus ac, commodo id dui. Aenean semper nisl in elit pharetra, a accumsan mauris laoreet. Quisque porttitor purus turpis, id sollicitudin diam pretium at. Fusce nec ante et ex euismod dignissim. Praesent vitae arcu metus. Fusce eu tristique lectus. Quisque id hendrerit diam. Curabitur sollicitudin nunc ut posuere convallis. Quisque suscipit massa at libero sollicitudin molestie. Aenean vitae placerat sem. Duis quis iaculis tortor. Vestibulum eget tincidunt nisi. Nunc efficitur tellus egestas augue posuere,.[/ultimate_heading][ultimate_heading main_heading="John Baumer, CPA" alignment="left" main_heading_font_size="desktop:30px;" main_heading_line_height="desktop:40px;" main_heading_margin="margin-top:20px;"][/ultimate_heading][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Hero Section vc-template
	$data = array();
	$data['name'] = esc_html__( 'Hero Section 11', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/hero-sections11.jpg' );
	$data['sort_name'] = 'Hero Sections';
	$data['custom_class'] = 'general hero-sections';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-default" bg_image_new="id^218|url^http://apresswp.com/demo5/wp-content/uploads/2017/02/word.jpg|caption^null|alt^null|title^word|description^null" bg_override="full" parallax_content="parallax_content_value" enable_overlay="enable_overlay_value" overlay_color="#727272" css=".vc_custom_1500287250017{padding-top: 280px !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/6"][/vc_column_inner][vc_column_inner width="2/3"][ultimate_heading main_heading="ALIQUAM SAGITTIS INTERDUM VELIT AT LAOREET. PRAESENT LACUS EROS, TEMPOR VITAE DUI." main_heading_font_size="desktop:27px;" main_heading_line_height="desktop:47px;"][/ultimate_heading][/vc_column_inner][vc_column_inner width="1/6"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1486562975383{padding-top: 87px !important;padding-bottom: 65px !important;}"][vc_column_inner width="1/3" css=".vc_custom_1486562847511{padding-bottom: 35px !important;}"][ult_content_box box_shadow="horizontal:0px|vertical:0px|blur:7px|spread:5px|color:rgba(0,0,0,0.04)|style:outset|" hover_bg_color="#252525" hover_box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:none|" bg_color="#2936b3" padding="padding-top:65px;padding-right:35px;padding-bottom:65px;padding-left:35px;"][ultimate_heading main_heading="ALIQUAM SAGITTIS" main_heading_color="#ffffff" sub_heading_color="#ffffff" alignment="left" main_heading_font_size="desktop:20px;" main_heading_line_height="desktop:30px;" main_heading_margin="margin-bottom:15px;"]Praesent Lacus Eros, Tempor Vitae Finibus Ac, Commodo Id Dui. Aenean Semper Nisl.[/ultimate_heading][/ult_content_box][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1486562855102{padding-bottom: 35px !important;}"][ult_content_box bg_color="#f1f1f1" box_shadow="horizontal:0px|vertical:0px|blur:7px|spread:5px|color:rgba(0,0,0,0.04)|style:outset|" padding="padding-top:65px;padding-right:35px;padding-bottom:65px;padding-left:35px;" hover_box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:none|" hover_bg_color="#e8e8e8"][ultimate_heading main_heading="ALIQUAM SAGITTIS" alignment="left" main_heading_font_size="desktop:20px;" main_heading_line_height="desktop:30px;" main_heading_margin="margin-bottom:15px;"]Praesent Lacus Eros, Tempor Vitae Finibus Ac, Commodo Id Dui. Aenean Semper Nisl.[/ultimate_heading][/ult_content_box][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1486562861260{padding-bottom: 35px !important;}"][ult_content_box bg_color="#f1f1f1" box_shadow="horizontal:0px|vertical:0px|blur:7px|spread:5px|color:rgba(0,0,0,0.04)|style:outset|" padding="padding-top:65px;padding-right:35px;padding-bottom:65px;padding-left:35px;" hover_bg_color="#e8e8e8" hover_box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:none|"][ultimate_heading main_heading="ALIQUAM SAGITTIS" alignment="left" main_heading_font_size="desktop:20px;" main_heading_line_height="desktop:30px;" main_heading_margin="margin-bottom:15px;"]Praesent Lacus Eros, Tempor Vitae Finibus Ac, Commodo Id Dui. Aenean Semper Nisl.[/ultimate_heading][/ult_content_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Hero Section vc-template
	$data = array();
	$data['name'] = esc_html__( 'Hero Section 12', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/hero-sections12.jpg' );
	$data['sort_name'] = 'Hero Sections';
	$data['custom_class'] = 'general hero-sections';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1504530752089{padding-top: 35px !important;}"][vc_column][apress_heading sub_title="" enable_delimiter="" style="heading_style1" title_font_options="tag:h1|font_size:60|line_height:70|letter_spacing:1" subtitle_font_options="tag:div"]GET TO THE FIRST PAGE OF GOOGLE[/apress_heading][vc_empty_space height="50px"][vc_row_inner equal_height="yes" content_placement="middle" css=".vc_custom_1507216698136{padding-bottom: 50px !important;}"][vc_column_inner width="1/2" css=".vc_custom_1507216942093{background-position: 0 0 !important;background-repeat: no-repeat !important;}"][apress_lightbox lightbox_type="video" link_style="link_icon_preview_image" image_url="39" button_icon_color="#ffffff" link_hover_caption="Watch Introduction" select_button_style="video_icon_style2" videolink_font_options="font_size:22|color:%23ffffff|line_height:30|letter_spacing:1" link="https://www.youtube.com/watch?v=yUCFRL43Zm4"][/vc_column_inner][vc_column_inner width="1/2"][apress_gradient_icon_box description="Mauris bibendum venenatis lectus, et consequat diam tincidunt et." color_scheme="gradient_scheme1" icon_alignment="left" data_animation="fadeInLeft" data_delay="300" icon_family="entypo" icon_entypo="entypo-icon entypo-icon-vcard" style="iconbox_style2" title_font_options="tag:h3"]Optimized Content For High Rankings[/apress_gradient_icon_box][vc_empty_space height="20px"][apress_gradient_icon_box description="Mauris bibendum venenatis lectus, et consequat diam tincidunt et." color_scheme="gradient_scheme1" icon_alignment="left" data_animation="fadeInLeft" data_delay="600" icon_family="fontawesome" icon_fontawesome="fa fa-line-chart" style="iconbox_style2" title_font_options="tag:h3"]Get Qualified Leads For Your Business[/apress_gradient_icon_box][vc_empty_space height="20px"][apress_gradient_icon_box description="Mauris bibendum venenatis lectus, et consequat diam tincidunt et." color_scheme="gradient_scheme1" icon_alignment="left" data_animation="fadeInLeft" data_delay="900" icon_family="fontawesome" icon_fontawesome="fa fa-usd" style="iconbox_style2" title_font_options="tag:h3"]Higher Visibility Means Higher Profits[/apress_gradient_icon_box][vc_empty_space height="20px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Hero Section vc-template
	$data = array();
	$data['name'] = esc_html__( 'Hero Section 13', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/hero-sections13.jpg' );
	$data['sort_name'] = 'Hero Sections';
	$data['custom_class'] = 'general hero-sections';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^103|url^http://apresswp.com/demo17/wp-content/uploads/2017/09/bg.jpg|caption^null|alt^null|title^bg|description^null" bg_image_repeat="no-repeat" bg_override="ex-full"][vc_column][vc_empty_space height="50px"][vc_row_inner gap="30"][vc_column_inner width="1/2"][apress_heading sub_title="ABOUT US" content_alignment="left" data_animation="fadeInUp" data_delay="300" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style6" title_font_options="tag:h1|font_size:30|line_height:40|letter_spacing:1" subtitle_font_options="tag:div|color:%23ffffff|letter_spacing:1"]We are the team behind the daily fresh healthy organic foods. Our vision is to help enable society get farm fresh balanced diet.[/apress_heading][vc_empty_space height="30px"][apress_lightbox lightbox_type="video" link_style="link_icon_with_text" button_icon_color="#ffffff" lightbox_hover_effect="yes" link="https://www.youtube.com/watch?v=yUCFRL43Zm4" select_button_style="video_icon_style2" link_text="Watch Our Story" videolink_font_options="color:%23ffffff"][/vc_column_inner][vc_column_inner width="1/2"][vc_empty_space height="30px"][info_list style="circle with_bg" icon_bg_color="#5fb538" icon_color="#ffffff" font_size_icon="16" connector_color="#5fb538"][info_list_item list_icon="Defaults-check" animation="fadeInLeft" desc_font_size="desktop:18px;" desc_font_line_height="desktop:28px;" desc_font_color="#ffffff"]Best produce guaranteed by our team.[/info_list_item][info_list_item list_icon="Defaults-check" animation="fadeInLeft" desc_font_size="desktop:18px;" desc_font_line_height="desktop:28px;" desc_font_color="#ffffff"]
 Harvested under strict supervision of experts

[/info_list_item][info_list_item list_icon="Defaults-check" animation="fadeInLeft" desc_font_size="desktop:18px;" desc_font_line_height="desktop:28px;" desc_font_color="#ffffff"]Only fresh quality delivered to your doorstep.[/info_list_item][info_list_item list_icon="Defaults-check" animation="fadeInLeft" desc_font_size="desktop:18px;" desc_font_line_height="desktop:28px;" desc_font_color="#ffffff"]Only fresh quality delivered to your doorstep.[/info_list_item][/info_list][/vc_column_inner][/vc_row_inner][vc_empty_space height="100px"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;

	//Car Rental Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Portfolio 1', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/portfolio1.jpg' );
	$data['sort_name'] = 'Portfolio';
	$data['custom_class'] = 'general portfolio';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1500631218326{padding-top: 150px !important;padding-bottom: 0px !important;}"][vc_column][apress_heading sub_title="" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:h4" heading_margin="margin-bottom:30" subheading_margin="margin-bottom:50"]FEATURED WORKS[/apress_heading][vc_empty_space height="50px"][apress_portfolio_styles style="style2" category="all" layoutstyle2="grid_retangular" portfoliocrsltitlecolor="#ffffff" portfoliocrslbuttonbg="" portfoliocrslbuttonhovbg="" data_animation="fadeInUp" data_delay="100"][/vc_column][/vc_row][vc_row css_animation="fadeInUp" bg_type="grad" bg_override="ex-full" css=".vc_custom_1505466749705{margin-top: 0px !important;padding-top: 50px !important;padding-bottom: 50px !important;}" bg_grad="background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, #4777E6), color-stop(99%, #8D54E9));background: -moz-linear-gradient(left,#4777E6 0%,#8D54E9 99%);background: -webkit-linear-gradient(left,#4777E6 0%,#8D54E9 99%);background: -o-linear-gradient(left,#4777E6 0%,#8D54E9 99%);background: -ms-linear-gradient(left,#4777E6 0%,#8D54E9 99%);background: linear-gradient(left,#4777E6 0%,#8D54E9 99%);"][vc_column width="1/4"][stat_counter icon="zplus-heart love like favorite" icon_size="50" icon_color="#ffffff" icon_animation="pulse" icon_position="right" counter_title="CLIENTS" counter_value="5754" speed="5" counter_color_txt="#ffffff" desc_font_size="desktop:50px;tablet:30px;tablet_portrait:30px;mobile_landscape:30px;mobile:30px;" desc_font_line_height="desktop:40px;" desc_font_color="#ffffff" title_font_size="desktop:19px;tablet:13px;tablet_portrait:13px;mobile_landscape:13px;mobile:13px;" title_font_line_height="desktop:23px;"][/vc_column][vc_column width="1/4"][stat_counter icon="zplus-download" icon_size="50" icon_color="#ffffff" icon_animation="pulse" icon_position="right" counter_title="DOWNLOADS" counter_value="10856" speed="5" counter_color_txt="#ffffff" desc_font_size="desktop:50px;tablet:30px;tablet_portrait:30px;mobile_landscape:30px;mobile:30px;" desc_font_line_height="desktop:40px;" desc_font_color="#ffffff" title_font_size="desktop:19px;tablet:13px;tablet_portrait:13px;mobile_landscape:13px;mobile:13px;" title_font_line_height="desktop:23px;"][/vc_column][vc_column width="1/4"][stat_counter icon="new-target" icon_size="50" icon_color="#ffffff" icon_animation="pulse" icon_position="right" counter_title="TICKETS" counter_value="15659" speed="5" counter_color_txt="#ffffff" desc_font_size="desktop:50px;tablet:30px;tablet_portrait:30px;mobile_landscape:30px;mobile:30px;" desc_font_line_height="desktop:40px;" desc_font_color="#ffffff" title_font_size="desktop:19px;tablet:13px;tablet_portrait:13px;mobile_landscape:13px;mobile:13px;" title_font_line_height="desktop:23px;"][/vc_column][vc_column width="1/4"][stat_counter icon="new-adjustments" icon_size="50" icon_color="#ffffff" icon_animation="pulse" icon_position="right" counter_title="OPTIONS" counter_value="1585" speed="5" counter_color_txt="#fcfcfc" desc_font_size="desktop:50px;tablet:30px;tablet_portrait:30px;mobile_landscape:30px;mobile:30px;" desc_font_line_height="desktop:40px;" desc_font_color="#ffffff" title_font_size="desktop:19px;tablet:13px;tablet_portrait:13px;mobile_landscape:13px;mobile:13px;" title_font_line_height="desktop:23px;"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Car Rental Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Portfolio 2', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/portfolio2.jpg' );
	$data['sort_name'] = 'Portfolio';
	$data['custom_class'] = 'general portfolio';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1505546452815{padding-top: 150px !important;padding-bottom: 200px !important;background-color: #6146db !important;}"][vc_column][apress_heading sub_title="Integer et gravida ante. Duis efficitur, nibh non porttitor mattis, elit nulla facilisis lorem, sed luctus ligula purus in elit. Integer et gravida ante. Duis efficitur, nibh non porttitor mattis, elit nulla facilisis lorem, sed luctus ligula purus in elit." content_alignment="left" data_animation="fadeInUp" data_delay="300" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" title_google_fonts="yes" style="heading_style1" heading_margin="margin-bottom:30" subheading_margin="margin-bottom:50" title_font_options="tag:h2|font_size:65|line_height:70|letter_spacing:1" subtitle_font_options="tag:p|color:%23ffffff" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" title_responsive="font_size_tablet:45|line_height_tablet:50|letter_spacing_tablet:1|font_size_mobile:35|line_height_mobile:40|letter_spacing_mobile:1"]Our Recent Works[/apress_heading][apress_portfolio_carousel style="style2" category="all" portfoliohovertype="hovertype_zoomin" num="8" portfoliocrslcolpad="0,5,0,5" portfoliocrsltitlecolor="#ffffff" portfoliocrslbuttonbg="#6146db" portfoliocrslbuttonhovbg="#6146db" portfoliocrslnav="square" data_delay="100"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Car Rental Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Portfolio 3', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/portfolio3.jpg' );
	$data['sort_name'] = 'Portfolio';
	$data['custom_class'] = 'general portfolio';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1473769042816{padding-bottom: 100px !important;}"][vc_column css=".vc_custom_1470037688258{padding-top: 0px !important;}"][ultimate_spacer height="100"][ultimate_heading main_heading="RECENT WORKS" main_heading_color="#404040" spacer="line_only" spacer_position="bottom" line_height="2" line_color="#6348db" main_heading_font_size="desktop:40px;" main_heading_line_height="desktop:35px;" line_width="50" spacer_margin="margin-bottom:15px;" main_heading_margin="margin-bottom:50px;"][/ultimate_heading][apress_portfolio_styles category="all" layoutstyle="masonry" portfoliohovertype="hovertype_zoomin" num="6" portfoliocrslcolprw="Three" portfoliocrsltitlesize="20" portfoliocrsltitlecolor="#a0a0a0" portfoliocrslbuttonbg="#6348db" portfoliocrslbuttonhovbg="#6348db" portfoliofilter="1" filter_button_align="center" portfoliofilter_des="" filter_button_text_color="#6348db" filter_button_bg_color="#ffffff" filter_button_border_color="#6348db" filter_button_text_hover_color="#ffffff" filter_button_bg_hover_color="#6348db" data_animation="fadeIn"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Car Rental Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Portfolio 4', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/portfolio4.jpg' );
	$data['sort_name'] = 'Portfolio';
	$data['custom_class'] = 'general portfolio';
	$data['content'] = <<<CONTENT
[vc_row gap="10" content_placement="top" css=".vc_custom_1473655878481{padding-top: 50px !important;}"][vc_column width="1/3" offset="vc_col-lg-offset-0 vc_col-md-offset-0 vc_col-sm-offset-0"][ultimate_heading main_heading="RECENT WORKS" alignment="right" main_heading_font_size="desktop:35px;" main_heading_line_height="desktop:60px;"]Featured[/ultimate_heading][/vc_column][vc_column width="2/3"][vc_column_text]Maecenas eu gravida nulla. Maecenas hendrerit pellentesque augue, auctor vehicula tellus tempus eu. Mauris eu iaculis felis, ac elementum nunc. Praesent sed bibendum leo. Nulla ullamcorper ipsum at libero tincidunt accumsan. Sed molestie felis vitae rutrum lacinia. In tempor nisi sit amet augue iaculis, nec viverra ipsum viverra.[/vc_column_text][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1473658275557{border-top-width: 1px !important;padding-bottom: 0px !important;border-top-color: #f2f2f2 !important;border-top-style: solid !important;}"][vc_column width="1/4" css=".vc_custom_1473658029522{padding-top: 10px !important;padding-bottom: 10px !important;}"][stat_counter icon="none" icon_size="0" icon_color="#ffffff" icon_animation="pulse" counter_title="CLIENTS" counter_value="5754" speed="5" counter_color_txt="#757575" desc_font_size="desktop:35px;" desc_font_line_height="desktop:40px;" desc_font_color="#757575" title_font_size="desktop:19px;" title_font_line_height="desktop:23px;" css_stat_counter=".vc_custom_1473657882751{padding-right: 40px !important;padding-left: 40px !important;}"][/vc_column][vc_column width="1/4" css=".vc_custom_1473658034912{padding-top: 10px !important;padding-bottom: 10px !important;}"][stat_counter icon="none" icon_size="0" icon_color="#ffffff" icon_animation="pulse" counter_title="DOWNLOADS" counter_value="10856" speed="5" counter_color_txt="#757575" desc_font_size="desktop:35px;" desc_font_line_height="desktop:40px;" desc_font_color="#757575" title_font_size="desktop:19px;" title_font_line_height="desktop:23px;" css_stat_counter=".vc_custom_1473657893305{padding-right: 40px !important;padding-left: 40px !important;}"][/vc_column][vc_column width="1/4" css=".vc_custom_1473658022645{padding-top: 10px !important;padding-bottom: 10px !important;}"][stat_counter icon="none" icon_size="0" icon_color="#ffffff" icon_animation="pulse" counter_title="TICKETS" counter_value="15659" speed="5" counter_color_txt="#757575" desc_font_size="desktop:35px;" desc_font_line_height="desktop:40px;" desc_font_color="#757575" title_font_size="desktop:19px;" title_font_line_height="desktop:23px;" css_stat_counter=".vc_custom_1473657902170{padding-right: 40px !important;padding-left: 40px !important;}"][/vc_column][vc_column width="1/4" css=".vc_custom_1473658041607{padding-top: 10px !important;padding-bottom: 10px !important;}"][stat_counter icon="none" icon_size="0" icon_color="#ffffff" icon_animation="pulse" counter_title="OPTIONS" counter_value="1585" speed="5" counter_color_txt="#757575" desc_font_size="desktop:35px;" desc_font_line_height="desktop:40px;" desc_font_color="#757575" title_font_size="desktop:19px;" title_font_line_height="desktop:23px;" css_stat_counter=".vc_custom_1473657910831{padding-right: 40px !important;padding-left: 40px !important;}"][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1473658393486{margin-top: 0px !important;padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_column css=".vc_custom_1473658646221{padding-top: 0px !important;}"][apress_portfolio_styles style="style2" category="all" portfoliohovertype="hovertype_zoomin" num="6" portfoliocrslcolprw="Six" portfoliocrsltitlecolor="#ffffff" portfoliocrslbuttonbg="" portfoliocrslbuttonhovbg="" data_animation="fadeIn" data_delay="300"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Car Rental Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Portfolio 5', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/portfolio5.jpg' );
	$data['sort_name'] = 'Portfolio';
	$data['custom_class'] = 'general portfolio';
	$data['content'] = <<<CONTENT
[vc_row][vc_column css_animation="fadeIn"][ultimate_spacer height="50"][apress_heading sub_title="You can customize the portfolio without any coding !" enable_delimiter="" color_scheme="design_your_own" subtitle_google_fonts="yes" style="heading_style1" heading_margin="margin-bottom:10" title_font_options="tag:h2" subtitle_font_options="tag:div" subtitle_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal"]Portfolio Packery 4 Column  With Space[/apress_heading][ultimate_spacer height="50"][apress_portfolio_styles style="style2" category="all" layoutstyle2="packery" portfolio_packery_gutter="10" num="5" portfoliocrsltitlecolor="#ffffff" portfoliocrslbuttonbg="" portfoliocrslbuttonhovbg="" portfoliofilter="1" filter_button_align="center" portfoliofilter_des="" filter_buttonborradi="20" filter_button_text_color="#ffffff" filter_button_bg_color="" filter_button_border_color="" filter_button_text_hover_color="#ffffff" filter_button_bg_hover_color="" data_delay="100"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Car Rental Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Portfolio 6', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/portfolio6.jpg' );
	$data['sort_name'] = 'Portfolio';
	$data['custom_class'] = 'general portfolio';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1486131137749{padding-top: 25px !important;padding-bottom: 40px !important;}"][vc_column][apress_portfolio_styles style="style2" layoutstyle2="grid_retangular" num="9" portfoliocrslcolprw="Three" portfoliocrslcolpad2="20,20,20,20" portfoliocrsltitlesize="21" portfoliocrsltitlecolor="#ffffff" portfoliocrsloverlayhovercolor="#ee624c" portfoliocrsloverlayhoveropac="0.95" portfoliocrslzoomicon="fa fa-plus" portfoliocrslbuttonbg="#363636" portfoliocrslbuttonhovbg="#414141"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Car Rental Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Portfolio 7', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/portfolio7.jpg' );
	$data['sort_name'] = 'Portfolio';
	$data['custom_class'] = 'general portfolio';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1504107210617{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #333333 !important;}"][vc_column][apress_heading sub_title="OUR PROJECTS" content_alignment="left" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style2" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div|color:%23ffffff" heading_margin="margin-bottom:50"]Recently Completed Projects[/apress_heading][apress_portfolio_styles style="style2" category="all" layoutstyle2="packery" portfolio_packery_gutter="10" portfoliohovertype="hovertype_zoomin" num="6" portfoliocrsltitlecolor="#ffffff" portfoliocrslbuttonbg="" portfoliocrslbuttonhovbg="" data_animation="fadeInUp" data_delay="100"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Car Rental Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Portfolio 8', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/portfolio8.jpg' );
	$data['sort_name'] = 'Portfolio';
	$data['custom_class'] = 'general portfolio';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1504531608412{padding-top: 50px !important;padding-bottom: 90px !important;background-color: #184f78 !important;}"][vc_column][apress_heading sub_title="Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea." delimiter_line_height_9_10="50" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style9" title_font_options="tag:h1|letter_spacing:1" subtitle_font_options="tag:div|color:%23ffffff" delimiter_line_color_9_10="#ffffff"]RECENT PROJECTS[/apress_heading][vc_empty_space height="30px"][apress_portfolio_carousel category="all" num="4" portfoliocrslcolprw="Three" portfoliocrsltitlecolor="" portfoliocrslbuttonbg="" portfoliocrslbuttonhovbg="" portfoliocrslnav="square" data_animation="fadeIn" data_delay="100"][/vc_column][/vc_row]
CONTENT;
$templates[] = $data;

	//Cloud Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Counter 1', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/counter1.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row css_animation="fadeInUp" bg_type="grad" bg_override="ex-full" css=".vc_custom_1505466749705{margin-top: 0px !important;padding-top: 50px !important;padding-bottom: 50px !important;}" bg_grad="background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, #4777E6), color-stop(99%, #8D54E9));background: -moz-linear-gradient(left,#4777E6 0%,#8D54E9 99%);background: -webkit-linear-gradient(left,#4777E6 0%,#8D54E9 99%);background: -o-linear-gradient(left,#4777E6 0%,#8D54E9 99%);background: -ms-linear-gradient(left,#4777E6 0%,#8D54E9 99%);background: linear-gradient(left,#4777E6 0%,#8D54E9 99%);"][vc_column width="1/4"][stat_counter icon="zplus-heart love like favorite" icon_size="50" icon_color="#ffffff" icon_animation="pulse" icon_position="right" counter_title="CLIENTS" counter_value="5754" speed="5" counter_color_txt="#ffffff" desc_font_size="desktop:50px;tablet:30px;tablet_portrait:30px;mobile_landscape:30px;mobile:30px;" desc_font_line_height="desktop:40px;" desc_font_color="#ffffff" title_font_size="desktop:19px;tablet:13px;tablet_portrait:13px;mobile_landscape:13px;mobile:13px;" title_font_line_height="desktop:23px;"][/vc_column][vc_column width="1/4"][stat_counter icon="zplus-download" icon_size="50" icon_color="#ffffff" icon_animation="pulse" icon_position="right" counter_title="DOWNLOADS" counter_value="10856" speed="5" counter_color_txt="#ffffff" desc_font_size="desktop:50px;tablet:30px;tablet_portrait:30px;mobile_landscape:30px;mobile:30px;" desc_font_line_height="desktop:40px;" desc_font_color="#ffffff" title_font_size="desktop:19px;tablet:13px;tablet_portrait:13px;mobile_landscape:13px;mobile:13px;" title_font_line_height="desktop:23px;"][/vc_column][vc_column width="1/4"][stat_counter icon="new-target" icon_size="50" icon_color="#ffffff" icon_animation="pulse" icon_position="right" counter_title="TICKETS" counter_value="15659" speed="5" counter_color_txt="#ffffff" desc_font_size="desktop:50px;tablet:30px;tablet_portrait:30px;mobile_landscape:30px;mobile:30px;" desc_font_line_height="desktop:40px;" desc_font_color="#ffffff" title_font_size="desktop:19px;tablet:13px;tablet_portrait:13px;mobile_landscape:13px;mobile:13px;" title_font_line_height="desktop:23px;"][/vc_column][vc_column width="1/4"][stat_counter icon="new-adjustments" icon_size="50" icon_color="#ffffff" icon_animation="pulse" icon_position="right" counter_title="OPTIONS" counter_value="1585" speed="5" counter_color_txt="#fcfcfc" desc_font_size="desktop:50px;tablet:30px;tablet_portrait:30px;mobile_landscape:30px;mobile:30px;" desc_font_line_height="desktop:40px;" desc_font_color="#ffffff" title_font_size="desktop:19px;tablet:13px;tablet_portrait:13px;mobile_landscape:13px;mobile:13px;" title_font_line_height="desktop:23px;"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Corporate Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Counter 2', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/counter2.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1485947789432{padding-bottom: 140px !important;background-image: url(http://apresswp.com/demo2/wp-content/uploads/2017/01/bg_1.jpg?id=55) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_class="sidebar custom_sidebar"][ultimate_heading main_heading="Our Achivement" main_heading_color="#ffffff" main_heading_font_size="desktop:40px;" main_heading_line_height="desktop:50px;" main_heading_margin="margin-top:55px;margin-bottom:50px;"][/ultimate_heading][vc_row_inner css=".vc_custom_1485759579498{padding-top: 80px !important;}"][vc_column_inner width="1/3"][stat_counter icon_size="32" icon_position="left" counter_title="Years of experience" counter_value="12" speed="5" counter_color_txt="#ffffff" title_font_size="desktop:14px;" title_font_line_height="desktop:20px;" desc_font_size="desktop:45px;" desc_font_line_height="desktop:55px;" desc_font_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/3"][stat_counter icon_size="32" icon_position="left" counter_title="Happy Customers" counter_value="99" counter_suffix="k" speed="5" counter_color_txt="#ffffff" title_font_size="desktop:14px;" title_font_line_height="desktop:20px;" desc_font_size="desktop:45px;" desc_font_line_height="desktop:55px;" desc_font_color="#ffffff" suf_pref_font_size="desktop:25px;" suf_pref_font_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/3"][stat_counter icon_size="32" icon_position="left" counter_title="Satisfaction" counter_value="100" counter_suffix="%" speed="5" counter_color_txt="#ffffff" title_font_size="desktop:14px;" title_font_line_height="desktop:20px;" desc_font_size="desktop:45px;" desc_font_line_height="desktop:55px;" desc_font_color="#ffffff" suf_pref_font_size="desktop:25px;" suf_pref_font_color="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" css=".vc_custom_1485947794596{padding-bottom: 27px !important;background-color: #2c2c2c !important;}" el_class="sidebar custom_sidebar"][ultimate_heading main_heading="Recent News" main_heading_color="#ffffff" main_heading_font_size="desktop:40px;" main_heading_line_height="desktop:50px;" main_heading_margin="margin-top:55px;margin-bottom:52px;"][/ultimate_heading][zolo_blog_modern style="style2" num="3" blgmoderncolbg="#2c2c2c" blgmoderncolhovbg="#2c2c2c"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Corporate Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Counter 3', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/counter3.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1486618782729{padding-bottom: 65px !important;}"][vc_column width="2/3"][ultimate_heading main_heading="ABOUT US" alignment="left" main_heading_font_size="desktop:50px;" main_heading_line_height="desktop:60px;" main_heading_margin="margin-top:53px;margin-bottom:30px;"]Curabitur sollicitudin nunc ut posuere convallis. Quisque suscipit massa at libero sollicitudin molestie. Aenean vitae placerat sem. Duis quis iaculis tortor. Vestibulum eget tincidunt nisi. Nunc efficitur tellus egestas augue posuere, eu laoreet sapien aliquet.[/ultimate_heading][vc_row_inner css=".vc_custom_1486615734416{padding-top: 56px !important;}"][vc_column_inner width="1/3" css=".vc_custom_1486615743100{padding-top: 30px !important;}"][stat_counter icon_size="32" counter_title="PROJECTS" counter_value="186" speed="3" counter_color_txt="b1b1b1" title_font_size="desktop:14px;" title_font_line_height="desktop:20px;" desc_font_color="#252525"][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1486615750482{padding-top: 30px !important;}"][stat_counter icon_size="32" counter_title="PROJECTS" counter_value="186" speed="3" counter_color_txt="b1b1b1" title_font_size="desktop:14px;" title_font_line_height="desktop:20px;" desc_font_color="#252525"][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1486615757226{padding-top: 30px !important;}"][stat_counter icon_size="32" counter_title="PROJECTS" counter_value="186" speed="3" counter_color_txt="b1b1b1" title_font_size="desktop:14px;" title_font_line_height="desktop:20px;" desc_font_color="#252525"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/3" css=".vc_custom_1486618665316{padding-top: 100px !important;}"][vc_single_image image="87" img_size="full" alignment="center"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Corporate Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Counter 4', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/counter4.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1483076743359{padding-bottom: 28px !important;}" el_id="progress"][vc_column][ultimate_heading main_heading="Great for tech & startups" main_heading_style="font-weight:bold;" main_heading_font_size="desktop:40px;" main_heading_line_height="desktop:55px;" main_heading_margin="margin-top:52px;margin-bottom:12px;" sub_heading_font_size="desktop:16px;" sub_heading_line_height="desktop:26px;"]Ut Placerat Nulla Sed Justo Interdum Facilisis. Etiam Sagittis Purus Lacus, Ac Ultrices Ante Convallis Ut.[/ultimate_heading][vc_single_image image="122" img_size="full" alignment="center" css=".vc_custom_1483015577055{padding-top: 147px !important;}"][vc_row_inner css=".vc_custom_1483017002834{padding-top: 50px !important;}"][vc_column_inner width="1/4" css=".vc_custom_1483019695061{padding-bottom: 30px !important;}"][stat_counter icon="Defaults-coffee" icon_size="60" icon_color="#292929" icon_position="left" counter_title="Cups Of Coffee" counter_value="999" speed="3" title_font_style="font-weight:bold;" counter_color_txt="#b7b7b7" desc_font_style="font-weight:bold;" title_font_size="desktop:16px;" title_font_line_height="desktop:26px;" desc_font_size="desktop:70px;" desc_font_line_height="desktop:55px;" desc_font_color="#292929"][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1483019700717{padding-bottom: 30px !important;}"][stat_counter icon="Defaults-trophy" icon_size="60" icon_color="#292929" icon_position="left" counter_title="Awards Won" counter_value="35" speed="3" title_font_style="font-weight:bold;" counter_color_txt="#b7b7b7" desc_font_style="font-weight:bold;" title_font_size="desktop:16px;" title_font_line_height="desktop:26px;" desc_font_size="desktop:70px;" desc_font_line_height="desktop:55px;" desc_font_color="#292929"][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1483019706108{padding-bottom: 30px !important;}"][stat_counter icon="Defaults-group users" icon_size="60" icon_color="#292929" icon_position="left" counter_title="Satisfied Clients" counter_value="101" speed="3" title_font_style="font-weight:bold;" counter_color_txt="#b7b7b7" desc_font_style="font-weight:bold;" title_font_size="desktop:16px;" title_font_line_height="desktop:26px;" desc_font_size="desktop:70px;" desc_font_line_height="desktop:55px;" desc_font_color="#292929"][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1483019712872{padding-bottom: 30px !important;}"][stat_counter icon="Defaults-cube" icon_size="60" icon_color="#292929" icon_position="left" counter_title="Projects Finished" counter_value="1501" speed="3" title_font_style="font-weight:bold;" counter_color_txt="#b7b7b7" desc_font_style="font-weight:bold;" title_font_size="desktop:16px;" title_font_line_height="desktop:26px;" desc_font_size="desktop:70px;" desc_font_line_height="desktop:55px;" desc_font_color="#292929"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Corporate Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box 1', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/icon-box1.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" css=".vc_custom_1505459664222{margin-right: 0px !important;}"][vc_column css_animation="fadeInLeft" width="1/2" css=".vc_custom_1505465961711{padding-top: 100px !important;padding-bottom: 100px !important;background-image: url(http://apresswp.com/demo1/wp-content/uploads/2016/09/bg2.jpg?id=1069) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][vc_column width="1/2" css=".vc_custom_1473583920619{border-top-width: 100px !important;padding-right: 10% !important;padding-bottom: 100px !important;padding-left: 10% !important;}" offset="vc_col-lg-offset-0 vc_col-md-offset-0 vc_col-sm-offset-0"][vc_empty_space height="30px"][apress_heading sub_title="Sed imperdiet bibendum purus nec tristique. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos." content_alignment="left" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div" heading_margin="margin-bottom:30" subheading_margin="margin-bottom:50"]WHY CHOOSE APRESS[/apress_heading][vc_row_inner][vc_column_inner][apress_gradient_icon_box description="Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." icon_alignment="left" data_animation="fadeInDown" icon_family="linecons" icon_linecons="vc_li vc_li-diamond" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]Header Builder[/apress_gradient_icon_box][vc_empty_space height="30px"][apress_gradient_icon_box description="Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." icon_alignment="left" data_animation="fadeInDown" icon_family="linecons" icon_linecons="vc_li vc_li-pen" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]Unlimited Layouts[/apress_gradient_icon_box][vc_empty_space height="30px"][apress_gradient_icon_box description="Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." icon_alignment="left" data_animation="fadeInDown" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h3"]Template Gallery[/apress_gradient_icon_box][vc_empty_space height="30px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
	$templates[] = $data;
	//Corporate Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box 2', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/icon-box2.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1500797107580{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #f7f7f7 !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/2"][apress_heading sub_title="OUR SPECIALITIES" content_alignment="left" enable_delimiter="" style="heading_style2" title_font_options="tag:h2|letter_spacing:1|font_style_bold:1" subtitle_font_options="tag:div" title_responsive="font_size_tablet:35|line_height_tablet:45|letter_spacing_tablet:1|font_size_mobile:25|line_height_mobile:35|letter_spacing_mobile:1"]We take <em>personal attention</em> in every client project no matter small or big. To us every project is <em>important.</em>[/apress_heading][/vc_column_inner][vc_column_inner width="1/2"][ultimate_spacer height="20"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris quis elit nec sem laoreet tempor sit amet a quam.Lorem ipsum dolor sit amet, consectetur adipiscing elit.Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris quis elit nec sem laoreet tempor sit amet a quam.[/vc_column_text][/vc_column_inner][/vc_row_inner][ultimate_spacer height="100" height_on_tabs="50" height_on_tabs_portrait="50" height_on_mob_landscape="50" height_on_mob="50"][vc_row_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." icon_alignment="left" data_animation="fadeInUp" data_delay="300" icon_family="fontawesome" icon_fontawesome="fa fa-desktop" style="iconbox_style2" title_font_options="tag:h3"]DESKTOP APPS[/apress_gradient_icon_box][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." icon_alignment="left" data_animation="fadeInUp" data_delay="600" icon_family="fontawesome" icon_fontawesome="fa fa-tablet" style="iconbox_style2" title_font_options="tag:h3"]IPAD APPS[/apress_gradient_icon_box][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." icon_alignment="left" data_animation="fadeInUp" data_delay="900" icon_family="fontawesome" icon_fontawesome="fa fa-mobile" style="iconbox_style2" title_font_options="tag:h3"]MOBILE APPS[/apress_gradient_icon_box][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50" height_on_tabs="25" height_on_tabs_portrait="25" height_on_mob_landscape="20" height_on_mob="20"][vc_row_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." icon_alignment="left" data_animation="fadeInUp" data_delay="300" icon_family="fontawesome" icon_fontawesome="fa fa-life-ring" style="iconbox_style2" title_font_options="tag:h3"]SUPPORT APPS[/apress_gradient_icon_box][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." icon_alignment="left" data_animation="fadeInUp" data_delay="600" icon_family="fontawesome" icon_fontawesome="fa fa-wordpress" style="iconbox_style2" title_font_options="tag:h3"]WORDPRESS APPS[/apress_gradient_icon_box][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." icon_alignment="left" data_animation="fadeInUp" data_delay="900" icon_family="fontawesome" icon_fontawesome="fa fa-bar-chart" style="iconbox_style2" title_font_options="tag:h3"]ANALYTICS[/apress_gradient_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Corporate Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box 3', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/icon-box3.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1505542267573{padding-top: 100px !important;padding-bottom: 130px !important;}"][vc_column width="1/3"][apress_gradient_icon_box description="Suspendisse potenti. Donec vestibulum commodo gravida. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam congue nibh porta augue." icon_alignment="top_left" data_animation="fadeIn" data_delay="100" icon_family="fontawesome" icon_fontawesome="fa fa-desktop" style="iconbox_style4" title_font_options="tag:h2|font_size:25|line_height:30|letter_spacing:1"]WEB DESIGN[/apress_gradient_icon_box][ultimate_spacer height="100" height_on_tabs="50" height_on_tabs_portrait="50" height_on_mob_landscape="50" height_on_mob="50"][apress_gradient_icon_box description="Suspendisse potenti. Donec vestibulum commodo gravida. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam congue nibh porta augue." icon_alignment="top_left" data_animation="fadeIn" data_delay="100" icon_family="fontawesome" icon_fontawesome="fa fa-shopping-basket" style="iconbox_style4" title_font_options="tag:h2|font_size:25|line_height:30|letter_spacing:1"]ECOMMERCE APPS[/apress_gradient_icon_box][/vc_column][vc_column width="1/3"][apress_gradient_icon_box description="Suspendisse potenti. Donec vestibulum commodo gravida. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam congue nibh porta augue." icon_alignment="top_left" data_animation="fadeIn" data_delay="100" icon_family="fontawesome" icon_fontawesome="fa fa-laptop" style="iconbox_style4" title_font_options="tag:h2|font_size:25|line_height:30|letter_spacing:1"]APP DESIGN[/apress_gradient_icon_box][ultimate_spacer height="100" height_on_tabs="50" height_on_tabs_portrait="50" height_on_mob_landscape="50" height_on_mob="50"][apress_gradient_icon_box description="Suspendisse potenti. Donec vestibulum commodo gravida. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam congue nibh porta augue." icon_alignment="top_left" data_animation="fadeIn" data_delay="100" icon_family="fontawesome" icon_fontawesome="fa fa-search" style="iconbox_style4" title_font_options="tag:h2|font_size:25|line_height:30|letter_spacing:1"]SEO SERVICES[/apress_gradient_icon_box][/vc_column][vc_column width="1/3"][apress_gradient_icon_box description="Suspendisse potenti. Donec vestibulum commodo gravida. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam congue nibh porta augue." icon_alignment="top_left" data_animation="fadeIn" data_delay="100" icon_family="fontawesome" icon_fontawesome="fa fa-cogs" style="iconbox_style4" title_font_options="tag:h2|font_size:25|line_height:30|letter_spacing:1"]ADMIN DESIGN[/apress_gradient_icon_box][ultimate_spacer height="100" height_on_tabs="50" height_on_tabs_portrait="50" height_on_mob_landscape="50" height_on_mob="50"][apress_gradient_icon_box description="Suspendisse potenti. Donec vestibulum commodo gravida. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam congue nibh porta augue." icon_alignment="top_left" data_animation="fadeIn" data_delay="100" icon_family="fontawesome" icon_fontawesome="fa fa-line-chart" style="iconbox_style4" title_font_options="tag:h2|font_size:25|line_height:30|letter_spacing:1"]ANALYTICS APPS[/apress_gradient_icon_box][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Corporate Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box 4', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/icon-box4.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" equal_height="yes" bg_type="image" parallax_style="vcpb-default" bg_image_new="id^486|url^http://apresswp.com/demo1/wp-content/uploads/2016/09/parallax-bg.jpg|caption^null|alt^null|title^parallax-bg|description^null" bg_img_attach="fixed" bg_override="full" enable_overlay="enable_overlay_value" overlay_color="rgba(0,0,0,0.62)"][vc_column][vc_row_inner css=".vc_custom_1501898676857{padding-right: 5% !important;padding-left: 5% !important;}"][vc_column_inner][apress_heading sub_title="Etiam ullamcorper massa et porta pretium. Mauris hendrerit tellus a hendrerit suscipit. Maecenas luctus elit odio, at luctus arcu dignissim eget. In urna elit, dignissim ut elementum in, tempus id ligula. Ut placerat nulla sed justo interdum facilisis. Etiam sagittis purus lacus, ac ultrices ante convallis ut." data_animation="fadeInUp" data_delay="300" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" title_google_fonts="yes" style="heading_style1" heading_margin="margin-bottom:30" subheading_margin="margin-bottom:30" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div|color:%23ffffff" title_responsive="font_size_tablet:35|line_height_tablet:40|letter_spacing_tablet:1|font_size_mobile:25|line_height_mobile:30|letter_spacing_mobile:1"]Our Services[/apress_heading][/vc_column_inner][/vc_row_inner][ultimate_spacer height="56"][vc_row_inner][vc_column_inner width="1/3"][apress_icon_box iconcolor="#ffffff" icon_hover_color="#8b79db" icon_size="50" contentboxtitle_size="20" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="#ffffff" icon_family="linecons" icon_linecons="vc_li vc_li-star" contentboxtitle="Responsive Design" contentboxanimation="fadeInLeft" contentboxdelay="300" icon="elg-icon_desktop"][ultimate_spacer height="20"][/vc_column_inner][vc_column_inner width="1/3"][apress_icon_box iconcolor="#ffffff" icon_hover_color="#8b79db" icon_size="50" contentboxtitle_size="20" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="#ffffff" icon_family="linecons" icon_linecons="vc_li vc_li-shop" contentboxtitle="WooCommerce Ready" contentboxanimation="fadeInDown" contentboxdelay="400" icon="wl-woothemes1"][ultimate_spacer height="20"][/vc_column_inner][vc_column_inner width="1/3"][apress_icon_box iconcolor="#ffffff" icon_hover_color="#8b79db" icon_size="50" contentboxtitle_size="20" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="#ffffff" icon_family="linecons" icon_linecons="vc_li vc_li-diamond" contentboxtitle="Visual Shortcode Editor" contentboxanimation="fadeInRight" icon="wb-edit"][ultimate_spacer height="20"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][apress_icon_box iconcolor="#ffffff" icon_hover_color="#8b79db" icon_size="50" contentboxtitle_size="20" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="#ffffff" icon_family="linecons" icon_linecons="vc_li vc_li-news" contentboxtitle="Home Page Styles" contentboxanimation="fadeInLeft" icon="place-home89"][/vc_column_inner][vc_column_inner width="1/3"][apress_icon_box iconcolor="#ffffff" icon_hover_color="#8b79db" icon_size="50" contentboxtitle_size="20" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="#ffffff" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" contentboxtitle="Shop Template" contentboxanimation="fadeInUp" icon="zo-cart"][/vc_column_inner][vc_column_inner width="1/3"][apress_icon_box iconcolor="#ffffff" icon_hover_color="#8b79db" icon_size="50" contentboxtitle_size="20" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="#ffffff" icon_family="linecons" icon_linecons="vc_li vc_li-params" contentboxtitle="Filterable Portfolio" contentboxanimation="fadeInRight" contentboxdelay="600" icon="sw-portfolio"][/vc_column_inner][/vc_row_inner][ultimate_spacer height="88"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Corporate Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box 5', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/icon-box5.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row gap="10" css=".vc_custom_1473922425780{padding-top: 60px !important;padding-bottom: 0px !important;}"][vc_column width="1/4" css=".vc_custom_1473765450683{padding-top: 40px !important;}"][ult_sticky_section sticky_gutter="150"][ultimate_heading main_heading="01" main_heading_color="rgba(0,0,0,0.08)" sub_heading_color="#757575" alignment="left" main_heading_font_size="desktop:90px;" sub_heading_font_size="desktop:35px;" main_heading_margin="margin-bottom:35px;" main_heading_line_height="desktop:0px;" main_heading_style="font-weight:bold;" el_class="zplus_sticky_headings_holder"]Our <strong>Services</strong>[/ultimate_heading][/ult_sticky_section][/vc_column][vc_column width="3/4"][vc_row_inner gap="5"][vc_column_inner width="1/2" css=".vc_custom_1470401964868{padding-right: 2% !important;padding-left: 2% !important;}"][vc_column_text]Vestibulum bibendum dui velit, ac auctor lectus condimentum bibendum. Aenean at suscipit nisl. Quisque eget velit lectus. Suspendisse mattis condimentum arcu id hendrerit. Fusce luctus dolor sit amet quam varius consectetur. Cras venenatis neque ac posuere dignissim. Aliquam porta.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1470401974204{padding-right: 2% !important;padding-left: 2% !important;}"][vc_column_text]Quisque maximus posuere bibendum. Morbi nulla sapien, sollicitudin dictum ipsum a, pharetra egestas tellus. Sed lobortis nisl vitae purus sagittis, at rhoncus ex cursus. Etiam euismod sapien ipsum.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1474464921572{padding-bottom: 20px !important;}"][vc_column_inner width="1/2" css=".vc_custom_1474464938055{padding-bottom: 20px !important;}"][ult_content_box box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:inherit|" hover_bg_color="#ffffff" hover_box_shadow="horizontal:0px|vertical:0px|blur:20px|spread:5px|color:rgba(2,2,2,0.07)|style:outset|" border="border-style:none;|" padding="padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px;"][apress_gradient_icon_box description="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris quis elit nec sem laoreet tempor sit amet a quam." icon_alignment="left" icon_family="fontawesome" icon_fontawesome="fa fa-desktop" style="iconbox_style2" title_font_options="tag:h2|font_size:20|line_height:30"]WEB DESIGN[/apress_gradient_icon_box][/ult_content_box][ult_content_box box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:inherit|" hover_bg_color="#ffffff" hover_box_shadow="horizontal:0px|vertical:0px|blur:20px|spread:5px|color:rgba(2,2,2,0.07)|style:outset|" border="border-style:none;|" padding="padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px;"][apress_gradient_icon_box description="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris quis elit nec sem laoreet tempor sit amet a quam." icon_alignment="left" icon_family="fontawesome" icon_fontawesome="fa fa-bullseye" style="iconbox_style2" title_font_options="tag:h2|font_size:20|line_height:30"]SEO[/apress_gradient_icon_box][/ult_content_box][ult_content_box box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:inherit|" hover_bg_color="#ffffff" hover_box_shadow="horizontal:0px|vertical:0px|blur:20px|spread:5px|color:rgba(2,2,2,0.07)|style:outset|" border="border-style:none;|" padding="padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px;"][apress_gradient_icon_box description="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris quis elit nec sem laoreet tempor sit amet a quam." icon_alignment="left" icon_family="fontawesome" icon_fontawesome="fa fa-html5" style="iconbox_style2" title_font_options="tag:h2|font_size:20|line_height:30"]HTML 5[/apress_gradient_icon_box][/ult_content_box][/vc_column_inner][vc_column_inner width="1/2"][ult_content_box box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:inherit|" hover_box_shadow="horizontal:0px|vertical:0px|blur:20px|spread:5px|color:rgba(2,2,2,0.07)|style:outset|" padding="padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px;"][apress_gradient_icon_box description="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris quis elit nec sem laoreet tempor sit amet a quam." icon_alignment="left" icon_family="fontawesome" icon_fontawesome="fa fa-mobile" style="iconbox_style2" title_font_options="tag:h2|font_size:20|line_height:30"]MOBILE APPS[/apress_gradient_icon_box][/ult_content_box][ult_content_box box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:inherit|" hover_box_shadow="horizontal:0px|vertical:0px|blur:20px|spread:5px|color:rgba(2,2,2,0.07)|style:outset|" padding="padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px;"][apress_gradient_icon_box description="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris quis elit nec sem laoreet tempor sit amet a quam." icon_alignment="left" icon_family="fontawesome" icon_fontawesome="fa fa-tablet" style="iconbox_style2" title_font_options="tag:h2|font_size:20|line_height:30"]IPAD APPS[/apress_gradient_icon_box][/ult_content_box][ult_content_box box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:inherit|" hover_box_shadow="horizontal:0px|vertical:0px|blur:20px|spread:5px|color:rgba(2,2,2,0.07)|style:outset|" padding="padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px;"][apress_gradient_icon_box description="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris quis elit nec sem laoreet tempor sit amet a quam." icon_alignment="left" icon_family="fontawesome" icon_fontawesome="fa fa-cloud-download" style="iconbox_style2" title_font_options="tag:h2|font_size:20|line_height:30"]CLOUD APPS[/apress_gradient_icon_box][/ult_content_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1473922044923{padding-bottom: 100px !important;background-color: #ffffff !important;}"][vc_column width="1/4"][/vc_column][vc_column width="3/4"][vc_row_inner css=".vc_custom_1473921885701{padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_column_inner width="1/4" css=".vc_custom_1473922747625{border-right-width: 1px !important;padding-top: 0px !important;padding-bottom: 0px !important;border-right-color: #e5e5e5 !important;border-right-style: solid !important;}"][stat_counter icon="none" icon_size="0" icon_color="#ffffff" icon_animation="pulse" counter_title="CLIENTS" counter_value="5754" speed="5" counter_color_txt="#757575" desc_font_size="desktop:30px;" desc_font_line_height="desktop:40px;" desc_font_color="#757575" title_font_size="desktop:19px;" title_font_line_height="desktop:23px;"][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1473922771705{border-right-width: 1px !important;padding-top: 0px !important;padding-bottom: 0px !important;border-right-color: #e5e5e5 !important;border-right-style: solid !important;}"][stat_counter icon="none" icon_size="0" icon_color="#ffffff" icon_animation="pulse" counter_title="DOWNLOADS" counter_value="10856" speed="5" counter_color_txt="#757575" desc_font_size="desktop:30px;" desc_font_line_height="desktop:40px;" desc_font_color="#757575" title_font_size="desktop:19px;" title_font_line_height="desktop:23px;"][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1473922103126{border-right-width: 1px !important;padding-top: 0px !important;padding-bottom: 0px !important;border-right-color: #e5e5e5 !important;border-right-style: solid !important;}"][stat_counter icon="none" icon_size="0" icon_color="#ffffff" icon_animation="pulse" counter_title="TICKETS" counter_value="15659" speed="5" desc_font_size="desktop:30px;" desc_font_line_height="desktop:40px;" desc_font_color="#757575" title_font_size="desktop:19px;" title_font_line_height="desktop:23px;"][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1473922110581{padding-top: 0px !important;padding-bottom: 0px !important;}"][stat_counter icon="none" icon_size="0" icon_color="#ffffff" icon_animation="pulse" counter_title="OPTIONS" counter_value="1585" speed="5" counter_color_txt="#757575" desc_font_size="desktop:30px;" desc_font_line_height="desktop:40px;" desc_font_color="#757575" title_font_size="desktop:19px;" title_font_line_height="desktop:23px;"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Corporate Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box 6', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/icon-box6.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" bg_type="image" parallax_style="vcpb-default" bg_image_new="id^815|url^http://apresswp.com/demo1/wp-content/uploads/2016/09/sds.jpg|caption^null|alt^null|title^A photo by David Marcu. unsplash.com/photos/JZXAr--Qdf4|description^null" bg_override="full" enable_overlay="enable_overlay_value" overlay_color="rgba(255,255,255,0.93)" css=".vc_custom_1507368544873{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column width="1/2"][apress_lightbox lightbox_type="video" link_style="link_icon_preview_image" image_url="1619" button_icon_color="#8e54e9" link="https://www.youtube.com/watch?v=yUCFRL43Zm4" select_button_style="video_icon_style4"][/vc_column][vc_column width="1/2"][ultimate_heading main_heading="Design &amp; Customize Everything !" main_heading_color="#474747" sub_heading_color="#474747" main_heading_font_size="desktop:36px;tablet:30px;tablet_portrait:30px;mobile_landscape:25px;mobile:25px;" main_heading_line_height="desktop:60px;tablet:50px;tablet_portrait:50px;mobile_landscape:40px;mobile:40px;" sub_heading_font_size="desktop:18px;" sub_heading_line_height="desktop:30px;" main_heading_margin="margin-bottom:10px;" sub_heading_margin="margin-bottom:30px;"]Design any kind of site with APRESS theme and customize like a PRO. Any design is possible with APRESS without touching a single line of code.[/ultimate_heading][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1474295184013{background-color: #ffffff !important;}"][vc_column][ultimate_spacer height="20"][vc_row_inner][vc_column_inner width="1/3"][apress_icon_box iconcolor="#8e54e9" icon_hover_color="#8e54e9" icon_size="50" iconposition="center" contentboxtitle_size="20" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="#373737" icon_family="linecons" icon_linecons="vc_li vc_li-diamond" contentboxtitle="AWESOME DESIGN" contentboxarea="Aliquam erat volutpat. Maecenas sagittis mattis urna, at feugiat tellus accumsan ac. Quisque interdum risus turpis, a sollicitudin ex auctor quis. Aenean volutpat eu diam." contentboxanimation="bounceIn" contentboxdelay="200" icon="el-layers"][/vc_column_inner][vc_column_inner width="1/3"][apress_icon_box iconcolor="#8e54e9" icon_hover_color="#8e54e9" icon_size="50" iconposition="center" contentboxtitle_size="20" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="#373737" icon_family="linecons" icon_linecons="vc_li vc_li-display" contentboxtitle="FULLY RESPONSIVE" contentboxarea="Aliquam erat volutpat. Maecenas sagittis mattis urna, at feugiat tellus accumsan ac. Quisque interdum risus turpis, a sollicitudin ex auctor quis. Aenean volutpat eu diam." contentboxanimation="bounceIn" contentboxdelay="400" icon="el-mobile"][/vc_column_inner][vc_column_inner width="1/3"][apress_icon_box iconcolor="#8e54e9" icon_hover_color="#8e54e9" icon_size="50" iconposition="center" contentboxtitle_size="20" boxtitlepad="" title_desc_color="#373737" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" contentboxtitle="INSTANT SUPPORT" contentboxarea="Aliquam erat volutpat. Maecenas sagittis mattis urna, at feugiat tellus accumsan ac. Quisque interdum risus turpis, a sollicitudin ex auctor quis. Aenean volutpat eu diam." contentboxanimation="bounceIn" contentboxdelay="600" icon="el-chat"][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Corporate Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box 7', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/icon-box7.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1507197606977{padding-top: 50px !important;padding-bottom: 100px !important;background-color: #f2f2f2 !important;}" el_id="#services"][vc_column][vc_row_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Suspendisse laoreet ante id velit dignissim, in semper ante tristique. Maecenas mattis est vel ipsum iaculis auctor. Curabitur auctor, eros sed condimentum convallis." data_animation="fadeInUp" data_delay="300" icon_family="fontawesome" icon_fontawesome="fa fa-desktop" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h2|font_size:20|line_height:30|letter_spacing:1"]DESKTOP APPS[/apress_gradient_icon_box][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Suspendisse laoreet ante id velit dignissim, in semper ante tristique. Maecenas mattis est vel ipsum iaculis auctor. Curabitur auctor, eros sed condimentum convallis." data_animation="fadeInUp" data_delay="600" icon_family="fontawesome" icon_fontawesome="fa fa-tablet" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h2|font_size:20|line_height:30|letter_spacing:1"]IPAD APPS[/apress_gradient_icon_box][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Suspendisse laoreet ante id velit dignissim, in semper ante tristique. Maecenas mattis est vel ipsum iaculis auctor. Curabitur auctor, eros sed condimentum convallis." data_animation="fadeInUp" data_delay="900" icon_family="fontawesome" icon_fontawesome="fa fa-mobile" gradient_icon_size="70" style="iconbox_style1" title_font_options="tag:h2|font_size:20|line_height:30|letter_spacing:1"]MOBILE APPS[/apress_gradient_icon_box][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][vc_empty_space height="50px"][apress_gradient_icon_box description="Suspendisse laoreet ante id velit dignissim, in semper ante tristique. Maecenas mattis est vel ipsum iaculis auctor. Curabitur auctor, eros sed condimentum convallis." data_animation="fadeInUp" data_delay="300" icon_family="fontawesome" icon_fontawesome="fa fa-shopping-cart" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h2|font_size:20|line_height:30|letter_spacing:1"]ECOMMERCE APPS[/apress_gradient_icon_box][/vc_column_inner][vc_column_inner width="1/3"][vc_empty_space height="50px"][apress_gradient_icon_box description="Suspendisse laoreet ante id velit dignissim, in semper ante tristique. Maecenas mattis est vel ipsum iaculis auctor. Curabitur auctor, eros sed condimentum convallis." data_animation="fadeInUp" data_delay="600" icon_family="fontawesome" icon_fontawesome="fa fa-bar-chart" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h2|font_size:20|line_height:30|letter_spacing:1"]ANALYTICS[/apress_gradient_icon_box][/vc_column_inner][vc_column_inner width="1/3"][vc_empty_space height="50px"][apress_gradient_icon_box description="Suspendisse laoreet ante id velit dignissim, in semper ante tristique. Maecenas mattis est vel ipsum iaculis auctor. Curabitur auctor, eros sed condimentum convallis." data_animation="fadeInUp" data_delay="900" icon_family="fontawesome" icon_fontawesome="fa fa-lightbulb-o" gradient_icon_size="50" style="iconbox_style1" title_font_options="tag:h2|font_size:20|line_height:30|letter_spacing:1"]CONCEPT DEVELOPMENT[/apress_gradient_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	//Corporate Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box 8', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/icon-box8.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1504552273911{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column][apress_heading sub_title="" data_animation="fadeInUp" enable_delimiter="" style="heading_style1" title_font_options="tag:h2|font_size:65|line_height:80" subtitle_font_options="tag:div" heading_margin="margin-bottom:50"]What We Do[/apress_heading][ultimate_spacer height="50" height_on_tabs="50" height_on_tabs_portrait="50"][vc_row_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. " data_animation="fadeInUp" data_delay="300" icon_family="linecons" icon_linecons="vc_li vc_li-lock" style="iconbox_style4" title_font_options="tag:h2"]Secure Applications[/apress_gradient_icon_box][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. " data_animation="fadeInUp" data_delay="600" icon_family="linecons" icon_linecons="vc_li vc_li-pen" style="iconbox_style4" title_font_options="tag:h2"]Custom Applications[/apress_gradient_icon_box][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. " data_animation="fadeInUp" data_delay="900" icon_family="linecons" icon_linecons="vc_li vc_li-camera" style="iconbox_style4" title_font_options="tag:h2"]Image Applications[/apress_gradient_icon_box][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50" height_on_tabs="50" height_on_tabs_portrait="50"][vc_row_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. " data_animation="fadeInUp" data_delay="1200" icon_family="linecons" icon_linecons="vc_li vc_li-news" style="iconbox_style4" title_font_options="tag:h2"]News Applications[/apress_gradient_icon_box][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. " data_animation="fadeInUp" data_delay="1500" icon_family="linecons" icon_linecons="vc_li vc_li-like" style="iconbox_style4" title_font_options="tag:h2"]Facebook Applications[/apress_gradient_icon_box][/vc_column_inner][vc_column_inner width="1/3"][apress_gradient_icon_box description="Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. " data_animation="fadeInUp" data_delay="1800" icon_family="linecons" icon_linecons="vc_li vc_li-sound" style="iconbox_style4" title_font_options="tag:h2"]Music Applications[/apress_gradient_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Maps 1', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/map1.jpg' );
	$data['sort_name'] = 'Maps';
	$data['custom_class'] = 'general map';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1455946933105{padding-top: 80px !important;background-color: #f7f7f7 !important;}"][vc_column][ultimate_google_map height="250px" lat="37.8090329" lng="-122.2823462" zoom="12" map_override="1" pancontrol="false"][/ultimate_google_map][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Maps 2', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/map2.jpg' );
	$data['sort_name'] = 'Maps';
	$data['custom_class'] = 'general map';
	$data['content'] = <<<CONTENT
[vc_row bg_type="theme_default" css=".vc_custom_1400053381620{padding-top: 80px !important;}"][vc_column][ultimate_google_map height="250px" map_type="SATELLITE" lat="24.483582" lng="54.607053" zoom="15" map_override="1" pancontrol="false"][/ultimate_google_map][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Maps 3', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/map3.jpg' );
	$data['sort_name'] = 'Maps';
	$data['custom_class'] = 'general map';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1457502434664{padding-top: 80px !important;background-color: #f7f7f7 !important;}"][vc_column][ultimate_google_map height="250px" lat="25.1977476" lng="55.2743059" zoom="17" map_override="1" pancontrol="false"][/ultimate_google_map][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Maps 4', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/map4.jpg' );
	$data['sort_name'] = 'Maps';
	$data['custom_class'] = 'general map';
	$data['content'] = <<<CONTENT
[vc_row bg_type="theme_default" css=".vc_custom_1400052644011{padding-top: 80px !important;}"][vc_column][ultimate_google_map height="250px" map_type="HYBRID" lat="40.692778" lng="-73.990278" zoom="12" map_override="1" map_style="JTVCJTBBJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJsYW5kc2NhcGUubWFuX21hZGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmdlb21ldHJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvbiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMmNvbG9yJTIyJTNBJTIwJTIyJTIzOWI5NTk1JTIyJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTVEJTBBJT
IwJTIwJTdEJTJDJTdCJTBBJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJyb2FkLmhpZ2h3YXklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIyY29sb3IlMjIlM0ElMjAlMjIlMjNlMWUxNDMlMjIlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ3ZWlnaHQlMjIlM0ElMjAwLjYlMjAlN0QlMEElMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlN0QlMkMlN0IlMEElMjAlMjAlMjAlMjAlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMCUyMnJvYWQuYXJ0ZXJpYWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmdlb21ldHJ5LmZpbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIyZ2FtbWElMjIlM0ElMjAxLjUlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ2aXNpYmlsaXR5JTIyJTNBJTIwJTIyb24lMjIlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJjb2xvciUyMiUzQSUyMCUyMiUyM2U5MWIwMiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMndlaWdodCUyMiUzQSUyMDAuMyUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCU3RCUwQSU1RA==" pancontrol="false"][/ultimate_google_map][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Maps 5', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/map5.jpg' );
	$data['sort_name'] = 'Maps';
	$data['custom_class'] = 'general map';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1455946952066{padding-top: 50px !important;padding-bottom: 50px !important;background-color: #f7f7f7 !important;}"][vc_column][ultimate_heading main_heading="FULL RESPONSIVE IN NATURE" main_heading_color="#6d6d6d" spacer="line_only" spacer_position="middle" line_height="4" line_color="#f9a639" main_heading_style="font-weight:bold;" main_heading_font_size="desktop:24px;" line_width="100" sub_heading_margin="margin-top:-10px;" spacer_margin="margin-top:10px;"]
<p style="text-align: center;">Maps are fully responsive in nature, to check this out, you can resize your browser.</p>

[/ultimate_heading][ultimate_google_map map_type="TERRAIN" lat="40.692778" lng="-73.990278" zoom="12" scrollwheel="disable" marker_icon="custom" zoomcontrol="true" pancontrol="true"][/ultimate_google_map][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'pricing 1', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/pricing1.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1500799550796{padding-top: 50px !important;padding-bottom: 100px !important;background-color: #f7f7f7 !important;}"][vc_column][apress_heading sub_title="OUR PRICING" enable_delimiter="" style="heading_style2" title_font_options="tag:h2|letter_spacing:1|font_style_bold:1" subtitle_font_options="tag:div" title_responsive="font_size_tablet:35|line_height_tablet:45|letter_spacing_tablet:1|font_size_mobile:25|line_height_mobile:35|letter_spacing_mobile:1"]Select you plan[/apress_heading][ultimate_spacer height="100"][vc_row_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="primary_color_scheme" title="Basic" data_animation="fadeInUp" data_delay="300" button_text="BUY NOW" button_size="medium" button_shape="round" price_google_fonts="yes" style="pricing_table_style1" title_font_options="tag:h2|letter_spacing:1" content_features_font_options="tag:div" price_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris quis elit nec sem laoreet tempor sit amet a quam[/apress_pricing_table][/vc_column_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="primary_color_scheme" title="Advanced" price="39" featured_pricing="yes" data_animation="fadeInUp" data_delay="600" button_text="BUY NOW" button_size="medium" button_shape="round" price_google_fonts="yes" style="pricing_table_style1" title_font_options="tag:h2|letter_spacing:1" content_features_font_options="tag:div" price_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris quis elit nec sem laoreet tempor sit amet a quam[/apress_pricing_table][/vc_column_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="primary_color_scheme" title="Enterprise" price="99" data_animation="fadeInUp" data_delay="900" button_text="BUY NOW" button_size="medium" button_shape="round" price_google_fonts="yes" style="pricing_table_style1" title_font_options="tag:h2|letter_spacing:1" content_features_font_options="tag:div" price_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris quis elit nec sem laoreet tempor sit amet a quam[/apress_pricing_table][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'pricing 2', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/pricing2.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1474636193794{padding-bottom: 100px !important;background-color: #ffffff !important;}"][vc_column css=".vc_custom_1464100748230{padding-top: 0px !important;}"][ultimate_spacer height="91" height_on_tabs="91" height_on_tabs_portrait="91" height_on_mob_landscape="91" height_on_mob="91"][ultimate_heading main_heading="Plans and Pricing" main_heading_color="#373737" sub_heading_color="#373737" main_heading_font_size="desktop:34px;" main_heading_line_height="desktop:40px;" sub_heading_font_size="desktop:18px;" sub_heading_line_height="desktop:30px;" main_heading_margin="margin-bottom:10px;" sub_heading_margin="margin-bottom:30px;"]Try APRESS Theme risk free with 30-Day Money Back Guarantee ![/ultimate_heading][ultimate_spacer height="60" height_on_tabs="60" height_on_tabs_portrait="60" height_on_mob_landscape="60" height_on_mob="60"][vc_row_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="design_your_own" highlight_color="#8e54e9" title="BASIC" pricing_box_swing="yes" data_animation="fadeInUp" data_delay="300" button_text="Sign Up" button_size="medium" button_bg_color="#8e54e9" button_bg_color_h="#8e54e9" button_border_color="#8e54e9" button_border_color_h="#8e54e9" style="pricing_table_style2" title_font_options="tag:h2" content_features_font_options="tag:div" button_font_options="letter_spacing:1"]10 Emails
x
x
Email Support
5 GB Storage[/apress_pricing_table][/vc_column_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="design_your_own" highlight_color="#8224e3" title="ADVANCED" featured_pricing="yes" pricing_box_swing="yes" data_animation="fadeInUp" data_delay="600" button_text="Sign Up" button_size="medium" button_bg_color="#8224e3" button_bg_color_h="#8224e3" button_border_color="#8224e3" button_border_color_h="#8224e3" style="pricing_table_style2" title_font_options="tag:h2" content_features_font_options="tag:div" button_font_options="letter_spacing:1"]10 Emails
20 GB Bandwidth
x
Email Support
5 GB Storage[/apress_pricing_table][/vc_column_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="design_your_own" highlight_color="#8e54e9" title="ENTERPRISE" pricing_box_swing="yes" data_animation="fadeInUp" data_delay="900" button_text="Sign Up" button_bg_color="#8e54e9" button_bg_color_h="#8e54e9" button_border_color="#8e54e9" button_border_color_h="#8e54e9" style="pricing_table_style2" title_font_options="tag:h2" content_features_font_options="tag:div" button_font_options="letter_spacing:1"]10 Emails
30 GB Bandwidth
Phone Support
Email Support
5 GB Storage[/apress_pricing_table][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'pricing 3', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/pricing3.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" equal_height="yes" content_placement="middle" css=".vc_custom_1502695909235{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #f2f2f2 !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="primary_color_scheme" title="BASIC" pricing_box_swing="yes" enable_icon="yes" icon_family="linecons" button_size="large" button_shape="rounded" style="pricing_table_style1" title_font_options="tag:h2" content_features_font_options="tag:div"]32 GB storage
Free Maintenance
Fully SEO Featured
Unlimited Data Transfer
Easy Payment[/apress_pricing_table][/vc_column_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="primary_color_scheme" title="ADVANCED" price="39" featured_pricing="yes" pricing_box_swing="yes" enable_icon="yes" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" button_size="large" button_shape="rounded" style="pricing_table_style1" title_font_options="tag:h2" content_features_font_options="tag:div"]32 GB storage
Free Maintenance
Fully SEO Featured
Unlimited Data Transfer
Easy Payment[/apress_pricing_table][/vc_column_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="primary_color_scheme" title="ENTERPRISE" price="99" pricing_box_swing="yes" enable_icon="yes" icon_family="linecons" icon_linecons="vc_li vc_li-cloud" button_size="large" button_shape="rounded" style="pricing_table_style1" title_font_options="tag:h2" content_features_font_options="tag:div"]32 GB storage
Free Maintenance
Fully SEO Featured
Unlimited Data Transfer
Easy Payment[/apress_pricing_table][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'pricing 4', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/pricing4.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" equal_height="yes" content_placement="middle" css=".vc_custom_1502695909235{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #f2f2f2 !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="gradient_scheme1" title="BASIC" pricing_box_swing="yes" enable_icon="yes" icon_family="linecons" button_size="large" button_shape="rounded" style="pricing_table_style2" title_font_options="tag:h2" content_features_font_options="tag:div"]32 GB storage
Free Maintenance
Fully SEO Featured
Unlimited Data Transfer
Easy Payment[/apress_pricing_table][/vc_column_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="gradient_scheme1" title="ADVANCED" price="39" featured_pricing="yes" pricing_box_swing="yes" enable_icon="yes" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" button_size="large" button_shape="rounded" style="pricing_table_style2" title_font_options="tag:h2" content_features_font_options="tag:div"]32 GB storage
Free Maintenance
Fully SEO Featured
Unlimited Data Transfer
Easy Payment[/apress_pricing_table][/vc_column_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="gradient_scheme1" title="ENTERPRISE" price="99" pricing_box_swing="yes" enable_icon="yes" icon_family="linecons" icon_linecons="vc_li vc_li-cloud" button_size="large" button_shape="rounded" style="pricing_table_style2" title_font_options="tag:h2" content_features_font_options="tag:div"]32 GB storage
Free Maintenance
Fully SEO Featured
Unlimited Data Transfer
Easy Payment[/apress_pricing_table][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'pricing 5', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/pricing5.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" equal_height="yes" content_placement="middle" css=".vc_custom_1502695951865{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="primary_color_scheme" title="BASIC" button_size="medium" style="pricing_table_style1" title_font_options="tag:h2" content_features_font_options="tag:div"]Sorem ipsum dolor sit amet,Consectetur adipiscing elit.Mauris quis elit nec sem laoreet. Tempor sit amet a quam. Lorem ipsum dolor sit amet,[/apress_pricing_table][/vc_column_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="primary_color_scheme" title="ADVANCED" price="39" featured_pricing="yes" button_size="medium" style="pricing_table_style1" title_font_options="tag:h2" content_features_font_options="tag:div"]Sorem ipsum dolor sit amet,Consectetur adipiscing elit.Mauris quis elit nec sem laoreet. Tempor sit amet a quam. Lorem ipsum dolor sit amet,[/apress_pricing_table][/vc_column_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="primary_color_scheme" title="ENTERPRISE" price="99" button_size="medium" style="pricing_table_style1" title_font_options="tag:h2" content_features_font_options="tag:div"]Sorem ipsum dolor sit amet,Consectetur adipiscing elit.Mauris quis elit nec sem laoreet. Tempor sit amet a quam. Lorem ipsum dolor sit amet,[/apress_pricing_table][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'pricing 6', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/pricing6.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" equal_height="yes" content_placement="middle" css=".vc_custom_1502695909235{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #f2f2f2 !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="primary_color_scheme" title="BASIC" pricing_box_swing="yes" enable_icon="yes" icon_family="linecons" button_size="large" button_shape="rounded" style="pricing_table_style1" title_font_options="tag:h2" content_features_font_options="tag:div"]32 GB storage
Free Maintenance
Fully SEO Featured
Unlimited Data Transfer
Easy Payment[/apress_pricing_table][/vc_column_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="primary_color_scheme" title="ADVANCED" price="39" featured_pricing="yes" pricing_box_swing="yes" enable_icon="yes" icon_family="linecons" icon_linecons="vc_li vc_li-bulb" button_size="large" button_shape="rounded" style="pricing_table_style1" title_font_options="tag:h2" content_features_font_options="tag:div"]32 GB storage
Free Maintenance
Fully SEO Featured
Unlimited Data Transfer
Easy Payment[/apress_pricing_table][/vc_column_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="primary_color_scheme" title="ENTERPRISE" price="99" pricing_box_swing="yes" enable_icon="yes" icon_family="linecons" icon_linecons="vc_li vc_li-cloud" button_size="large" button_shape="rounded" style="pricing_table_style1" title_font_options="tag:h2" content_features_font_options="tag:div"]32 GB storage
Free Maintenance
Fully SEO Featured
Unlimited Data Transfer
Easy Payment[/apress_pricing_table][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'pricing 7', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/pricing7.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" equal_height="yes" content_placement="middle" css=".vc_custom_1502695951865{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="design_your_own" highlight_color="#f9ba48" title="BASIC" enable_icon="yes" icon_to_display="image" button_size="large" button_shape="rounded" button_hover_style="hoverstyle2" button_bg_color="rgba(82,149,234,0.01)" button_bg_color_h="#f9ba48" button_text_color="#f9ba48" button_border_color="#f9ba48" button_border_color_h="#f9ba48" style="pricing_table_style3" title_font_options="tag:h2|color:%23ffffff" content_features_font_options="tag:div" upload_image="1808" icon_size="100"]Sorem ipsum dolor sit amet,Consectetur adipiscing elit.Mauris quis elit nec sem laoreet. Tempor sit amet a quam. Lorem ipsum dolor sit amet,[/apress_pricing_table][/vc_column_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="design_your_own" highlight_color="#f9ba48" title="ADVANCED" price="39" featured_pricing="yes" enable_icon="yes" icon_to_display="image" button_size="large" button_hover_style="hoverstyle4" button_bg_color="rgba(82,149,234,0.01)" button_bg_color_h="#f9ba48" button_text_color="#f9ba48" button_border_color="#f9ba48" button_border_color_h="#f9ba48" style="pricing_table_style3" title_font_options="tag:h2|color:%23ffffff" content_features_font_options="tag:div" upload_image="1807" icon_size="100"]Sorem ipsum dolor sit amet,Consectetur adipiscing elit.Mauris quis elit nec sem laoreet. Tempor sit amet a quam. Lorem ipsum dolor sit amet,[/apress_pricing_table][/vc_column_inner][vc_column_inner width="1/3"][apress_pricing_table color_scheme="design_your_own" highlight_color="#f9ba48" title="ENTERPRISE" price="99" enable_icon="yes" icon_to_display="image" button_size="large" button_bg_color="rgba(82,149,234,0.01)" button_bg_color_h="#f9ba48" button_text_color="#f9ba48" button_border_color="#f9ba48" button_border_color_h="#f9ba48" style="pricing_table_style3" title_font_options="tag:h2|color:%23ffffff" content_features_font_options="tag:div" upload_image="2086" icon_size="100"]Sorem ipsum dolor sit amet,Consectetur adipiscing elit.Mauris quis elit nec sem laoreet. Tempor sit amet a quam. Lorem ipsum dolor sit amet,[/apress_pricing_table][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'pricing 8', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/pricing8.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1470982091861{padding-bottom: 80px !important;}"][vc_column width="1/4"][ultimate_pricing color_scheme="custom" color_bg_highlight="#bfc946" package_heading="PRICING PLAN 1" package_sub_heading="For Beginners" package_price="$100" package_unit="Per Month" package_btn_text="BUY NOW" package_name_font_style="font-weight:bold;" package_name_font_size="desktop:25px;" package_name_line_height="desktop:30px;" subheading_font_size="desktop:17px;" subheading_line_height="desktop:22px;" price_font_style="font-weight:bold;" price_font_size="desktop:20px;" price_line_height="desktop:24px;" price_unit_font_size="desktop:14px;" price_unit_line_height="desktop:18px;" features_font_size="desktop:16px;" features_line_height="desktop:40px;" button_font_size="desktop:16px;" button_line_height="desktop:24px;"]15 Emails Accounts
50 GB Bandwidth
1 MySQL Database
Daily Backup
Web File Management[/ultimate_pricing][/vc_column][vc_column width="1/4"][ultimate_pricing color_scheme="custom" color_bg_highlight="#ffce5f" package_heading="PRICING PLAN 2" package_sub_heading="For Pro" package_price="$150" package_unit="Per Month" package_btn_text="BUY NOW" package_name_font_size="desktop:25px;" package_name_line_height="desktop:30px;" package_name_font_style="font-weight:bold;" subheading_font_size="desktop:17px;" subheading_line_height="desktop:22px;" price_font_style="font-weight:bold;" price_font_size="desktop:20px;" price_line_height="desktop:24px;" price_unit_font_size="desktop:14px;" price_unit_line_height="desktop:18px;" features_font_size="desktop:16px;" features_line_height="desktop:40px;" button_font_size="desktop:16px;" button_line_height="desktop:24px;"]25 Emails Accounts
100 GB Bandwidth
10 MySQL Database
Daily Backup
Web File Management[/ultimate_pricing][/vc_column][vc_column width="1/4"][ultimate_pricing color_scheme="custom" color_bg_highlight="#fb8267" package_heading="PRICING PLAN 3" package_sub_heading="For Business" package_price="$200" package_unit="Per Month" package_btn_text="BUY NOW" package_featured="enable" package_name_font_size="desktop:25px;" package_name_line_height="desktop:30px;" package_name_font_style="font-weight:bold;" subheading_font_size="desktop:17px;" subheading_line_height="desktop:22px;" price_font_size="desktop:20px;" price_line_height="desktop:24px;" price_font_style="font-weight:bold;" price_unit_font_size="desktop:14px;" price_unit_line_height="desktop:18px;" features_font_size="desktop:16px;" features_line_height="desktop:40px;" button_font_size="desktop:16px;" button_line_height="desktop:24px;"]50 Emails Accounts
200 GB Bandwidth
30 MySQL Database
Daily Backup
Web File Management[/ultimate_pricing][/vc_column][vc_column width="1/4"][ultimate_pricing color_scheme="custom" color_bg_highlight="#c44767" package_heading="PRICING LIST 4" package_sub_heading="For Experts" package_price="$300" package_unit="Per Month" package_btn_text="BUY NOW" package_name_font_size="desktop:25px;" package_name_line_height="desktop:30px;" package_name_font_style="font-weight:bold;" subheading_font_size="desktop:17px;" subheading_line_height="desktop:22px;" price_font_size="desktop:20px;" price_line_height="desktop:24px;" price_font_style="font-weight:bold;" price_unit_font_size="desktop:14px;" price_unit_line_height="desktop:18px;" features_font_size="desktop:16px;" features_line_height="desktop:40px;" button_font_size="desktop:16px;" button_line_height="desktop:24px;"]100 Emails Accounts
500 GB Bandwidth
50 MySQL Database
Daily Backup
Web File Management[/ultimate_pricing][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'pricing 9', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/pricing9.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-default" bg_image_new="id^1931|url^http://apresswp.com/demo1/wp-content/uploads/2017/09/bg2.jpg|caption^null|alt^null|title^Counter_Circle_bg|description^null" bg_override="full" css=".vc_custom_1470982124727{padding-top: 80px !important;padding-bottom: 80px !important;}"][vc_column width="1/3"][ultimate_pricing design_style="design02" color_scheme="custom" color_bg_main="#ffffff" color_bg_highlight="#3a6ee8" package_heading="Silver Plan" package_price="$35" package_unit="/Per Month" package_btn_text="BUY NOW" price_font_color="#3a6ee8" price_unit_font_color="#9d9d9d" package_name_font_size="desktop:26px;" package_name_line_height="desktop:34px;" price_font_size="desktop:50px;" price_line_height="desktop:60px;" price_unit_font_size="desktop:13px;" price_unit_line_height="desktop:16px;" features_font_size="desktop:16px;" features_line_height="desktop:40px;" button_font_size="desktop:16px;" button_line_height="desktop:24px;" price_unit_font_style="font-style:italic;"]

    32 GB storage
    Free Maintenance
    Fully SEO Featured
    Unlimited Data Transfer
    Easy Payment

[/ultimate_pricing][/vc_column][vc_column width="1/3"][ultimate_pricing design_style="design02" color_scheme="custom" color_bg_main="#ffffff" color_bg_highlight="#ff2b2b" package_heading="Gold Plan" package_sub_heading="Best Value" package_price="$50" package_unit="/Per Month" package_btn_text="BUY NOW" package_featured="enable" subheading_font_color="#ffffff" price_font_color="#ff2b2b" price_unit_font_color="#9d9d9d" package_name_font_size="desktop:26px;" package_name_line_height="desktop:34px;" subheading_font_size="desktop:18px;" subheading_line_height="desktop:34px;" price_font_size="desktop:50px;" price_line_height="desktop:60px;" price_unit_font_style="font-style:italic;" price_unit_font_size="desktop:13px;" price_unit_line_height="desktop:16px;" features_font_size="desktop:16px;" features_line_height="desktop:40px;" button_font_size="desktop:16px;" button_line_height="desktop:24px;"]

    120 GB Storage
    Free Maintenance
    Fully SEO Featured
    Unlimited Data Transfer
    Easy Payment

[/ultimate_pricing][/vc_column][vc_column width="1/3"][ultimate_pricing design_style="design02" color_scheme="custom" color_bg_main="#ffffff" color_bg_highlight="#a65bf4" package_heading="Platinum Plan" package_price="$120" package_unit="/Per Month" package_btn_text="BUY NOW" price_font_color="#a65bf4" price_unit_font_color="#9d9d9d" package_name_font_size="desktop:26px;" package_name_line_height="desktop:34px;" price_font_size="desktop:50px;" price_line_height="desktop:60px;" price_unit_font_size="desktop:13px;" price_unit_line_height="desktop:16px;" features_font_size="desktop:16px;" features_line_height="desktop:40px;" button_font_size="desktop:16px;" button_line_height="desktop:24px;" price_unit_font_style="font-style:italic;"]

    32 GB storage
    Free Maintenance
    Fully SEO Featured
    Unlimited Data Transfer
    Easy Payment

[/ultimate_pricing][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'pricing 10', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/pricing10.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1505725829628{padding-top: 50px !important;padding-bottom: 120px !important;}"][vc_column][apress_heading sub_title="Show your menu on any page, post or column style without any coding." enable_delimiter="" color_scheme="design_your_own" style="heading_style1" heading_margin="margin-bottom:10" title_font_options="tag:h2" subtitle_font_options="tag:div"]Pricing List Style 1 ( Without thumbnail )[/apress_heading][ultimate_spacer height="100"][vc_row_inner][vc_column_inner width="1/2"][apress_text_separator title="Starters" title_align="separator_align_left" color="#e8e8e8" title_font_options="tag:h2"][apress_pricing_list pricing_list_title="Cold Meat Platter" pricing_list_price="$6" description_text="Sed ullamcorper ex et pharetra scelerisque." enable_highlighted_item="yes" pricing_list_highlight_title="SPECIAL" color_scheme="design_your_own" pricing_list_highlight_title_bg_color="#f45c43" title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_title="Tomato Soup" pricing_list_price="$5" description_text="Sed ullamcorper ex et pharetra scelerisque." title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_title="Prawn Salad" pricing_list_price="$2" description_text="Sed ullamcorper ex et pharetra scelerisque." title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_title="Hunter Pastry" pricing_list_price="$6" description_text="Sed ullamcorper ex et pharetra scelerisque." title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_title="Crab Claw Soup" pricing_list_price="$5" description_text="Sed ullamcorper ex et pharetra scelerisque." title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_title="Prawn Salad" pricing_list_price="$2" description_text="Sed ullamcorper ex et pharetra scelerisque." title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][/vc_column_inner][vc_column_inner width="1/2"][apress_text_separator title="Mains" title_align="separator_align_left" color="#e8e8e8" title_font_options="tag:h2"][apress_pricing_list pricing_list_title="Grilled Lamb Tenderloins" pricing_list_price="$9" description_text="Sed ullamcorper ex et pharetra scelerisque." enable_highlighted_item="yes" pricing_list_highlight_title="SPECIAL" color_scheme="gradient_scheme1" title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_title="Catfish & Shrimp Combo" pricing_list_price="$10" description_text="Sed ullamcorper ex et pharetra scelerisque." enable_highlighted_item="" title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_title="Chicken Wings " pricing_list_price="$5" description_text="Sed ullamcorper ex et pharetra scelerisque." enable_highlighted_item="" title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_title="Tuna Grilled" pricing_list_price="$10" description_text="Sed ullamcorper ex et pharetra scelerisque." enable_highlighted_item="" title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_title="Catfish & Shrimp Combo" pricing_list_price="$10" description_text="Sed ullamcorper ex et pharetra scelerisque." enable_highlighted_item="" title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_title="Fish BBQ" pricing_list_price="$10" description_text="Sed ullamcorper ex et pharetra scelerisque." enable_highlighted_item="" title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'pricing 11', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/pricing11.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1505725854126{padding-top: 100px !important;padding-bottom: 150px !important;background-color: #ededed !important;}"][vc_column][apress_heading sub_title="Show your menu on any page, post or column style without any coding." enable_delimiter="" color_scheme="design_your_own" style="heading_style1" heading_margin="margin-bottom:10" title_font_options="tag:h2" subtitle_font_options="tag:div"]Pricing List Style 2 ( With thumbnail )[/apress_heading][ultimate_spacer height="100"][vc_row_inner][vc_column_inner width="1/2"][apress_text_separator title="Starters" title_align="separator_align_left" color="#aaaaaa" title_font_options="tag:h2"][apress_pricing_list pricing_list_image="1828" pricing_list_title="Cold Meat Platter" pricing_list_price="$6" description_text="Sed ullamcorper ex et pharetra scelerisque." enable_highlighted_item="yes" pricing_list_highlight_title="SPECIAL" color_scheme="design_your_own" pricing_list_highlight_title_bg_color="#f45c43" title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_image="1834" pricing_list_title="Tomato Soup" pricing_list_price="$5" description_text="Sed ullamcorper ex et pharetra scelerisque." title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_image="1833" pricing_list_title="Prawn Salad" pricing_list_price="$2" description_text="Sed ullamcorper ex et pharetra scelerisque." title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_image="1832" pricing_list_title="Pastry King" pricing_list_price="$6" description_text="Sed ullamcorper ex et pharetra scelerisque." title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_image="1829" pricing_list_title="Crab Claw Soup" pricing_list_price="$5" description_text="Sed ullamcorper ex et pharetra scelerisque." title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_image="1833" pricing_list_title="Prawn Salad" pricing_list_price="$2" description_text="Sed ullamcorper ex et pharetra scelerisque." title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][/vc_column_inner][vc_column_inner width="1/2"][apress_text_separator title="Mains" title_align="separator_align_left" color="#aaaaaa" title_font_options="tag:h2"][apress_pricing_list pricing_list_image="1831" pricing_list_title="Grilled Lamb Tenderloins" pricing_list_price="$9" description_text="Sed ullamcorper ex et pharetra scelerisque." enable_highlighted_item="yes" pricing_list_highlight_title="SPECIAL" color_scheme="gradient_scheme1" title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_image="1826" pricing_list_title="Catfish & Shrimp Combo" pricing_list_price="$10" description_text="Sed ullamcorper ex et pharetra scelerisque." enable_highlighted_item="" title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_image="1827" pricing_list_title="Chicken Breast" pricing_list_price="$5" description_text="Sed ullamcorper ex et pharetra scelerisque." enable_highlighted_item="" title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_image="1825" pricing_list_title="Tuna Grilled" pricing_list_price="$10" description_text="Sed ullamcorper ex et pharetra scelerisque." enable_highlighted_item="" title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_image="1826" pricing_list_title="Catfish & Shrimp Combo" pricing_list_price="$10" description_text="Sed ullamcorper ex et pharetra scelerisque." enable_highlighted_item="" title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][apress_pricing_list pricing_list_image="1830" pricing_list_title="Lamb BBQ" pricing_list_price="$10" description_text="Sed ullamcorper ex et pharetra scelerisque." enable_highlighted_item="" title_font_options="font_size:20|color:%23333333|line_height:30|letter_spacing:1"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Service 1', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/service1.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1474463301052{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column width="1/2"][vc_single_image image="1097" img_size="full" css_animation="fadeInDown"][/vc_column][vc_column width="1/2"][vc_column_text css_animation="top-to-bottom"]
<h2>TOTAL CREATIVE SOLUTIONS</h2>
Nunc sit amet mollis nunc, quis venenatis orci. Nullam in odio eu velit tristique rhoncus nec ac odio. Nulla ac augue nec nulla pharetra vulputate id vitae mi.Nunc sit amet mollis nunc, quis venenatis orci. Nullam in odio eu velit tristique rhoncus nec ac odio. Nulla ac augue nec nulla pharetra vulputate id vitae mi.[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1474463458619{padding-top: 10px !important;padding-bottom: 50px !important;}"][vc_column width="1/3"][apress_counter_circle data_percent_value="50" bar_color="#8659d6" scale_color="#ffffff" line_cap="square" line_width="5" size="200" c_circle_data="zt_circle_text" circle_text="50% " circlefontcolor="#8659d6"][vc_column_text]
<h3 style="text-align: center;">FASTER</h3>
[/vc_column_text][/vc_column][vc_column width="1/3"][apress_counter_circle data_percent_value="85" bar_color="#8659d6" scale_color="#ffffff" line_cap="square" line_width="5" size="200" c_circle_data="zt_circle_text" circle_text="85 %" circlefontcolor="#8659d6"][vc_column_text]
<h3 style="text-align: center;">EFFICIENT</h3>
[/vc_column_text][/vc_column][vc_column width="1/3"][apress_counter_circle data_percent_value="95" bar_color="#8659d6" scale_color="#ffffff" line_cap="square" line_width="5" size="200" c_circle_data="zt_circle_text" circle_text="95 %" circlefontcolor="#8659d6"][vc_column_text]
<h3 style="text-align: center;">RELIABLE</h3>
[/vc_column_text][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Service 2', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/service2.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1474463443289{padding-top: 10px !important;padding-bottom: 74px !important;}"][vc_column width="1/3"][apress_imagebox imagebox_style="style2" imagebox_image="576" imagebox_title="WORDPRESS" imagebox_title_fonsize="20" imagebox_title_color="" imagebox_description_color="#757575" imagebox_button_size="medium" imagebox_button_text="READ MORE" imagebox_buttonfontcolorhover="#8659d6" imagebox_buttonbackgroundcolor="#8659d6" imagebox_buttonbordercolor="#8659d6" imagebox_buttonbordercolorhover="#8659d6" data_animation="fadeIn" data_delay="100"]Your Description Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column][vc_column width="1/3"][apress_imagebox imagebox_style="style2" imagebox_image="575" imagebox_title="DESIGNING" imagebox_title_fonsize="20" imagebox_title_color="" imagebox_description_color="#757575" imagebox_button_size="medium" imagebox_button_text="READ MORE" imagebox_buttonfontcolorhover="#8659d6" imagebox_buttonbackgroundcolor="#8659d6" imagebox_buttonbordercolor="#8659d6" imagebox_buttonbordercolorhover="#8659d6" data_animation="fadeIn" data_delay="200"]Your Description Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column][vc_column width="1/3"][apress_imagebox imagebox_style="style2" imagebox_image="574" imagebox_title="COPYRIGHTING" imagebox_title_fonsize="20" imagebox_title_color="" imagebox_description_color="#757575" imagebox_button_size="medium" imagebox_button_text="READ MORE" imagebox_buttonfontcolorhover="#8659d6" imagebox_buttonbackgroundcolor="#8659d6" imagebox_buttonbordercolor="#8659d6" imagebox_buttonbordercolorhover="#8659d6" data_animation="fadeIn" data_delay="300"]Your Description Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Service 3', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/service3.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1474462850477{padding-top: 150px !important;padding-bottom: 50px !important;}"][vc_column width="1/2"][vc_single_image image="1097" img_size="full" alignment="center" css_animation="fadeInLeft"][/vc_column][vc_column width="1/2"][vc_column_text css_animation="fadeInRight"]
<h2>WE DESIGN FULLY CUSTOMIZABLE WORDPRESS THEMES.</h2>
Nullam sem diam, gravida eu posuere quis, bibendum nec neque. Nunc sed gravida ex. Praesent porta auctor dolor, eget pretium elit eleifend vel. Integer sagittis elementum quam, sed porttitor lectus aliquam eu. Aliquam pulvinar gravida dolor vel placerat. Pellentesque malesuada sapien at ante malesuada efficitur vitae ac sapien. Curabitur nec mollis massa.[/vc_column_text][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1474462861744{padding-top: 70px !important;padding-bottom: 50px !important;}"][vc_column width="1/2"][vc_column_text]
<h2>MOBILE APP DEVELOPMENT</h2>
Nullam sem diam, gravida eu posuere quis, bibendum nec neque. Nunc sed gravida ex. Praesent porta auctor dolor, eget pretium elit eleifend vel. Integer sagittis elementum quam, sed porttitor lectus aliquam eu. Aliquam pulvinar gravida dolor vel placerat. Pellentesque malesuada sapien at ante malesuada efficitur vitae ac sapien. Curabitur nec mollis massa.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_single_image image="484" img_size="full" alignment="center" css_animation="bottom-to-top"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1474462874998{padding-top: 70px !important;padding-bottom: 50px !important;}"][vc_column width="1/2"][vc_single_image image="478" img_size="full" alignment="center" css_animation="bottom-to-top"][/vc_column][vc_column width="1/2"][vc_column_text]
<h2>PHOTOSHOP DESIGN</h2>
Nullam sem diam, gravida eu posuere quis, bibendum nec neque. Nunc sed gravida ex. Praesent porta auctor dolor, eget pretium elit eleifend vel. Integer sagittis elementum quam, sed porttitor lectus aliquam eu. Aliquam pulvinar gravida dolor vel placerat. Pellentesque malesuada sapien at ante malesuada efficitur vitae ac sapien. Curabitur nec mollis massa.[/vc_column_text][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Service 4', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/service4.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row gap="10" content_placement="middle" css=".vc_custom_1474462592059{margin-right: 0px !important;padding-bottom: 95px !important;}"][vc_column width="1/2" css=".vc_custom_1473583983301{padding-right: 10% !important;padding-left: 10% !important;}" offset="vc_col-lg-offset-0 vc_col-md-offset-0 vc_col-sm-offset-0"][ultimate_heading main_heading="Why Choose APRESS" alignment="left" main_heading_margin="margin-top:50px;margin-bottom:50x;" sub_heading_margin="margin-bottom:10px;" main_heading_font_size="desktop:30px;tablet:25px;tablet_portrait:20px;mobile_landscape:20px;mobile:20px;" main_heading_line_height="desktop:60px;tablet:50px;tablet_portrait:40px;mobile_landscape:40px;mobile:40px;" sub_heading_font_size="desktop:16px;tablet:16px;tablet_portrait:16px;mobile_landscape:16px;mobile:16px;" sub_heading_line_height="desktop:26px;tablet:25px;tablet_portrait:25px;mobile_landscape:25px;mobile:25px;"]Sed imperdiet bibendum purus nec tristique. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.[/ultimate_heading][ultimate_spacer height="10"][vc_row_inner][vc_column_inner][apress_icon_box iconcolor="#8659d6" icon_size="50" contentboxtitle_size="20" title_desc_color="#757575" icon_family="openiconic" icon_openiconic="vc-oi vc-oi-aperture" contentboxtitle="Drag N Drop Header Builder" contentboxarea="APRESS has unique Drag N Drop header builder for creating any kind of website ,both horizontal and vertical." icon="el-clipboard"][ultimate_spacer height="10"][apress_icon_box iconcolor="#8659d6" icon_size="50" contentboxtitle_size="20" title_desc_color="#757575" icon_family="openiconic" icon_openiconic="vc-oi vc-oi-layers" contentboxtitle="Unlimited Layouts" contentboxarea="With APRESS you can easily manage different looks for pages,posts and portfolio . Simply select the options ." icon="el-tools-2"][ultimate_spacer height="10"][apress_icon_box iconcolor="#8659d6" icon_size="50" contentboxtitle_size="20" title_desc_color="#757575" icon_family="openiconic" icon_openiconic="vc-oi vc-oi-download-cloud" contentboxtitle="80 + VC Elements" contentboxarea="ZPLUS theme is fully Visual Composer ready and has 80+ custom elements .All fully editable." icon="el-layers"][ultimate_spacer height="10"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" css=".vc_custom_1473428822970{margin-right: 0px !important;padding-right: 0px !important;}"][ultimate_spacer height="100" height_on_tabs="70" height_on_tabs_portrait="50" height_on_mob_landscape="50" height_on_mob="50"][vc_single_image image="1097" img_size="full" alignment="right" css_animation="bottom-to-top"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Service 5', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/service5.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-default" bg_image_new="id^585|url^http://apresswp.com/demo1/wp-content/uploads/2016/09/new-slide01.jpg|caption^null|alt^null|title^new-slide01|description^null" css=".vc_custom_1507373605359{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column css=".vc_custom_1473430252985{padding-top: 100px !important;padding-bottom: 100px !important;}"][/vc_column][/vc_row][vc_row css=".vc_custom_1474461305565{padding-top: 75px !important;padding-bottom: 65px !important;}"][vc_column][ultimate_heading main_heading="WE DESIGN FULLY CUSTOMIZABLE WORDPRESS THEMES. " main_heading_color="#8659d6" sub_heading_color="#757575" main_heading_font_size="desktop:35px;tablet:25px;tablet_portrait:20px;mobile_landscape:20px;mobile:20px;" main_heading_line_height="desktop:50px;tablet:40px;tablet_portrait:30px;mobile_landscape:30px;mobile:30px;" main_heading_margin="margin-bottom:20px;" sub_heading_font_size="desktop:24px;tablet:20px;tablet_portrait:20px;mobile_landscape:20px;mobile:20px;" sub_heading_line_height="desktop:50px;tablet:20px;tablet_portrait:20px;mobile_landscape:20px;mobile:20px;"]EASY TO USE BY BEGINNER AND ADVANCED DEVELOPERS[/ultimate_heading][/vc_column][/vc_row][vc_row css=".vc_custom_1474462577648{padding-top: 30px !important;padding-bottom: 35px !important;}"][vc_column width="1/3"][apress_icon_box iconcolor="#8659d6" contentboxtitle_size="20" title_desc_color="#757575" icon_family="linecons" icon_linecons="vc_li vc_li-params" contentboxtitle="POWERFUL ADMIN"][/vc_column][vc_column width="1/3"][apress_icon_box iconcolor="#8659d6" contentboxtitle_size="20" title_desc_color="#757575" icon_family="linecons" icon_linecons="vc_li vc_li-paperplane" contentboxtitle="DRAG N DROP" icon="wb-layers"][/vc_column][vc_column width="1/3"][apress_icon_box iconcolor="#8659d6" contentboxtitle_size="20" title_desc_color="#757575" icon_family="linecons" icon_linecons="vc_li vc_li-like" contentboxtitle="ONE CLICK SET UP" icon="zm-settings"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Service 6', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/service6.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][ultimate_heading main_heading="Industry We Serve" main_heading_font_size="desktop:40px;" main_heading_line_height="desktop:50px;" main_heading_margin="margin-top:90px;margin-bottom:50px;"][/ultimate_heading][/vc_column][/vc_row][vc_row content_placement="middle" css_animation="none"][vc_column css_animation="fadeInUp" width="1/2"][vc_column_text]
<h2>Accounting Services</h2>
<ul>
	<li>Quisque suscipit massa at libero sollicitudin molestie.</li>
	<li>Nunc efficitur tellus egestas augue posuere.</li>
	<li>Etiam sagittis purus lacus, ac ultrices ante convallis ut.</li>
	<li>Ut condimentum ipsum quis accumsan pharetra.</li>
	<li>Quisque fringilla felis odio, non semper elit semper vel.</li>
	<li>Etiam sagittis purus lacus, ac ultrices ante convallis ut.</li>
	<li>Ut condimentum ipsum quis accumsan pharetra.</li>
</ul>
[/vc_column_text][/vc_column][vc_column css_animation="fadeInDown" width="1/2"][vc_single_image image="46" img_size="full" css_animation="none"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Service 7', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/service7.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][ultimate_heading main_heading="Industries We Serve" main_heading_color="#292929" spacer="image_only" spacer_position="bottom" spacer_img_width="25" main_heading_font_size="desktop:38px;" main_heading_line_height="desktop:48px;" spacer_img="id^54|url^http://apresswp.com/demo7/wp-content/uploads/2017/02/title_separater_img_2.png|caption^null|alt^null|title^title_separater_img_2|description^null" main_heading_style="font-weight:bold;" spacer_margin="margin-top:18px;margin-bottom:38px;" main_heading_margin="margin-top:90px;"][/ultimate_heading][/vc_column][/vc_row][vc_row gap="25" css=".vc_custom_1486100220735{padding-bottom: 75px !important;}"][vc_column width="1/3" css=".vc_custom_1486032828861{padding-top: 319px !important;padding-right: 50px !important;padding-left: 50px !important;background-image: url(http://apresswp.com/demo7/wp-content/uploads/2017/02/img_1.jpg?id=123) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_heading main_heading="SAVE TAX ON RETURNS" main_heading_color="#ffffff" sub_heading_color="#ffffff" alignment="left" main_heading_style="font-weight:bold;" main_heading_font_size="desktop:20px;" main_heading_line_height="desktop:30px;" sub_heading_font_size="desktop:14px;" sub_heading_line_height="desktop:26px;" main_heading_margin="margin-bottom:15px;"]Aliquam sagittis interdum velit at laoreet. Praesent lacus eros, tempor vitae finibus ac, commodo id dui Aenean semper .[/ultimate_heading][ult_buttons btn_title="LEARN MORE" btn_size="ubtn-custom" btn_width="120" btn_height="30" btn_title_color="#ffffff" btn_bg_color="#ee624c" icon_size="32" btn_icon_pos="ubtn-sep-icon-at-left" btn_border_style="solid" btn_border_size="0" btn_radius="0" btn_font_style="font-weight:bold;" btn_font_size="desktop:12px;" btn_line_height="desktop:20px;" css_adv_btn=".vc_custom_1486032352848{margin-top: 35px !important;padding-bottom: 15px !important;}"][/vc_column][vc_column width="2/3"][vc_row_inner gap="25" css=".vc_custom_1486032557782{margin-top: -13px !important;}"][vc_column_inner width="1/2" css=".vc_custom_1486032600085{padding-right: 50px !important;padding-left: 50px !important;background-image: url(http://apresswp.com/demo7/wp-content/uploads/2017/02/img_2.jpg?id=124) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_heading main_heading="Pay My Tax Bill" main_heading_color="#ffffff" sub_heading_color="#ffffff" alignment="left" main_heading_style="font-weight:bold;" main_heading_font_size="desktop:20px;" main_heading_line_height="desktop:30px;" sub_heading_font_size="desktop:14px;" sub_heading_line_height="desktop:26px;" main_heading_margin="margin-bottom:15px;"]Aliquam sagittis interdum velit at laoreet. Praesent lacus eros, tempor vitae finibus ac, commodo id dui Aenean semper .[/ultimate_heading][ult_buttons btn_title="LEARN MORE" btn_size="ubtn-custom" btn_width="120" btn_height="30" btn_title_color="#ffffff" btn_bg_color="#ee624c" icon_size="32" btn_icon_pos="ubtn-sep-icon-at-left" btn_border_style="solid" btn_border_size="0" btn_radius="0" btn_font_style="font-weight:bold;" btn_font_size="desktop:12px;" btn_line_height="desktop:20px;" css_adv_btn=".vc_custom_1486032690588{margin-top: 35px !important;padding-bottom: 8px !important;}"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1486032731280{padding-right: 50px !important;padding-left: 50px !important;background-image: url(http://apresswp.com/demo7/wp-content/uploads/2017/02/img_4.jpg?id=126) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_heading main_heading="TAX REFUNDS" main_heading_color="#ffffff" sub_heading_color="#ffffff" alignment="left" main_heading_style="font-weight:bold;" main_heading_font_size="desktop:20px;" main_heading_line_height="desktop:30px;" sub_heading_font_size="desktop:14px;" sub_heading_line_height="desktop:26px;" main_heading_margin="margin-bottom:15px;"]Aliquam sagittis interdum velit at laoreet. Praesent lacus eros, tempor vitae finibus ac, commodo id dui Aenean semper .[/ultimate_heading][ult_buttons btn_title="LEARN MORE" btn_size="ubtn-custom" btn_width="120" btn_height="30" btn_title_color="#292929" btn_bg_color="#ffffff" icon_size="32" btn_icon_pos="ubtn-sep-icon-at-left" btn_border_style="solid" btn_border_size="0" btn_radius="0" btn_font_style="font-weight:bold;" btn_font_size="desktop:12px;" btn_line_height="desktop:20px;" css_adv_btn=".vc_custom_1486032976015{margin-top: 35px !important;padding-bottom: 8px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner gap="25" css=".vc_custom_1486032557782{margin-top: -13px !important;}"][vc_column_inner width="1/2" css=".vc_custom_1486032872939{padding-right: 50px !important;padding-left: 50px !important;background-image: url(http://apresswp.com/demo7/wp-content/uploads/2017/02/img_3.jpg?id=125) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_heading main_heading="Free File" main_heading_color="#ffffff" sub_heading_color="#ffffff" alignment="left" main_heading_style="font-weight:bold;" main_heading_font_size="desktop:20px;" main_heading_line_height="desktop:30px;" sub_heading_font_size="desktop:14px;" sub_heading_line_height="desktop:26px;" main_heading_margin="margin-bottom:15px;"]Aliquam sagittis interdum velit at laoreet. Praesent lacus eros, tempor vitae finibus ac, commodo id dui Aenean semper .[/ultimate_heading][ult_buttons btn_title="LEARN MORE" btn_size="ubtn-custom" btn_width="120" btn_height="30" btn_title_color="#ee624c" btn_bg_color="#ffffff" icon_size="32" btn_icon_pos="ubtn-sep-icon-at-left" btn_border_style="solid" btn_border_size="0" btn_radius="0" btn_font_style="font-weight:bold;" btn_font_size="desktop:12px;" btn_line_height="desktop:20px;" css_adv_btn=".vc_custom_1486032944295{margin-top: 35px !important;padding-bottom: 8px !important;}"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1486032885806{padding-right: 50px !important;padding-left: 50px !important;background-image: url(http://apresswp.com/demo7/wp-content/uploads/2017/02/img_5.jpg?id=127) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_heading main_heading="HELP CENTER" main_heading_color="#ffffff" sub_heading_color="#ffffff" alignment="left" main_heading_style="font-weight:bold;" main_heading_font_size="desktop:20px;" main_heading_line_height="desktop:30px;" sub_heading_font_size="desktop:14px;" sub_heading_line_height="desktop:26px;" main_heading_margin="margin-bottom:15px;"]Aliquam sagittis interdum velit at laoreet. Praesent lacus eros, tempor vitae finibus ac, commodo id dui Aenean semper .[/ultimate_heading][ult_buttons btn_title="LEARN MORE" btn_size="ubtn-custom" btn_width="120" btn_height="30" btn_title_color="#ffffff" btn_bg_color="#ee624c" icon_size="32" btn_icon_pos="ubtn-sep-icon-at-left" btn_border_style="solid" btn_border_size="0" btn_radius="0" btn_font_style="font-weight:bold;" btn_font_size="desktop:12px;" btn_line_height="desktop:20px;" css_adv_btn=".vc_custom_1486032690588{margin-top: 35px !important;padding-bottom: 8px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Service 8', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/service8.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1486116180936{padding-top: 18px !important;}"][vc_column][vc_row_inner css=".vc_custom_1485870804294{padding-top: 7px !important;}"][vc_column_inner width="1/3" css=".vc_custom_1486116101382{padding-top: 20px !important;}"][vc_single_image image="252" img_size="full" alignment="center" css_animation="fadeInLeft" css=".vc_custom_1486114963331{margin-bottom: 22px !important;}"][ultimate_heading main_heading="Why Choose Accounting" main_heading_color="#303030" sub_heading_color="#636363" alignment="left" spacer="line_only" spacer_position="bottom" line_height="3" line_color="#ee624c" main_heading_style="font-weight:bold;" main_heading_font_size="desktop:24px;" main_heading_line_height="desktop:34px;" sub_heading_font_size="desktop:16px;" sub_heading_line_height="desktop:30px;" main_heading_margin="margin-top:7px;margin-bottom:18px;" line_width="30" spacer_margin="margin-top:14px;margin-bottom:19px;"]Aliquam sagittis interdum velit at laoreet. Praesent lacus eros, tempor vitae finibus ac, commodo id dui. Aenean semper nisl in elit pharetra, a accumsan mauris laoreet. Quisque porttitor purus turpis, id sollicitudin diam pretium at. n nunc ut posuere convallis.[/ultimate_heading][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1486116112325{padding-top: 20px !important;}"][vc_single_image image="253" img_size="full" alignment="center" css_animation="fadeInDown" css=".vc_custom_1486116463748{margin-bottom: 22px !important;}"][ultimate_heading main_heading="Why Choose Accounting" main_heading_color="#303030" sub_heading_color="#636363" alignment="left" spacer="line_only" spacer_position="bottom" line_height="3" line_color="#ee624c" main_heading_style="font-weight:bold;" main_heading_font_size="desktop:24px;" main_heading_line_height="desktop:34px;" sub_heading_font_size="desktop:16px;" sub_heading_line_height="desktop:30px;" main_heading_margin="margin-top:7px;margin-bottom:18px;" line_width="30" spacer_margin="margin-top:14px;margin-bottom:19px;"]Aliquam sagittis interdum velit at laoreet. Praesent lacus eros, tempor vitae finibus ac, commodo id dui. Aenean semper nisl in elit pharetra, a accumsan mauris laoreet. Quisque porttitor purus turpis, id sollicitudin diam pretium at. n nunc ut posuere convallis.[/ultimate_heading][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1486116118993{padding-top: 20px !important;}"][vc_single_image image="254" img_size="full" alignment="center" css_animation="fadeInRight" css=".vc_custom_1486116483040{margin-bottom: 22px !important;}"][ultimate_heading main_heading="Why Choose Accounting" main_heading_color="#303030" sub_heading_color="#636363" alignment="left" spacer="line_only" spacer_position="bottom" line_height="3" line_color="#ee624c" main_heading_style="font-weight:bold;" main_heading_font_size="desktop:24px;" main_heading_line_height="desktop:34px;" sub_heading_font_size="desktop:16px;" sub_heading_line_height="desktop:30px;" main_heading_margin="margin-top:7px;margin-bottom:18px;" line_width="30" spacer_margin="margin-top:14px;margin-bottom:19px;"]Aliquam sagittis interdum velit at laoreet. Praesent lacus eros, tempor vitae finibus ac, commodo id dui. Aenean semper nisl in elit pharetra, a accumsan mauris laoreet. Quisque porttitor purus turpis, id sollicitudin diam pretium at. n nunc ut posuere convallis.[/ultimate_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Service 9', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/service9.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1504530724317{padding-top: 25px !important;padding-bottom: 50px !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/3"][apress_imagebox imagebox_style="style2" imagebox_bor_color="#f2f2f2" imagebox_image="33" imagebox_title="DIGITAL MARKETING" imagebox_title_fonsize="" imagebox_title_color="" imagebox_description_color="" imagebox_button_size="large" imagebox_button_text="" imagebox_buttonfontcolorhover="" imagebox_buttonbackgroundcolor="" imagebox_buttonbordercolorhover="" data_animation="fadeInUp" data_delay="300"]Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column_inner][vc_column_inner width="1/3"][apress_imagebox imagebox_style="style2" imagebox_bor_color="#f2f2f2" imagebox_image="32" imagebox_title="VIDEO MARKETING" imagebox_title_fonsize="" imagebox_title_color="" imagebox_description_color="" imagebox_button_size="large" imagebox_button_text="" imagebox_buttonfontcolorhover="" imagebox_buttonbackgroundcolor="" imagebox_buttonbordercolorhover="" data_animation="fadeInUp" data_delay="600"]Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column_inner][vc_column_inner width="1/3"][apress_imagebox imagebox_style="style2" imagebox_bor_color="#f2f2f2" imagebox_image="31" imagebox_title="MOBILE MARKETING" imagebox_title_fonsize="" imagebox_title_color="" imagebox_description_color="" imagebox_button_size="large" imagebox_button_text="" imagebox_buttonfontcolorhover="" imagebox_buttonbackgroundcolor="" imagebox_buttonbordercolorhover="" data_animation="fadeInUp" data_delay="900"]Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Service 10', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/service10.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1505974763663{padding-top: 70px !important;padding-bottom: 100px !important;}"][vc_column width="1/2"][apress_heading sub_title="" content_alignment="left" enable_delimiter="" style="heading_style1" heading_margin="margin-bottom:30" title_font_options="tag:h2|font_size:45|line_height:60|letter_spacing:1" subtitle_font_options="tag:div"]Welcome to our clinic[/apress_heading][vc_column_text]Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor.

Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.

<img class="alignleft size-medium wp-image-38" src="http://apresswp.com/demo19/wp-content/uploads/2017/09/signature-300x75.png" alt="" width="300" height="75" />[/vc_column_text][/vc_column][vc_column centered_text="true" width="1/2" css=".vc_custom_1505974025046{margin: 5% !important;}"][apress_lightbox lightbox_type="video" link_style="link_icon_preview_image" image_url="29" button_icon_color="#ffffff" lightbox_hover_effect="yes" link_hover_caption="Watch Introduction" select_button_style="video_icon_style2" videolink_font_options="font_size:25|color:%23ffffff|line_height:40|letter_spacing:1"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1505976585997{padding-top: 50px !important;padding-bottom: 50px !important;background-color: #f7f7f7 !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/3"][apress_heading sub_title="Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." content_alignment="left" enable_delimiter="" style="heading_style1" heading_margin="margin-bottom:30" title_font_options="tag:h2|font_size:45|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" subheading_margin="margin-bottom:50"]Our Services[/apress_heading][/vc_column_inner][vc_column_inner width="1/3"][apress_heading sub_title="" content_alignment="left" enable_delimiter="" style="heading_style1" title_font_options="tag:h2|font_size:35|line_height:60|letter_spacing:1" subtitle_font_options="tag:div"]<a href="#">Invisalign®</a>[/apress_heading][apress_heading sub_title="" content_alignment="left" enable_delimiter="" style="heading_style1" title_font_options="tag:h2|font_size:35|line_height:60|letter_spacing:1" subtitle_font_options="tag:div"]<a href="#">Teeth Whitening</a>[/apress_heading][apress_heading sub_title="" content_alignment="left" enable_delimiter="" style="heading_style1" title_font_options="tag:h2|font_size:35|line_height:60|letter_spacing:1" subtitle_font_options="tag:div"]<a href="#">Teeth Cleaning</a>[/apress_heading][/vc_column_inner][vc_column_inner width="1/3"][apress_heading sub_title="" content_alignment="left" enable_delimiter="" style="heading_style1" title_font_options="tag:h2|font_size:35|line_height:60|letter_spacing:1" subtitle_font_options="tag:div"]<a href="#">Root Canal</a>[/apress_heading][apress_heading sub_title="" content_alignment="left" enable_delimiter="" style="heading_style1" title_font_options="tag:h2|font_size:35|line_height:60|letter_spacing:1" subtitle_font_options="tag:div"]<a href="#">Cavities</a>[/apress_heading][apress_heading sub_title="" content_alignment="left" enable_delimiter="" style="heading_style1" title_font_options="tag:h2|font_size:35|line_height:60|letter_spacing:1" subtitle_font_options="tag:div"]<a href="#">Same Day Crown</a>[/apress_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Team 1', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/team1.jpg' );
	$data['sort_name'] = 'Teams';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1505467505167{padding-top: 120px !important;padding-right: 5% !important;padding-bottom: 150px !important;padding-left: 5% !important;}"][vc_column][apress_heading sub_title="" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:h4" heading_margin="margin-bottom:30" subheading_margin="margin-bottom:50"]OUR TEAM[/apress_heading][ultimate_spacer height="30"][apress_team teamstyle="team_style2" category="all" num="3" teamcrslcolprw="Three" teamnamefontcolor="#ffffff" teamdesignationfontcolor="#ffffff" teamboxoverlayopa="0.1" data_animation="fadeInUp" data_delay="100"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Team 2', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/team2.jpg' );
	$data['sort_name'] = 'Teams';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1500712042279{padding-top: 90px !important;padding-right: 5% !important;padding-bottom: 115px !important;padding-left: 5% !important;}"][vc_column][vc_column_text css=".vc_custom_1505556872811{margin-bottom: 0px !important;}"]
<h1 style="text-align: center;">OUR TEAM</h1>
[/vc_column_text][ultimate_spacer height="30"][apress_team category="all" teamtext_align="center" teamnamefontcolor="#8e54e9" teamtitlehoverbgcolor="#8e54e9" data_animation="fadeInUp" data_delay="100"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Team 3', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/team3.jpg' );
	$data['sort_name'] = 'Teams';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1474448614565{padding-top: 70px !important;}"][vc_column][vc_column_text css=".vc_custom_1505558199534{margin-bottom: 0px !important;}"]
<h2 style="text-align: center;">OUR TEAM</h2>
[/vc_column_text][ultimate_spacer height="30"][apress_team category="all" teamcrslcolprw="Three" teamtext_align="center" teamnamefontcolor="#8e54e9" teamtitlehoverbgcolor="#8e54e9" teamslidershowhide="slider_show"][/vc_column][/vc_row][vc_row css=".vc_custom_1474448621725{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column][apress_callto_action calltoaction_title="Design any type of website using APRESS and customize everything !" calltoaction_text="" calltoaction_buttonfontcolor="#ffffff" calltoaction_buttonfontcolorhover="#8659d6" calltoaction_buttonbgcolor="#8659d6" calltoaction_buttonbgcolorhover="#ffffff" calltoaction_buttonbordercolor="#8659d6" calltoaction_buttonbordercolorhover="#8659d6" data_animation="fadeInDown" icon_family="fontawesome" icon_fontawesome="fa fa-paper-plane-o" calltoaction_button_icon_position="right"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Team 4', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/team4.jpg' );
	$data['sort_name'] = 'Teams';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces"][vc_column width="1/3" css=".vc_custom_1474627147236{padding-top: 400px !important;padding-right: 10% !important;padding-bottom: 65px !important;padding-left: 10% !important;background-image: url(http://apresswp.com/demo3/wp-content/uploads/2016/09/tm_2.jpg?id=181) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_heading main_heading="John Doe" main_heading_color="#ffffff" sub_heading_color="#ffffff" main_heading_font_size="desktop:28px;" main_heading_line_height="desktop:36px;" sub_heading_font_size="desktop:22px;" sub_heading_line_height="desktop:40px;" main_heading_margin="margin-bottom:-25px;" main_heading_style="font-weight:bold;" sub_heading_margin="margin-bottom:-10px;"]
<p style="text-align: center; font-weight: lighter !important;"><em>Developer</em>
Vestibulum facilisis, velit eu feugiat efficitur, sapien sem maximus nisl, nec sagittis augue.

[/ultimate_heading][apress_sociallinks socialicon_style="color" socialicon_design="round" socialicon_twitter="#" socialicon_instagram="#" socialicon_googleplus="#" socialicon_alignment="center"][/vc_column][vc_column width="1/3" css=".vc_custom_1474627154177{padding-top: 400px !important;padding-right: 10% !important;padding-bottom: 65px !important;padding-left: 10% !important;background-image: url(http://apresswp.com/demo3/wp-content/uploads/2016/09/tm_3.jpg?id=182) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_heading main_heading="John Doe" main_heading_color="#ffffff" sub_heading_color="#ffffff" main_heading_font_size="desktop:28px;" main_heading_line_height="desktop:36px;" sub_heading_font_size="desktop:22px;" sub_heading_line_height="desktop:40px;" main_heading_margin="margin-bottom:-25px;" main_heading_style="font-weight:bold;" sub_heading_margin="margin-bottom:-10px;"]
<p style="text-align: center; font-weight: lighter !important;"><em>Designer</em>
Vestibulum facilisis, velit eu feugiat efficitur, sapien sem maximus nisl, nec sagittis augue.

[/ultimate_heading][apress_sociallinks socialicon_style="color" socialicon_design="round" socialicon_facebook="#" socialicon_twitter="#" socialicon_googleplus="#" socialicon_alignment="center"][/vc_column][vc_column width="1/3" css=".vc_custom_1475226469847{padding-top: 400px !important;padding-right: 10% !important;padding-bottom: 65px !important;padding-left: 10% !important;background-image: url(http://apresswp.com/demo3/wp-content/uploads/2016/09/tm_4.jpg?id=308) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_heading main_heading="Johnny Doe" main_heading_color="#ffffff" sub_heading_color="#ffffff" main_heading_font_size="desktop:28px;" main_heading_line_height="desktop:36px;" sub_heading_font_size="desktop:22px;" sub_heading_line_height="desktop:40px;" main_heading_margin="margin-bottom:-25px;" main_heading_style="font-weight:bold;" sub_heading_margin="margin-bottom:-10px;"]
<p style="text-align: center; font-weight: lighter !important;"><em>SEO</em>
Vestibulum facilisis, velit eu feugiat efficitur, sapien sem maximus nisl, nec sagittis augue.

[/ultimate_heading][apress_sociallinks socialicon_style="color" socialicon_design="round" socialicon_twitter="#" socialicon_linkedin="#" socialicon_tumblr="#" socialicon_alignment="center"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Team 5', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/team5.jpg' );
	$data['sort_name'] = 'Teams';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/4" css=".vc_custom_1486638804644{margin-top: 15px !important;padding-right: 40px !important;padding-bottom: 245px !important;padding-left: 40px !important;background-color: #2936b3 !important;}"][ultimate_heading main_heading="OUR
TEAM" main_heading_color="#ffffff" alignment="left" main_heading_font_size="desktop:50px;" main_heading_line_height="desktop:60px;" main_heading_margin="margin-top:53px;margin-bottom:30px;"][/ultimate_heading][/vc_column][vc_column width="3/4"][zolo_team_shortcode num="3" teamcrslcolprw="Three" teamnamefontcolor="#2936b3" teamtitlehoverbgcolor="#2936b3"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Team 6', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/team6.jpg' );
	$data['sort_name'] = 'Teams';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content" css=".vc_custom_1503941309543{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column css_animation="fadeInUp"][apress_heading sub_title="OUR TEAM" enable_delimiter="" title_google_fonts="yes" style="heading_style2" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" title_custom_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" heading_margin="margin-bottom:30"]OUR QUALIFIED ARTISTS[/apress_heading][vc_empty_space height="30px"][apress_team teamstyle="team_style2" category="all" teamnamefontcolor="#ffffff" teamdesignationfontcolor="#ffffff" teamtitlehoverbgcolor="#dd9933" teamboxspace="0" data_delay="100"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Testimonial 1', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/testimonial1.jpg' );
	$data['sort_name'] = 'Testimonial';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1505467468499{padding-top: 120px !important;padding-bottom: 140px !important;background-color: #f7f7f7 !important;}"][vc_column][apress_heading sub_title="" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:h4" heading_margin="margin-bottom:30" subheading_margin="margin-bottom:50"]CLIENT TESTIMONIALS[/apress_heading][ultimate_spacer height="30"][vc_row_inner][vc_column_inner width="1/3"][apress_testimonial testimonialstyle="testimonials_style3" authorimage="408" by="Jane Tucker" designation=", Designer" testimonialfontcolor="#747474" testimonialbordercolor="#d8d8d8" testimonialauthorcolor="#8659d6" data_animation="fadeInUp" data_delay="300"]Sed imperdiet bibendum purus nec tristique. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Proin pulvinar id mauris sed finibus. Nunc tempor lacinia efficitur. [/apress_testimonial][/vc_column_inner][vc_column_inner width="1/3"][apress_testimonial testimonialstyle="testimonials_style3" authorimage="404" by="Martin Legend" designation=", Web Works Corp" testimonialfontcolor="#747474" testimonialbordercolor="#d8d8d8" testimonialauthorcolor="#8659d6" data_animation="fadeInUp" data_delay="600"]Sed imperdiet bibendum purus nec tristique. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Proin pulvinar id mauris sed finibus. Nunc tempor lacinia efficitur. Maecenas nec diam ligula. Mauris quis malesuada arcu. [/apress_testimonial][/vc_column_inner][vc_column_inner width="1/3"][apress_testimonial testimonialstyle="testimonials_style3" authorimage="409" by="Layla McLion" designation=", Insta Life Inc" testimonialfontcolor="#747474" testimonialbordercolor="#d8d8d8" testimonialauthorcolor="#8659d6" data_animation="fadeInUp" data_delay="900"]Sed imperdiet bibendum purus nec tristique. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Proin pulvinar id mauris sed finibus. Nunc tempor lacinia efficitur. [/apress_testimonial][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Testimonial 2', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/testimonial2.jpg' );
	$data['sort_name'] = 'Testimonial';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1501862756700{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column][vc_row_inner][vc_column_inner css=".vc_custom_1501869392077{padding-right: 5% !important;padding-left: 5% !important;}"][apress_heading sub_title="Suspendisse potenti. Donec vestibulum commodo gravida. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam congue nibh porta augue scelerisque bibendum facilisis sed libero." enable_delimiter="" title_google_fonts="yes" style="heading_style1" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div" heading_margin="margin-bottom:30" subheading_margin="margin-bottom:30"]Our Trusted Partners[/apress_heading][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50" height_on_tabs="50" height_on_tabs_portrait="50" height_on_mob_landscape="50" height_on_mob="50"][vc_row_inner][vc_column_inner width="1/3"][apress_testimonial rating_option="100%" authorimage="408" testimonialbordercolor="#eaeaea"]Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.[/apress_testimonial][/vc_column_inner][vc_column_inner width="1/3"][apress_testimonial rating_option="100%" authorimage="407" testimonialbordercolor="#eaeaea"]Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.Cras gravida consequat lorem vitae vestibulum.[/apress_testimonial][/vc_column_inner][vc_column_inner width="1/3"][apress_testimonial rating_option="100%" authorimage="409" testimonialbordercolor="#eaeaea"]Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.[/apress_testimonial][/vc_column_inner][/vc_row_inner][ultimate_spacer height="100" height_on_tabs="50" height_on_tabs_portrait="50" height_on_mob_landscape="50" height_on_mob="50"][vc_row_inner][vc_column_inner width="1/4" css=".vc_custom_1505541425988{padding-right: 3% !important;padding-left: 3% !important;}"][vc_single_image image="466" img_size="full" alignment="center"][/vc_column_inner][vc_column_inner width="1/4"][vc_single_image image="465" img_size="full" alignment="center"][/vc_column_inner][vc_column_inner width="1/4"][vc_single_image image="464" img_size="full" alignment="center"][/vc_column_inner][vc_column_inner width="1/4"][vc_single_image image="467" img_size="full" alignment="center"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Testimonial 3', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/testimonial3.jpg' );
	$data['sort_name'] = 'Testimonial';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1473946321552{padding-top: 20px !important;padding-bottom: 50px !important;}"][vc_column][ultimate_heading main_heading="CLIENT TESTIMONIALS" main_heading_margin="margin-top:50px;margin-bottom:50x;" sub_heading_margin="margin-bottom:10px;" main_heading_font_size="desktop:30px;tablet:25px;tablet_portrait:20px;mobile_landscape:20px;mobile:20px;" main_heading_line_height="desktop:40px;tablet:35px;tablet_portrait:35px;mobile_landscape:30px;mobile:30px;" sub_heading_font_size="desktop:20px;tablet:16px;tablet_portrait:16px;mobile_landscape:16px;mobile:16px;" sub_heading_line_height="desktop:30px;tablet:25px;tablet_portrait:25px;mobile_landscape:25px;mobile:25px;"]<strong> </strong>[/ultimate_heading][apress_testimonial_slider testimonialstyle="testimonials_style2" testimonialnamefontcolor="#8e54e9" testimonialimgborradi="0" data_animation="fadeInUp"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Testimonial 4', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/testimonial4.jpg' );
	$data['sort_name'] = 'Testimonial';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1500712079219{padding-top: 85px !important;padding-bottom: 110px !important;background-color: #f7f7f7 !important;}"][vc_column][vc_column_text css=".vc_custom_1505556878593{margin-bottom: 0px !important;}"]
<h1 style="text-align: center;">WHAT THEY SAY</h1>
[/vc_column_text][ultimate_spacer height="30"][vc_row_inner][vc_column_inner][apress_testimonial_slider testimonialnamefontcolor="#8e54e9" testimonialsliderpagi="pagi_none" testimonialslidernav="nav_style3" testimonialimgborcolor="#8e54e9" data_animation="fadeInUp" data_delay="300"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Testimonial 5', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/testimonial5.jpg' );
	$data['sort_name'] = 'Testimonial';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row gap="10" content_placement="top" css=".vc_custom_1473659963280{padding-top: 85px !important;padding-bottom: 85px !important;}"][vc_column width="1/3" offset="vc_col-lg-offset-0 vc_col-md-offset-0 vc_col-sm-offset-0"][ultimate_heading main_heading="TESTIMONIALS" alignment="right" main_heading_font_size="desktop:35px;" main_heading_line_height="desktop:60px;"]Clients speak[/ultimate_heading][/vc_column][vc_column width="2/3"][vc_row_inner][vc_column_inner width="1/2"][apress_testimonial rating_option="100%" authorimage="408" testimonialimgborradi="0" data_animation="fadeInUp" data_delay="300"]This is the best WordPress theme I have ever used! Maecenas eu gravida nulla. Maecenas hendrerit pellentesque augue, auctor vehicula tellus tempus eu. Mauris eu iaculis felis, ac elementum nunc.[/apress_testimonial][/vc_column_inner][vc_column_inner width="1/2"][apress_testimonial rating_option="100%" authorimage="409" testimonialimgborradi="0" data_animation="fadeInUp" data_delay="600"]This is the best WordPress theme I have ever used! Maecenas eu gravida nulla. Maecenas hendrerit pellentesque augue, auctor vehicula tellus tempus eu. Mauris eu iaculis felis, ac elementum nunc.[/apress_testimonial][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]

[/vc_column_text][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Testimonial 6', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/testimonial6.jpg' );
	$data['sort_name'] = 'Testimonial';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][vc_empty_space height="50px"][apress_heading sub_title="MY TESTIMONIALS" data_animation="fadeInUp" enable_delimiter="" title_google_fonts="yes" style="heading_style2" title_font_options="tag:h2" subtitle_font_options="tag:div" title_custom_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" heading_margin="margin-bottom:50"]What My Client Say[/apress_heading][vc_row_inner][vc_column_inner width="1/3"][apress_testimonial testimonialstyle="testimonials_style3" rating_option="5star" authorimage="36" testimonialfontcolor="" testimonialbordercolor="#4cd964" data_animation="fadeInUp" data_delay="300"]Suspendisse quis lobortis diam. Aenean sagittis arcu ut neque ornare, ac porta augue commodo. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Proin malesuada enim ut turpis pulvinar consequat.[/apress_testimonial][/vc_column_inner][vc_column_inner width="1/3"][apress_testimonial testimonialstyle="testimonials_style3" rating_option="5star" authorimage="35" testimonialfontcolor="" testimonialbordercolor="#4cd964" data_animation="fadeInUp" data_delay="600"]Suspendisse quis lobortis diam. Aenean sagittis arcu ut neque ornare, ac porta augue commodo. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Proin malesuada enim ut turpis pulvinar consequat.[/apress_testimonial][/vc_column_inner][vc_column_inner width="1/3"][apress_testimonial testimonialstyle="testimonials_style3" rating_option="5star" authorimage="34" testimonialfontcolor="" testimonialbordercolor="#4cd964" data_animation="fadeInUp" data_delay="900"]Suspendisse quis lobortis diam. Aenean sagittis arcu ut neque ornare, ac porta augue commodo. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Proin malesuada enim ut turpis pulvinar consequat.[/apress_testimonial][/vc_column_inner][/vc_row_inner][vc_empty_space height="70px"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Testimonial 7', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/testimonial7.jpg' );
	$data['sort_name'] = 'Testimonial';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1504535232199{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column][apress_testimonial_slider testimonialfontcolor="" testimonialnamefontcolor="" testimonialsliderpagi="pagi_none" testimonialslidernav="nav_style3" testimonialimgborcolor="#48af4b" data_animation="fadeIn"][vc_empty_space height="30px"][vc_single_image image="110" img_size="full" alignment="center" css_animation="fadeInUp"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Testimonial 8', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/testimonial8.jpg' );
	$data['sort_name'] = 'Testimonial';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1504555494282{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column][apress_heading sub_title="" data_animation="fadeInUp" enable_delimiter="" style="heading_style1" title_font_options="tag:h2|font_size:70|line_height:80" subtitle_font_options="tag:div" heading_margin="margin-bottom:50"]Our Customer Stories[/apress_heading][ultimate_spacer height="20"][vc_row_inner][vc_column_inner width="1/3"][apress_testimonial rating_option="5star" authorimage="52" testimonialimgborradi="20" by="Mary Tucker" testimonialfontcolor="" testimonialbordercolor="#eeeeee" testimonialauthorcolor="" data_animation="fadeInUp" data_delay="300"]Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum.[/apress_testimonial][/vc_column_inner][vc_column_inner width="1/3"][apress_testimonial rating_option="5star" authorimage="51" testimonialimgborradi="20" testimonialfontcolor="" testimonialbordercolor="#eeeeee" testimonialauthorcolor="" data_animation="fadeInUp" data_delay="300"]Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum.Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum.[/apress_testimonial][/vc_column_inner][vc_column_inner width="1/3"][apress_testimonial rating_option="5star" authorimage="50" testimonialimgborradi="20" by="Susan Taylor" testimonialfontcolor="" testimonialbordercolor="#eeeeee" testimonialauthorcolor="" data_animation="fadeInUp" data_delay="300"]Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum. In nec arcu ac sem tristique iaculis. Sed a nisi nec odio placerat tempor. Cras congue nibh ut purus sollicitudin rutrum.[/apress_testimonial][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Testimonial 9', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/testimonial9.jpg' );
	$data['sort_name'] = 'Testimonial';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" css=".vc_custom_1504610947465{margin-top: 0px !important;margin-bottom: 20px !important;padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_column width="1/2" css=".vc_custom_1504607255232{padding-right: 5% !important;padding-left: 5% !important;}"][ultimate_spacer height="200" height_on_mob_landscape="50" height_on_mob="50"][vc_row_inner css=".vc_custom_1504608468489{padding-top: 100px !important;}"][vc_column_inner][apress_heading sub_title="" enable_delimiter="" style="heading_style1" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:50"]Customer's Delight[/apress_heading][apress_testimonial_slider num="2" testimonialfontcolor="" testimonialnamefontcolor="#333333" testimonialimgborcolor="#333333" data_animation="fadeInUp"][/vc_column_inner][/vc_row_inner][ultimate_spacer height="200" height_on_mob_landscape="50" height_on_mob="50"][/vc_column][vc_column css_animation="fadeInUp" width="1/2" css=".vc_custom_1504611016160{background-image: url(http://apresswp.com/demo16/wp-content/uploads/2017/09/bg3.jpg?id=37) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_spacer height="300"][ultimate_spacer height="300"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Testimonial 10', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/testimonial10.jpg' );
	$data['sort_name'] = 'Testimonial';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^144|url^http://apresswp.com/demo17/wp-content/uploads/2017/09/bg5.jpg|caption^null|alt^null|title^bg5|description^null" bg_override="ex-full" css=".vc_custom_1505378261912{padding-top: 80px !important;padding-bottom: 90px !important;}"][vc_column css_animation="fadeInUp"][apress_testimonial_slider num="2" testimonialfontsize="20" testimoniallineheight="30" testimonialfontcolor="#ffffff" testimonialnamefontcolor="#ffffff" testimonialsliderpagi="pagi_none" testimonialslidernav="nav_style3" testimonialimgborcolor="#ffffff"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Contact 1', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/contact1.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1503904227384{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column width="2/3"][apress_heading sub_title="" content_alignment="left" data_animation="fadeInUp" delimiter_line_height="3" delimiter_line_width="80" color_scheme="design_your_own" style="heading_style1" delimiter_line_color="#00a300" title_font_options="tag:h2|font_size:25|line_height:30" subtitle_font_options="tag:div" heading_margin="margin-bottom:15" subheading_margin="margin-top:30|margin-bottom:15"]GET A PERSONALIZED QUOTE[/apress_heading][vc_empty_space height="30px"][apress_contactform contactform_id="82" contactform_button_size="medium_buttton" data_animation="fadeInUp" data_delay="300"][/vc_column][vc_column width="1/3"][vc_single_image image="87" img_size="full"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Contact 2', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/contact2.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-default" bg_image_new="id^58|url^http://apresswp.com/demo10/wp-content/uploads/2017/08/bg.jpg|caption^null|alt^null|title^bg|description^null" bg_override="full" enable_overlay="enable_overlay_value" overlay_color="#7c7c7c" css=".vc_custom_1503934845977{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column width="1/2" css=".vc_custom_1504611613287{padding-top: 10% !important;padding-right: 10% !important;padding-bottom: 10% !important;padding-left: 10% !important;background-color: #333333 !important;}"][apress_heading sub_title="HELP US SERVE YOU BEST" enable_delimiter="" title_google_fonts="yes" style="heading_style2" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" title_custom_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" heading_margin="margin-bottom:30"]BOOK APPOINTMENT[/apress_heading][apress_contactform contactform_id="4"][/vc_column][vc_column width="1/2"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Contact 3', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/contact3.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-default" bg_image_new="id^53|url^http://apresswp.com/demo13/wp-content/uploads/2017/08/bg2.jpg|caption^Portrait of beautiful woman looking at camera|alt^null|title^Portrait of beautiful woman looking at camera|description^null" bg_image_repeat="no-repeat" bg_override="ex-full" css=".vc_custom_1504205504964{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column width="1/2"][/vc_column][vc_column width="1/2"][apress_heading sub_title="CONTACT ME" data_animation="fadeInUp" data_delay="300" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" title_google_fonts="yes" style="heading_style2" title_font_options="tag:h2" subtitle_font_options="tag:div|color:%23ffffff" title_custom_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" heading_margin="margin-bottom:50"]Get Your Personalized Plan[/apress_heading][apress_contactform contactform_id="4" contactform_textcolor="#f2f2f2" contactform_button_size="fullwidth_buttton" data_animation="fadeInLeft" data_delay="600"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Contact 4', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/contact4.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" css=".vc_custom_1504610947465{margin-top: 0px !important;margin-bottom: 20px !important;padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_column css_animation="fadeInUp" width="1/2" css=".vc_custom_1504614913662{background-image: url(http://apresswp.com/demo16/wp-content/uploads/2017/09/bg5.jpg?id=58) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][apress_heading sub_title="" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:50"]Facebook | Twitter[/apress_heading][/vc_column][vc_column width="1/2" css=".vc_custom_1504607255232{padding-right: 5% !important;padding-left: 5% !important;}"][ultimate_spacer height="200" height_on_mob_landscape="50" height_on_mob="50"][vc_row_inner css=".vc_custom_1504608468489{padding-top: 100px !important;}"][vc_column_inner][apress_heading sub_title="" enable_delimiter="" style="heading_style1" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:50"]Connect With Us ![/apress_heading][apress_contactform contactform_id="4" contactform_button_size="medium_buttton" data_animation="fadeIn"][/vc_column_inner][/vc_row_inner][ultimate_spacer height="200" height_on_mob_landscape="50" height_on_mob="50"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Contact 5', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/contact5.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
[vc_row gap="30" css=".vc_custom_1505388678518{padding-top: 60px !important;padding-bottom: 50px !important;}"][vc_column css_animation="fadeInUp" width="1/2"][apress_text_separator title="Visit Our Stores" title_align="separator_align_left" align="align_left" color="#ededed" title_font_options="tag:h2|font_size:35|color:%23333333|line_height:45|letter_spacing:1"][vc_empty_space height="20px"][apress_gradient_icon_box description="Hours: Open 24 hours" icon_alignment="left" icon_family="fontawesome" icon_fontawesome="fa fa-map-marker" style="iconbox_style1" title_font_options="tag:h4"]Address: 160 Broadway, New York, NY 10038[/apress_gradient_icon_box][vc_empty_space height="20px"][apress_gradient_icon_box description="Hours: 5AM–1AM" icon_alignment="left" icon_family="fontawesome" icon_fontawesome="fa fa-map-marker" style="iconbox_style1" title_font_options="tag:h4"]Address: 3003 NY-50, Saratoga Springs, NY 12866[/apress_gradient_icon_box][vc_empty_space height="20px"][apress_gradient_icon_box description="Hours: 5AM–11PM" icon_alignment="left" icon_family="fontawesome" icon_fontawesome="fa fa-map-marker" style="iconbox_style1" title_font_options="tag:h4"]Address: 8644 NY-22, Granville, NY 12832
[/apress_gradient_icon_box][vc_empty_space height="20px"][apress_gradient_icon_box description="Hours: 5AM–11PM" icon_alignment="left" icon_family="fontawesome" icon_fontawesome="fa fa-map-marker" style="iconbox_style1" title_font_options="tag:h4"]Address: 8644 NY-22, Granville, NY 12832
[/apress_gradient_icon_box][vc_empty_space height="20px"][/vc_column][vc_column css_animation="fadeInUp" width="1/2"][apress_text_separator title="Contact Us" title_align="separator_align_left" align="align_left" color="#ededed" title_font_options="tag:h2|font_size:35|color:%23333333|line_height:45|letter_spacing:1"][apress_contactform contactform_id="4" contactform_button_size="medium_buttton"][/vc_column][/vc_row][vc_row][vc_column css_animation="fadeInUp"][apress_callto_action calltoaction_style="style2" calltoaction_topbottom_pad="50" calltoaction_leftright_pad="50" calltoaction_title="Offering 20% off on all fresh stocks available across all our stores. Hurry !" calltoaction_titlecolor="#ffffff" calltoaction_text="" calltoaction_textalign="center" calltoaction_textcolor="#ffffff" calltoaction_boxbgcolor="#5fb538" calltoaction_button_size="large"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Contact 6', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/contact6.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^63|url^http://apresswp.com/demo18/wp-content/uploads/2017/09/bg02.jpg|caption^null|alt^null|title^bg02|description^null" bg_image_repeat="no-repeat" bg_override="browser_size"][vc_column css_animation="fadeInUp"][vc_row_inner css=".vc_custom_1506079444071{padding-right: 10% !important;padding-left: 10% !important;}"][vc_column_inner css=".vc_custom_1506079777191{padding-top: 5% !important;padding-right: 5% !important;padding-bottom: 5% !important;padding-left: 5% !important;background-color: #ffffff !important;}"][apress_heading sub_title="" data_animation="fadeInUp" data_delay="300" enable_delimiter="" style="heading_style1" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:50"]Tabella del libro[/apress_heading][apress_contactform contactform_id="4" contactform_button_size="fullwidth_buttton"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Contact 7', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/contact7.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces"][vc_column][ultimate_google_map height="400px" lat="40.73568" lng="-73.72854" zoom="12" scrollwheel="disable" zoomcontrol="true"]ZPLUS Headquarter
123th Demo Street, Cuba, North America[/ultimate_google_map][/vc_column][/vc_row][vc_row css=".vc_custom_1474113519407{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column width="1/3"][ultimate_heading main_heading="Get Social" alignment="left" main_heading_margin="margin-bottom:38px;"][/ultimate_heading][apress_sociallinks socialicon_style="color" socialicon_design="rounded" socialicon_facebook="#" socialicon_twitter="#" socialicon_instagram="#" socialicon_googleplus="#"][ultimate_spacer height="45"][ultimate_heading main_heading="Contact Info" alignment="left" main_heading_margin="margin-bottom:38px;"][/ultimate_heading][apress_icon_box iconcolor="#8659d6" icon_hover_color="#8659d6" icon_size="22" icon_background_shape="circle" icon_background_shape_type="thick_bordered" shape_background_color="#8659d6" icon_hover_bg_color="#8659d6" contentboxtitle_size="16" title_desc_color="#545454" icon_family="fontawesome" icon_fontawesome="fa fa-home" contentboxtitle="" contentboxarea="123th Demo Street, Cuba, North America" icon="fa-map-marker"][ultimate_spacer height="20"][apress_icon_box iconcolor="#8659d6" icon_hover_color="#8659d6" icon_size="22" icon_background_shape="circle" icon_background_shape_type="thick_bordered" shape_background_color="#8659d6" icon_hover_bg_color="#8659d6" contentboxtitle_size="16" title_desc_color="#545454" icon_family="fontawesome" icon_fontawesome="fa fa-phone-square" contentboxtitle="" contentboxarea="+ 1.555.555.555" icon="zo-call"][ultimate_spacer height="20"][apress_icon_box iconcolor="#8659d6" icon_hover_color="#8659d6" icon_size="22" icon_background_shape="circle" icon_background_shape_type="thick_bordered" shape_background_color="#8659d6" icon_hover_bg_color="#8659d6" contentboxtitle_size="16" title_desc_color="#545454" icon_family="fontawesome" icon_fontawesome="fa fa-envelope" contentboxtitle="" contentboxarea="info@yourdomain.com" icon="fa-send"][/vc_column][vc_column width="2/3"][ultimate_heading main_heading="Get in Touch with Us" alignment="left" main_heading_margin="margin-bottom:38px;" sub_heading_font_size="desktop:14px;" sub_heading_line_height="desktop:25px;"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ultimate_heading][apress_contactform contactform_id="614" contactform_button_size="medium_buttton"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Contact 8', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/contact8.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2"][ultimate_heading main_heading="Contact Info" alignment="left" main_heading_margin="margin-bottom:38px;"][/ultimate_heading][apress_icon_box iconcolor="#8659d6" icon_hover_color="#8659d6" icon_size="22" icon_background_shape="circle" icon_background_shape_type="thick_bordered" shape_background_color="#8659d6" icon_hover_bg_color="#8659d6" contentboxtitle_size="16" boxtitlepad="" title_desc_color="#545454" icon_family="fontawesome" icon_fontawesome="fa fa-home" contentboxtitle="" contentboxarea="123th Demo Street, Cuba, North America" icon="fa-map-marker"][ultimate_spacer height="20"][apress_icon_box iconcolor="#8659d6" icon_hover_color="#8659d6" icon_size="22" icon_background_shape="circle" icon_background_shape_type="thick_bordered" shape_background_color="#8659d6" icon_hover_bg_color="#8659d6" contentboxtitle_size="16" boxtitlepad="" title_desc_color="#545454" icon_family="fontawesome" icon_fontawesome="fa fa-phone-square" contentboxtitle="" contentboxarea="+ 1.555.555.555" icon="zo-call"][ultimate_spacer height="20"][apress_icon_box iconcolor="#8659d6" icon_hover_color="#8659d6" icon_size="22" icon_background_shape="circle" icon_background_shape_type="thick_bordered" shape_background_color="#8659d6" icon_hover_bg_color="#8659d6" contentboxtitle_size="16" boxtitlepad="" title_desc_color="#545454" icon_family="fontawesome" icon_fontawesome="fa fa-envelope" contentboxtitle="" contentboxarea="info@yourdomain.com" icon="fa-send"][ultimate_spacer height="45"][ultimate_google_map height="350px" lat="40.73568" lng="-73.72854" zoom="12"][/ultimate_google_map][/vc_column][vc_column width="1/2"][ultimate_heading main_heading="Get in Touch with Us" alignment="left" main_heading_margin="margin-bottom:38px;" sub_heading_font_size="desktop:14px;" sub_heading_line_height="desktop:25px;"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla nisi augue, maximus id posuere id, dictum ut ipsum. Etiam ullamcorper massa et porta pretium. Mauris hendrerit tellus a hendrerit suscipit. Maecenas luctus elit odio, at luctus arcu dignissim eget.[/ultimate_heading][apress_contactform contactform_id="617" contactform_button_size="fullwidth_buttton"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]

[/vc_column_text][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'CTA 1', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/cta1.jpg' );
	$data['sort_name'] = 'Call to Action';
	$data['custom_class'] = 'general call-to-action';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-default" bg_image_new="id^1069|url^http://apresswp.com/demo1/wp-content/uploads/2016/09/bg2.jpg|caption^Great minds getting together. Confident young African man pointing laptop while sitting together with his colleagues in office|alt^null|title^Young designers at work in office|description^null" enable_overlay="enable_overlay_value" multi_color_overlay="uvc-multi-color-bg" css=".vc_custom_1507530493492{padding-top: 100px !important;padding-right: 5% !important;padding-bottom: 100px !important;padding-left: 5% !important;}"][vc_column][apress_heading sub_title="Suspendisse potenti. Donec vestibulum commodo gravida. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam congue nibh porta augue scelerisque bibendum facilisis sed libero." enable_delimiter="" title_google_fonts="yes" style="heading_style1" title_font_options="tag:h2|font_size:50|color:%23ffffff|line_height:60|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div|color:%23ffffff" heading_margin="margin-bottom:30" subheading_margin="margin-bottom:30"]Delivering Results. On Time. Everytime.[/apress_heading][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'CTA 2', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/cta2.jpg' );
	$data['sort_name'] = 'Call to Action';
	$data['custom_class'] = 'general call-to-action';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1501870124162{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #8659d6 !important;}"][vc_column css=".vc_custom_1501867341160{padding-left: 5% !important;}"][apress_heading sub_title="" enable_delimiter="" title_google_fonts="yes" style="heading_style1" title_font_options="tag:h2|font_size:35|color:%23ffffff|line_height:50|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div|color:%23ffffff" subheading_margin="margin-bottom:30" heading_margin="margin-bottom:50"]Have  A Question. Contact Us Today for Immediate Assistance.[/apress_heading][apress_button button_text="Contact Us " color_scheme="design_your_own" button_bg_color="rgba(82,149,234,0.01)" button_bg_color_h="#8659d6" button_border_color="#ffffff" button_border_color_h="#ffffff" button_size="large" button_alignment="center"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'CTA 3', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/cta3.jpg' );
	$data['sort_name'] = 'Call to Action';
	$data['custom_class'] = 'general call-to-action';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1500730630316{background-color: #8659d6 !important;}"][vc_column css=".vc_custom_1473662300217{padding-top: 0px !important;}"][apress_callto_action calltoaction_title="HAVE A QUESTION FOR US, WE ARE AVAILABLE 24 X 7" calltoaction_title_size="20" calltoaction_titlecolor="#ffffff" calltoaction_text="" calltoaction_textcolor="#ffffff" calltoaction_boxbgcolor="rgba(247,247,247,0.01)" calltoaction_boxbordercolor="rgba(240,240,240,0.01)" calltoaction_button_text="START PROJECT" calltoaction_buttonfontcolor="#ffffff" calltoaction_buttonfontcolorhover="#8659d6" calltoaction_buttonbgcolor="#8659d6" calltoaction_buttonbgcolorhover="#ffffff" calltoaction_buttonbordercolor="#ffffff" calltoaction_buttonbordercolorhover="#8659d6" data_delay="300" icon_family="fontawesome"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'CTA 4', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/cta4.jpg' );
	$data['sort_name'] = 'Call to Action';
	$data['custom_class'] = 'general call-to-action';
	$data['content'] = <<<CONTENT
[vc_row][vc_column css=".vc_custom_1469083605663{padding-top: 0px !important;}"][ultimate_spacer height="70"][apress_callto_action calltoaction_topbottom_pad="50" calltoaction_title="Are you looking for job?" calltoaction_titlecolor="#4d4d4d" calltoaction_text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla nisi augue, maximus id posuere id, dictum ut ipsum. Etiam ullamcorper massa et porta pretium." calltoaction_textcolor="#4d4d4d" calltoaction_button_text="READ MORE" calltoaction_buttonfontcolor="#ffffff" calltoaction_buttonfontcolorhover="#ffffff" calltoaction_buttonbgcolor="#8b79db" calltoaction_buttonbgcolorhover="#8b79db" calltoaction_buttonbordercolor="#8b79db" calltoaction_buttonbordercolorhover="#8b79db" icon_family="fontawesome" icon_fontawesome="fa fa-paper-plane-o" calltoaction_button_icon_position="right"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'CTA 5', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/cta5.jpg' );
	$data['sort_name'] = 'Call to Action';
	$data['custom_class'] = 'general call-to-action';
	$data['content'] = <<<CONTENT
[vc_row bg_type="bg_color" bg_override="full" bg_color_value="#ededed"][vc_column css=".vc_custom_1469087635873{padding-top: 0px !important;}"][ultimate_spacer height="50"][vc_row_inner][vc_column_inner width="1/3" css=".vc_custom_1469092647590{padding-top: 30px !important;}"][apress_callto_action calltoaction_topbottom_pad="50" calltoaction_title="Are you looking for job?" calltoaction_titlecolor="#4d4d4d" calltoaction_text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla nisi augue, maximus id posuere id, dictum ut ipsum. Etiam ullamcorper massa et porta pretium." calltoaction_textcolor="#4d4d4d" calltoaction_buttonposi="button_posi_bottom" calltoaction_button_text="READ MORE" calltoaction_buttonfontcolor="#ffffff" calltoaction_buttonfontcolorhover="#ffffff" calltoaction_buttonbgcolor="#8b79db" calltoaction_buttonbgcolorhover="#8b79db" calltoaction_buttonbordercolor="#8b79db" calltoaction_buttonbordercolorhover="#8b79db" icon_family="typicons" icon_typicons="typcn typcn-arrow-right" calltoaction_button_icon_position="right"][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1469092654165{padding-top: 30px !important;}"][apress_callto_action calltoaction_topbottom_pad="50" calltoaction_title="Are you looking for job?" calltoaction_titlecolor="#ffffff" calltoaction_text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla nisi augue, maximus id posuere id, dictum ut ipsum. Etiam ullamcorper massa et porta pretium." calltoaction_textcolor="#ffffff" imagebox_image="496" calltoaction_buttonposi="button_posi_bottom" calltoaction_button_text="READ MORE" calltoaction_buttonstyle="rounded" calltoaction_buttonfontcolor="#ffffff" calltoaction_buttonfontcolorhover="#ffffff" calltoaction_buttonbgcolor="" calltoaction_buttonbgcolorhover="" calltoaction_buttonbordercolor="#ffffff" calltoaction_buttonbordercolorhover="#ffffff" icon_family="typicons" icon_typicons="typcn typcn-arrow-right" calltoaction_button_icon_position="right"][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1469092659852{padding-top: 30px !important;}"][apress_callto_action calltoaction_topbottom_pad="50" calltoaction_title="Are you looking for job?" calltoaction_titlecolor="#ffffff" calltoaction_text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla nisi augue, maximus id posuere id, dictum ut ipsum. Etiam ullamcorper massa et porta pretium." calltoaction_textcolor="#ffffff" calltoaction_boxbgcolor="#8b79db" calltoaction_buttonposi="button_posi_bottom" calltoaction_button_text="READ MORE" calltoaction_buttonstyle="rounded" calltoaction_buttonfontcolor="#ffffff" calltoaction_buttonfontcolorhover="#8b79db" calltoaction_buttonbgcolor="" calltoaction_buttonbgcolorhover="#ffffff" calltoaction_buttonbordercolor="#ffffff" calltoaction_buttonbordercolorhover="#ffffff" icon_family="typicons" icon_typicons="typcn typcn-arrow-right" calltoaction_button_icon_position="right"][/vc_column_inner][/vc_row_inner][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'CTA 6', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/cta6.jpg' );
	$data['sort_name'] = 'Call to Action';
	$data['custom_class'] = 'general call-to-action';
	$data['content'] = <<<CONTENT
[vc_row][vc_column css=".vc_custom_1469092974060{padding-top: 0px !important;}"][ultimate_spacer height="100"][apress_callto_action calltoaction_topbottom_pad="50" calltoaction_title="Are you looking for job?" calltoaction_titlecolor="#4d4d4d" calltoaction_text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla nisi augue, maximus id posuere id, dictum ut ipsum. Etiam ullamcorper massa et porta pretium." calltoaction_textcolor="#4d4d4d" calltoaction_boxbgcolor="" calltoaction_top_borderwidth="2" calltoaction_right_borderwidth="2" calltoaction_bottom_borderwidth="2" calltoaction_left_borderwidth="2" calltoaction_boxbordercolor="#8b79db" calltoaction_button_text="READ MORE" calltoaction_buttonstyle="rounded" calltoaction_button_border_radius="3" calltoaction_buttonfontcolor="#8b79db" calltoaction_buttonfontcolorhover="#ffffff" calltoaction_buttonbgcolor="" calltoaction_buttonbgcolorhover="#8b79db" calltoaction_buttonbordercolor="#8b79db" calltoaction_buttonbordercolorhover="#8b79db" icon_family="typicons" icon_typicons="typcn typcn-arrow-right" calltoaction_button_icon_position="right"][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'CTA 7', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/cta7.jpg' );
	$data['sort_name'] = 'Call to Action';
	$data['custom_class'] = 'general call-to-action';
	$data['content'] = <<<CONTENT
[vc_row][vc_column css=".vc_custom_1469092974060{padding-top: 0px !important;}"][ultimate_spacer height="100"][apress_callto_action calltoaction_topbottom_pad="50" calltoaction_title="Are you looking for job?" calltoaction_titlecolor="#4d4d4d" calltoaction_text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla nisi augue, maximus id posuere id, dictum ut ipsum. Etiam ullamcorper massa et porta pretium." calltoaction_textcolor="#4d4d4d" calltoaction_boxbgcolor="#f7f8fa" calltoaction_top_borderwidth="0" calltoaction_right_borderwidth="0" calltoaction_bottom_borderwidth="8" calltoaction_left_borderwidth="0" calltoaction_boxbordercolor="#e3e8eb" calltoaction_button_text="READ MORE" calltoaction_buttonfontcolor="#ffffff" calltoaction_buttonfontcolorhover="#ffffff" calltoaction_buttonbgcolor="#8b79db" calltoaction_buttonbgcolorhover="#8b79db" calltoaction_buttonbordercolor="#8b79db" calltoaction_buttonbordercolorhover="#8b79db" icon_family="typicons" icon_typicons="typcn typcn-arrow-right" calltoaction_button_icon_position="right"][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'CTA 8', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/cta8.jpg' );
	$data['sort_name'] = 'Call to Action';
	$data['custom_class'] = 'general call-to-action';
	$data['content'] = <<<CONTENT
[vc_row][vc_column css=".vc_custom_1469092974060{padding-top: 0px !important;}"][ultimate_spacer height="100"][apress_callto_action calltoaction_topbottom_pad="50" calltoaction_title="Are you looking for job?" calltoaction_titlecolor="#4d4d4d" calltoaction_text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla nisi augue, maximus id posuere id, dictum ut ipsum. Etiam ullamcorper massa et porta pretium." calltoaction_textcolor="#4d4d4d" calltoaction_boxbgcolor="#f7f8fa" calltoaction_top_borderwidth="0" calltoaction_right_borderwidth="0" calltoaction_bottom_borderwidth="0" calltoaction_left_borderwidth="8" calltoaction_boxbordercolor="#e3e8eb" calltoaction_button_text="READ MORE" calltoaction_buttonfontcolor="#ffffff" calltoaction_buttonfontcolorhover="#ffffff" calltoaction_buttonbgcolor="#8b79db" calltoaction_buttonbgcolorhover="#8b79db" calltoaction_buttonbordercolor="#8b79db" calltoaction_buttonbordercolorhover="#8b79db" icon_family="typicons" icon_typicons="typcn typcn-arrow-right" calltoaction_button_icon_position="right"][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'CTA 9', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/cta9.jpg' );
	$data['sort_name'] = 'Call to Action';
	$data['custom_class'] = 'general call-to-action';
	$data['content'] = <<<CONTENT
[vc_row][vc_column css=".vc_custom_1469092974060{padding-top: 0px !important;}"][ultimate_spacer height="100"][apress_callto_action calltoaction_style="style2" calltoaction_topbottom_pad="50" calltoaction_title="Are you looking for job?" calltoaction_titlecolor="#ffffff" calltoaction_text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla nisi augue, maximus id posuere id, dictum ut ipsum. Etiam ullamcorper massa et porta pretium." calltoaction_textalign="center" calltoaction_textcolor="#ffffff" calltoaction_boxbgcolor="#4d5a6a" calltoaction_top_borderwidth="0" calltoaction_right_borderwidth="0" calltoaction_bottom_borderwidth="0" calltoaction_left_borderwidth="0" calltoaction_boxbordercolor=""][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'CTA 10', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/cta10.jpg' );
	$data['sort_name'] = 'Call to Action';
	$data['custom_class'] = 'general call-to-action';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-default" bg_image_new="id^140|url^http://apresswp.com/demo4/wp-content/uploads/2016/12/img_7.jpg|caption^null|alt^null|title^img_7|description^null" bg_override="full" css=".vc_custom_1483077965593{padding-bottom: 350px !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/6"][/vc_column_inner][vc_column_inner width="2/3"][ultimate_heading main_heading="Present your own tech or startup business with StartIT" main_heading_style="font-weight:bold;" main_heading_font_size="desktop:40px;" main_heading_line_height="desktop:55px;" main_heading_margin="margin-top:52px;margin-bottom:12px;" sub_heading_font_size="desktop:16px;" sub_heading_line_height="desktop:26px;"]Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat.[/ultimate_heading][/vc_column_inner][vc_column_inner width="1/6"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1483505193140{padding-bottom: 125px !important;}"][vc_column_inner width="1/2"][ult_buttons btn_title="VIEW PAGE" btn_align="ubtn-right" btn_bg_color="" btn_hover="ubtn-fade-bg" btn_anim_effect="ulta-wobble-horizontal" btn_bg_color_hover="#292929" btn_title_color_hover="#ffffff" icon_size="32" btn_icon_pos="ubtn-sep-icon-at-left" btn_border_style="solid" btn_color_border="#292929" btn_color_border_hover="#292929" btn_border_size="3" btn_radius="3" css_adv_btn=".vc_custom_1483505171021{margin-top: 15px !important;}" btn_font_style="font-weight:bold;" btn_font_size="desktop:14px;" btn_line_height="desktop:20px;"][/vc_column_inner][vc_column_inner width="1/2"][ult_buttons btn_title="PURCHASE NOW" btn_title_color="#ffffff" btn_bg_color="#896ad5" btn_hover="ubtn-fade-bg" btn_anim_effect="ulta-wobble-horizontal" btn_bg_color_hover="#e0dfe5" btn_title_color_hover="#896ad5" icon_size="32" btn_icon_pos="ubtn-sep-icon-at-left" btn_border_style="solid" btn_color_border="#896ad5" btn_color_border_hover="#896ad5" btn_border_size="3" btn_radius="3" css_adv_btn=".vc_custom_1483505157634{margin-top: 15px !important;}" btn_font_style="font-weight:bold;" btn_font_size="desktop:14px;" btn_line_height="desktop:20px;"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 1', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general1.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" equal_height="yes" content_placement="middle" css=".vc_custom_1505543904011{padding-bottom: 50px !important;}"][vc_column width="1/3"][apress_heading sub_title="Etiam ullamcorper massa et porta pretium. Mauris hendrerit tellus a hendrerit suscipit. Maecenas luctus elit odio, at luctus arcu dignissim eget. In urna elit, dignissim ut elementum in, tempus id ligula. Ut placerat nulla sed justo interdum facilisis. Etiam sagittis purus lacus, ac ultrices ante convallis ut." content_alignment="left" data_animation="fadeInLeft" enable_delimiter="" title_google_fonts="yes" style="heading_style1" heading_margin="margin-bottom:30" subheading_margin="margin-bottom:30" title_font_options="tag:h2|letter_spacing:1|font_style_underline:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div" title_responsive="font_size_tablet:35|line_height_tablet:40|letter_spacing_tablet:1|font_size_mobile:25|line_height_mobile:30|letter_spacing_mobile:1"]Excellence Breeds Success[/apress_heading][/vc_column][vc_column width="1/3"][vc_single_image image="1579" img_size="350 x 600" alignment="center" onclick="link_image" css_animation="fadeInUp"][/vc_column][vc_column width="1/3"][apress_heading sub_title="Etiam ullamcorper massa et porta pretium. Mauris hendrerit tellus a hendrerit suscipit. Maecenas luctus elit odio, at luctus arcu dignissim eget. In urna elit, dignissim ut elementum in, tempus id ligula. Ut placerat nulla sed justo interdum facilisis. Etiam sagittis purus lacus, ac ultrices ante convallis ut." content_alignment="left" data_animation="fadeInRight" data_delay="700" enable_delimiter="" title_google_fonts="yes" style="heading_style1" heading_margin="margin-bottom:30" subheading_margin="margin-bottom:30" title_font_options="tag:h2|letter_spacing:1|font_style_underline:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div" title_responsive="font_size_tablet:35|line_height_tablet:40|letter_spacing_tablet:1|font_size_mobile:25|line_height_mobile:30|letter_spacing_mobile:1"]We Deliver Results[/apress_heading][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 2', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general2.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1501898468617{padding-top: 45px !important;padding-bottom: 30px !important;}"][vc_column css=".vc_custom_1501897467348{padding-right: 10% !important;padding-left: 10% !important;}"][apress_heading sub_title="Etiam ullamcorper massa et porta pretium. Mauris hendrerit tellus a hendrerit suscipit. Maecenas luctus elit odio, at luctus arcu dignissim eget. In urna elit, dignissim ut elementum in, tempus id ligula. Ut placerat nulla sed justo interdum facilisis. Etiam sagittis purus lacus, ac ultrices ante convallis ut." data_animation="fadeInUp" data_delay="300" enable_delimiter="" title_google_fonts="yes" style="heading_style1" heading_margin="margin-bottom:30" subheading_margin="margin-bottom:30" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" subtitle_font_options="tag:div" title_responsive="font_size_tablet:35|line_height_tablet:40|letter_spacing_tablet:1|font_size_mobile:25|line_height_mobile:30|letter_spacing_mobile:1"]How We Work[/apress_heading][/vc_column][/vc_row][vc_row css=".vc_custom_1505543863176{padding-bottom: 50px !important;}"][vc_column width="1/3"][apress_process title="DESIGN" content_alignment="left" data_animation="fadeInLeft" data_delay="200" style="process_style3" title_font_options="tag:h1" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Etiam ullamcorper massa et porta pretium. Mauris hendrerit tellus a hendrerit suscipit. Maecenas luctus elit odio, at luctus arcu dignissim eget.[/apress_process][/vc_column][vc_column width="1/3"][apress_process title="DELIVER" process_step="02" content_alignment="left" data_animation="fadeInUp" data_delay="400" style="process_style3" title_font_options="tag:h1" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Etiam ullamcorper massa et porta pretium. Mauris hendrerit tellus a hendrerit suscipit. Maecenas luctus elit odio, at luctus arcu dignissim eget.[/apress_process][/vc_column][vc_column width="1/3"][apress_process title="SUPPORT" process_step="03" content_alignment="left" data_animation="fadeInRight" data_delay="600" style="process_style3" title_font_options="tag:h1" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Etiam ullamcorper massa et porta pretium. Mauris hendrerit tellus a hendrerit suscipit. Maecenas luctus elit odio, at luctus arcu dignissim eget.[/apress_process][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 3', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general3.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row][vc_column css=".vc_custom_1470037688258{padding-top: 0px !important;}"][ultimate_spacer height="93"][ultimate_heading main_heading="OUR SERVICES" main_heading_color="#404040" spacer="line_only" spacer_position="bottom" line_height="2" line_color="#6348db" main_heading_font_size="desktop:40px;" main_heading_line_height="desktop:35px;" line_width="50" spacer_margin="margin-bottom:20px;" main_heading_margin="margin-bottom:50px;"][/ultimate_heading][vc_row_inner css=".vc_custom_1473768479816{padding-top: 30px !important;}"][vc_column_inner width="1/3" css=".vc_custom_1470043738136{padding-top: 30px !important;}"][apress_icon_box box_style="box_style_square" box_hover_style="box-flip-vertical" box_bg="#7862db" box_border="#7862db" box_hover_bg="#7862db" box_hover_border="#7862db" iconcolor="#ffffff" iconposition2="center" variation_icon_hover_bg_color="#ffffff" variation_icon_hover_border_color="#ffffff" contentboxtitle_size="20" title_desc_color="#ffffff" icon_family="fontawesome" icon_fontawesome="fa fa-desktop" contentboxtitle="WEB DEVELOPMENT" contentboxanimation="bounceIn" icon="zm-mobile"][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1470043743728{padding-top: 30px !important;}"][apress_icon_box box_style="box_style_square" box_hover_style="box-flip-vertical" box_bg="#6348db" box_border="#6348db" box_hover_bg="#6348db" box_hover_border="#6348db" iconcolor="#ffffff" iconposition2="center" variation_icon_hover_bg_color="#ffffff" variation_icon_hover_border_color="#ffffff" contentboxtitle_size="20" title_desc_color="#ffffff" icon_family="fontawesome" icon_fontawesome="fa fa-wordpress" contentboxtitle="WORDPRESS" contentboxanimation="bounceIn" contentboxdelay="700" icon="fa-wordpress"][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1470043748909{padding-top: 30px !important;}"][apress_icon_box box_style="box_style_square" box_hover_style="box-flip-vertical" box_bg="#4c2bdb" box_border="#4c2bdb" box_hover_bg="#4c2bdb" box_hover_border="#4c2bdb" iconcolor="#ffffff" iconposition2="center" variation_icon_hover_bg_color="#ffffff" variation_icon_hover_border_color="#ffffff" contentboxtitle_size="20" title_desc_color="#ffffff" icon_family="fontawesome" icon_fontawesome="fa fa-cart-arrow-down" contentboxtitle="WOOCOMMERCE" contentboxanimation="bounceIn" contentboxdelay="900" icon="en-cart"][/vc_column_inner][/vc_row_inner][ultimate_spacer height="120"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 4', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general4.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" gap="10" content_placement="middle" css=".vc_custom_1473946195230{margin-right: 0px !important;padding-bottom: 80px !important;}"][vc_column width="1/2" css=".vc_custom_1473947126804{padding-top: 90px !important;padding-right: 10% !important;padding-bottom: 50px !important;padding-left: 10% !important;}" offset="vc_col-lg-offset-0 vc_col-md-offset-0 vc_col-sm-offset-0"][ultimate_heading main_heading="WHY CHOOSE APRESS" alignment="left" main_heading_margin="margin-top:50px;margin-bottom:50x;" sub_heading_margin="margin-bottom:10px;" main_heading_font_size="desktop:30px;tablet:25px;tablet_portrait:20px;mobile_landscape:20px;mobile:20px;" main_heading_line_height="desktop:60px;tablet:50px;tablet_portrait:40px;mobile_landscape:40px;mobile:40px;" sub_heading_font_size="desktop:20px;tablet:16px;tablet_portrait:16px;mobile_landscape:16px;mobile:16px;" sub_heading_line_height="desktop:30px;tablet:25px;tablet_portrait:25px;mobile_landscape:25px;mobile:25px;"]Sed imperdiet bibendum purus nec tristique. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.[/ultimate_heading][vc_row_inner][vc_column_inner][ultimate_spacer height="10"][apress_icon_box iconcolor="#8e54e9" icon_size="50" contentboxtitle_size="20" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="#757575" icon_family="typicons" icon_typicons="typcn typcn-tick" contentboxtitle="Unlimited Unique Headers" contentboxarea="APRESS has drag n drop unique header builder for creating any kind of website ,both horizontal and vertical." icon="el-clipboard"][ultimate_spacer height="10"][apress_icon_box iconcolor="#8e54e9" icon_size="50" contentboxtitle_size="20" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="#757575" icon_family="typicons" icon_typicons="typcn typcn-tick" contentboxtitle="Unlimited Layouts" contentboxarea="With APRESS you can easily manage different looks for pages,posts and portfolio . Simply select the options ." icon="el-tools-2"][ultimate_spacer height="10"][apress_icon_box iconcolor="#8e54e9" icon_size="50" contentboxtitle_size="20" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="#757575" icon_family="typicons" icon_typicons="typcn typcn-tick" contentboxtitle="80 + VC Elements" contentboxarea="APRESS theme is fully Visual Composer ready and has 80+ custom elements .All fully editable." icon="el-layers"][ultimate_spacer height="10"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" css=".vc_custom_1473428822970{margin-right: 0px !important;padding-right: 0px !important;}"][ultimate_spacer height="100" height_on_tabs="70" height_on_tabs_portrait="50" height_on_mob_landscape="50" height_on_mob="50"][vc_single_image image="509" img_size="full" alignment="right" css_animation="bottom-to-top"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 5', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general5.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1475224662720{padding-bottom: 100px !important;background-color: #ffffff !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ultimate_spacer height="35" height_on_tabs="35" height_on_tabs_portrait="35" height_on_mob_landscape="35" height_on_mob="35"][ultimate_heading main_heading="FREQUENTLY ASKED QUESTIONS" main_heading_color="#747474" main_heading_font_size="desktop:35px;tablet:25px;tablet_portrait:20px;mobile_landscape:20px;mobile:20px;" main_heading_line_height="desktop:80px;tablet:50px;tablet_portrait:40px;mobile_landscape:40px;mobile:40px;" main_heading_margin="margin-bottom:40px;"][/ultimate_heading][vc_tta_accordion c_icon="plus" active_section="1" css_animation="fadeInUp" title_color="" content_border_color="rgba(236,235,235,0.01)"][vc_tta_section active_title_color="#8e54e9" active_border_color="#f4f4f4" title="How to get free theme installation." tab_id="1505550656876-22a2d212-fc23"][vc_column_text css=".vc_custom_1505550915619{margin-top: -10px !important;margin-bottom: -10px !important;}"]Thanks you for choosing APRESS Theme. For free theme installation simply mail us at <a href="mailto:apresswp@gmail.com">apresswp@gmail.com</a> . We will take care of the rest.[/vc_column_text][/vc_tta_section][vc_tta_section active_title_color="#8e54e9" active_border_color="#f4f4f4" title="What details do you need for installing APRESS Theme on server ." tab_id="1505550929253-b03cec6b-583c"][vc_column_text css=".vc_custom_1505551181079{margin-top: -10px !important;margin-bottom: -10px !important;}"]We will need the following details –

FTP Credentials
Domain name where the site needs to be configured.
Database details

If you have WordPress already installed then only FTP and WordPress Admin credentials are required.[/vc_column_text][/vc_tta_section][vc_tta_section active_title_color="#8e54e9" active_border_color="#f4f4f4" title="How safe are sharing my credentials with your team." tab_id="1505550928345-1f1e2c77-dac5"][vc_column_text css=".vc_custom_1505551214146{margin-top: -10px !important;margin-bottom: -10px !important;}"]We do not save any credentials on our end and once the set up is ready we will inform you so you can change the credentials to your need.[/vc_column_text][/vc_tta_section][vc_tta_section active_title_color="#8e54e9" active_border_color="#f4f4f4" title="How much time is needed for theme installation" tab_id="1505550927568-2e2f2140-10e6"][vc_column_text css=".vc_custom_1505551244495{margin-top: -10px !important;margin-bottom: -10px !important;}"]Setting up the theme takes less than an hour but it depends on the workload.[/vc_column_text][/vc_tta_section][vc_tta_section active_title_color="#8e54e9" active_border_color="#f4f4f4" title="What does 1 hour free customization include ?" tab_id="1505550926623-45a26c2e-53d6"][vc_column_text css=".vc_custom_1505551273083{margin-top: -10px !important;margin-bottom: -10px !important;}"]Free 1 hour customization includes only changes to theme options set up in case you cannot modify or have trouble changing the theme options. However this does not include any code changes or extending functionality of theme.

If something that needs couple of minutes work ,we will happily do it for you. If the change is major you can order our customization services.[/vc_column_text][/vc_tta_section][vc_tta_section active_title_color="#8e54e9" active_border_color="#f4f4f4" title="Do you charge anything for 1 hour customization" tab_id="1505550925328-cb8cc3a8-da9c"][vc_column_text css=".vc_custom_1505551315545{margin-top: -10px !important;margin-bottom: -10px !important;}"]No.[/vc_column_text][/vc_tta_section][vc_tta_section active_title_color="#8e54e9" active_border_color="#f4f4f4" title="Can you make the theme look like my PSD of Mock up ?" tab_id="1505551320496-65cce04d-dc3f"][vc_column_text css=".vc_custom_1505551358653{margin-top: -10px !important;margin-bottom: -10px !important;}"]Yes we can customize the Theme as per your requirements. Check our customization and services.[/vc_column_text][/vc_tta_section][vc_tta_section active_title_color="#8e54e9" active_border_color="#f4f4f4" title="I need more customization !" tab_id="1505551318575-2578de22-0d55"][vc_column_text css=".vc_custom_1505551399673{margin-top: -10px !important;margin-bottom: -10px !important;}"]Check out our services and customization page.[/vc_column_text][/vc_tta_section][vc_tta_section active_title_color="#8e54e9" active_border_color="#f4f4f4" title="I have a question !" tab_id="1505551401508-903f91e9-967b"][vc_column_text css=".vc_custom_1505551442440{margin-top: -10px !important;margin-bottom: -10px !important;}"]DO mail us your questions, feedback or suggestions at apresswp@gmail.com[/vc_column_text][/vc_tta_section][/vc_tta_accordion][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 6', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general6.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" bg_type="image" parallax_style="vcpb-default" bg_image_new="id^1088|url^http://apresswp.com/demo1/wp-content/uploads/2016/09/business_1.jpg|caption^null|alt^null|title^business_1|description^null" bg_override="ex-full" parallax_content="parallax_content_value" enable_overlay="enable_overlay_value" overlay_color="rgba(30,29,29,0.56)" css=".vc_custom_1500729127876{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column css=".vc_custom_1473430252985{padding-top: 100px !important;padding-bottom: 100px !important;}"][ultimate_heading main_heading="The goal as a company is to have customer service that is not just the best but legendary. " main_heading_color="#ffffff" sub_heading_color="#ffffff" main_heading_font_size="desktop:40px;tablet:25px;tablet_portrait:20px;mobile_landscape:20px;mobile:20px;" main_heading_line_height="desktop:60px;tablet:40px;tablet_portrait:30px;mobile_landscape:30px;mobile:30px;" main_heading_margin="margin-bottom:20px;" sub_heading_font_size="desktop:24px;tablet:20px;tablet_portrait:20px;mobile_landscape:20px;mobile:20px;" sub_heading_line_height="desktop:50px;tablet:20px;tablet_portrait:20px;mobile_landscape:20px;mobile:20px;"]<em>Sam Walton</em>[/ultimate_heading][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 7', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general7.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1474448178353{padding-top: 50px !important;padding-bottom: 0px !important;}"][vc_column][apress_callto_action calltoaction_title="Maecenas eu gravida nulla. Maecenas hendrerit pellentesque augue, auctor vehicula tellus tempus eu. Mauris eu iaculis felis, ac elementum nunc. Praesent sed bibendum leo. " calltoaction_title_size="20" calltoaction_text="" calltoaction_boxbgcolor="rgba(247,247,247,0.01)" calltoaction_boxbordercolor="rgba(240,240,240,0.01)" calltoaction_button_text="START PROJECT" calltoaction_buttonfontcolor="#ffffff" calltoaction_buttonfontcolorhover="#8659d6" calltoaction_buttonbgcolor="#8659d6" calltoaction_buttonbgcolorhover="#ffffff" calltoaction_buttonbordercolor="#8659d6" calltoaction_buttonbordercolorhover="#8659d6" data_animation="fadeIn" data_delay="100" icon_family="fontawesome"][/vc_column][/vc_row][vc_row css=".vc_custom_1474448190780{padding-top: 100px !important;padding-bottom: 110px !important;}"][vc_column width="1/3"][apress_icon_box box_style="box_style_square" box_variation="variation_modern" box_bg="#ffffff" box_border="#e0e0e0" iconcolor="#ffffff" icon_hover_color="rgba(255,255,255,0.5)" icon_size="50" variation_icon_bg_shape="full_width" shape_size="100" variation_icon_bg_color="#8659d6" variation_icon_border_color="#8659d6" contentboxtitle_size="20" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="" icon_family="fontawesome" icon_fontawesome="fa fa-cog" contentboxtitle="POWERFUL ADMIN" contentboxanimation="fadeIn" contentboxdelay="100" box_button="button_show" button_text="ORDER NOW" button_style="button_style_outline" button_shape="button_shape_square" button_font_color="#90c847" button_border_color="#90c847" button_hover_font_color="#90c847" button_hover_border_color="#90c847" button_size="button_size_normal" button_alignment="button_alignment_center" button_icon_show_hide="button_icon_show_onhover" button_icon="oi-cole-townsend-check" button_icon_alignment="but_icon_alignment_right"][/vc_column][vc_column width="1/3"][apress_icon_box box_style="box_style_square" box_variation="variation_modern" box_bg="#ffffff" box_border="#e0e0e0" iconcolor="#ffffff" icon_hover_color="rgba(255,255,255,0.5)" icon_size="50" variation_icon_bg_shape="full_width" shape_size="100" variation_icon_bg_color="#8659d6" variation_icon_border_color="#8659d6" contentboxtitle_size="20" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="" icon_family="openiconic" icon_openiconic="vc-oi vc-oi-layers" contentboxtitle="DRAG N DROP" contentboxanimation="fadeIn" contentboxdelay="200" icon="wb-layers" box_button="button_show" button_text="ORDER NOW" button_style="button_style_outline" button_shape="button_shape_square" button_font_color="#90c847" button_border_color="#90c847" button_hover_font_color="#90c847" button_hover_border_color="#90c847" button_size="button_size_normal" button_alignment="button_alignment_center" button_icon_show_hide="button_icon_show_onhover" button_icon="oi-cole-townsend-check" button_icon_alignment="but_icon_alignment_right"][/vc_column][vc_column width="1/3"][apress_icon_box box_style="box_style_square" box_variation="variation_modern" box_bg="#ffffff" box_border="#e0e0e0" iconcolor="#ffffff" icon_hover_color="rgba(255,255,255,0.5)" icon_size="50" variation_icon_bg_shape="full_width" shape_size="100" variation_icon_bg_color="#8659d6" variation_icon_border_color="#8659d6" contentboxtitle_size="20" boxtitlepad="padding-top:10|padding-bottom:5" title_desc_color="" icon_family="fontawesome" icon_fontawesome="fa fa-magic" contentboxtitle="ONE CLICK SET UP" contentboxanimation="fadeIn" contentboxdelay="300" icon="zm-settings" box_button="button_show" button_text="ORDER NOW" button_style="button_style_outline" button_shape="button_shape_square" button_font_color="#90c847" button_border_color="#90c847" button_hover_font_color="#90c847" button_hover_border_color="#90c847" button_size="button_size_normal" button_alignment="button_alignment_center" button_icon_show_hide="button_icon_show_onhover" button_icon="oi-cole-townsend-check" button_icon_alignment="but_icon_alignment_right"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 8', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general8.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row gap="10" content_placement="middle" css=".vc_custom_1473771827981{margin-right: 0px !important;padding-bottom: 20px !important;}"][vc_column width="1/2" offset="vc_col-lg-offset-0 vc_col-md-offset-0 vc_col-sm-offset-0"][ultimate_heading main_heading="WHO WE ARE " alignment="left" main_heading_margin="margin-top:50px;margin-bottom:50x;" sub_heading_margin="margin-bottom:10px;" main_heading_font_size="desktop:30px;tablet:25px;tablet_portrait:20px;mobile_landscape:20px;mobile:20px;" main_heading_line_height="desktop:60px;tablet:50px;tablet_portrait:40px;mobile_landscape:40px;mobile:40px;" sub_heading_font_size="desktop:20px;tablet:16px;tablet_portrait:16px;mobile_landscape:16px;mobile:16px;" sub_heading_line_height="desktop:30px;tablet:25px;tablet_portrait:25px;mobile_landscape:25px;mobile:25px;"][/ultimate_heading][vc_column_text]Morbi et quam nec quam egestas eleifend. Nullam consectetur posuere vestibulum. Mauris eleifend urna felis, vel dictum nunc aliquet eget. Cras bibendum lacus odio, a commodo enim dictum nec. Suspendisse lacinia eget orci vitae pharetra. Maecenas imperdiet sem eu nulla rutrum scelerisque. Duis posuere non quam non porta.[/vc_column_text][/vc_column][vc_column width="1/2" css=".vc_custom_1473428822970{margin-right: 0px !important;padding-right: 0px !important;}"][ultimate_spacer height="50" height_on_tabs="50" height_on_tabs_portrait="50" height_on_mob_landscape="50" height_on_mob="50"][vc_single_image image="1060" img_size="large" alignment="center" css_animation="bottom-to-top"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 9', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general9.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row gap="10" content_placement="top" css=".vc_custom_1473657695499{padding-top: 85px !important;}"][vc_column width="1/3" offset="vc_col-lg-offset-0 vc_col-md-offset-0 vc_col-sm-offset-0"][ultimate_heading main_heading="MY SKILLS" alignment="right" main_heading_font_size="desktop:35px;" main_heading_line_height="desktop:60px;"]Best of me[/ultimate_heading][/vc_column][vc_column width="2/3"][vc_column_text]Maecenas eu gravida nulla. Maecenas hendrerit pellentesque augue, auctor vehicula tellus tempus eu. Mauris eu iaculis felis, ac elementum nunc. Praesent sed bibendum leo. Nulla ullamcorper ipsum at libero tincidunt accumsan. Sed molestie felis vitae rutrum lacinia. In tempor nisi sit amet augue iaculis, nec viverra ipsum viverra.[/vc_column_text][apress_progress_bar cnt_height="5" title="WEB DESIGN" percentage="50" percentage_style="z_percentage_3" pb_color="#8659d6" pb_alt_color="#5f7ee2"][apress_progress_bar cnt_height="5" title="PHOTOSHOP" percentage="60" percentage_style="z_percentage_3" pb_color="#8659d6" pb_alt_color="#5f7ee2"][apress_progress_bar cnt_height="5" title="PHP" percentage="70" percentage_style="z_percentage_3" pb_color="#8659d6" pb_alt_color="#5f7ee2"][apress_progress_bar cnt_height="5" title="DATABASE" percentage_style="z_percentage_3" pb_color="#8659d6" pb_alt_color="#5f7ee2"][apress_progress_bar cnt_height="5" title="WORDPRESS" percentage="90" percentage_style="z_percentage_3" pb_color="#8659d6" pb_alt_color="#5f7ee2"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 10', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general10.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" bg_type="image" parallax_style="vcpb-default" bg_image_new="id^1108|url^http://apresswp.com/demo1/wp-content/uploads/2016/09/bgapress.jpg|caption^null|alt^null|title^bgapress|description^null" bg_img_attach="fixed" bg_override="browser_size" enable_overlay="enable_overlay_value" overlay_color="rgba(22,22,22,0.59)" css=".vc_custom_1500731793038{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column][ultimate_heading sub_heading_color="#ffffff" spacer="image_only" spacer_img_width="100" sub_heading_font_size="desktop:30px;" sub_heading_line_height="desktop:40px;" spacer_img="id^1052|url^http://apresswp.com/demo1/wp-content/uploads/2016/09/apress.png|caption^null|alt^null|title^apress|description^null" spacer_margin="margin-bottom:40px;" sub_heading_margin="margin-bottom:40px;"]We’re coming soon.
Get notified when site goes live[/ultimate_heading][ult_countdown count_style="ult-cd-s2" datetime="2018/09/26 12:11:42" countdown_opts="sday,shr,smin,ssec" tick_col="#ffffff" tick_sep_col="#ffffff" tick_style="bold" tick_size="desktop:60px;" tick_line_height="desktop:70px;" tick_sep_size="desktop:14px;" tick_sep_line_height="desktop:20px;"][ult_buttons btn_title="BACK TO HOME PAGE" btn_link="url:http%3A%2F%2Fapressthemes.com%2Fdemo1|||" btn_align="ubtn-center" btn_title_color="#ffffff" btn_bg_color="" btn_bg_color_hover="rgba(255,255,255,0.1)" btn_title_color_hover="#ffffff" icon_size="32" btn_icon_pos="ubtn-sep-icon-at-left" btn_border_style="solid" btn_color_border="#ffffff" btn_color_border_hover="#ffffff" btn_border_size="2" btn_radius="3" btn_font_size="desktop:14px;" btn_line_height="desktop:20px;" btn_font_style="font-weight:bold;"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 11', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general11.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" bg_type="bg_color" bg_override="browser_size" bg_color_value="#8659d6" css=".vc_custom_1500718798751{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column centered_text="true"][ultimate_heading main_heading="Coming Soon" main_heading_color="#dff856" sub_heading_color="#ffffff" main_heading_font_size="desktop:16px;" main_heading_line_height="desktop:25px;" sub_heading_font_size="desktop:50px;" sub_heading_line_height="desktop:60px;" main_heading_margin="margin-top:30px;margin-bottom:10px;" sub_heading_style="font-weight:bold;" sub_heading_margin="margin-bottom:20px;"]Get notified when
site goes live.[/ultimate_heading][vc_row_inner][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]
<p style="text-align: center;"><span style="color: #ffffff;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla nisi augue, maximus id posuere id, dictum ut ipsum. Etiam ullamcorper massa et porta pretium. Mauris hendrerit tellus a hendrerit suscipit. Maecenas luctus elit odio, at luctus arcu dignissim eget. In urna elit, dignissim ut elementum in, tempus id ligula.</span></p>
[/vc_column_text][vc_column_text]
<p style="text-align: center;">[mc4wp_form id="838"]</p>
[/vc_column_text][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 12', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general12.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" bg_type="image" parallax_style="vcpb-fs-jquery" layer_image="824,825" parallax_sense="10" bg_override="full" css=".vc_custom_1500719103101{background-color: #8659d6 !important;}"][vc_column width="1/2"][ultimate_heading main_heading="The website is in maintenance mode." main_heading_color="#ffffff" sub_heading_color="#ffffff" alignment="left" main_heading_style="font-weight:bold;" main_heading_font_size="desktop:50px;tablet:30px;tablet_portrait:30px;mobile_landscape:25px;mobile:25px;" main_heading_line_height="desktop:60px;tablet:50px;tablet_portrait:50px;mobile_landscape:40px;mobile:40px;" sub_heading_font_size="desktop:14px;" sub_heading_line_height="desktop:24px;" main_heading_margin="margin-bottom:30px;" sub_heading_margin="margin-bottom:30px;"]Integer et gravida ante. Duis efficitur, nibh non porttitor mattis, elit nulla facilisis lorem, sed luctus ligula purus in elit. Fusce tempor orci et malesuada tincidunt. Duis nec nisi ligula. Sed id dapibus felis, quis laoreet lectus. Suspendisse hendrerit, quam at ultrices euismod, est velit fermentum lacus, in pretium turpis est sed risus.[/ultimate_heading][apress_progress_bar title="<strong><em>STATUS PROGRESS</em></strong>" title_color="#ffffff" pb_color="#ffffff" pb_ctn_color="rgba(247,247,247,0.3)" border_color="rgba(255,255,255,0.01)"][ultimate_spacer height="10"][vc_separator color="custom" accent_color="rgba(255,255,255,0.5)"][ult_buttons btn_title="BACK TO HOMEPAGE" btn_link="url:http%3A%2F%2Fapressthemes.com%2Fdemo1|||" btn_title_color="#ffffff" btn_bg_color="rgba(224,224,224,0.01)" btn_hover="ubtn-fade-bg" btn_bg_color_hover="rgba(255,255,255,0.25)" icon_size="32" btn_icon_pos="ubtn-sep-icon-at-left" btn_border_style="solid" btn_color_border="#ffffff" btn_border_size="2" btn_radius="50" btn_font_style="font-weight:bold;" btn_font_size="desktop:14px;" btn_line_height="desktop:20px;"][/vc_column][vc_column width="1/2"][/vc_column][/vc_row]

&nbsp;
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 13', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general13.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][apress_heading sub_title="" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" heading_margin="margin-bottom:50" title_font_options="tag:h2|font_size:35|line_height:50|letter_spacing:1" subtitle_font_options="tag:div"]Image Flip Box With Gradient Buttons[/apress_heading][ultimate_spacer height="50"][vc_row_inner][vc_column_inner width="1/3"][vc_hoverbox image="1945" primary_title="WEB DESIGN" primary_title_font_container="color:%23ffffff" primary_title_use_theme_fonts="yes" primary_title_css_animation="fadeInUp" hover_title="WEB DESIGN" hover_title_font_container="color:%23ffffff" hover_title_use_theme_fonts="yes" hover_background_color="custom" hover_btn_title="Learn More" hover_btn_style="gradient-custom" hover_btn_gradient_custom_color_1="#4776e6" hover_btn_gradient_custom_color_2="#8e54e9" css_animation="fadeInUp" use_custom_fonts_primary_title="true" use_custom_fonts_hover_title="true" hover_add_button="true" hover_custom_background="#333333"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/vc_hoverbox][ultimate_spacer height="50"][/vc_column_inner][vc_column_inner width="1/3"][vc_hoverbox image="1944" primary_title="PHOTOSHOP" primary_title_font_container="color:%23ffffff" primary_title_use_theme_fonts="yes" primary_title_css_animation="fadeInUp" hover_title="WEB DESIGN" hover_title_font_container="color:%23ffffff" hover_title_use_theme_fonts="yes" hover_background_color="custom" hover_btn_title="Learn More" hover_btn_style="gradient-custom" hover_btn_gradient_custom_color_1="#4776e6" hover_btn_gradient_custom_color_2="#8e54e9" css_animation="fadeInUp" use_custom_fonts_primary_title="true" use_custom_fonts_hover_title="true" hover_add_button="true" hover_custom_background="#333333"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/vc_hoverbox][ultimate_spacer height="50"][/vc_column_inner][vc_column_inner width="1/3"][vc_hoverbox image="1943" primary_title="PROMOTION" primary_title_font_container="color:%23ffffff" primary_title_use_theme_fonts="yes" primary_title_css_animation="fadeInUp" hover_title="WEB DESIGN" hover_title_font_container="color:%23ffffff" hover_title_use_theme_fonts="yes" hover_background_color="custom" hover_btn_title="Learn More" hover_btn_style="gradient-custom" hover_btn_gradient_custom_color_1="#4776e6" hover_btn_gradient_custom_color_2="#8e54e9" css_animation="fadeInUp" use_custom_fonts_primary_title="true" use_custom_fonts_hover_title="true" hover_add_button="true" hover_custom_background="#333333"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.[/vc_hoverbox][ultimate_spacer height="50"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 14', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general14.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row bg_type="no_bg" padding="70px 0px 40px 0px"][vc_column width="1/4"][icon_counter flip_type="horizontal_flip_right" flip_box_style="advanced" box_border_style="dashed" box_border_size="2" icon_type="custom" icon_img="id^305|url^http://apresswp.com/demo1/wp-content/uploads/2017/07/0121.png|caption^null|alt^null|title^0121|description^null" img_width="130" block_title_front="Zesty Quinoa Salad" block_desc_front="Lorem ipsum dolor sit amet, consectetur adipiscing elit." block_text_color="#444444" block_front_color="#ffffff" box_border_color="#655643" block_title_back="More info" block_back_text_color="#ffffff" block_back_color="#655643" box_border_color_back="#655643" custom_link="1" button_link="url:%23||" button_text="Buy Now!" button_bg="#dd9933" button_txt="#ffffff" height_type="ifb-custom-height" box_height="320" title_font_style="font-weight:bold;" back="Cras ultricies ligula sed magna dictum porta. Praesent sapien massa, convallis a pellentesque nec, egestas non nisi. " flipbx_padding="padding-bottom:40px;" flipbx_margin="margin-bottom:40px;"][/vc_column][vc_column width="1/4"][icon_counter flip_type="horizontal_flip_right" flip_box_style="advanced" box_border_style="dashed" box_border_size="2" icon_type="custom" icon_img="id^305|url^http://apresswp.com/demo1/wp-content/uploads/2017/07/0121.png|caption^null|alt^null|title^0121|description^null" img_width="130" block_title_front="Pan-Seared Tilapia" block_desc_front="Lorem ipsum dolor sit amet, consectetur adipiscing elit." block_text_color="#444444" block_front_color="#ffffff" box_border_color="#655643" block_title_back="More info" block_desc_back="Cras ultricies ligula sed magna dictum porta. Praesent sapien massa, convallis a pellentesque nec, egestas non nisi. " block_back_text_color="#ffffff" block_back_color="#655643" box_border_color_back="#655643" custom_link="1" button_link="url:%23||" button_text="Buy Now!" button_bg="#dd9933" button_txt="#ffffff" height_type="ifb-custom-height" box_height="320" title_font_style="font-weight:bold;" flipbx_padding="padding-bottom:40px;"][/vc_column][vc_column width="1/4"][icon_counter flip_type="horizontal_flip_right" flip_box_style="advanced" box_border_style="dashed" box_border_size="2" icon_type="custom" icon_img="id^305|url^http://apresswp.com/demo1/wp-content/uploads/2017/07/0121.png|caption^null|alt^null|title^0121|description^null" img_width="130" block_title_front="Garlic Asparagus" block_desc_front="Lorem ipsum dolor sit amet, consectetur adipiscing elit." block_text_color="#444444" block_front_color="#ffffff" box_border_color="#655643" block_title_back="More info" block_desc_back="Cras ultricies ligula sed magna dictum porta. Praesent sapien massa, convallis a pellentesque nec, egestas non nisi. " block_back_text_color="#ffffff" block_back_color="#655643" box_border_color_back="#655643" custom_link="1" button_link="url:%23||" button_text="Buy Now!" button_bg="#dd9933" button_txt="#ffffff" height_type="ifb-custom-height" box_height="320" title_font_style="font-weight:bold;" flipbx_padding="padding-bottom:40px;"][/vc_column][vc_column width="1/4"][icon_counter flip_type="horizontal_flip_right" flip_box_style="advanced" box_border_style="dashed" box_border_size="2" icon_type="custom" icon_img="id^305|url^http://apresswp.com/demo1/wp-content/uploads/2017/07/0121.png|caption^null|alt^null|title^0121|description^null" img_width="130" block_title_front="Mexican Lasagna Lite" block_desc_front="Lorem ipsum dolor sit amet, consectetur adipiscing elit." block_text_color="#444444" block_front_color="#ffffff" box_border_color="#655643" block_title_back="More info" block_desc_back="Cras ultricies ligula sed magna dictum porta. Praesent sapien massa, convallis a pellentesque nec, egestas non nisi. " block_back_text_color="#ffffff" block_back_color="#655643" box_border_color_back="#655643" custom_link="1" button_link="url:%23||" button_text="Buy Now!" button_bg="#dd9933" button_txt="#ffffff" height_type="ifb-custom-height" box_height="320" title_font_style="font-weight:bold;" flipbx_padding="padding-bottom:40px;"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 15', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general15.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" css=".vc_custom_1457168822079{padding-top: 70px !important;padding-right: 0px !important;padding-bottom: 40px !important;padding-left: 0px !important;}"][vc_column width="1/4"][icon_counter flip_box_style="advanced" box_border_style="solid" box_border_size="1" icon="Defaults-bell-o" icon_size="80" icon_color="#de5034" block_title_front="Fully Documented" block_desc_front="Built with you in mind, it's super clean, sleek and simply pleasure to use." block_text_color="#444444" block_front_color="#f7f7f7" box_border_color="#e4e4e4" block_title_back="Fully Documented" block_desc_back="We give a lot of time and effort to ensure our users love to use our themes. It makes us smile." block_back_text_color="#444444" block_back_color="#f7f7f7" box_border_color_back="#eaeaea" custom_link="1" button_link="url:%23||" button_text="Read More!" button_bg="#de5034" button_txt="#ffffff" height_type="ifb-auto-height" title_font_style="font-weight:bold;" title_font_size="desktop:18px;" title_font_line_height="desktop:32px;" desc_font_size="desktop:16px;" desc_font_line_height="desktop:24px;"][/vc_column][vc_column width="1/4"][icon_counter flip_box_style="advanced" box_border_style="solid" box_border_size="1" icon="Defaults-heart-o" icon_size="80" icon_color="#de5034" block_title_front="Lightning Quick" block_desc_front="Built with you in mind, it's super clean, sleek and simply pleasure to use." block_text_color="#444444" block_front_color="#f7f7f7" box_border_color="#e4e4e4" block_title_back="Fully Documented" block_desc_back="We give a lot of time and effort to ensure our users love to use our themes. It makes us smile. " block_back_text_color="#444444" block_back_color="#f7f7f7" box_border_color_back="#eaeaea" custom_link="1" button_link="url:%23||" button_text="Read More!" button_bg="#de5034" button_txt="#ffffff" height_type="ifb-auto-height" title_font_style="font-weight:bold;" title_font_size="desktop:18px;" title_font_line_height="desktop:32px;" desc_font_size="desktop:16px;" desc_font_line_height="desktop:24px;"][/vc_column][vc_column width="1/4"][icon_counter flip_box_style="advanced" box_border_style="solid" box_border_size="1" icon="Defaults-lightbulb-o" icon_size="80" icon_color="#de5034" block_title_front="Tutorial Videos" block_desc_front="Built with you in mind, it's super clean, sleek and simply pleasure to use." block_text_color="#444444" block_front_color="#f7f7f7" box_border_color="#e4e4e4" block_title_back=" Fully Documented" block_desc_back="We give a lot of time and effort to ensure our users love to use our themes. It makes us smile. " block_back_text_color="#444444" block_back_color="#f7f7f7" box_border_color_back="#eaeaea" custom_link="1" button_link="url:%23||" button_text="Get in Touch!" button_bg="#de5034" button_txt="#ffffff" height_type="ifb-auto-height" title_font_style="font-weight:bold;" title_font_size="desktop:18px;" title_font_line_height="desktop:32px;" desc_font_size="desktop:16px;" desc_font_line_height="desktop:24px;"][/vc_column][vc_column width="1/4"][icon_counter flip_box_style="advanced" icon="Defaults-star-o" icon_size="80" icon_color="#de5034" block_title_front="Quick &amp; Easy" block_desc_front="Built with you in mind, it's super clean, sleek and simply pleasure to use." block_text_color="#444444" block_front_color="#f7f7f7" block_title_back="Fully Documented" block_desc_back="We give a lot of time and effort to ensure our users love to use our themes. It makes us smile." block_back_text_color="#444444" block_back_color="#f7f7f7" custom_link="1" button_link="url:%23||" button_text="See Details!" button_bg="#de5034" button_txt="#ffffff" title_font_style="font-weight:bold;" title_font_size="desktop:18px;" title_font_line_height="desktop:32px;" desc_font_size="desktop:16px;" desc_font_line_height="desktop:24px;"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 16', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general16.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1469804027991{padding-bottom: 20px !important;}"][vc_column][ult_hotspot main_img="id^1345|url^http://apresswp.com/demo1/wp-content/uploads/2017/07/hortspot_bg_img_2-1.jpg|caption^null|alt^null|title^hortspot_bg_img_2-1|description^null"][ult_hotspot_items icon="Defaults-eye" icon_size="18" icon_color="#ffffff" icon_style="circle" icon_color_bg="#25bd96" tooltip_custom_bg_color="#ffffff" tooltip_width="170" tooltip_position="left" tooltip_align="center" tooltip_continuous_animation="on" hotspot_position="6.7629179331307,32.142857142857146" tooltip_custom_border_size="border-style:solid;|border-width:1px;border-radius:3px;|border-color:#b4b4b4;" tooltip_font_size="desktop:14px;" tooltip_font_line_height="desktop:20px;"]Drill &amp; Bits[/ult_hotspot_items][ult_hotspot_items icon="Defaults-eye" icon_size="18" icon_color="#ffffff" icon_style="circle" icon_color_bg="#25bd96" tooltip_custom_bg_color="#ffffff" tooltip_width="170" tooltip_position="left" tooltip_align="center" tooltip_continuous_animation="on" hotspot_position="28.373859718577837,28.93586005830904" tooltip_custom_border_size="border-style:solid;|border-width:1px;border-radius:3px;|border-color:#b4b4b4;" tooltip_font_size="desktop:14px;" tooltip_font_line_height="desktop:20px;"]Hand Tools[/ult_hotspot_items][ult_hotspot_items icon="Defaults-eye" icon_size="18" icon_color="#ffffff" icon_style="circle" icon_color_bg="#25bd96" tooltip_custom_bg_color="#ffffff" tooltip_width="170" tooltip_position="left" tooltip_align="center" tooltip_continuous_animation="on" hotspot_position="48.72340518290511,25.437317784256557" tooltip_custom_border_size="border-style:solid;|border-width:1px;border-radius:3px;|border-color:#b4b4b4;" tooltip_font_size="desktop:14px;" tooltip_font_line_height="desktop:20px;"]Shears &amp; Hand Pruners[/ult_hotspot_items][ult_hotspot_items icon="Defaults-eye" icon_size="18" icon_color="#ffffff" icon_style="circle" icon_color_bg="#25bd96" tooltip_custom_bg_color="#ffffff" tooltip_width="170" tooltip_position="right" tooltip_align="center" tooltip_continuous_animation="on" hotspot_position="47.74316248560387,72.56883745406645" tooltip_custom_border_size="border-style:solid;|border-width:1px;border-radius:3px;|border-color:#b4b4b4;" tooltip_font_size="desktop:14px;" tooltip_font_line_height="desktop:20px;"]Drain Cleaner[/ult_hotspot_items][ult_hotspot_items icon="Defaults-eye" icon_size="18" icon_color="#ffffff" icon_style="circle" icon_color_bg="#25bd96" tooltip_custom_bg_color="#ffffff" tooltip_width="170" tooltip_position="right" tooltip_align="center" tooltip_continuous_animation="on" hotspot_position="25.481257105308465,67.3210299744898" tooltip_custom_border_size="border-style:solid;|border-width:1px;border-radius:3px;|border-color:#b4b4b4;" tooltip_font_size="desktop:14px;" tooltip_font_line_height="desktop:20px;"]Measuring[/ult_hotspot_items][ult_hotspot_items icon="Defaults-eye" icon_size="18" icon_color="#ffffff" icon_style="circle" icon_color_bg="#25bd96" tooltip_custom_bg_color="#ffffff" tooltip_width="170" tooltip_position="right" tooltip_align="center" tooltip_continuous_animation="on" hotspot_position="4.25531914893617,62.656306942419825" tooltip_custom_border_size="border-style:solid;|border-width:1px;border-radius:3px;|border-color:#b4b4b4;" tooltip_font_size="desktop:14px;" tooltip_font_line_height="desktop:20px;"]Measuring Scale[/ult_hotspot_items][ult_hotspot_items icon="Defaults-eye" icon_size="18" icon_color="#ffffff" icon_style="circle" icon_color_bg="#25bd96" tooltip_custom_bg_color="#ffffff" tooltip_width="170" tooltip_align="center" tooltip_continuous_animation="on" hotspot_position="0,48.079047467201164" tooltip_custom_border_size="border-style:solid;|border-width:1px;border-radius:3px;|border-color:#b4b4b4;" tooltip_font_size="desktop:14px;" tooltip_font_line_height="desktop:20px;"]Yellow Safety Helmet[/ult_hotspot_items][ult_hotspot_items icon="Defaults-eye" icon_size="18" icon_color="#ffffff" icon_style="circle" icon_color_bg="#25bd96" tooltip_custom_bg_color="#ffffff" tooltip_width="170" tooltip_position="bottom" tooltip_align="center" tooltip_continuous_animation="on" hotspot_position="44.22492633112296,41.5678656367681" tooltip_custom_border_size="border-style:solid;|border-width:1px;border-radius:3px;|border-color:#b4b4b4;" tooltip_font_size="desktop:14px;" tooltip_font_line_height="desktop:20px;"]Construction Tool Kit[/ult_hotspot_items][/ult_hotspot][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 17', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general17.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1469804068361{padding-bottom: 20px !important;}"][vc_column][ult_hotspot main_img="id^1347|url^http://apresswp.com/demo1/wp-content/uploads/2017/07/hortspot_bg_img_3.jpg|caption^null|alt^null|title^hortspot_bg_img_3|description^null"][ult_hotspot_items icon="Defaults-dollar usd" icon_size="18" icon_color="#303030" icon_style="circle" icon_color_bg="#f9f9f9" tooltip_custom_color="#ffffff" tooltip_custom_bg_color="#222222" tooltip_width="250" tooltip_trigger="click" tooltip_position="right" tooltip_animation="euclid" tooltip_align="center" tooltip_continuous_animation="glow" glow_color="#f4f4f4" hotspot_position="14.913070459160016,47.10884353741497" tooltip_custom_border_size="border-style:solid;|border-width:1px;border-radius:3px;|border-color:#222222;" tooltip_font_size="desktop:14px;" tooltip_font_line_height="desktop:20px;"](32.87$)
Hidewear Men's Faux Leather Jacket
#1 Leather Jacket
#2 Mens Leather Jacket
#3 Mens Pu Leather Jacket
#4 Stylish Designer Jacket
#5 Branded Jackets[/ult_hotspot_items][ult_hotspot_items icon="Defaults-dollar usd" icon_size="18" icon_color="#303030" icon_style="circle" icon_color_bg="#f9f9f9" tooltip_custom_color="#ffffff" tooltip_custom_bg_color="#222222" tooltip_width="250" tooltip_trigger="click" tooltip_position="left" tooltip_animation="euclid" tooltip_align="center" tooltip_continuous_animation="glow" glow_color="#f4f4f4" hotspot_position="25.251800207782992,42.63848396501458" tooltip_custom_border_size="border-style:solid;|border-width:1px;border-radius:3px;|border-color:#222222;" tooltip_font_size="desktop:14px;" tooltip_font_line_height="desktop:20px;"](111.99$)
Regular-fit Checkered Casual Shirt
#1 Spread collar
#2 Single chest patch pocket
#3 Long sleeves with barrel cuffs
#4 Regular fit
#5 100% Cotton[/ult_hotspot_items][ult_hotspot_items icon="Defaults-dollar usd" icon_size="18" icon_color="#303030" icon_style="circle" icon_color_bg="#f9f9f9" tooltip_custom_color="#ffffff" tooltip_custom_bg_color="#222222" tooltip_width="250" tooltip_trigger="click" tooltip_position="left" tooltip_animation="euclid" tooltip_align="center" tooltip_continuous_animation="glow" glow_color="#f4f4f4" hotspot_position="51.65767532458408,46.91448007774539" tooltip_custom_border_size="border-style:solid;|border-width:1px;border-radius:3px;|border-color:#222222;" tooltip_font_size="desktop:14px;" tooltip_font_line_height="desktop:20px;"](80.00$)
Jack &amp; Jones Men Black Slim Fit Jeans
#1 Black heavily washed jeans
#2 Blended; Machine-wash cold
#3 The model (height 6' and waist 32") is wearing a size 32
#4 Stylecode: JKJNS16AMDMJS9906750
#5 100% Peor[/ult_hotspot_items][ult_hotspot_items icon="Defaults-dollar usd" icon_size="18" icon_color="#303030" icon_style="circle" icon_color_bg="#f9f9f9" tooltip_custom_color="#ffffff" tooltip_custom_bg_color="#222222" tooltip_width="250" tooltip_trigger="click" tooltip_animation="euclid" tooltip_align="center" tooltip_continuous_animation="glow" glow_color="#f4f4f4" hotspot_position="84.08572793864518,47.59475218658892" tooltip_custom_border_size="border-style:solid;|border-width:1px;border-radius:3px;|border-color:#222222;" tooltip_font_size="desktop:14px;" tooltip_font_line_height="desktop:20px;"](95.25$)
Jollify Mens Sport White Synthetic Leather Shoes
#1 Lifestyle: Sport
#2 Closure type: Lace-Up
#3 Warranty type: Manufacturer
#4 Allow your pair of shoes to air and de-odorize at regular basis; Use Shoe bags to prevent any stains or mildew; Dust any dry dirt from the surface using a clean cloth. Do not use Polish or Shiner[/ult_hotspot_items][/ult_hotspot][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 18', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general18.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/3"][apress_imagebox imagebox_image="576" imagebox_button_size="medium" imagebox_button_text="ABOUT US" imagebox_buttonfontcolor="#ffffff" imagebox_buttonfontcolorhover="#727272" imagebox_buttonbackgroundcolor="rgba(0,0,0,0.53)" imagebox_buttonbordercolor="#727272" imagebox_buttonbordercolorhover="#ffffff" data_animation="fadeIn" data_delay="200" imagebox_link="url:%23|||"]Your Description Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column][vc_column width="1/3"][apress_imagebox imagebox_image="575" imagebox_button_text="OUR TEAM" imagebox_buttonfontcolor="#ffffff" imagebox_buttonfontcolorhover="#727272" imagebox_buttonbackgroundcolor="rgba(0,0,0,0.53)" imagebox_buttonbordercolor="#727272" imagebox_buttonbordercolorhover="#ffffff" data_animation="fadeIn" data_delay="400" imagebox_link="url:%23|||"]Your Description Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column][vc_column width="1/3"][apress_imagebox imagebox_image="574" imagebox_button_text="WORK WITH US" imagebox_buttonfontcolor="#ffffff" imagebox_buttonfontcolorhover="#727272" imagebox_buttonbackgroundcolor="rgba(0,0,0,0.53)" imagebox_buttonbordercolor="#727272" imagebox_buttonbordercolorhover="#ffffff" data_animation="fadeIn" data_delay="600" imagebox_link="url:%23|||"]Your Description Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 19', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general19.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row][vc_column css_animation="fadeInUp"][ultimate_spacer height="100"][vc_row_inner][vc_column_inner width="1/6"][/vc_column_inner][vc_column_inner width="2/3"][apress_image_comparison image_url="1914" image_2_url="1913" image_comparison_orientation="image_comparison_horizontal"][/vc_column_inner][vc_column_inner width="1/6"][/vc_column_inner][/vc_row_inner][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 20', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general20.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row][vc_column css_animation="fadeInUp"][ultimate_spacer height="100"][vc_row_inner][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][apress_image_comparison image_url="1916" image_2_url="1915"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 21', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general21.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1505735329030{padding-top: 100px !important;background-color: #f7f7f7 !important;}"][vc_column][apress_heading sub_title="Add the image slider to any post, page or portfolio." enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div"]Image Slider Style 1 ( Simple Fade Slider )[/apress_heading][apress_image_slider images="1863,1862" img_size="full" slick_fade_effect="yes" slick_item_shadow="" slick_lazyload="yes" style="slider_style1" arrows_style="arrows_style1" bullet_navigation_style="dots_style1"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 22', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general22.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" css=".vc_custom_1505753291044{padding-top: 100px !important;background-color: #f7f7f7 !important;}"][vc_column][apress_heading sub_title="Add the image slider to any post, page or portfolio." enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div"]Image Slider Style 2 ( Stage Slider )[/apress_heading][apress_image_slider images="1864,1865,1866" img_size="full" desktop_no_of_items="1" small_desktop_no_of_items="1" tablet_no_of_items="1" slider_gutter="10" slick_center_desktop_padding="30%" slick_center_small_desktop_padding="40%" slick_center_tablet_padding="30%" slick_focusonselect="yes" slick_item_shadow="yes" slick_lazyload="yes" arrows_bg="" style="slider_style2" arrows_style="arrows_style3" bullet_navigation_style="dots_style3"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 23', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general23.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1505753451694{padding-top: 100px !important;background-color: #f7f7f7 !important;}"][vc_column][apress_heading sub_title="Add the image slider to any post, page or portfolio." enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div"]Image Slider Style 3 ( Carousel Slider )[/apress_heading][apress_image_slider images="1868,1869,1870,1871,1872,1873,1874" img_size="full" desktop_no_of_items2="5" small_desktop_no_of_items="3" tablet_no_of_items="1" slider_gutter="10" slick_item_shadow="" slick_lazyload="yes" arrows_bg="" style="slider_style3" arrows_style="arrows_style3" bullet_navigation_style="dots_style2"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 24', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general24.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle" css=".vc_custom_1505735343437{padding-top: 100px !important;background-color: #f7f7f7 !important;}"][vc_column][apress_heading sub_title="Add the image slider to any post, page or portfolio." enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div"]Image Slider Style 4 ( Variable Width Slider )[/apress_heading][apress_image_slider images="1878,1884,1879,1885" slider_gutter="10" slick_item_shadow="yes" slick_lazyload="yes" slick_autoplay="yes" slick_autoplay_duration="2000" arrows_bg="#333333" style="slider_style4" arrows_style="arrows_style2" bullet_navigation_style="dots_style1"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 25', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general25.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" css=".vc_custom_1505735351139{padding-top: 100px !important;background-color: #f7f7f7 !important;}"][vc_column][apress_heading sub_title="Add the image slider to any post, page or portfolio." enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div"]Image Slider Style 5 ( Staged Slider 2 )[/apress_heading][apress_image_slider images="1866,1865,1864" img_size="full" slick_center_desktop_padding="30%" slick_center_small_desktop_padding="40%" slick_center_tablet_padding="30%" slick_item_shadow="yes" slick_lazyload="yes" arrows_color="#333333" style="slider_style5" arrows_style="arrows_style1" bullet_navigation_style="dots_style1"][/vc_column][/vc_row]
CONTENT;


$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 26', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general26.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1505735361046{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #f7f7f7 !important;}"][vc_column][apress_image_slider images="1880,1881,1882" img_size="full" slick_item_shadow="yes" slick_lazyload="yes" style="slider_style6" bullet_navigation_style="dots_style1"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 27', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general27.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2"][ultimate_info_banner banner_title="iPhone 6" banner_desc="Bigger than bigger." button_text="FROM $199" info_alignment="ib3-info-left" info_effect="fadeInLeft" banner_image="id^1383|url^http://apresswp.com/demo1/wp-content/uploads/2017/07/iphone-6.png|caption^null|alt^null|title^iphone-6|description^null" banner_size="300" ib3_alignment="ultb3-img-top-right" banner_img_height_mobile_landscape="312" button_text_color="#1e73be" title_color="#424242" desc_color="#928373" ib3_background="#efdfcf" title_font_family="font_family:Roboto|font_call:Roboto|variant:300" title_font_style="font-weight:300;" desc_font_family="font_family:Roboto|font_call:Roboto|variant:300" desc_font_style="font-weight:300;" button_font_size="desktop:16px;" title_font_size="desktop:40px;" desc_font_size="desktop:20px;" _mobile="0"][/vc_column][vc_column width="1/2"][ultimate_info_banner banner_title="MacBook Pro" banner_desc="More power
behind every pixel." button_text="FROM $1200" info_alignment="ib3-info-left" info_effect="fadeInRight" banner_image="id^1384|url^http://apresswp.com/demo1/wp-content/uploads/2017/07/Switch-1.png|caption^null|alt^null|title^Switch-1|description^null" banner_size="300" ib3_alignment="ultb3-img-bottom-right" banner_img_height="400" banner_img_height_tablet="260" banner_img_height_tablet_portrait="250" banner_img_height_mobile_landscape="250" button_text_color="#1e73be" title_color="#424242" desc_color="#b5b5b5" ib3_background="#ebecee" title_font_family="font_family:Roboto|font_call:Roboto|variant:300" title_font_style="font-weight:300;" desc_font_family="font_family:Roboto|font_call:Roboto|variant:300" desc_font_style="font-weight:300;" title_font_size="desktop:40px;" desc_font_size="desktop:20px;" button_font_size="desktop:16px;"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][ultimate_info_banner banner_title="iPod Shuffle" banner_desc="Small, but big on music." button_text="FROM $49" info_alignment="ib3-info-left" info_effect="fadeInLeft" banner_image="id^1386|url^http://apresswp.com/demo1/wp-content/uploads/2017/07/iPode-shuffle.png|caption^null|alt^null|title^iPode-shuffle|description^null" banner_size="300" ib3_alignment="ultb3-img-top-right" banner_img_height_mobile_landscape="312" button_color="#ffffff" button_text_color="#ffffff" button_text_hover_color="#62d6ef" title_color="#ffffff" desc_color="#3997aa" ib3_background="#62d6ef" title_font_family="font_family:Roboto|font_call:Roboto|variant:300" title_font_style="font-weight:300;" desc_font_family="font_family:Roboto|font_call:Roboto|variant:300" desc_font_style="font-weight:300;" button_font_size="desktop:16px;" title_font_size="desktop:40px;" desc_font_size="desktop:20px;" _mobile="0"][/vc_column][vc_column width="1/2"][ultimate_info_banner banner_title="iPhone 5C" banner_desc="For the colorful." button_text="FROM $99" info_alignment="ib3-info-left" info_effect="fadeInRight" banner_image="id^1385|url^http://apresswp.com/demo1/wp-content/uploads/2017/07/iPhone-5c.png|caption^null|alt^null|title^iPhone-5c|description^null" banner_size="300" ib3_alignment="ultb3-img-top-right" banner_img_height="370" banner_img_height_mobile_landscape="312" button_color="#ffffff" button_text_color="#ffffff" button_text_hover_color="#ff8181" title_color="#ffffff" desc_color="#ba5050" ib3_background="#ff8181" title_font_family="font_family:Roboto|font_call:Roboto|variant:300" title_font_style="font-weight:300;" desc_font_family="font_family:Roboto|font_call:Roboto|variant:300" desc_font_style="font-weight:300;" button_font_size="desktop:16px;" title_font_size="desktop:40px;" desc_font_size="desktop:20px;" _mobile="0"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 28', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general28.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/3"][ultimate_info_banner banner_title="Royal Beans" banner_desc="Securae ubi manebat usu diverso coeperunt nullus." button_text="LEARN MORE" info_effect="flipInX" banner_image="id^1087|url^http://apresswp.com/demo1/wp-content/uploads/2016/09/bg3.jpeg|caption^null|alt^null|title^bg3|description^null" banner_size="300" ib3_alignment="ultb3-img-bottom-right" ib3_effect="ultb3-hover-5" overlay_color="rgba(30,115,190,0.33)" banner_img_height_large_screen="600" banner_img_height="500" button_color="#ffffff" button_text_color="#ffffff" button_text_hover_color="#1e73be" title_color="#e5e5e5" desc_color="#e5e5e5" ib3_background="#ebecee" title_font_family="font_family:Roboto|font_call:Roboto|variant:300" title_font_style="font-weight:300;" y="font_family:Roboto|font_call:Roboto|variant:300" desc_font_style="font-weight:300;" title_font_size="desktop:40px;" button_font_size="desktop:16px;"][/vc_column][vc_column width="1/3"][ultimate_info_banner banner_title="Smoked Chicken" banner_desc="Securae ubi manebat usu diverso coeperunt nullus." button_text="LEARN MORE" info_effect="zoomIn" banner_image="id^1069|url^http://apresswp.com/demo1/wp-content/uploads/2016/09/bg2.jpg|caption^Great minds getting together. Confident young African man pointing laptop while sitting together with his colleagues in office|alt^null|title^Young designers at work in office|description^null" banner_size="300" ib3_alignment="ultb3-img-bottom-right" ib3_effect="ultb3-hover-1" overlay_color="rgba(221,51,51,0.3)" banner_img_height_large_screen="600" banner_img_height="500" banner_img_height_mobile_landscape="350" banner_img_height_mobile="380" button_color="#ffffff" button_text_color="#ffffff" button_text_hover_color="#dd3333" title_color="#ffffff" desc_color="#ffffff" ib3_background="#ebecee" title_font_family="font_family:Roboto|font_call:Roboto|variant:300" title_font_style="font-weight:300;" desc_font_family="font_family:Roboto|font_call:Roboto|variant:300" nt_style="font-weight:300;" title_font_size="desktop:40px;" button_font_size="desktop:16px;"][/vc_column][vc_column width="1/3"][ultimate_info_banner banner_title="Classic Wine" banner_desc="Securae ubi manebat usu diverso coeperunt nullus." button_text="LEARN MORE" info_effect="fadeInRight" banner_image="id^1060|url^http://apresswp.com/demo1/wp-content/uploads/2016/09/bg1.jpg|caption^Positivity in work place. Group of businesspeople giving thumbs up to smartphone making selfie|alt^null|title^Happy businesspeople in their office|description^null" banner_size="300" ib3_effect="ultb3-hover-3" overlay_color="rgba(129,215,66,0.22)" banner_img_height_large_screen="400" banner_img_height="350" banner_img_height_mobile_landscape="350" button_color="#ffffff" button_text_color="#ffffff" button_text_hover_color="#27ae60" title_color="#ffffff" desc_color="#ffffff" ib3_background="#ebecee" title_font_family="font_family:Roboto|font_call:Roboto|variant:300" title_font_style="font-weight:300;" desc_font_family="font_family:Roboto|font_call:Roboto|variant:300" c_font_style="font-weight:300;" title_font_size="desktop:40px;" button_font_size="desktop:16px;"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 29', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general29.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row bg_type="no_bg" css=".vc_custom_1409409710044{padding-top: 30px !important;}" animation_type="h" horizontal_animation="left-animation" vertical_animation="top-animation"][vc_column][/vc_column][/vc_row][vc_row][vc_column width="1/3"][bsf-info-box icon_type="custom" icon_img="id^1392|url^http://apresswp.com/demo1/wp-content/uploads/2017/07/1392250374_wine.png|caption^null|alt^null|title^1392250374_wine|description^null" img_width="85" icon_animation="bounceIn" title="This is an icon box." hover_effect="style_2" pos="top"]Write a short description, that will describe the title or something informational and useful.[/bsf-info-box][bsf-info-box icon_type="custom" icon_img="id^1395|url^http://apresswp.com/demo1/wp-content/uploads/2017/07/Pocket.png|caption^null|alt^null|title^Pocket|description^null" img_width="85" icon_animation="bounceIn" title="This is an icon box." hover_effect="style_2" pos="top"]Write a short description, that will describe the title or something informational and useful.[/bsf-info-box][/vc_column][vc_column width="1/3"][bsf-info-box icon_type="custom" icon_img="id^1393|url^http://apresswp.com/demo1/wp-content/uploads/2017/07/1392250447_analytics.png|caption^null|alt^null|title^1392250447_analytics|description^null" img_width="85" icon_animation="bounceIn" title="This is an icon box." hover_effect="style_2" pos="top"]Write a short description, that will describe the title or something informational and useful.[/bsf-info-box][bsf-info-box icon_type="custom" icon_img="id^1396|url^http://apresswp.com/demo1/wp-content/uploads/2017/07/Clipboard.png|caption^null|alt^null|title^Clipboard|description^null" img_width="85" icon_animation="bounceIn" title="This is an icon box." hover_effect="style_2" pos="top"]Write a short description, that will describe the title or something informational and useful.[/bsf-info-box][/vc_column][vc_column width="1/3"][bsf-info-box icon_type="custom" icon_img="id^1394|url^http://apresswp.com/demo1/wp-content/uploads/2017/07/1392250361_Briefcase.png|caption^null|alt^null|title^1392250361_Briefcase|description^null" img_width="85" icon_animation="bounceIn" title="This is an icon box." hover_effect="style_2" pos="top"]Write a short description, that will describe the title or something informational and useful.[/bsf-info-box][bsf-info-box icon_type="custom" icon_img="id^1397|url^http://apresswp.com/demo1/wp-content/uploads/2017/07/Book.png|caption^null|alt^null|title^Book|description^null" img_width="85" icon_animation="bounceIn" title="This is an icon box." hover_effect="style_2" pos="top"]Write a short description, that will describe the title or something informational and useful.[/bsf-info-box][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 30', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general30.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row padding="70px 0px 40px 0px" bg_color="#ffffff"][vc_column width="1/4"][bsf-info-box icon="Defaults-mobile mobile-phone" icon_size="32" icon_color="#f6653c" icon_style="advanced" icon_color_bg="#f4f4f4" icon_border_style="solid" icon_color_border="#e2e2e2" icon_border_size="1" icon_border_radius="500" icon_border_spacing="90" title="100% Responsive Design" hover_effect="style_2" pos="top"]Write a short description, that will describe the title or something informational and useful.[/bsf-info-box][/vc_column][vc_column width="1/4"][bsf-info-box icon="Defaults-home" icon_size="32" icon_color="#f6653c" icon_style="advanced" icon_color_bg="#f4f4f4" icon_border_style="solid" icon_color_border="#e2e2e2" icon_border_size="1" icon_border_radius="500" icon_border_spacing="90" title="Award Winning Quality" hover_effect="style_2" pos="top" on_size="32"]Write a short description, that will describe the title or something informational and useful.[/bsf-info-box][/vc_column][vc_column width="1/4"][bsf-info-box icon="Defaults-star-o" icon_size="32" icon_color="#f6653c" icon_style="advanced" icon_color_bg="#f4f4f4" icon_border_style="solid" icon_color_border="#e2e2e2" icon_border_size="1" icon_border_radius="500" icon_border_spacing="90" title="Extensive Documentation" hover_effect="style_2" pos="top"]Write a short description, that will describe the title or something informational and useful.[/bsf-info-box][/vc_column][vc_column width="1/4"][bsf-info-box icon="Defaults-futbol-o soccer-ball-o" icon_size="32" icon_color="#f6653c" icon_style="advanced" icon_color_bg="#f4f4f4" icon_border_style="solid" icon_color_border="#e2e2e2" icon_border_size="1" icon_border_radius="500" icon_border_spacing="90" title="Extensive Documentation" hover_effect="style_2" pos="top"]Write a short description, that will describe the title or something informational and useful.[/bsf-info-box][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 31', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general31.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row bg_type="bg_color" bg_override="ex-full" bg_color_value="#1f3aef" css=".vc_custom_1505744382899{padding-top: 250px !important;padding-bottom: 250px !important;}"][vc_column centered_text="true"][apress_heading sub_title="This is the video lightbox to show your story in an impressive way." data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" heading_margin="margin-bottom:20" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div|color:%23ffffff" subheading_margin="margin-bottom:20"]Impressive Way To Share Your Story[/apress_heading][apress_lightbox lightbox_type="video" link_style="link_icon" button_icon_color="#ffffff" button_icon_hover_color="#ffffff" select_button_style="video_icon_style5" link="https://www.youtube.com/watch?v=yUCFRL43Zm4"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 32', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general32.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^1924|url^http://apresswp.com/demo1/wp-content/uploads/2017/09/bg10.jpg|caption^null|alt^null|title^bg10|description^null" bg_image_repeat="no-repeat" bg_override="ex-full" css=".vc_custom_1505746217615{padding-top: 150px !important;padding-bottom: 150px !important;}"][vc_column][apress_heading sub_title="This is the video lightbox to show your story in an impressive way." content_alignment="left" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" heading_margin="margin-bottom:20" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div|color:%23ffffff" subheading_margin="margin-bottom:20"]More Styles To Share Your Story.[/apress_heading][apress_lightbox lightbox_type="video" link_style="link_icon_with_text" button_icon_color="#ffffff" button_icon_hover_color="#8e54e9" select_button_style="video_icon_style5" link_text="Watch Overview" videolink_font_options="color:%23ffffff" link="https://www.youtube.com/watch?v=yUCFRL43Zm4"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 33', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general33.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle" css=".vc_custom_1485758305450{padding-top: 65px !important;}"][vc_column width="1/3" css=".vc_custom_1485756194887{padding-top: 96px !important;padding-bottom: 96px !important;background-color: #2c2c2c !important;}"][ultimate_heading main_heading="TAX SERVICES" main_heading_color="#ffffff" main_heading_font_size="desktop:40px;" main_heading_line_height="desktop:60px;"][/ultimate_heading][/vc_column][vc_column width="1/3" css=".vc_custom_1485756326376{padding-top: 96px !important;padding-bottom: 96px !important;background-color: #4169e1 !important;}"][ultimate_heading main_heading="PAYROLL SERVICES" main_heading_color="#ffffff" main_heading_font_size="desktop:40px;" main_heading_line_height="desktop:60px;"][/ultimate_heading][/vc_column][vc_column width="1/3" css=".vc_custom_1485756333927{padding-top: 96px !important;padding-bottom: 96px !important;background-color: #ececec !important;}"][ultimate_heading main_heading="BUSINESS SERVICES" main_heading_color="#303030" main_heading_font_size="desktop:40px;" main_heading_line_height="desktop:60px;"][/ultimate_heading][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 34', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general34.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1486625698863{padding-top: 183px !important;}"][vc_column width="1/3"][/vc_column][vc_column width="2/3" css=".vc_custom_1486626068420{padding-top: 55px !important;padding-bottom: 55px !important;background-image: url(http://apresswp.com/demo5/wp-content/uploads/2017/02/img_3.jpg?id=127) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_row_inner][vc_column_inner width="1/2"][ult_content_box bg_color="#ffffff" box_shadow="horizontal:0px|vertical:0px|blur:10px|spread:5px|color:rgba(2,2,2,0.03)|style:outset|" hover_box_shadow="horizontal:px|vertical:px|blur:px|spread:px|color:#f7f7f7|style:none|" padding="padding-top:81px;padding-right:60px;padding-bottom:70px;padding-left:60px;" margin="margin-right:150px;margin-left:-200px;" border="border-style:solid;|border-width:1px;border-radius:0px;|border-color:#ffffff;" hover_border_color="#2936b3"][ultimate_heading main_heading="ABOUT US" main_heading_font_size="desktop:20px;" main_heading_line_height="desktop:30px;" main_heading_margin="margin-bottom:20px;"]Fusce nec ante et ex euismod dignissim. Praesent vitae arcu metus. Fusce eu tristique lectus. Quisque id hendrerit diam curabitur sollicitudin.Fusce nec ante et ex euismod dignissim. Praesent vitae arcu metus. Fusce eu tristique lectus. Quisque id hendrerit diam curabitur sollicitudin.Fusce nec ante et ex euismod dignissim. Praesent vitae arcu metus. Fusce eu tristique lectus. Quisque id hendrerit diam curabitur sollicitudin.

<span style="color: #2936b3;"><strong><em>- John Doe</em></strong></span>[/ultimate_heading][/ult_content_box][/vc_column_inner][vc_column_inner width="1/2"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 35', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general35.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1486622179191{padding-top: 200px !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3" css=".vc_custom_1486622308046{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-bottom: 35px !important;border-left-color: #252525 !important;border-left-style: solid !important;border-right-color: #252525 !important;border-right-style: solid !important;border-top-color: #252525 !important;border-top-style: solid !important;border-bottom-color: #252525 !important;border-bottom-style: solid !important;border-radius: 1px !important;}"][ultimate_heading main_heading="ALIQUAM SAGITTIS INTERDUM VELIT AT LAOREET. PRAESENT LACUS EROS, TEMPOR VITAE FINIBUS AC, COMMODO ID DUI." main_heading_color="#252525" main_heading_font_size="desktop:27px;" main_heading_line_height="desktop:47px;"][/ultimate_heading][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row gap="35" css=".vc_custom_1486623047077{padding-top: 82px !important;}"][vc_column width="1/3" css=".vc_custom_1486624241180{padding-right: 40px !important;padding-left: 40px !important;background-color: #2936b3 !important;}"][ultimate_heading main_heading="CLIENTS" main_heading_color="#ffffff" sub_heading_color="#ffffff" alignment="left" main_heading_font_size="desktop:33px;" main_heading_line_height="desktop:40px;" sub_heading_font_size="desktop:14px;" sub_heading_line_height="desktop:28px;" main_heading_margin="margin-top:43px;margin-bottom:20px;" main_heading_style="font-weight:bold;" sub_heading_margin="margin-bottom:78px;"]QUBEC IT <span style="color: #8b95ed;">|</span> TIMES REAL ESTATE
QUBEC IT <span style="color: #8b95ed;">|</span> TIMES REAL ESTATE
QUBEC IT <span style="color: #8b95ed;">|</span> TIMES REAL ESTATE[/ultimate_heading][/vc_column][vc_column width="1/3" css=".vc_custom_1486623964746{padding-right: 40px !important;padding-left: 40px !important;background-color: #2936b3 !important;}"][ultimate_heading main_heading="MEMBERSHIP" main_heading_color="#ffffff" sub_heading_color="#ffffff" alignment="left" main_heading_font_size="desktop:33px;" main_heading_line_height="desktop:40px;" sub_heading_font_size="desktop:14px;" sub_heading_line_height="desktop:28px;" main_heading_margin="margin-top:43px;margin-bottom:20px;" main_heading_style="font-weight:bold;" sub_heading_margin="margin-bottom:78px;"]- Quisque porttitor purus turpis.
- Quisque suscipit massa at lib.
- Nunc efficitur tellus egestas aug.
- Etiam vehicula dictum libero.[/ultimate_heading][/vc_column][vc_column width="1/3" css=".vc_custom_1486624249866{padding-right: 40px !important;padding-left: 40px !important;background-color: #2936b3 !important;}"][ultimate_heading main_heading="WORK WITH US" main_heading_color="#ffffff" sub_heading_color="#979ff3" alignment="left" main_heading_font_size="desktop:33px;" main_heading_line_height="desktop:40px;" sub_heading_font_size="desktop:14px;" sub_heading_line_height="desktop:28px;" main_heading_margin="margin-top:71px;margin-bottom:20px;" main_heading_style="font-weight:bold;" sub_heading_margin="margin-bottom:106px;"]hello@work.com[/ultimate_heading][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 36', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general36.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/4" css=".vc_custom_1500286794401{padding-right: 35px !important;padding-bottom: 150px !important;padding-left: 35px !important;background-color: #2936b3 !important;}"][ultimate_heading main_heading="INDUSTRIES
WE SERVE" main_heading_color="#ffffff" alignment="left" main_heading_font_size="desktop:50px;" main_heading_line_height="desktop:60px;" main_heading_margin="margin-top:105px;margin-bottom:30px;"][/ultimate_heading][/vc_column][vc_column width="1/4" css=".vc_custom_1500286702120{padding-top: 50px !important;padding-right: 35px !important;padding-bottom: 50px !important;padding-left: 35px !important;}"][ultimate_heading main_heading="PHARMACEUTICALS" alignment="left" main_heading_font_size="desktop:20px;" main_heading_line_height="desktop:30px;" main_heading_margin="margin-bottom:20px;"]- Quisque porttitor purus turpis.
- Quisque suscipit massa at libero.
- Nunc efficitur tellus egestas au.[/ultimate_heading][ultimate_spacer height="30"][ultimate_heading main_heading="FOOD PROCESSING" alignment="left" main_heading_font_size="desktop:20px;" main_heading_line_height="desktop:30px;" main_heading_margin="margin-bottom:20px;"]- Quisque porttitor purus turpis.
- Quisque suscipit massa at libero.
- Nunc efficitur tellus egestas au.[/ultimate_heading][/vc_column][vc_column width="1/4" css=".vc_custom_1500286715663{padding-top: 50px !important;padding-right: 35px !important;padding-bottom: 50px !important;padding-left: 35px !important;}"][ultimate_heading main_heading="STEEL INDUSTRIES" alignment="left" main_heading_font_size="desktop:20px;" main_heading_line_height="desktop:30px;" main_heading_margin="margin-bottom:20px;"]- Quisque porttitor purus turpis.
- Quisque suscipit massa at libero.
- Nunc efficitur tellus egestas au.[/ultimate_heading][ultimate_spacer height="30"][ultimate_heading main_heading="TEXTILES INDUSTRY" alignment="left" main_heading_font_size="desktop:20px;" main_heading_line_height="desktop:30px;" main_heading_margin="margin-bottom:20px;"]- Quisque porttitor purus turpis.
- Quisque suscipit massa at libero.
- Nunc efficitur tellus egestas au.[/ultimate_heading][/vc_column][vc_column width="1/4" css=".vc_custom_1500286725826{padding-top: 50px !important;padding-right: 35px !important;padding-bottom: 50px !important;padding-left: 35px !important;}"][ultimate_heading main_heading="AGRICULTURAL INDUSTRY" alignment="left" main_heading_font_size="desktop:20px;" main_heading_line_height="desktop:30px;" main_heading_margin="margin-bottom:20px;"]- Quisque porttitor purus turpis.
- Quisque suscipit massa at libero.
- Nunc efficitur tellus egestas au.[/ultimate_heading][ultimate_spacer height="30"][ultimate_heading main_heading="ALIQUAM SAGITTIS" alignment="left" main_heading_font_size="desktop:20px;" main_heading_line_height="desktop:30px;" main_heading_margin="margin-bottom:20px;"]- Quisque porttitor purus turpis.
- Quisque suscipit massa at libero.
- Nunc efficitur tellus egestas au.[/ultimate_heading][/vc_column][/vc_row][vc_row full_width="stretch_row_content" content_placement="middle"][vc_column width="1/4"][vc_single_image image="94" img_size="full" alignment="center" css=".vc_custom_1486621007266{margin-top: 50px !important;margin-bottom: 50px !important;}"][/vc_column][vc_column width="3/4" css=".vc_custom_1486620976027{padding-right: 13% !important;padding-bottom: 48px !important;padding-left: 13% !important;background-color: #222222 !important;}"][ultimate_heading main_heading="CLIENT TESTIMONIAL" main_heading_color="#ffffff" main_heading_font_size="desktop:50px;" main_heading_line_height="desktop:60px;" main_heading_margin="margin-top:53px;margin-bottom:30px;"][/ultimate_heading][zolo_testimonial_plus_shortcode num="2" testimonialfontsize="14" testimoniallineheight="26" testimonialfontcolor="#fafafa" testimonialnamefontcolor="#2936b3" testimonialimgborcolor="#222222"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 37', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general37.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" bg_type="bg_color" bg_override="full" bg_color_value="#f8f8f8" css=".vc_custom_1483508684665{padding-top: 55px !important;}"][vc_column width="1/2"][vc_single_image image="106" img_size="full" alignment="center"][/vc_column][vc_column width="1/2"][ultimate_heading main_heading="Easily show off what you do and how you do it." alignment="left" main_heading_style="font-weight:bold;" main_heading_font_size="desktop:40px;" main_heading_line_height="desktop:50px;" main_heading_margin="margin-bottom:18px;" sub_heading_line_height="desktop:26px;"]Donec sit amet aliquet lorem, id molestie diam. Duis lectus nunc, malesuada et odio sit amet, iaculis aliquam erat. Pellentesque ornare ligula id eros porttitor, vitae ornare tortor tincidunt. Quisque et ipsum et nunc fermentum elementum. Etiam dictum lorem quis neque mattis venenatis. Nam ac venenatis enim. Etiam nec ipsum auctor, lacinia lacus at, dictum felis. Donec sodales nisl orci, non pulvinar metus scelerisque a.[/ultimate_heading][ult_buttons btn_title="READ MORE" btn_bg_color="" btn_hover="ubtn-fade-bg" btn_anim_effect="ulta-wobble-horizontal" btn_bg_color_hover="#292929" btn_title_color_hover="#ffffff" icon_size="32" btn_icon_pos="ubtn-sep-icon-at-left" btn_border_style="solid" btn_color_border="#292929" btn_color_border_hover="#292929" btn_border_size="3" btn_radius="3" css_adv_btn=".vc_custom_1483011098068{margin-top: 40px !important;margin-bottom: 100px !important;}" btn_font_style="font-weight:bold;" btn_font_size="desktop:14px;" btn_line_height="desktop:20px;"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 38', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general38.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-default" bg_image_new="id^149|url^http://apresswp.com/demo5/wp-content/uploads/2017/02/img_4-1.jpg|caption^null|alt^null|title^img_4|description^null" bg_override="full" css=".vc_custom_1486631767428{margin-top: 200px !important;padding-top: 111px !important;padding-bottom: 95px !important;}"][vc_column][ultimate_carousel arrows="off" dots="off"][vc_single_image image="145" img_size="full" alignment="center"][vc_single_image image="143" img_size="full" alignment="center"][vc_single_image image="144" img_size="full" alignment="center"][vc_single_image image="146" img_size="full" alignment="center"][vc_single_image image="147" img_size="full" alignment="center"][/ultimate_carousel][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 39', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general39.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content" css=".vc_custom_1503932944832{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column css_animation="fadeInUp"][apress_heading sub_title="OUR IMAGE GALLERY" enable_delimiter="" title_google_fonts="yes" style="heading_style2" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" title_custom_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" heading_margin="margin-bottom:30"]PERFECTION IS EVERYTHING[/apress_heading][vc_empty_space height="30px"][apress_photo_gallery images="29,30,38,32,33,35,36,37" photo_gallery_type="image_masonry" number_items_per_row="five" image_gutter="10" use_lightbox="yes" hover_effects="bwtocolor_effect" data_animation="fadeInUp"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 40', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general40.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1504088453236{padding-top: 50px !important;padding-bottom: 100px !important;background-color: #333333 !important;}"][vc_column][apress_text_separator title="PROJECT GALLERY" title_align="separator_align_left" align="align_left" el_width="40" contentboxanimation="fadeIn" contentboxdelay="300" color="#ffffff" title_font_options="tag:h2|color:%23ffffff"][apress_photo_gallery images="115,116,117,118,119,120,121,122" images_size="full" image_gutter="10" use_lightbox="yes" hover_effects="zoomin_effect" data_animation="fadeInUp"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 41', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general41.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^43|url^http://apresswp.com/demo13/wp-content/uploads/2017/08/bg.jpg|caption^null|alt^null|title^Happy people at the gym|description^null" bg_image_repeat="no-repeat" bg_override="ex-full" css=".vc_custom_1504204457941{padding-top: 50px !important;padding-bottom: 80px !important;}"][vc_column width="1/3"][apress_heading sub_title="Never Miss An Update" data_animation="fadeIn" data_delay="300" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" title_google_fonts="yes" style="heading_style2" title_font_options="tag:h2" subtitle_font_options="tag:div|color:%23ffffff" title_custom_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"]Subscribe to my newsletter[/apress_heading][/vc_column][vc_column width="2/3" css=".vc_custom_1504204347238{padding-top: 20px !important;}"][vc_column_text css_animation="fadeIn"][mc4wp_form id="38"][/vc_column_text][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 42', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general42.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" css=".vc_custom_1504610936519{margin-top: 0px !important;margin-bottom: 20px !important;padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_column css_animation="fadeInUp" width="1/2" css=".vc_custom_1504611024109{background-image: url(http://apresswp.com/demo16/wp-content/uploads/2017/09/bg1.jpg?id=25) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_spacer height="300"][ultimate_spacer height="300"][/vc_column][vc_column width="1/2" css=".vc_custom_1504609791548{margin-top: 0px !important;padding-top: 0px !important;padding-right: 5% !important;padding-left: 5% !important;}"][vc_row_inner css=".vc_custom_1504608468489{padding-top: 100px !important;}"][vc_column_inner width="1/3"][apress_process title="DESIGN" content_alignment="left" data_animation="fadeInLeft" data_delay="300" style="process_style3" title_font_options="tag:h1" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Aenean nec accumsan est. Sed porttitor porttitor felis ut interdum. Nam eget nisl ligula. Integer eget congue diam.[/apress_process][/vc_column_inner][vc_column_inner width="1/3"][/vc_column_inner][vc_column_inner width="1/3"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][/vc_column_inner][vc_column_inner width="1/3"][apress_process title="CREATE" process_step="02" content_alignment="left" data_animation="fadeInLeft" data_delay="600" style="process_style3" title_font_options="tag:h1" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Aenean nec accumsan est. Sed porttitor porttitor felis ut interdum. Nam eget nisl ligula. Integer eget congue diam.[/apress_process][/vc_column_inner][vc_column_inner width="1/3"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1504608477641{padding-bottom: 100px !important;}"][vc_column_inner width="1/3"][/vc_column_inner][vc_column_inner width="1/3"][/vc_column_inner][vc_column_inner width="1/3"][apress_process title="IMPRESS" process_step="03" content_alignment="left" data_animation="fadeInLeft" data_delay="900" style="process_style3" title_font_options="tag:h1" step_font_options="tag:h1|font_size:100|color:%23f1f1f1|line_height:100" content_font_options="tag:div"]Aenean nec accumsan est. Sed porttitor porttitor felis ut interdum. Nam eget nisl ligula. Integer eget congue diam.[/apress_process][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 43', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general43.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1506079353903{padding-top: 70px !important;padding-bottom: 120px !important;}"][vc_column width="1/2"][apress_heading sub_title="Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum.Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." content_alignment="left" enable_delimiter="" style="heading_style1" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:30"]La più bella cucina della campagna per divorare l'appetito[/apress_heading][/vc_column][vc_column css_animation="fadeInDown" width="1/4" css=".vc_custom_1506076502753{margin-top: -20px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_single_image image="85" img_size="full" style="vc_box_shadow" onclick="link_image"][/vc_column][vc_column css_animation="fadeInUp" width="1/4" css=".vc_custom_1506076509962{margin-bottom: -20px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_single_image image="21" img_size="full" style="vc_box_shadow" onclick="link_image"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 44', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general44.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1505997259433{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column][apress_heading sub_title="Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." enable_delimiter="" style="heading_style1" heading_margin="margin-bottom:20" title_font_options="tag:h2|font_size:45|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" subheading_margin="margin-bottom:50"]Our Smile Photo Gallery ![/apress_heading][apress_photo_gallery images="99,100,101,102,103,104,105,106,107,108,109,110,111,112" photo_gallery_type="image_justify" image_gutter="10" use_lightbox="yes" hover_effects="bwtocolor_effect"][ultimate_spacer height="50"][apress_button button_text="Contact Us Today" button_shape="rounded" button_size="design_your_own" padding_top_bottom="20" padding_right_left="50" button_alignment="center" button_font_options="font_size:25|line_height:35|letter_spacing:1"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'General 45', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/general45.jpg' );
	$data['sort_name'] = 'General';
	$data['custom_class'] = 'general generals';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1505997510187{padding-top: 100px !important;padding-bottom: 130px !important;}"][vc_column width="1/3"][apress_heading sub_title="Sed ullamcorper ex et pharetra scelerisque. Suspendisse placerat sapien in ullamcorper porttitor. Cras gravida consequat lorem vitae vestibulum." content_alignment="left" enable_delimiter="" style="heading_style1" heading_margin="margin-bottom:30" title_font_options="tag:h2|font_size:45|line_height:60|letter_spacing:1" subtitle_font_options="tag:div" subheading_margin="margin-bottom:50"]Your Smile is Contagious[/apress_heading][/vc_column][vc_column css_animation="fadeIn" width="2/3"][apress_image_comparison image_url="71" image_2_url="72" image_comparison_orientation="image_comparison_horizontal"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 1', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study1.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column css_animation="fadeInUp" width="1/2" css=".vc_custom_1507378188387{padding-right: 10% !important;padding-left: 10% !important;}"][ultimate_spacer height="200"][apress_heading sub_title="THE CHALLENGE" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style2" title_font_options="tag:h2|font_size:35|line_height:50|letter_spacing:1" subtitle_font_options="tag:div"]Looking for a Creative team to showcase their talent and collection exotic coffee.[/apress_heading][vc_column_text css_animation="fadeIn"]Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat.Mauris viverra orci non nibh posuere, non dignissim ipsum convallis. Nunc auctor pulvinar velit, et vehicula lectus congue volutpat. Mauris viverra orci non nibh posuere, non dignissim ipsum convallis.[/vc_column_text][apress_button button_text="Visit Website" color_scheme="design_your_own" button_bg_color="#ffffff" button_bg_color_h="#3c2a1e" button_text_color="#3c2a1e" button_border_color="#3c2a1e" button_border_color_h="#3c2a1e" button_size="medium" data_animation="fadeIn" button_font_options="letter_spacing:1"][ultimate_spacer height="200"][/vc_column][vc_column parallax="content-moving" parallax_image="177" css_animation="fadeInUp" width="1/2"][ultimate_spacer height="200"][ultimate_spacer height="200"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column parallax="content-moving" parallax_image="176" parallax_speed_bg="2" css_animation="fadeInUp" width="1/2"][ultimate_spacer height="200"][ultimate_spacer height="200"][/vc_column][vc_column css_animation="fadeInUp" width="1/2" css=".vc_custom_1508259197743{background-image: url(http://apresswp.com/demo8/wp-content/uploads/2017/10/Showcase-01.jpg?id=208) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_spacer height="700"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 2', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study2.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1508259218443{background-image: url(http://apresswp.com/demo8/wp-content/uploads/2017/10/Showcase-04.jpg?id=206) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_spacer height="700"][/vc_column][vc_column parallax="content-moving" parallax_image="180" parallax_speed_bg="2" width="1/2" css=".vc_custom_1508259266681{padding-right: 5% !important;padding-left: 5% !important;}"][ultimate_spacer height="700"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column css_animation="fadeInUp" width="1/2" css=".vc_custom_1508259258637{background-image: url(http://apresswp.com/demo8/wp-content/uploads/2017/08/brooke-cagle-224815.jpg?id=222) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ultimate_spacer height="700"][/vc_column][vc_column css_animation="fadeInUp" width="1/2" css=".vc_custom_1507378226370{padding-right: 10% !important;padding-left: 10% !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][apress_heading sub_title="`` Nam nec ante molestie est fringilla hendrerit eleifend et eros. Proin non porta augue. Aenean sit amet mauris nulla. Morbi eget vehicula lectus, non porttitor nisi. Nunc vel nulla tortor. ``" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#3c2a1e" style="heading_style2" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1|font_style_underline:1" subtitle_font_options="tag:div|font_size:20|line_height:30|letter_spacing:1" heading_margin="margin-top:50"]Spencer &amp; James[/apress_heading][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 3', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study3.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1507378689121{padding-top: 150px !important;padding-right: 10% !important;padding-bottom: 150px !important;padding-left: 10% !important;background-color: #3c2a1e !important;}"][vc_column][vc_row_inner][vc_column_inner css=".vc_custom_1507379452675{padding-right: 20% !important;padding-left: 20% !important;}"][apress_heading sub_title="" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style2" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1|font_style_underline:1" subtitle_font_options="tag:div|font_size:20|line_height:30|letter_spacing:1" heading_margin="margin-bottom:50" title_responsive="font_size_mobile:35|line_height_mobile:50|letter_spacing_mobile:1"]We are excited help you overcome your challenge ![/apress_heading][/vc_column_inner][/vc_row_inner][apress_button button_text="Hire Us" color_scheme="design_your_own" button_bg_color="#3c2a1e" button_bg_color_h="#ffffff" button_text_color_h="#3c2a1e" button_border_color="#ffffff" button_border_color_h="#ffffff" button_size="design_your_own" padding_top_bottom="25" padding_right_left="40" button_alignment="center" data_animation="fadeIn" button_font_options="letter_spacing:3"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 4', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study4.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1507385689327{padding-right: 15% !important;padding-left: 15% !important;}"][vc_column][ultimate_spacer height="50"][apress_heading sub_title="THE CHALLENGE" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" style="heading_style2" title_font_options="tag:h2" subtitle_font_options="tag:div|color:%23333333|letter_spacing:3" heading_margin="margin-top:30|margin-bottom:50"]Nam nec ante molestie est fringilla hendrerit eleifend et eros. Proin non porta augue. Aenean sit amet mauris nulla.[/apress_heading][ultimate_spacer height="50"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 5', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study5.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1507387659501{padding-right: 15% !important;padding-left: 15% !important;}"][vc_column][ultimate_spacer height="50"][apress_heading sub_title="CLIENT FEEDBACK" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" style="heading_style2" title_font_options="tag:h4" subtitle_font_options="tag:div|color:%23333333|letter_spacing:3" heading_margin="margin-top:30|margin-bottom:50"]" Nam nec ante molestie est fringilla hendrerit eleifend et eros. Proin non porta augue. Aenean sit amet mauris nulla. Morbi eget vehicula lectus, non porttitor nisi. Nunc vel nulla tortor. Phasellus dui erat, finibus quis pellentesque sed, sagittis vitae nisi. "

<img class="aligncenter size-full wp-image-187" src="http://apresswp.com/demo8/wp-content/uploads/2017/08/sign.png" alt="" width="250" height="98" />[/apress_heading][ultimate_spacer height="50"][apress_button button_text="Visit Website" button_size="large" button_alignment="center" data_animation="fadeInUp"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 6', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study6.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row bg_type="image" parallax_style="vcpb-vz-jquery" bg_image_new="id^189|url^http://apresswp.com/demo8/wp-content/uploads/2017/10/spencer.jpg|caption^null|alt^null|title^spencer|description^null" bg_image_repeat="no-repeat" bg_override="browser_size" css=".vc_custom_1507704674430{padding-right: 10% !important;padding-left: 10% !important;}"][vc_column][apress_heading sub_title="Showcase your work in style " data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style2" title_font_options="tag:h1|font_size:50|line_height:60|letter_spacing:1" subtitle_font_options="tag:div|color:%23ffffff|letter_spacing:6" heading_margin="margin-top:30"]SPENCER DIGITAL[/apress_heading][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 7', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study7.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][ultimate_spacer height="100"][apress_heading sub_title="" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" style="heading_style1" title_font_options="tag:h2|font_size:40|line_height:50|letter_spacing:1" subtitle_font_options="tag:div" heading_margin="margin-bottom:30"]Identity for a web design works company with vast experience in designing and defining we trends.[/apress_heading][ultimate_spacer height="70"][vc_row_inner][vc_column_inner width="1/4"][apress_heading sub_title="Project Deliverables" content_alignment="left" data_animation="fadeInUp" data_delay="300" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style2" title_font_options="tag:p" subtitle_font_options="tag:div|font_size:20|color:%23333333|line_height:30|letter_spacing:1|font_style_bold:1" heading_margin="margin-bottom:10"]Design
Development
Marketing[/apress_heading][/vc_column_inner][vc_column_inner width="1/4"][apress_heading sub_title="Project Duration" content_alignment="left" data_animation="fadeInUp" data_delay="600" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style2" title_font_options="tag:p" subtitle_font_options="tag:div|font_size:20|color:%23333333|line_height:30|letter_spacing:1|font_style_bold:1" heading_margin="margin-bottom:10"]90 days[/apress_heading][/vc_column_inner][vc_column_inner width="1/4"][apress_heading sub_title="Awards" content_alignment="left" data_animation="fadeInUp" data_delay="900" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style2" title_font_options="tag:p" subtitle_font_options="tag:div|font_size:20|color:%23333333|line_height:30|letter_spacing:1|font_style_bold:1" heading_margin="margin-bottom:10"]TN Digital
AWWWARDS[/apress_heading][/vc_column_inner][vc_column_inner width="1/4"][apress_heading sub_title="YEAR" content_alignment="left" data_animation="fadeInUp" data_delay="1200" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style2" title_font_options="tag:p" subtitle_font_options="tag:div|font_size:20|color:%23333333|line_height:30|letter_spacing:1|font_style_bold:1" heading_margin="margin-bottom:10"]2016[/apress_heading][/vc_column_inner][/vc_row_inner][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 8', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study8.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1507473383804{padding-top: 150px !important;padding-bottom: 150px !important;background-color: #f2f2f2 !important;}"][vc_column width="1/3"][apress_heading sub_title="COLOR PALLETE" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" style="heading_style2" heading_margin="margin-top:10" title_font_options="tag:h2|font_size:35|line_height:50|letter_spacing:1|font_style_bold:1" subtitle_font_options="tag:div|letter_spacing:5"]COLORS[/apress_heading][/vc_column][vc_column width="2/3"][vc_row_inner gap="20"][vc_column_inner width="1/3" css=".vc_custom_1507535854371{background-color: #0300d5 !important;}"][apress_heading sub_title="" data_animation="fadeInUp" data_delay="300" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" title_font_options="tag:h4" subtitle_font_options="tag:div" heading_margin="margin-bottom:36"]#0300d5[/apress_heading][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1507472688196{background-color: #1d8cae !important;}"][apress_heading sub_title="" data_animation="fadeInUp" data_delay="600" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" title_font_options="tag:h4" subtitle_font_options="tag:div" heading_margin="margin-bottom:36"]#1d8cae[/apress_heading][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1507472753067{background-color: #5cc6c3 !important;}"][apress_heading sub_title="" data_animation="fadeInUp" data_delay="900" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" title_font_options="tag:h4" subtitle_font_options="tag:div" heading_margin="margin-bottom:36"]#5cc6c3[/apress_heading][/vc_column_inner][/vc_row_inner][vc_row_inner gap="20"][vc_column_inner width="1/3" css=".vc_custom_1507472730150{background-color: #32d762 !important;}"][apress_heading sub_title="" data_animation="fadeInUp" data_delay="300" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" title_font_options="tag:h4" subtitle_font_options="tag:div" heading_margin="margin-bottom:36"]#32d762[/apress_heading][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1507472737325{background-color: #fbaf44 !important;}"][apress_heading sub_title="" data_animation="fadeInUp" data_delay="600" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" title_font_options="tag:h4" subtitle_font_options="tag:div" heading_margin="margin-bottom:36"]#fbaf44[/apress_heading][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1507472746427{background-color: #333333 !important;}"][apress_heading sub_title="" data_animation="fadeInUp" data_delay="900" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" title_font_options="tag:h4" subtitle_font_options="tag:div" heading_margin="margin-bottom:36"]#333333[/apress_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 9', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study9.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1507473471885{padding-top: 150px !important;padding-bottom: 150px !important;background-color: #ffffff !important;}"][vc_column width="1/3"][apress_heading sub_title="FONTS USED" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" style="heading_style2" heading_margin="margin-top:10" title_font_options="tag:h2|font_size:35|line_height:50|letter_spacing:1|font_style_bold:1" subtitle_font_options="tag:div|letter_spacing:5"]TYPOGRAPHY[/apress_heading][/vc_column][vc_column width="2/3"][vc_row_inner][vc_column_inner][apress_heading sub_title="Montserrat Bold" content_alignment="left" data_animation="fadeInUp" data_delay="300" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" title_google_fonts="yes" style="heading_style2" heading_margin="margin-top:30" title_font_options="tag:h2|letter_spacing:3" title_custom_fonts="font_family:Montserrat%3Aregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" subtitle_font_options="tag:div|color:%23333333|letter_spacing:3" title_responsive="font_size_mobile:20|line_height_mobile:30|letter_spacing_mobile:1"]ABCDEFGHIJKLMNOPQRSTUVWXYZ

abcdefghijklmnopqrstuvwxyz[/apress_heading][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][vc_row_inner][vc_column_inner][apress_heading sub_title="Open Sans Regular" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" title_google_fonts="yes" style="heading_style2" heading_margin="margin-top:30" title_font_options="tag:h2|letter_spacing:3" title_custom_fonts="font_family:Open%20Sans%3A300%2C300italic%2Cregular%2Citalic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic|font_style:400%20regular%3A400%3Anormal" subtitle_font_options="tag:div|color:%23333333|letter_spacing:3" title_responsive="font_size_mobile:20|line_height_mobile:30|letter_spacing_mobile:1"]ABCDEFGHIJKLMNOPQRSTUVWXYZ

abcdefghijklmnopqrstuvwxyz[/apress_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 10', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study10.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row bg_type="bg_color" bg_override="ex-full" css=".vc_custom_1507538884856{padding-top: 120px !important;padding-bottom: 110px !important;}" bg_color_value="#0300d5"][vc_column][vc_row_inner][vc_column_inner width="1/4"][apress_heading sub_title="WHAT WE DELIVERED" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style2" heading_margin="margin-top:10" title_font_options="tag:h2|font_size:35|line_height:50|letter_spacing:1|font_style_bold:1" subtitle_font_options="tag:div|color:%23ffffff|letter_spacing:5"]THE RESULT[/apress_heading][/vc_column_inner][vc_column_inner width="3/4"][ultimate_spacer height="" height_on_mob_landscape="50" height_on_mob="50"][apress_heading sub_title="" content_alignment="left" data_animation="fadeInUp" data_delay="300" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" title_google_fonts="yes" style="heading_style2" title_font_options="tag:h2|letter_spacing:3" title_custom_fonts="font_family:Montserrat%3Aregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" subtitle_font_options="tag:div|color:%23333333|letter_spacing:3"]A minimal &amp;  classic looking site based on aesthetics. Nam nec ante molestie est fringilla hendrerit eleifend et eros. Proin non porta augue. Aenean sit amet mauris nulla.[/apress_heading][/vc_column_inner][/vc_row_inner][ultimate_spacer height="160"][vc_single_image image="193" img_size="full" alignment="center" css_animation="fadeInUp" css=".vc_custom_1507704969332{margin-bottom: -500px !important;padding-bottom: 100px !important;}"][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1507539454351{margin-top: -100px !important;}"][ultimate_spacer height="" height_on_mob_landscape="300" height_on_mob="300"][apress_button button_text="VISIT WEBSITE" color_scheme="design_your_own" button_bg_color="#0300d5" button_bg_color_h="#3a37d6" button_border_color="#0300d5" button_border_color_h="#3a37d6" button_shape="round" button_size="design_your_own" padding_top_bottom="20" padding_right_left="30" button_alignment="center" data_animation="fadeInUp" button_font_options="font_size:20|line_height:30|letter_spacing:3"][ultimate_spacer height="110"][/vc_column][/vc_row][vc_row][vc_column][ultimate_spacer height="110"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 11', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study11.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row bg_type="bg_color" bg_override="browser_size" bg_color_value="#8224e3"][vc_column centered_text="true"][ultimate_spacer height="200"][vc_row_inner css=".vc_custom_1507563770128{padding-right: 10% !important;padding-left: 10% !important;}"][vc_column_inner width="2/3"][apress_heading sub_title="" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" title_google_fonts="yes" style="heading_style1" title_font_options="tag:h2|font_size:60|line_height:70|letter_spacing:1|font_style_bold:1" subtitle_font_options="tag:div|color:%23ffffff" title_responsive="font_size_mobile:35|line_height_mobile:45|letter_spacing_mobile:1" title_custom_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" heading_margin="margin-bottom:50"]Redefining precious expression of beauty.[/apress_heading][/vc_column_inner][vc_column_inner width="1/3"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1507563775708{padding-right: 10% !important;padding-left: 10% !important;}"][vc_column_inner width="1/3"][apress_heading sub_title="" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" title_google_fonts="yes" style="heading_style1" title_font_options="tag:div|line_height:26" subtitle_font_options="tag:div" heading_margin="margin-bottom:30" title_custom_fonts="font_family:Lekton%3Aregular%2Citalic%2C700|font_style:400%20regular%3A400%3Anormal"]Web Design
Photography
Implementation[/apress_heading][/vc_column_inner][vc_column_inner width="2/3"][apress_heading sub_title="" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" title_google_fonts="yes" style="heading_style1" title_font_options="tag:div" subtitle_font_options="tag:div" heading_margin="margin-bottom:30" title_custom_fonts="font_family:Lekton%3Aregular%2Citalic%2C700|font_style:400%20regular%3A400%3Anormal"]Nam nec ante molestie est fringilla hendrerit eleifend et eros. Proin non porta augue. Aenean sit amet mauris nulla. Morbi eget vehicula lectus, non porttitor nisi. Nunc vel nulla tortor. Phasellus dui erat, finibus quis pellentesque sed, sagittis vitae nisi. Nulla vitae porttitor neque. Nunc sit amet mattis metus. Cras vitae odio mauris.[/apress_heading][/vc_column_inner][/vc_row_inner][ultimate_spacer height="50"][apress_lightbox lightbox_type="video" link_style="link_icon_preview_image" image_url="196" button_icon_color="#ffffff" button_icon_hover_color="#ffffff" select_button_style="video_icon_style5" link_hover_caption="Wath Our Story" videolink_font_options="font_size:20|color:%23ffffff|line_height:30|letter_spacing:1" link="https://vimeo.com/9405917"][ultimate_spacer height="150"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 12', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study12.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1507611500626{padding-top: 150px !important;padding-right: 10% !important;padding-bottom: 100px !important;padding-left: 10% !important;}"][vc_column width="1/3"][apress_heading sub_title="1/" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" title_google_fonts="yes" subtitle_google_fonts="yes" style="heading_style2" heading_margin="margin-top:40|margin-bottom:40" title_font_options="tag:h2|font_size:50|line_height:60|letter_spacing:1|font_style_bold:1" subtitle_font_options="tag:div|font_size:150|color:%23333333|line_height:150|letter_spacing:1" subtitle_custom_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" title_custom_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"]Redefining Brand Position[/apress_heading][apress_heading sub_title="" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" title_google_fonts="yes" style="heading_style1" title_font_options="tag:div" subtitle_font_options="tag:div" title_custom_fonts="font_family:Lekton%3Aregular%2Citalic%2C700|font_style:400%20regular%3A400%3Anormal"]Sam nec ante molestie est fringilla hendrerit eleifend et eros. Proin non porta augue. Aenean sit amet mauris nulla. Morbi eget vehicula lectus, non porttitor nisi.[/apress_heading][/vc_column][vc_column width="2/3"][ultimate_spacer height="100"][vc_single_image image="198" img_size="full" css_animation="fadeInUp"][/vc_column][/vc_row][vc_row css=".vc_custom_1507610515420{padding-right: 10% !important;padding-left: 10% !important;}"][vc_column width="1/2" css=".vc_custom_1507611431058{margin-right: 0px !important;margin-bottom: 0px !important;padding-right: 0px !important;}"][vc_single_image image="199" img_size="full" alignment="right" css_animation="fadeInUp" css=".vc_custom_1507705585203{margin-top: 0px !important;margin-right: 0px !important;margin-bottom: 0px !important;margin-left: 0px !important;}"][vc_single_image image="197" img_size="full" alignment="right" css_animation="fadeInUp"][/vc_column][vc_column width="1/2" css=".vc_custom_1507610925662{margin-left: 0px !important;padding-left: 0px !important;}"][vc_single_image image="200" img_size="full" css_animation="fadeInUp" css=".vc_custom_1507705596961{margin-bottom: 0px !important;padding-bottom: 0px !important;}"][vc_row_inner css=".vc_custom_1507611952965{margin-top: 0px !important;margin-bottom: 0px !important;margin-left: 0px !important;padding-top: 0px !important;padding-right: 10% !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][vc_column_inner css=".vc_custom_1507620660327{margin-top: 0px !important;margin-left: 0px !important;padding-top: 70px !important;padding-right: 70px !important;padding-bottom: 70px !important;padding-left: 70px !important;background-color: #8224e3 !important;}"][apress_heading sub_title="" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" style="heading_style1" title_font_options="tag:h2" subtitle_font_options="tag:div"]The strength of brand loyalty begins with how your product makes people feel.[/apress_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 13', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study13.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row bg_type="bg_color" bg_override="ex-full" css=".vc_custom_1507614964259{padding-top: 150px !important;padding-right: 10% !important;padding-bottom: 150px !important;padding-left: 10% !important;}" bg_color_value="#8224e3"][vc_column][vc_row_inner][vc_column_inner width="1/3"][/vc_column_inner][vc_column_inner width="1/3"][vc_single_image image="204" img_size="full" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner width="1/3"][/vc_column_inner][/vc_row_inner][vc_row_inner gap="10"][vc_column_inner width="1/3"][apress_heading sub_title="" content_alignment="right" data_animation="fadeInUp" data_delay="300" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" title_google_fonts="yes" style="heading_style1" title_font_options="tag:h2|font_size:35|line_height:50|letter_spacing:1|font_style_italic:1|font_style_bold:1" subtitle_font_options="tag:div|color:%23ffffff" title_responsive="font_size_mobile:35|line_height_mobile:45|letter_spacing_mobile:1" title_custom_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" heading_margin="margin-bottom:20"]bolder[/apress_heading][apress_vertical_separator vertical_separator_width="1" vertical_separator_height="50" vertical_separator_align="right" vertical_separator_color="#ffffff" data_animation="fadeIn" data_delay="400"][apress_heading sub_title="" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" title_google_fonts="yes" style="heading_style1" title_font_options="tag:div" subtitle_font_options="tag:div" heading_margin="margin-top:20" title_custom_fonts="font_family:Lekton%3Aregular%2Citalic%2C700|font_style:400%20regular%3A400%3Anormal"]Nam nec ante molestie est fringilla hendrerit eleifend et eros. Proin non porta augue.[/apress_heading][/vc_column_inner][vc_column_inner width="1/3"][ultimate_spacer height="100"][apress_heading sub_title="" data_animation="fadeInUp" data_delay="600" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" title_google_fonts="yes" style="heading_style1" title_font_options="tag:h2|font_size:35|line_height:50|letter_spacing:1|font_style_italic:1|font_style_bold:1" subtitle_font_options="tag:div|color:%23ffffff" title_responsive="font_size_mobile:35|line_height_mobile:45|letter_spacing_mobile:1" title_custom_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" heading_margin="margin-bottom:20"]smarter[/apress_heading][apress_vertical_separator vertical_separator_width="1" vertical_separator_height="50" vertical_separator_align="center" vertical_separator_color="#ffffff" data_animation="fadeInUp" data_delay="700"][apress_heading sub_title="" data_animation="fadeInUp" data_delay="800" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" title_google_fonts="yes" style="heading_style1" title_font_options="tag:div" subtitle_font_options="tag:div" heading_margin="margin-top:20" title_custom_fonts="font_family:Lekton%3Aregular%2Citalic%2C700|font_style:400%20regular%3A400%3Anormal"]Nam nec ante molestie est fringilla hendrerit eleifend et eros. Proin non porta augue.[/apress_heading][/vc_column_inner][vc_column_inner width="1/3"][apress_heading sub_title="" content_alignment="left" data_animation="fadeInUp" data_delay="900" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" title_google_fonts="yes" style="heading_style1" title_font_options="tag:h2|font_size:35|line_height:50|letter_spacing:1|font_style_italic:1|font_style_bold:1" subtitle_font_options="tag:div|color:%23ffffff" title_responsive="font_size_mobile:35|line_height_mobile:45|letter_spacing_mobile:1" title_custom_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" heading_margin="margin-bottom:20"]beautiful[/apress_heading][apress_vertical_separator vertical_separator_width="1" vertical_separator_height="50" vertical_separator_color="#ffffff" data_animation="fadeInUp" data_delay="1000"][apress_heading sub_title="" data_animation="fadeInUp" data_delay="1200" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#ffffff" title_google_fonts="yes" style="heading_style1" title_font_options="tag:div" subtitle_font_options="tag:div" heading_margin="margin-top:20" title_custom_fonts="font_family:Lekton%3Aregular%2Citalic%2C700|font_style:400%20regular%3A400%3Anormal"]Nam nec ante molestie est fringilla hendrerit eleifend et eros. Proin non porta augue.[/apress_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 14', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study14.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1507624517697{padding-right: 10% !important;padding-left: 10% !important;}"][vc_column][ultimate_spacer height="100"][apress_heading sub_title="Comfort at Its best" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" title_google_fonts="yes" subtitle_google_fonts="yes" style="heading_style2" title_font_options="tag:h2|letter_spacing:3" subtitle_font_options="tag:div|color:%23333333|letter_spacing:1|font_style_bold:1" title_custom_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" heading_margin="margin-top:30|margin-bottom:30" subtitle_custom_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"]A shoe is not only a design, but it's a part of your body language, the way you walk. The way you're going to move is quite dictated by your shoes[/apress_heading][apress_heading sub_title="" content_alignment="left" data_animation="fadeInUp" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" style="heading_style1" title_font_options="tag:div" subtitle_font_options="tag:div"]Nam nec ante molestie est fringilla hendrerit eleifend et eros. Proin non porta augue. Aenean sit amet mauris nulla. Morbi eget vehicula lectus, non porttitor nisi. Nunc vel nulla tortor. Phasellus dui erat, finibus quis pellentesque sed, sagittis vitae nisi. Nulla vitae porttitor neque. Nunc sit amet mattis metus. Cras vitae odio mauris. Pellentesque sit amet turpis blandit, viverra nunc in, feugiat urna. Donec et elit in justo lobortis imperdiet id in mauris.

Nam nec ante molestie est fringilla hendrerit eleifend et eros. Proin non porta augue. Aenean sit amet mauris nulla. Morbi eget vehicula lectus, non porttitor nisi. Nunc vel nulla tortor. Phasellus dui erat, finibus quis pellentesque sed, sagittis vitae nisi. Nulla vitae porttitor neque. Nunc sit amet mattis metus. Cras vitae odio mauris.[/apress_heading][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 15', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study15.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1507624517697{padding-right: 10% !important;padding-left: 10% !important;}"][vc_column][ultimate_spacer height="100"][apress_heading sub_title="Branding" content_alignment="left" enable_delimiter="" color_scheme="design_your_own" main_heading_color="#333333" subtitle_google_fonts="yes" style="heading_style2" title_font_options="tag:div" subtitle_font_options="tag:div|color:%23333333|letter_spacing:1|font_style_bold:1" heading_margin="margin-top:30|margin-bottom:30" subtitle_custom_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"]<span class="title_text">Nam nec ante molestie est fringilla hendrerit eleifend et eros. Proin non porta augue. Aenean sit amet mauris nulla. Morbi eget vehicula lectus, non porttitor nisi. Nunc vel nulla tortor. Phasellus dui erat, finibus quis pellentesque sed, sagittis vitae nisi. Nulla vitae porttitor neque. Nunc sit amet mattis metus. Cras vitae odio mauris. Pellentesque sit amet turpis blandit, viverra nunc in, feugiat urna. Donec et elit in justo lobortis imperdiet id in mauris.</span>[/apress_heading][ultimate_spacer height="100"][vc_single_image image="210" img_size="full" alignment="center" css_animation="fadeInUp"][ultimate_spacer height="100"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 16', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study16.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content"][vc_column css_animation="none"][apress_image_slider images="1341,1342,1343,1344,1345" slider_gutter="50" slick_item_shadow="yes" slick_lazyload="yes" slick_autoplay="yes" slick_autoplay_duration="2000" style="slider_style4" bullet_navigation_style="dots_style3" arrows_style="arrows_style4"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 17', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study17.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row][vc_column css_animation="none"][apress_image_slider images="1319,1318" img_size="full" slick_item_shadow="yes" slick_lazyload="yes" style="slider_style6" bullet_navigation_style="dots_style3"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 18', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study18.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content"][vc_column css_animation="none"][apress_image_slider images="1323,1317,1322" img_size="full" desktop_no_of_items="1" small_desktop_no_of_items="1" tablet_no_of_items="1" slider_gutter="10" slick_center_desktop_padding="20%" slick_center_small_desktop_padding="40%" slick_center_tablet_padding="20%" slick_focusonselect="yes" slick_item_shadow="yes" slick_lazyload="yes" slick_autoplay="yes" slick_autoplay_duration="2000" style="slider_style2" bullet_navigation_style="dots_style3" arrows_style="arrows_style1"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Case Studies 19', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/case_study19.jpg' );
	$data['sort_name'] = 'Case Studies';
	$data['custom_class'] = 'general case-studies';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content"][vc_column css_animation="none"][apress_image_slider images="1318,1319,1320,1321,1325" img_size="full" desktop_no_of_items2="3" small_desktop_no_of_items="1" tablet_no_of_items="1" slider_gutter="50" slick_focusonselect="yes" slick_item_shadow="yes" slick_lazyload="yes" slick_autoplay="yes" slick_autoplay_duration="2000" style="slider_style3" bullet_navigation_style="dots_style3" arrows_style="arrows_style4"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Ecommerce 1', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/ecommerce1.jpg' );
	$data['sort_name'] = 'Ecommerce';
	$data['custom_class'] = 'general ecommerce';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1479313965794{border-bottom-width: 1px !important;border-bottom-color: #eeeeee !important;border-bottom-style: solid !important;}"][vc_column css=".vc_custom_1479377286226{padding-top: 53px !important;padding-bottom: 20px !important;}"][vc_single_image image="111" img_size="full" alignment="center"][/vc_column][/vc_row][vc_row][vc_column][ultimate_spacer height="80"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][apress_imagebox imagebox_style="style2" imagebox_bg_color="rgba(255,255,255,0.01)" imagebox_bor_color="rgba(255,255,255,0.01)" imagebox_image="93" imagebox_title="PREMIUM WORKSPACES" imagebox_title_fonsize="20" imagebox_title_color="" imagebox_button_size="medium" imagebox_button_text="" imagebox_button_fontsize="20" imagebox_buttonfontcolor="#333333" imagebox_buttonfontcolorhover="#ffffff" imagebox_buttonbackgroundcolor="#ffffff" imagebox_buttonbackgroundcolorhover="#333333" imagebox_buttonbordercolor="#ffffff" imagebox_buttonbordercolorhover="#333333" data_delay="300" imagebox_description="
"]Your Description Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column][vc_column width="1/3"][apress_imagebox imagebox_style="style2" imagebox_bg_color="rgba(255,255,255,0.01)" imagebox_bor_color="rgba(221,221,221,0.01)" imagebox_image="110" imagebox_title="MINIMAL DESIGNS" imagebox_title_fonsize="20" imagebox_title_color="" imagebox_button_size="medium" imagebox_button_text="" imagebox_button_fontsize="20" imagebox_buttonfontcolor="#333333" imagebox_buttonfontcolorhover="#ffffff" imagebox_buttonbackgroundcolor="#ffffff" imagebox_buttonbackgroundcolorhover="#333333" imagebox_buttonbordercolor="#ffffff" imagebox_buttonbordercolorhover="#333333" data_delay="300" imagebox_description="
"]Your Description Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column][vc_column width="1/3"][apress_imagebox imagebox_style="style2" imagebox_bg_color="rgba(255,255,255,0.01)" imagebox_bor_color="rgba(221,221,221,0.01)" imagebox_image="94" imagebox_title="OUTDOOR FURNITURE" imagebox_title_fonsize="20" imagebox_title_color="" imagebox_button_size="medium" imagebox_button_text="" imagebox_button_fontsize="20" imagebox_buttonfontcolor="#333333" imagebox_buttonfontcolorhover="#ffffff" imagebox_buttonbackgroundcolor="#ffffff" imagebox_buttonbackgroundcolorhover="#333333" imagebox_buttonbordercolor="#ffffff" imagebox_buttonbordercolorhover="#333333" data_delay="300" imagebox_description="
"]Your Description Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Ecommerce 2', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/ecommerce2.jpg' );
	$data['sort_name'] = 'Ecommerce';
	$data['custom_class'] = 'general ecommerce';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][vc_separator][ultimate_spacer height="75"][ultimate_heading main_heading="CHECK OUT OUR LATEST COLLECTION FOR 2017" main_heading_margin="margin-bottom:30px;" sub_heading_margin="margin-bottom:30px;"]Nam sit amet aliquam dolor, molestie elementum lacus. Etiam ac semper quam. Nulla facilisi. Phasellus vel ullamcorper dui,[/ultimate_heading][recent_products per_page="8" columns="4" orderby="" order=""][ultimate_spacer height="40"][/vc_column][/vc_row]
CONTENT;

$templates[] = $data;	
	$data = array();
	$data['name'] = esc_html__( 'Ecommerce 3', 'apcore' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/vc_studio/ecommerce3.jpg' );
	$data['sort_name'] = 'Ecommerce';
	$data['custom_class'] = 'general ecommerce';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/3" css=".vc_custom_1475654015259{padding-top: 80px !important;}"][apress_imagebox imagebox_image="37" imagebox_button_text="NUTCRACKER" imagebox_button_fontsize="14" imagebox_button_hover_style="hoverstyle2" imagebox_buttonfontcolor="#ffffff" imagebox_buttonfontcolorhover="#363636" imagebox_buttonbackgroundcolor="#363636" imagebox_buttonbordercolor="#363636" imagebox_buttonbordercolorhover="#363636" data_animation="fadeIn" imagebox_link="url:%23|||"]Your Description Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column][vc_column width="1/3" css=".vc_custom_1475654020918{padding-top: 80px !important;}"][apress_imagebox imagebox_image="139" imagebox_button_text="STOOL" imagebox_button_fontsize="14" imagebox_button_hover_style="hoverstyle2" imagebox_buttonfontcolor="#ffffff" imagebox_buttonfontcolorhover="#363636" imagebox_buttonbackgroundcolor="#363636" imagebox_buttonbordercolor="#363636" imagebox_buttonbordercolorhover="#363636" data_animation="fadeIn" imagebox_link="url:%23|||"]Your Description Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column][vc_column width="1/3" css=".vc_custom_1475654027341{padding-top: 80px !important;}"][apress_imagebox imagebox_image="39" imagebox_button_text="WOOD" imagebox_button_fontsize="14" imagebox_button_hover_style="hoverstyle2" imagebox_buttonfontcolor="#ffffff" imagebox_buttonfontcolorhover="#363636" imagebox_buttonbackgroundcolor="#363636" imagebox_buttonbordercolor="#363636" imagebox_buttonbordercolorhover="#363636" data_animation="fadeIn" imagebox_link="url:%23|||"]Your Description Eos movet legimus euripidis ea. Cu eos minim aeque interpretaris, vel te eirmod dissentiet, homero utroque ut mea.[/apress_imagebox][/vc_column][/vc_row][vc_row][vc_column][ultimate_heading main_heading="OUR FEATURED PRODUCTS" spacer="line_only" spacer_position="bottom" line_height="3" line_color="#363636" main_heading_style="font-weight:bold;" main_heading_margin="margin-top:44px;margin-bottom:10px;" line_width="20" spacer_margin="margin-top:24px;margin-bottom:30px;"]KNOW MORE ABOUT OUR <strong><em>#UNIQUE COLLECTION</em></strong>[/ultimate_heading][featured_products per_page="4" columns="4" orderby="date" order="ASC"][/vc_column][/vc_row]
CONTENT;


	
	$templates[] = $data;

	return $templates;
}